h04162
s 00000/00000/00069
d D 1.2 83/01/28 13:58:22 tes 2 1
c initial_internal_update
e
s 00069/00000/00000
d D 1.1 83/01/28 13:03:48 tes 1 0
c date and time created 83/01/28 13:03:48 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpstck (count, stkary, index, xin, yin, xout, yout)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Stack data when stacking is on; if necessary,          #
#               initialize the stack array                             #
#                                                                      #
#     Input Parameters:                                                #
#            count  - length of data array                             #
#            stkary - array used to stack current graph extents        #
#            index  - current index into stkary                        #
#            xin    - x input coordinate                               #
#            yin    - y input coordinate                               #
#                                                                      #
#     Output Parameters:                                               #
#            stkary - array used to stack current graph extents        #
#            xout   - x output coordinate                              #
#            yout   - y output coordinate                              #
#                                                                      #
#     Routines Called:                                                 #
#            none                                                      #
#                                                                      #
########################################################################
integer count, index
real stkary(1), xin, yin, xout, yout
 
integer i, length
real data

include(`pltcom')
 
   #     nstack          meaning
   #       0     no stacking is being done
   #       1     user desires stacking, but stack array is not initialized
   #       2     stacking is in effect, stack array initialized
 
   length = count*nbclst
   if (nstack == 1) {   # If the stack has not been initialized, initialize
      do i=1, length    #    to the bar base value
         stkary(i) = zbrbas
      nstack = 2
      }
 
   xout = xin
   yout = yin
 
   if (index <= length & nstack != 0) {    # Insure that the index is within
                                      # the array bounds and we're stacking
      data = stkary(index)
      if (nbrdir == 0) {      # Determine the direction of stacking
         data = data + yin       # Stack in the y direction
         yout = data
         }
      else {
         data = data + xin       # Stack in the x direction
         xout = data
         }
      stkary(index) = data    # Update the stck array
      }
 
   return
end
E 1
