h64837
s 00005/00006/00064
d D 1.2 83/03/31 12:43:15 mmm 2 1
c 
e
s 00070/00000/00000
d D 1.1 83/03/15 21:43:47 tes 1 0
c date and time created 83/03/15 21:43:47 by tes
e
u
4
U
t
T
I 1
subroutine gsw (tnr, xmin, xmax, ymin, ymax)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set the window size                                    #
#                                                                      #
#     Input Parameters:                                                #
#            tnr       -   transformation number                       #
#            xmin,ymin -   the lower left corner (WC)                  #
#            xmax,ymax -   the upper right corner (WC)                 #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Errors:                                                          #
#	   8 GKS not in proper state: GKS must be in one of the states #
#	     GKOP, WSOP, WSAC or SGOP                                  #
#         40 Transformation number is invalid                          #
#         41 Rectangle definition is invalid                           #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer tnr
real xmin,xmax,ymin,ymax
 
ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

integer i, gimnmx
D 2
real txmin, txmax, tymin, tymax
REALS GETREAL
E 2
I 2
real txmin, txmax, tymin, tymax, gtreal 
E 2

include(`gkscom')

D 2
   txmin = GETREAL(xmin) # convert to R format
   txmax = GETREAL(xmax)
   tymin = GETREAL(ymin)
   tymax = GETREAL(ymax)
E 2
I 2
   txmin = gtreal (xmin, 0) # convert to R format
   txmax = gtreal (xmax, 0)
   tymin = gtreal (ymin, 0)
   tymax = gtreal (ymax, 0)
E 2

   ifdef(`ERROR_ON',`
      rounum = GSW
      errind = errchk(tnr, ierdum)
      ')

   if (txmax <= txmin | tymax <= tymin) {
      ifdef(`ERROR_ON',`call gkserr (41)')
      return
      }
 
   i = gimnmx(tnr, 0, 1) + 1  # Make sure tnr is bounded correctly.
   wxminl(i) = txmin     # Set the GKS state list elements.
   wxmaxl(i) = txmax
   wyminl(i) = tymin
   wymaxl(i) = tymax

   nview = 1        # set viewing transform dirty flag (.true.)
   ntext = 1        # set text transform dirty flag (.true.)

   return
end
E 1
