h30047
s 00437/00000/00000
d D 1.1 83/03/15 21:13:40 tes 1 0
c date and time created 83/03/15 21:13:40 by tes
e
u
4
U
t
T
I 1
/****************************************************************
* cs1.c -- the second half of the Control Systems Artist I	*
* driver. This contains all the code that interfaces to the	*
* hardware, not to GKS.						*
*								*
*	copyright (C) Graphic Software Systems, Inc.		*
*		All Rights Reserved				*
****************************************************************/
 
#include "gksdef.c"
#include "csmit.c"
#include "gdc.c"
#include "font.c"

#define HOLLOW 0
#define SOLID 1
#define PATTERN 2
#define HATCH 3
#define DMreplace 1             /* writing mode defines */
#define DMover 2
#define DMxor 3
#define DMblank 4
 
drawRect(loX,loY,hiX,hiY,style,index,col,dm)
int loX,loY,hiX,hiY;
int style,index,col,dm;
/****************************************************************
* Function: Display a rectangle, given a location, fill style
*	and color, and draw mode.
*
* Input Parameters:
*	loX,loY: the 7220 position of one corner.
*	hiX,hiY: the other corner. hiX>=loX, hiY>=loY
*		(watch out: display is inverted.)
*	style: one of HOLLOW, SOLID, PATTERN, HATCH.
*	index: which pattern to use.
*	col: the color to display in.
*	dm: the way to put pixels up -- DMreplace ... DMxor
*
* Output Parameters:
*	none
*
* Routines Called:
*	putCmd: send 7220 command byte
*	putParam: follow it with parameter byte
*	putList: do both these things at once
*	moveCursor: set 7220 drawing position
****************************************************************/
{
extern int ncolmp[16];
extern int pats[56];
int i,plane,mode;
int word;
 
	if (style == SOLID) index=6;
 
	putCmd(ZOOMC);  /* make sure no zoom factor is present */
	putParam(0);
 
	/* load pattern into parameter RAM */
	putList(PARAMC | 8,8,&pats[index*8-8]);
 
	for (plane=0; plane<=3; plane++) {
 
		/* for each color plane: set or reset bit? */
		switch (dm) {
			case DMreplace:
				if ((1<<plane) & ncolmp[col]) mode=SET;
				else mode=RESET;
				break;
 
			case DMover:
				if ((1<<plane) & ncolmp[col]) mode=SET;
				else mode=RESET;
				break;
 
			case DMxor:
				if ((1<<plane) & ncolmp[col])
					mode=COMPLEMENT;
				else
					mode= -1;
				break;
 
			case DMblank:
				mode=RESET;
				break;
		}
 
		if (mode == -1) continue; /* don't write plane for xor mode */
 
		putCmd(WDATC | WORD | mode);
 
		/* starting location in each succesive plane */
		moveCursor(loX,loY,plane);
 
		/* figure to draw is a graphic character */
		putCmd(FIGSC);
		putParam(FIGGRAFCHAR);
		word=(hiX>loX)?hiX-loX:0; /* at least one pixel */
		putParam(word & 0xFF);
		putParam((word >> 8) & 0x3F);
		word=(hiY>=loY)?hiY-loY+1:1; /* at least one pixel */
		putParam(word & 0xFF);
		putParam((word >> 8) & 0x3F);
		putParam(word & 0xFF);
		putParam((word >> 8) & 0x3F);
 
		/* start the area fill */
		putCmd(GCHRDC);
	}
 
}
 
charDraw(ch,x,y,col,rot,dm)
char ch;
int x,y,col,rot,dm;
/****************************************************************
* Function: Display a single character at a certain position, at
*	a specified rotation and color. Scale is handled at a
*	higher level (It's not repeated for each character).
*
* Input Parameters:
*	ch: the charater to be drawn.
*	x,y: the 7220 position of the lower left corner.
*	col: the color to display in.
*	rot: the 7220 text rotation factor to apply.
*	dm: the way to put pixels up -- DMreplace ... DMxor
*
* Output Parameters:
*	none
*
* Routines Called:
*	putCmd: send 7220 command byte
*	putParam: follow it with parameter byte
*	putList: do both these things at once
*	moveCursor: set 7220 drawing position
****************************************************************/
{
extern int ncolmp[16];
static int bs[7]={-1,7,0,6,0,6,0}; /* parameter list for call to FIGSC */
int i,plane,mode;
char *sa;
 
	for (plane=0; plane<=3; plane++) {
 
		/* for each color plane: set or reset bit? */
		switch (dm) {
			case DMreplace:
				mode=REPLACE;
				if ((1<<plane) & ncolmp[col])
					sa=&fntary[((ch-32) << 3)+7];
				else
					sa=&fntary[7];
				break;
 
			case DMover:
				if ((1<<plane) & ncolmp[col]) mode=SET;
				else mode=RESET;
				sa=&fntary[((ch-32) << 3)+7];
				break;
 
			case DMxor:
				mode=COMPLEMENT;
				if ((1<<plane) & ncolmp[col])
					sa=&fntary[((ch-32) << 3)+7];
				else
					sa=&fntary[7];
				break;
 
			case DMblank:
				mode=RESET;
				sa=&fntary[((ch-32) << 3)+7];
				break;
		}
 
		putCmd(PARAMC | 8);	/* load character into parameter RAM */
		for (i=0; i<=7; i++) {
			putParam(*sa--);
		}
 
		putCmd(WDATC | WORD | mode);
 
		/* figure to draw is a graphic character */
		putCmd(FIGSC);
		putParam(FIGGRAFCHAR | rot);
		for (i=1; i<=6; i++) putParam(bs[i]);
 
		/* starting location in each succesive plane */
		moveCursor(x,y,plane);
 
		/* start the figure drawing process */
		putCmd(GCHRDC);
	}
}
 
lineDraw(x1,y1,x2,y2,col,dm)
int x1,y1,x2,y2,col,dm;
/****************************************************************
* Function: Display a single vector at a given position, in a
*	specified color and drawing mode.
*	Line style is handled above, so as not to repeat the call.
*
* Input Parameters:
*	x1,y1: starting point, 7220 coordinates.
*	x2,y2: ending position.
*	col: the color to display in.
*	dm: the drawing mode to use
*
* Input Globals:
*	none
*
* Output Parameters:
*	none
*
* Routines Called:
*	lineDir: find direction of line for 7220
*	putCmd: send 7220 command byte
*	putParam: follow it with parameter byte
*	putList: do both these things at once
*	moveCursor: set 7220 drawing position
****************************************************************/
{
extern int ncolmp[16];
int bs[9];
int plane;
int dx,dy,d,max,min;
int word,mode;
	dx=x2-x1;
	dy=y2-y1;
	d=lineDir(dx,dy);
	dx=abs(dx);
	dy=abs(dy);
	max=(dx>dy)?dx:dy;
	min=(dx<dy)?dx:dy;
 
	/* build parameter list for repeated call to FIGSC function */
 
	bs[0]=FIGLINE | d;
	bs[1]=max & 0xFF;
	bs[2]=(max >> 8) & 0x3F;
	word=2*min-max;
	bs[3]=word & 0xFF;
	bs[4]=(word >> 8) & 0x3F;
	word=2*(min-max);
	bs[5]=word & 0xFF;
	bs[6]=(word >> 8) & 0x3F;
	word=2*min;
	bs[7]=word & 0xFF;
	bs[8]=(word >> 8) & 0x3F;
 
	for (plane=0; plane<=3; plane++) {
 
		/* for each color plane: set or reset bit? */
		switch (dm) {
			case DMreplace:
			case DMover:
				if ((1<<plane) & ncolmp[col]) mode=SET;
				else mode=RESET;
				break;
			case DMxor:
				if ((1<<plane) & ncolmp[col]) mode=COMPLEMENT;
				else mode=-1;
				break;
			case DMblank:
				mode=RESET;
				break;
		}
		if (mode == -1) continue;
		putCmd(WDATC | WORD | mode);
 
		/* figure to draw is a line */
		putList(FIGSC,9,bs);
 
		/* starting location in each succesive plane */
		moveCursor(x1,y1,plane);
 
		/* start the figure drawing process */
		putCmd(FIGDC);
	}
}
 
int lineDir(dx,dy)
int dx,dy;
/****************************************************************
* Function: compute the 7220 'direction' parameter for lines
*
* Input Parameters:
*	dx,dy: vector pointing in the direction the line will
*		be drawn in.
*
* Output Parameters:
*	function value -- suitable for submission to the 7220
*
* Routines Called:
*	none
****************************************************************/
{
	if (dx>0) {
		if (dy>0) return ((dy>dx)?0:1);
		else if (dy==0) return (2);
		else return ((-dy<dx)?2:3);
	}
	else if (dx==0) return ((dy>0)?0:4);
	else {
		if (dy>0) return ((-dx>dy)?6:7);
		else if (dy==0) return (6);
		else return ((-dy>-dx)?4:5);
	}
}
 
/****************************************************************
* Function: NEC 7220 interface routines. Perform some of the
*	more common 7220 instructions.
*
* Routines Called:
*	putCmd -- output a command byte
*	putParam -- output a parameter byte
****************************************************************/
moveCursor(x,y,plane)
int x,y,plane;
/* set the cursor position using the CURSC command of the 7220.
   (0,0) is at the top left of the screen, video style. */
{
long pos;
	pos=(y*PTCH) + (x>>4);
	putCmd(CURSC);
	putParam(pos & 0xFF);
	putParam((pos >> 8) & 0xFF);
	putParam(((x & 0x0F) << 4) | plane);
}
 
unsigned get16(x,y,plane)
int x,y,plane;
/* get a 16-bit word from a bit plane: the one that includes pixel (x,y) */
{
static int bs[3]={2,1,0};	/* FIGSC parameter list */
unsigned u;
	moveCursor(x & 0xFFF0,y,plane);
	putList(FIGSC,3,bs);	/* set direction, count */
	putCmd(RDATC | WORD);
	u=getData() & 0xFF;
	u=u | (getData()<<8);
	return(u);
}
/****************************************************************
* Function: graphics hardware interface routines. These are
*	adapted almost directly from the routines supplied
*	by Control Systems.
*
* Input Parameters:
*	b: byte to send to command or data port of 7220
*
* Output Parameters:
*	none
*
* Routines Called:
*	inportb -- input a byte from an I/O port
*	outportb -- output a byte to an I/O port
****************************************************************/
 
putCmd(i)
int i;
/* output a 7220 command */
{
extern int DEBUG;
unsigned char b;
#ifdef TEST
	if (DEBUG) dpr("putCmd",i);
#endif
	b=i & 0xFF;
	while (inportb(GDCSTAT) & FIFOFULL) /* spin */;
	outportb(CMD,b);
}
 
putParam(i)
int i;
/* output a 7220 parameter */
{
extern int DEBUG;
unsigned char b;
#ifdef TEST
	if (DEBUG) dpr("putParam",i);
#endif
	b=i & 0xFF;
	while (inportb(GDCSTAT) & FIFOFULL) /* spin */;
	outportb(PARAM,b);
}
 
int getData()
/* input a 7220 data byte */
{
extern int DEBUG;
int i;
	while ((inportb(GDCSTAT) & DATAREADY) == 0) /* spin */;
	i=inportb(FIFO);
#ifdef TEST
	if (DEBUG) dpr("getData",i);
#endif
	return(i);
}
 
putConfig(i)
int i;
/* output to the configuration register. Nobody knows what this does */
{
extern int DEBUG;
unsigned char b;
#ifdef TEST
	if (DEBUG) dpr("putConfig",i);
#endif
	b=i & 0xFF;
	outportb(CONFIGURE,b);
}
 
putZoom(i)
int i;
/* output to the zoom register. Nobody knows what this does */
{
extern int DEBUG;
unsigned char b;
#ifdef TEST
	if (DEBUG) dpr("putZoom",i);
#endif
	b=i & 0xFF;
	outportb(ZOOMREG,b);
}
 
putList(c,n,b)
int c;
int n;
int b[];
/* output a command, then bytes b[0..n-1] */
{
int i;
	putCmd(c);
	for (i=0; i<n; i++) putParam(b[i]);
}
E 1
