h64304
s 00197/00000/00000
d D 1.1 83/03/23 16:18:21 bog 1 0
c date and time created 83/03/23 16:18:21 by bog
e
u
4
U
t
T
I 1
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#############################################################################
#									    #
#	Function:  							    #
#		LOGICAL Function EmMEdS ()				    #
#			Output	EmMEdS:	LOGICAL True if edit was ok;	    #
#					False if repaint and continue	    #
#					needed.
#		    Replace the string pointed to by the following code in  #
#		    the Menu Machine with one typed in on the keyboard.	    #
#									    #
#	Called By:							    #
#									    #
#	Routines Called:						    #
#									    #
#############################################################################
 
LOGICAL Function EmMEdS(ZZ)
INTEGER ZZ
 
# Locals
CHARACTER Common		# String is at <Common>:<StrPtr>
INTEGER StrPtr			#  nth character is at <Common>:<StrPtr+n>
INTEGER LenPtr			#  with length at <Common>:<LenPtr>
CHARACTER StrMax		# Maximum length of string
CHARACTER Length(50)		# # of *s to poop when rubbing string chars
CHARACTER ChrPtr		# Index into Length and offset from StrPtr
CHARACTER Char			# General CHARACTER register
LOGICAL Rubbed			# True if something got rubbed out
CHARACTER C			# General CHARACTER counter
INTEGER I			# General INTEGER counter
INTEGER XSave,YSave,Error	# Place to save initial position
 
# External functions
CHARACTER EmIKb			# Fetch a keyboard character
External EmIKb
 
CHARACTER EmOFet		# Fetch a code-space CHARACTER
External EmOFet
INTEGER EmPFet			# Fetch a code-space INTEGER
External EmPFet
 
CHARACTER EmCFet		# Fetch a CHARACTER variable, ^ in code space
External EmCFet
CHARACTER EmCGet		# Fetch a CHARACTER variable, ^ is parameter
External EmCGet
INTEGER EmIFet			# Fetch an INTEGER variable, ^ in code space
External EmIFet
INTEGER EmIGet			# Fetch an INTEGER variable, ^ is parameter
External EmIGet
LOGICAL EmLFet			# Fetch a LOGICAL variable, ^ in code space
External EmLFet
LOGICAL EmLGet			# Fetch a LOGICAL variable, ^ is parameter
External EmLGet
 
INTEGER EmMStr			# Show a string
External EmMStr
CHARACTER EmAPut		# Show the name of a character
External EmAPut
CHARACTER EmNPut		# Show an integer
External EmNPut
 
BEGINCOMMON
COMMON(BEAMSTATE)
COMMON(DRIVER)
COMMON(SPECIALKEYS)
ENDCOMMON
 
EmMEdS = TRUE			# Assume edit goes ok
 
Common = EmOFet(Common)		# Fetch <Common>
StrPtr = EmPFet(StrPtr)-1	# Fetch <String>
LenPtr = EmPFet(LenPtr)		# Fetch <Length>
StrMax = EmOFet(StrMax)		# Fetch maximum length
ChrPtr = 0			# Start at nothing there
XSave = X			# Save X, Y
YSave = Y
Edting = TRUE			# EmIKb should not substitute during edit
 
If (Going) {			# Poop out a "
  Call EmAsci(DOUBLEQUOTE)
  }
 
Repeat {			# until Break
  While (EmIKb(Char) == EMPTY) {# Get a non-EMPTY character
    }
  If (Going & (ChrPtr > 0)) {	# Space after each character name or letter
    Call EmAsci(SPACE)
    }
  Switch (Char) {		# Diverge on keystroke
    Case BS, DEL: {		# Starting a rubout train
      Rubbed = FALSE		# Nothing necessarily rubbed out yet
      Repeat {			#  until not BS or DEL
        If (ChrPtr > 0) {	# Was there a character to rub?
	  ChrPtr = ChrPtr-1	# Erase character from string & Length
	  If (Going) {
	    Rubbed = TRUE	# Yes
	    Call EmAsci(BS)	# Compensate for space after getch
	    For (C = 1; C <= Length(ChrPtr+1); C = C+1) {
	      Call EmAsci(BS)	# Wipe out the previously shown character
	      Call EmAsci(SPLAT)
	      Call EmAsci(BS)
	      }
	    }
	  }
	While (EmIKb(Char) == EMPTY) {	# Get a non-EMPTY char
	  }
	} Until ((Char != BS) & (Char != DEL))
      Call EmPKb(Char)		# Push rubber stopper back to kb
      If (Rubbed & Going) {	# Was something rubbed out?
	If (Y > YCh) {		# Room for another line?
	  X = XSave		# Move back to saved position
	  Y = YSave
	  MOVE(X,Y)
	  Call EmAsci(LF)	# Down a line
	  XSave = X		# Save new position
	  YSave = Y
	  Call EmAsci(DOUBLEQUOTE)	# Poop new "
	  For (I = StrPtr+1; I <= (StrPtr+ChrPtr); I = I+1) {# String so far
	    C = EmAPut(EmCGet(Common,I))# Show each character
	    If (I < (StrPtr+ChrPtr)) {	#  & a space
	      Call EmAsci(SPACE)
	      }
	    }
	  }
	Else {			# No more room on page
	  For (I = StrPtr+ChrPtr; I > StrPtr; I = I-1) {# Traverse chars back
	    Call EmPKb(EmCGet(Common,I))# Push char on EmIKb stack
	    Call EmPKb(DOUBLEQUOTE)	# Push " to quote it
	    }
	  EmMEdS = FALSE	# Must restart page
	  Break
	  }
	}
      }
    Case CR: {
      Break			# Quit at unquoted Cr
      }
    Case DOUBLEQUOTE: {
      If (ChrPtr >= StrMax) {
        Break			# Quit if string would overflow
        }
      While (EmIKb(Char) == EMPTY) {	# Get a non-EMPTY char
	}
      C = 0
      ChrPtr = ChrPtr+1		# One more character
      If ((Char >= ZERO) & (Char <= NINE)) {	# Digit
	If (Going) {		# Poop a "
	  Call EmAsci(DOUBLEQUOTE)
	  }
	Length(ChrPtr) = 2	# One for each "
	While ((Char >= ZERO) & (Char <= NINE)) {	# Loop until ~digit
	  C = C*10+(Char-ZERO)
	  Length(ChrPtr) = Length(ChrPtr)+1
	  If (Going) {		# Poop out the digit
	    Call EmAsci(Char)
	    }
	  While (EmIKb(Char) == EMPTY) {# Get non-EMPTY char
	    }
	  }
	Call EmCPut(C,Common,StrPtr+ChrPtr)	# Stuff the character
	If (Going) {
	  Call EmAsci(DOUBLEQUOTE)
	  }
	If (Char != DOUBLEQUOTE) {	# Unless it's a ", push the character
	  Call EmPKb(Char)		#  which stopped digit parse
	  }
	}
      Else {			# Not a digit
	Call EmCPut(Char,Common,StrPtr+ChrPtr)
	Length(ChrPtr) = EmAPut(Char)	# Show quoted character
	}
      }
    Default: {			# Not a special character
      If (ChrPtr >= StrMax) {
	Break			# Quit if string would overflow
	}
      ChrPtr = ChrPtr+1		# Bump number of characters
      Call EmCPut(Char,Common,StrPtr+ChrPtr)# Stuff the character in string
      Length(ChrPtr) = EmAPut(Char)	# Stuff length
      }
    }				# End Switch
  }				# End repeat loop
Call EmCPut(ChrPtr,Common,LenPtr)	# Stuff length
Edting = FALSE			# Tell EmIKb he can substitute special keys
 
Return
End
E 1
