h63593
s 00619/00000/00000
d D 1.1 83/03/23 15:26:27 bog 1 0
c date and time created 83/03/23 15:26:27 by bog
e
u
4
U
t
T
I 1
include(ghcomn.m)
 
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#	Function:  							    #
#		Subroutine GHChNW (Ch,Error)				    #
#			Output	Ch:	Integer in [EMPTY,BREAK,NUL..255]   #
#				Error:	Integer error return code	    #
#					   0:	No error		    #
#					   1:	Parity error		    #
#					   2:	Overrun error		    #
#					   3:	Parity and overrun errors   #
#					   4:	Not currently open error    #
#		    Return next character from port, or EMPTY if none	    #
#									    #
#	Called By:							    #
#	    Application program.					    #
#									    #
#	Routines Called:						    #
#		Subroutine HsRecv (Ch,Error)				    #
#			Output	Ch:	ADE-coded integer in		    #
#					  [BREAK,EMPTY,NUL..255]	    #
#				Error:	Integer error code:		    #
#					  0:  No error			    #
#					  1:  Parity error on character	    #
#					  2:  Overrun error on character    #
#					  3:  Both parity and overrun	    #
#		    Return the next character from the host port or EMPTY   #
#		    if none available.  BREAK is returned if the port found #
#		    a BREAK condition on the line.			    #
#									    #
#############################################################################
 
Subroutine GHChNW(Ch,Error)
INTEGER Ch,Error
 
COMMSTATECOMMON()
 
If (COpen == 0) {
  Error = OPENERROR
  }
 Else {
  Call HsRecv(Ch,Error)
  }
 
Return
End
 
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#	Function:  							    #
#		Subroutine GHChOt (Ch,Error)				    #
#			Input	Ch:	Integer in [BREAK,NUL..255]	    #
#			Output	Error:	Integer error return code	    #
#					  -1:   Port busy; not sent	    #
#					   0:	No error		    #
#					   1:	Not capable error	    #
#					   4:	Not currently open error    #
#		    If the port is not busy, send out Ch.  Error set if not #
#		    capable of sending code specified.			    #
#									    #
#	Called By:							    #
#	    Application program.					    #
#									    #
#	Routines Called:						    #
#		Subroutine HsSend (Ch,Busy)				    #
#			Input	Ch:	ADE-coded integer in		    #
#					  [BREAK,NUL..255]		    #
#			Output	Busy:	Integer busy flag		    #
#					  -1:  busy; Ch not sent	    #
#					   0:  Ch sent successfully	    #
#		    If the port is not busy, send a character.		    #
#									    #
#############################################################################
 
Subroutine GHChOt(Ch,Error)
INTEGER Ch,Error
 
COMMSTATECOMMON(
`
COMMCAPABILITYCOMMON()
')
 
If (COpen == 0) {
  Error = OPENERROR
  }
 Else {
  If ((Ch == BREAK) & (TxBkCp == 0)) {
    Error = NOTCAPABLEERROR
    }
   Else {
    Call HsSend(Ch,Error)
    }
  }
 
Return
End
 
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#	Function:  							    #
#		Subroutine GHInit (InParm,InStSt,InGoSt,OtStSt,OtGoSt,Error)#
#			Input	InParm:	Array [1..12] of integer	    #
#				  (1):	Receive baud rate		    #
#				  (2):	Transmit baud rate; may be zero if  #
#					 same as receive		    #
#				  (3):	Parity control			    #
#					  0:	No parity		    #
#					  1:	Odd parity		    #
#					  2:	Even parity		    #
#				  (4):	Number of data bits per character   #
#				  (5):	Number of stop bits per character   #
#					  0:	if not capable		    #
#					  1:	1 stop bit		    #
#					  2:	1.5 stop bits		    #
#					  3:	2 stop bits		    #
#				  (6):	Transmit BREAK milliseconds	    #
#				  (7):	Input flagging mode		    #
#					    0:	None			    #
#					    1:  Stop/go string		    #
#					    2:  DSR/DTR			    #
#				  (8):	Output flagging mode		    #
#					    0:	None			    #
#					    1:  Stop/go string		    #
#					    2:  RTS/CTS			    #
#				  (9):	Length of input stop string	    #
#				 (10):	Length of input go string	    #
#				 (11):	Length of output stop string	    #
#				 (12):	Length of output go string	    #
#				InStSt:	CHARACTER array input stop string   #
#				InGoSt:	CHARACTER array input go string	    #
#				OtStSt:	CHARACTER array output stop string  #
#				OtGoSt: CHARACTER array output go string    #
#			Output	Error:	Integer error return code	    #
#					  0:	No error		    #
#					  1:	Not capable error	    #
#					  2:	String too long error	    #
#					  3:	Illegal request error	    #
#					  4:	Already open error	    #
#					If an error occurs, no action	    #
#					is taken.			    #
#		    If the request is valid for the capabilities of the	    #
#		    communications driver employed, the communications	    #
#		    channel is initialized.				    #
#									    #
#	Called By:							    #
#	    Application program.					    #
#									    #
#	Routines Called:						    #
#		Logical Function GHLUEr(Index,Len,Dim,Array)		    #
#									    #
#############################################################################
 
Subroutine GHInit(InParm,InStSt,InGoSt,OtStSt,OtGoSt,Error)
INTEGER InParm(12)
CHARACTER InStSt(FLAGSTRINGDIM)
CHARACTER InGoSt(FLAGSTRINGDIM)
CHARACTER OtStSt(FLAGSTRINGDIM)
CHARACTER OtGoSt(FLAGSTRINGDIM)
INTEGER Error
 
LOGICAL GHLUEr				# Table-lookup validity function
External GHLUEr
 
LOGICAL StRqEr				# Legal string req error stmt func
INTEGER Mode,StoLen,GoLen
 
LOGICAL StCpEr				# String capability error stmt func
INTEGER StCap,StoCh,GoCh,HwCap
 
# Locals
INTEGER LRBaud				# Local Rx baud rate then index
INTEGER LTBaud				#   Tx baud rate then index
INTEGER LDatBt				#   number of data bits then index
INTEGER LStoBt				#   number of stop bits then index
INTEGER I
 
COMMSTATECOMMON(
`
COMMCAPABILITYCOMMON()
')
 
# Stop/Go string request error or conflict statement function
StRqEr(Mode,StoLen,GoLen) =
    ( (Mode == 1) &			# Stop/go string mode
      ((StoLen < 1) | (GoLen < 1))_	#  & some length not positive
    ) | (
      (Mode != 1) &			# Not Stop/go string mode
      ((StoLen != 0) | (GoLen != 0))_	#  & some length not zero
    )
 
# Stop/Go string capability error statement function
StCpEr(Mode,StCap,StoLen,GoLen,StoCh,GoCh,HwCap) =
    ( (Mode == 1) &			# String flagging &
      ( (StCap == 0) |			#  not string capable or
	( (StCap == 1) &		#  single char only and req multiple
	  ( (StoLen != 1) |
	    (GoLen != 1) _
	  ) _
	) _
      ) _
    ) | (
      (Mode == 2) & (HwCap == 0) _	# Hw flag req and incapable
    )
 
#########################################
 
Error = NOERROR				# Assume no errors
 
LRBaud = InParm(1)			# RxBaud setting now; index later
 
LTBaud = InParm(2)			# TxBaud setting now; index later
If ((LTBaud == 0) & (TBdCpL != 0)) {
  LTBaud = LRBaud			# Match RxBaud if split rate capable
  }
 
LDatBt = InParm(4)			# DataBit setting now; index later
 
LStoBt = InParm(5)			# StopBit setting now; index later
 
If (COpen != 0) {			# Already open error
  Error = OPENERROR
  }
 Else {					# Invalid requests
  If ( (LRBaud < 0)				# Inv receive baud rate
     | (LTBaud < 0)				# Inv transmit baud rate
     | (InParm(3) < 0) | (InParm(3) > 2)	# Inv parity request
     | (LDatBt < 0)				# Inv number of data bits
     | (LStoBt < 0)				# Inv number of stop bits
     | (InParm(6) < 0)				# Inv BREAK time
     | (InParm(7) < 0) | (InParm(7) > 2)	# Inv input flagging mode
     | (InParm(8) < 0) | (InParm(8) > 2)	# Inv output flagging mode
     | StRqEr(InParm(7),InParm(9),InParm(10))	# Inv in flag string
     | StRqEr(InParm(8),InParm(11),InParm(12))	# Inv out flag string
     ) {
    Error = REQUESTERROR
    }
   Else {				# Driver incapable errors
    If ( GHLUEr(LRBaud,RBdCpL,BAUDDIM,RxBdCp)	# Receive baud error?
       | GHLUEr(LTBaud,TBdCpL,BAUDDIM,TxBdCp)	# Transmit baud error?
       | ((InParm(3) != 0) & (ParCap == 0))	# Parity controllable?
       | GHLUEr(LDatBt,DtBCpL,DATABITDIM,DtBtCp)# Data bits error?
       | GHLUEr(LStoBt,StBCpL,STOPBITDIM,StBtCp)# Stop bits error?
       | ((InParm(6) != 0) & (TBkTCp == 0))	# BREAK timing controllable?
       | ( (SpFMCp == 0) &				# Differing flag modes and
	   (InParm(7) != 0) &			#  incapable
	   (InParm(8) != 0) &
	   (InParm(7) != InParm(8))
	 )
       | StCpEr(InParm(7),RStFCp,InParm(9),InParm(10),
	    InStSt(1),InGoSt(1),RHwFCp)		# Rx string capability error?
       | StCpEr(InParm(8),TStFCp,InParm(11),InParm(12),
	    OtStSt(1),OtGoSt(1),THwFCp)		# Tx string capability error?
       ) {
      Error = NOTCAPABLEERROR
      }
 
     Else {			# String too long for common errors
      If ( (InParm(9) > FLAGSTRINGDIM)	# InStSt too long
	 | (InParm(10) > FLAGSTRINGDIM)	# InGoSt too long
	 | (InParm(11) > FLAGSTRINGDIM)	# OtStSt too long
	 | (InParm(12) > FLAGSTRINGDIM)	# OtGoSt too long
	 ) {
	Error = LENGTHERROR
	}
       Else {		# Legitimate request of which the driver is capable
	RBaudI = LRBaud			# Rx baud rate and index
	If (LRBaud == 0) {
	  CRBaud = 0
	  }
	 Else {
	  CRBaud = RxBdCp(LRBaud)
	  }
 
	TBaudI = LTBaud			# Tx baud rate and index
	If (LTBaud == 0) {
	  CTBaud = 0
	  }
	 Else {
	  CTBaud = TxBdCp(LTBaud)
	  }
 
	CurPar = InParm(3)		# Parity setting
 
	DatBtI = LDatBt			# Number of data bits and index
	If (LDatBt == 0) {
	  CDatBt = 0
	  }
	 Else {
	  CDatBt = DtBtCp(LDatBt)
	  }
 
	StoBtI = LStoBt			# Number of stop bits and index
	If (LStoBt == 0) {
	  CStoBt = 0
	  }
	 Else {
	  CStoBt = StBtCp(LStoBt)
	  }
 
	CBkTim = InParm(6)		# BREAK time
 
	CIFMod = InParm(7)		# Rx flagging mode
 
	COFMod = InParm(8)		# Tx flagging mode
 
	CInStL = InParm(9)		# Rx stop string
	For (I = 1; I <= CInStL; I = I+1) {
	  CInStS(I) = InStSt(I)
	  }
 
	CInGoL = InParm(10)		# Rx go string
	For (I = 1; I <= CInGoL; I = I+1) {
	  CInGoS(I) = InGoSt(I)
	  }
 
	COtStL = InParm(11)		# Tx stop string
	For (I = 1; I <= COtStL; I = I+1) {
	  COtStS(I) = OtStSt(I)
	  }
 
	COtGoL = InParm(12)		# Tx go string
	For (I = 1; I <= COtGoL; I = I+1) {
	  COtGoS(I) = OtGoSt(I)
	  }
 
	Call HsInit			# Communication via Common
	COpen = -1			# Channel now open
	}
      }
    }
  }
Return
End
 
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#	Function:  							    #
#		Subroutine GHInqC (DevCpI,DevCpL,RxBaud,TxBaud,DatBit,	    #
#					StoBit,Error)			    #
#			Input	DevCpI:	Array [1..6] of integer		    #
#				  (1):	Dimension of RxBaud		    #
#				  (2):	Dimension of TxBaud		    #
#				  (3):	Dimension of DatBit		    #
#				  (4):	Dimension of StoBit		    #
#			Output	DevCpI:	Array [1..6] of integer		    #
#				  (1):	Actual length of RxBaud		    #
#				  (2):	Actual length of TxBaud		    #
#				  (3):	Actual length of DatBit		    #
#				  (4):	Actual length of StoBit		    #
#				  (5):	Rx string flagging capability	    #
#					 0:  Not capable of control	    #
#					 1:  Capable of single-char flagging#
#					 2:  Capable of flagging with	    #
#					      arbitrary data strings	    #
#				  (6):	Tx string flagging capability	    #
#					 0:  Not capable of control	    #
#					 1:  Capable of single-char flagging#
#					 2:  Capable of flagging with	    #
#					      arbitrary data strings	    #
#				DevCpL:	Array [1..6] of logical; true if:   #
#				  (1):	 Parity is controllable		    #
#				  (2):	 BREAK can be transmitted	    #
#				  (3):	 BREAK time is controllable	    #
#				  (4):	 Receive h/w flagging controllable  #
#				  (5):	 Transmit h/w flagging controllable #
#				  (6):	 Receive/transmit flagging modes    #
#					  can differ			    #
#				RxBaud:	Integer array [1..n] of receive baud#
#					 rates.  External is encoded as -1. #
#				TxBaud:	Integer array [1..n] of transmit    #
#					 baud rates.  External is encoded as#
#					 -1.  If the driver is not capable  #
#					 of changing rates, DevCpI(1) and   #
#					 DevCpI(2) will be zero.  If	    #
#					 transmit and receive rates cannot  #
#					 be split, DevCpI(2) will be zero   #
#					 and the receive array should be    #
#					 used.				    #
#				DatBit:	Integer array [1..n] of valid data  #
#					 bits per character.  DevCpI(3) will#
#					 be zero if not controllable.	    #
#				StoBit:	Integer array [1..n] of valid stop  #
#					 bits per character.  DevCpI(4) will#
#					 be zero if not controllable.	    #
#					 Encoding:			    #
#					  1:	1 stop bit		    #
#					  2:	1.5 stop bits		    #
#					  3:	2 stop bits		    #
#				Error:	Integer error return code	    #
#					  0:	No error		    #
#					  2:	Array too long error	    #
#					If a length error occurs, the	    #
#					array is filled only up to its	    #
#					dimension, but the actual length    #
#					will reflect the length the array   #
#					should be.			    #
#		    Return host communications capabilities.		    #
#									    #
#	Called By:							    #
#	    Application program.					    #
#									    #
#	Routines Called:						    #
#		Subroutine GHMvAr (Dim,Len,Dest,Source,Error)		    #
#									    #
#############################################################################
 
Subroutine GHInqC(DevCpI,DevCpL,RxBaud,TxBaud,DatBit,StoBit,Error)
INTEGER DevCpI(6)
LOGICAL DevCpL(5)
INTEGER RxBaud(BAUDDIM)
INTEGER TxBaud(BAUDDIM)
INTEGER DatBit(DATABITDIM)
INTEGER StoBit(STOPBITDIM)
INTEGER Error
 
COMMCAPABILITYCOMMON()
 
Error = NOERROR				# Assume no errors
 
Call GHMvAr(DevCpI(1),RBdCpL,RxBaud,RxBdCp,Error)	# Build RxBaud
Call GHMvAr(DevCpI(2),TBdCpL,TxBaud,TxBdCp,Error)	# Build TxBaud
Call GHMvAr(DevCpI(3),DtBCpL,DatBit,DtBtCp,Error)	# Build DatBit
Call GHMvAr(DevCpI(4),StBCpL,StoBit,StBtCp,Error)	# Build StoBit
 
DevCpI(5) = RStFCp		# Receive string flagging capability
DevCpI(6) = TStFCp		# Transmit string flagging capability
 
DevCpL(1) = ParCap != 0		# Parity capability
DevCpL(2) = TxBkCp != 0		# BREAK sending capability
DevCpL(3) = TBkTCp != 0		# BREAK timing capability
DevCpL(4) = RHwFCp != 0		# Receive hardware flagging capability
DevCpL(5) = THwFCp != 0		# Transmit hardware flagging capability
DevCpL(6) = SpFMCp != 0		# Receive/transmit flagging modes can differ
 
Return
End
 
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#	Function:  							    #
#		Logical Function GHLUEr(Index,Len,Dim,Array)		    #
#			Input	Index:	Integer requested setting; zero if  #
#					 uncontrolled			    #
#				Len:	Integer array item count; zero if   #
#					 uncontrollable			    #
#				Dim:	Integer dimension of Array	    #
#				Array:	[1..Dim] of integer settings	    #
#			Output	Index:	Index of requested setting if ok    #
#				GHLUEr:	TRUE if capability error	    #
#		    Baud rate, data bits, stop bits capability check	    #
#									    #
#	Called By:							    #
#									    #
#	Routines Called:						    #
#									    #
#############################################################################
 
LOGICAL Function GHLUEr(Index,Len,Dim,Array)
INTEGER Index
INTEGER Len
INTEGER Dim
INTEGER Array(Dim)
 
INTEGER I
 
GHLUEr = TRUE				# Assume not legitimate
 
If ((Index == 0) & (Len == 0)) {	# Correct request for incapable
  GhLUEr = FALSE
  }
 Else {
  If ((Index != 0) & (Len != 0)) {	# May be correct capable request
    For (I = 1; I <= Len; I = I+1) {	# Step looking for match
      If (Index == Array(I)) {		# Found match
	Index = I			# Now it's an index, not a setting
	GHLUEr = FALSE			# Valid setting found
	}
      }
    }
  }
 
Return
End
 
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#	Function:  							    #
#		Subroutine GHMvAr (Dim,Len,Dest,Source,Error)		    #
#			Input	Dim:	Integer length of Dest		    #
#				Len:	Integer length of Source	    #
#				Source:	Integer array [1..Len] of	    #
#					 parameters			    #
#				Error:	Integer errors so far		    #
#			Output	Dim:	Actual length of Source		    #
#				Dest:	Integer array [1..Dim] of returned  #
#					 parameters			    #
#				Error:	Integer errors including this	    #
#		    Pass parameter array to inquirer.			    #
#									    #
#	Called By:							    #
#									    #
#	Routines Called:						    #
#									    #
#############################################################################
 
Subroutine GHMvAr(Dim,Len,Dest,Source,Error)
INTEGER Dim
INTEGER Len
INTEGER Dest(Dim)
INTEGER Source(Len)
INTEGER Error
 
CHARACTER Last,I
 
Last = Len				# Assume fill to actual length
If (Last > Dim) {			# If actual length > dimension
  Last = Dim				#    fill to dimension
  Error = LENGTHERROR			#    set length error
  }
Dim = Len				# Return actual length
 
For (I = 1; I <= Last; I = I+1) {
  Dest(I) = Source(I)			# Fill through min(actual,dim)
  }
 
Return
End
 
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#	Function:  							    #
#		Subroutine GHStop (Error)				    #
#			Output	Error:	Integer error code		    #
#					  0:	No error		    #
#					  4:	Not open error		    #
#		    Terminate host communications			    #
#									    #
#	Called By:							    #
#		Application program.					    #
#									    #
#	Routines Called:						    #
#		Subroutine HsStop					    #
#		    Close the communications channel.			    #
#									    #
#############################################################################
 
Subroutine GHStop(Error)
INTEGER Error
 
COMMSTATECOMMON()
 
If (COpen != 0) {
  Error = NOERROR
  Call HsStop
  COpen = 0
  }
 Else {
  Error = OPENERROR
  }
 
Return
End
E 1
