h08606
s 00000/00000/00058
d D 1.3 83/02/09 11:40:29 mrk 3 2
c no changes made
e
s 00000/00000/00058
d D 1.2 83/01/28 14:03:57 tes 2 1
c initial_internal_update
e
s 00058/00000/00000
d D 1.1 83/01/28 13:05:14 tes 1 0
c date and time created 83/01/28 13:05:14 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine leglbl (item, ilen, string)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set up a legend label                                  #
#                                                                      #
#     Input Parameters:                                                #
#            item   - legend item number                               #
#            ilen   - length of text string                            #
#            string - text string                                      #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gptxat - set up the proper text environment               #
#            imove  - modify current position for latter action        #
#            text   - output a string of graphic text                  #
#                                                                      #
########################################################################
integer item, ilen, string(1)

real x, y
 
include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) item, ilen, string(1)
DxB 100 format (' leglbl:', 3i5)
 
   if (item > 0 & item <= nleged)   {
      nclip = YES           # Turn clipping on for the string
      njust(LEGENDxTEXTxATT) = 1       # Justify to lower left corner
      call gptxat (LEGENDxTEXTxATT)    # Set up the text attributes
      x = zlgxy(1) + zxlspc    # Calculate the x position for the legend item.
                            # The glogal ZLGXY is the location of the upper
                            # left hand corner of the legend. The global
                            # ZXLSPC is the distance to offset so as to leave
                            # space for the legend line or bar type.
      y = zlgxy(2) - float(item)*zylspc # Calculate y position of legend item.
                            # The Global ZLGXY is the location of the upper
                            # left corner of the legend. The global ZYLSPC
                            # is the distance to be used to move between lines
                            # of the legend. The parameter ITEM is used to
                            # position to the correct line.
      call imove (ABSOLUTE, x, y)
      call text (ilen, string)
      nclip = NO            # All done with clipping
      }
 
   return
end
E 1
