h43415
s 00009/00021/00066
d D 1.3 83/03/08 20:21:47 tes 3 2
c modified axis pipeline for integer calculations
e
s 00006/00002/00081
d D 1.2 83/01/28 14:02:18 tes 2 1
c initial_internal_update
e
s 00083/00000/00000
d D 1.1 83/01/28 13:04:49 tes 1 0
c date and time created 83/01/28 13:04:49 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine idraw (mode, x, y)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: do a polyline                                          #
#                                                                      #
#     Input Parameters:                                                #
#            mode - 1 = Absolute,  2 = Relative                        #
#            x - x coordinate                                          #
#            y - y coordinate                                          #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device driver control                            #
#                                                                      #
########################################################################
integer mode
real x, y 

D 3
integer contrl(5), opcd, intin(1), ptsout(1), intout(1), ipos
E 3
I 3
integer dc(2)
E 3
real xtemp, ytemp, pnt1(2), pnt2(2)
logical q1, q2, qgone
include(`pltcom')

# The following equivelences were made to reduce code size:
D 3
#     contrl(1) = opcd
E 3
#     pnt2(1)   = xtemp
#     pnt2(2)   = ytemp

D 3
equivalence  (pnt2(1),xtemp), (pnt2(2),ytemp),
             (contrl(OPCODE), opcd)
E 3
I 3
equivalence  (pnt2(1),xtemp), (pnt2(2),ytemp)
E 3


D 3
   if (ncount == 10)   {  # Time to dump the buffer
      opcd = POLYLINE 
      contrl(2) = 10    # Set the number of vertices to 10 for output
 
      call gzddop (contrl, intin, npnts, intout, ptsout)

      ncount = 1  # Reset count 
      npnts(1) = npnts(19)# Set new start position to the last point drawn to
      npnts(2) = npnts(20)
      }


E 3
   if (mode == ABSOLUTE)   {   # an absolute draw
      xtemp = x
      ytemp = y
      }
   else  {
      xtemp = x + zxabsl
      ytemp = y + zyabsl
      }

   if (nclip == YES)   {  # Do the clipping if needed

      pnt1(1) = zxabsl # Set point to start of vector
      pnt1(2) = zyabsl
     
      call lnclip (pnt1, pnt2, q1, q2, qgone)
D 2

      if (qgone)   return # Entire segment was clipped
E 2
I 2
      if (q1)  {  # If the last point moved, fix it
D 3
         ipos = 2*ncount - 1
         call gpn2dc (pnt1(1), pnt1(2), npnts(ipos))
E 3
I 3
         call gpn2dc (pnt1(1), pnt1(2), dc)
	 call gpzmov (ABSOLUTE, dc(1), dc(2))
E 3
	 }
E 2
      }
I 3
   else {
      qgone = .false.
      }
E 3

   zxabsl = xtemp   # Update the current position for next vector
   zyabsl = ytemp
I 2

   if (qgone)   return # Entire segment was clipped
E 2

   # Convert into 32k device corrdinates
D 3
   ncount = ncount + 1
   ipos = 2*ncount - 1
   call gpn2dc (xtemp, ytemp, npnts(ipos))
E 3
I 3
   call gpn2dc (xtemp, ytemp, dc)
   call gpzdrw (ABSOLUTE, dc(1), dc(2))
E 3

  return
end
E 1
