h00028
s 00000/00000/00164
d D 1.2 83/03/31 12:45:45 mmm 2 1
c 
e
s 00164/00000/00000
d D 1.1 83/03/15 21:45:11 tes 1 0
c date and time created 83/03/15 21:45:11 by tes
e
u
4
U
t
T
I 1
subroutine gzcleg (insiz, xin, yin, edge, code, outsiz, xout, yout)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: clip a polygon against a given edge                    #
#                                                                      #
#     Input Parameters:                                                #
#            insiz - number of input points                            #
#            xin   - array of x coordinates                            #
#            yin   - array of y coordinates                            #
#            edge  - edge to be clipped against                        #
#            code  - relative location of clipping edge                #
#     Output Parameters:                                               #
#            outsiz - number of output points                          #
#            xout   - array of x coordinates                           #
#            yout   - array of y coordinates                           #
#                                                                      #
#     Routines Called:                                                 #
#            gzplpt - move point array to multiple output arrays       #
#            gzints - find intersection of two lines                   #
#                                                                      #
########################################################################
integer insiz, code, outsiz
real xin(1), yin(1), edge, xout(1), yout(1)
 
integer i, index, j
real px, py, dist,
     e1(2), e2(2), ex1, ey1, ex2, ey2,
     f(2), fx, fy,
     pnew(2), pnewx, pnewy,
     s(2), sx, sy
logical qint, qinsid
 
include(`gkscom')

# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements. The arrays and the
#    variables equivalenced are listed below:
#
#       e1(1) :: ex1
#       e1(2) :: ey1
#
#       e2(1) :: ex2
#       e2(2) :: ey2
#
#       f(1) :: fx
#       f(2) :: fy
#
#       pnew(1) :: pnewx
#       pnew(2) :: pnewy
#
#       s(1) :: sx
#       s(2) :: sy
 
equivalence (e1(1), ex1), (e1(2), ey1),
            (e2(1), ex2), (e2(2), ey2),
            (f(1), fx), (f(2), fy),
            (pnew(1), pnewx), (pnew(2), pnewy),
            (s(1), sx), (s(2), sy)
 
   # Assumptions:
   #
   #   Input coordinates are in NDC space
   #   "edge" is in NDC space
 
   outsiz = 0   # initialize the output polygon size to zero (entire clip)

   #   we initially set the polygon clipping edge to a diagonal much larger
   # than the expected values in NDC space. We are assuming here that the
   # user's coordinates, when transformed, will be somewhere in the area
   # of 0-1 space. This could be a future bug but will be very data dependent
   # because the clipping line extents are 4 orders of magnitude larger than
   # the expected values in NDC space.
   e1(1) = -32768.
   e1(2) = -32768.
   e2(1) = 32768.
   e2(2) = 32768.
   index = 1
   if (code == TOP | code == BOTTOM) index = 2
   e1(index) = edge
   e2(index) = edge
 
   #   sx and sy -- start point for current line segment
   #   fx and fy -- final point for polygon closure
   #   px and py -- end point for current line segment 
   #
   #   loop for each line segment and clip to the current edge which is defined
   #   by the variables e1 and e2.

   j = insiz
   for (i=1; i<=j; i=i+1) {
      px = xin(i)
      py = yin(i)
      if (i == 1) {   # on the first time through initialize the start and
		      # final points.
         #   s(1) = px
         #   s(2) = py
         sx = px           # set the start point
         sy = py
 
         #   f(1) = px
         #   f(2) = py
         fx = px          # save the last point for polygon closure
         fy = py
 
         }
      else {
 
	 # check for intersection of the current line segment, (sx,sy) and
	 # (px,py), with the clipping edge (ex1,ey1) and (ex2,ey2).
         call gzints (sx, sy, px, py, ex1, ey1, ex2, ey2, qint, pnewx, pnewy)
 
         #   s(1) = px
         #   s(2) = py
         sx = px        # set (sx,sy) for the next line segment
         sy = py

         if (qint) {   # if there was a line intersection copy the intersection
		       #   point to the output.
            call gzplpt (pnew, outsiz, xout, yout)
            }
	 }

      # check to see if the end point of the current line segment is inside the
      #    clipping edge. If the end point is inside, copy it to the output.
      qinsid = .false.
      dist = s(index) - edge
      if (code == RIGHT | code == TOP) {
         if (dist <= 0.0) qinsid = .true.
         }
      else {
         if (dist >= 0.0) qinsid = .true.
         }
      if (qinsid) {
         call gzplpt (s, outsiz, xout, yout)
         }
      }

   if (outsiz > 0) {
      # Insure that the polygon is closed by joining the first and last
      # points
      if ((xout(1) != xout(outsiz)) | (yout(1) != yout(outsiz))) {
         outsiz = outsiz + 1
         xout(outsiz) = xout(1)
         yout(outsiz) = yout(1)
         }
      }
 
#   if (outsiz > 0) {
#      call gzints (sx, sy, fx, fy, ex1, ey1, ex2, ey2, qint, pnewx, pnewy)
#      if (qint) {
#         call gzplpt (pnew, outsiz, xout, yout)
#         }
#      }
 
   return
end
E 1
