h01447
s 00005/00007/00092
d D 1.2 83/03/31 12:35:29 mmm 2 1
c 
e
s 00099/00000/00000
d D 1.1 83/03/15 21:40:50 tes 1 0
c date and time created 83/03/15 21:40:50 by tes
e
u
4
U
t
T
I 1
subroutine gpl (n, px, py)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Perform a series of absolute draws connecting points   #
#               specified in world space                               #
#                                                                      #
#     Input Parameters:                                                #
#            n       - number of points to connect                     #
#            px      - array of x coordinates in world space           #
#            py      - array of y coordinates in world space           #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Errors:                                                          #
#            5  GKS not in proper state: GKS must be in the state      #
#               WSAC or in the state SGOP                              #
#          100  Number of points invalid                               #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            gwddc2 - convert/clip line from world to device           #
#            gzddop - call current device driver                       #
#                                                                      #
########################################################################
integer n        
real px(n), py(n)

integer contrl(5), opcd, vertin, idummy(1), i, ptsin(4)
D 2
real linein(4) 
E 2
I 2
real linein(4), gtreal 
E 2
logical q1move, q2move, qgone

D 2
REALS GETREAL

E 2
ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')
 
include(`gkscom')

# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements. The arrays and the
#    variables equivalenced are listed below:
#
#       contrl(OPCODE) :: opcd
#       contrl(VERTICESxIN) :: vertin
 
equivalence (contrl(OPCODE), opcd), (contrl(VERTICESxIN), vertin)

ifdef(`ERROR_ON',`
      rounum = GPL
      errind = errchk(ierdum(1), ierdum)
      ')

if (n <= 1) {
   ifdef(`ERROR_ON',`call gkserr (100)')
   return
   }

D 2
   linein(1) = GETREAL(px(1)) # Set first point of line (move to)
   linein(2) = GETREAL(py(1))
E 2
I 2
   linein(1) = gtreal (px, 0) # Set first point of line (move to)
   linein(2) = gtreal (py, 0)
E 2

   opcd = POLYLINE 
   vertin = 2    # Set the number of vertices to 2 for output

   for (i=2; i<=n; i=i+1) {  # Loop over line segs of polyline
 
D 2
      linein(3) = GETREAL(px(i))  # Set second point of line (draw to)
      linein(4) = GETREAL(py(i))
E 2
I 2
      linein(3) = gtreal (px, i-1)  # Set second point of line (draw to)
      linein(4) = gtreal (py, i-1)
E 2

      # Transform and clip from world to device coordinates
      
      call gwddc2 (linein, ptsin, q1move, q2move, qgone) 

      # is everything gone?
      if (!qgone) {
 
         # Ship the two points to POLYLINE

         call gzddop (contrl, idummy, ptsin, idummy, idummy)
 
	 # Set screen flag to erase
         eraflg = YES
	 }
      
      linein(1) = linein(3)  # Reinitialize for next line segment
      linein(2) = linein(4)
      }
 
   return
end
E 1
