h24343
s 00000/00000/00065
d D 1.6 83/02/01 19:29:50 mjb 6 5
c fixed problem with checking for 0 file descriptors
e
s 00001/00000/00064
d D 1.5 83/01/31 16:21:50 mjb 5 4
c fixed and implemented multi file error reporting
e
s 00007/00007/00057
d D 1.4 83/01/30 18:29:42 mjb 4 3
c error reporting bug fixing
e
s 00019/00022/00045
d D 1.3 83/01/29 16:37:49 mjb 3 2
c made changes for save restore of multi files and error reporting
e
s 00003/00003/00064
d D 1.2 83/01/20 14:44:44 mjb 2 1
c modified for multiple graphs
e
s 00067/00000/00000
d D 1.1 83/01/20 11:15:12 tes 1 0
c date and time created 83/01/20 11:15:12 by tes
e
u
tes
mjb
U
t
T
I 1
D 3
integer function rdwrit (mode, fname, buffer, length)
E 3
I 3
subroutine rdwrit (mode, fname, buffer, length)
E 3
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Open and READ or WRITE to a given file                 #
#                                                                      #
#     Input Parameters:                                                #
#            mode - mode to open file in                               #
#            fname - file name to open and close                       #
#            buffer - buffer to read and write from                    #
#            length - number of bytes to read and write                #
#                                                                      #
#     Output Parameters:                                               #
D 3
#            rdwrit - 0 upon successful operation, -1 if not           #
E 3
I 3
#            none                                                      #
E 3
#                                                                      #
#     Routines Called:                                                 #
#            None                                                      #
#                                                                      #
########################################################################
D 2
SHORTINT fname(14), buffer(1)
E 2
I 2
D 3
SHORTINT fname(1), buffer(1)
E 3
I 3
SHORTINT fname(1), buffer(1), locbuf(3)
E 3
E 2
ifdef(`UNIX',`character*14 ufname')
integer mode, length

D 3
integer fildes, i
E 3
I 3
D 4
integer fildes, i, itemp
E 4
I 4
integer fildes, i, itemp, kmode
E 4
E 3

D 3
integer gdopen, gdclos, gdread, gdwrit
E 3
I 3
integer gdopen, gdclos, gdseek, gdread, gdwrit
E 3

D 3
   rdwrit = 0
E 3
I 3
include(`gphcom')
E 3

I 3
equivalence (locbuf(2), itemp)

E 3
   ifdef(`UNIX',`
      do i = 1,14 {
         ufname(i:i) = char (fname(i))
         }
      ')
D 3

E 3
   ifdef(`UNIX',
      `fildes = gdopen (ufname, mode)',
      `fildes = gdopen (fname, mode)')

D 2
   if (fildes > 0) {
      if (mode > 3) mode = mode - 3
E 2
I 2
D 3
   if (fildes >= 0) {
      if (mode > 2) mode = mode - 3
E 2
      if (mode > ASCIIxREAD) {       # Must be a write
	 i = gdwrit (fildes, buffer, length)
	 }
      else {
	 i = gdread (fildes, buffer, length)
	 }
      if (i != length) {
	 rdwrit = -1
	 pause 6969
	 }
      i = gdclos (fildes)
E 3
I 3
   locbuf(1) = multfg         # Initialize header buffer
   itemp = length  

I 5
   kmode = mode
E 5
D 4
   if (mode > 2) mode = mode - 3
   if (mode > ASCIIxREAD) {       # Must be a write
      i = gdwrit (fildes, locbuf, 3)     # Write out header
      i = gdwrit (fildes, buffer, length)# Write out file itself
      i = gdwrit (fildes, locbuf, 3)     # Write out trailer
E 4
I 4
   if (mode > 2) kmode = mode - 3
   if (kmode > ASCIIxREAD) {       # Must be a write
      i = gdwrit (fildes, locbuf, HEADERxLENGTH)     # Write out header
      i = gdwrit (fildes, buffer, length)            # Write out file itself
      i = gdwrit (fildes, locbuf, HEADERxLENGTH)     # Write out trailer
E 4
E 3
      }
   else {
D 3
      rdwrit = -1
      pause 6970
E 3
I 3
D 4
      i = gdseek (fildes, 0, 3)          # Ignore header
E 4
I 4
      i = gdseek (fildes, 0, HEADERxLENGTH)          # Ignore header
E 4
      i = gdread (fildes, buffer, length)
E 3
      }
I 3
   i = gdclos (fildes)
E 3

return
end
E 1
