h11791
s 00005/00003/00155
d D 1.2 83/01/28 23:26:49 tes 2 1
c modified apmenu interface to include a clear screen flag
e
s 00158/00000/00000
d D 1.1 83/01/20 11:08:40 tes 1 0
c date and time created 83/01/20 11:08:40 by tes
e
u
tes
mjb
U
t
T
I 1
D 2
subroutine apmenu (id)
E 2
I 2
subroutine apmenu (id, clear)
E 2
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Make a menu appear on console                          #
#                                                                      #
#     Input Parameters:                                                #
#            id    - (integer) menu identification number              #
I 2
#            clear - (integer) YES -> clear screen, NO -> no clear     #
E 2
#                                                                      #
#     Output Parameters:                                               #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            qtext - output text string at given location              #
#                                                                      #
########################################################################
D 2
integer id
E 2
I 2
integer id, clear
E 2

integer i, j, k, row, column, cmdlen
integer mode, type, length, kount, rev

SHORTINT locbuf(81), c

include(`mnucom')

D 2
call clrscr
E 2
I 2
# Clear the screen if required
if (clear == YES) call clrscr
E 2

for (i=1; i<=lastid; i=i+1) {
   if (id == mnuid(i)) break;
   }

if (i <= lastid) {
   crntid = id   # set global current menu id
   j = midptr(i)
   call revers (0)

   # the field data structure has the following format:
   #   each field is made up of a minimum of 7 bytes (choice) and is defined
   #   as follows:
   #
   #   /command length/
   #   /row/
   #   /column/
   #   /field length/
   #   /video type + field type/
   #   /multiple field count/
   #   /toggle characters or seperator character terminated with null/
   #   
   #   the video type + field type item is defined as follows:
   #
   #      /video type + field type/
   #             video reversed = 8
   #             field type >   1=Alpha
   #                            2=Integer
   #                            3=Decimal
   #                            4=Choice
   #                            5=Toggle
   #                            6=Seperator
   
   while (mnubuf(j) != 0) {
      row = mnubuf(j)
      column = mnubuf(j+1)
      call qtext (row, column, mnubuf(j+2))
      while (mnubuf(j) != 0) j = j + 1
      j = j + 1
      }
   dtaptr = 1   # initialize screen description buffer pointers
   chcptr = 1
   j = fldptr(i)
   while (fldbuf(j) != 0) {
      cmdlen = fldbuf(j)
      row = fldbuf(j+1)
      column = fldbuf(j+2)
      length = fldbuf(j+3)
      rev = 0
      mode = fldbuf(j+4)
      if (mode < 0) {
	 rev = 1
	 mode = mode + 128
	 }
      if (mode == 6) { # Seperator field

	 # we assume at least one character
         # load up locbuf with sperator chars
	 k = j + 6
	 for (i=1; i<=length; i=i+1) {
	       c = fldbuf(k)
	       if (c == 0) k = j + 6
	       locbuf(i) = fldbuf(k)
	       k = k + 1
	       }

         locbuf(length+1) = 0 # put in terminator

         call revers (rev)
         call qtext (row, column, locbuf)
	 }
      else {
	 
	 # protected field definition
	 kount = fldbuf(j+5)
	 do k=1, kount {
	    type = 0    # default is a data field
	    if (mode == 4) type = 1   # choice field
	    if (type == 0) {
	       # Total command length equals orginal command length
	       # minus multiple field count and toggle null terminator
	       # plus the field length plus its null terminator
	       c = (cmdlen - 1) + (length + 1)
	       call bscrbf (type, c) # output total field length
	       }
            c = row
	    call bscrbf (type, c)
	    c = column
	    call bscrbf (type, c)
	    c = length
	    call bscrbf (type, c)
	    c = mode
	    if (type == 0) call bscrbf (type, c) # output field mode
	    c = UNDERLINE
	    do i=1, length
	       call bscrbf (type, c)
	    c = NUL
	    call bscrbf (type, c)
	    if (mode == 5) {	
	       for (i=j+6; i<j+cmdlen; i=i+1) {
	           c = fldbuf(i)
	           call bscrbf (type, c) # output toggel characters
		   }
	       }
	    row = row + 1
	    }
	 }
      j = j + cmdlen
      }
   call bscrbf (0, c)   # set end of menu in display buffers
   call bscrbf (1, c)
   call revers (1)
   i = 1
   while (chcbfr(i) != 0) {
      row = chcbfr(i)
      column = chcbfr(i+1)
      length = chcbfr(i+2)
      call qtext (row, column, chcbfr(i+3))
      i = i + 4 + length
      }
   call revers (0)
   }

return
end
E 1
