PROGRAM MAILINT;
{ MAILINIT.PAS--initialization module for prototype electronic
		mail system.
		Version 0.3 4/28/82 rld
		Version 0.4 9/3/82 rld
	1.  Get parameters
	2.  Get Drive Designation for Mail Partition
	3.  Get Legal Target Names and fill in Headers
	4.  Create and link-together Free List
	5.  Quit					}

CONST
  max_names = 64;
{$I D:inclmail.pas }
  cpm_drive : char;
  safety: char;
  l  : integer;
  version : integer;
  name : string[9];
  got_a_name,
    indx_has_been_read : Boolean;
  s_no,
    iores1,
    iores2 : integer;
  ch,
   bs,
   cr,
   com_ch : char;
  pass : string[7];

  mt_err : integer;

EXTERNAL PROCEDURE @HLT;	{ Return to CP/M }
EXTERNAL PROCEDURE c_init;	{ Initialize direct console calls }
EXTERNAL PROCEDURE out_ch(ch:char);
EXTERNAL FUNCTION  in_echo:char;
EXTERNAL FUNCTION  in_nech:char;

PROCEDURE p35_read_and_echo_console_string(max_len:integer;var s:string);
VAR
  cur_len:integer;
  ch : char;
BEGIN
  s := '';
  cur_len := 0;
  REPEAT		{ Assume max_len>=1 }
    ch := in_nech;
    if ch=cr then EXIT; { DONE }
    if (ch>=' ') AND (ch<='~') then
       begin
	 if cur_len<max_len then
	    begin
	      out_ch(ch);	       { Show it on screen }
	      cur_len := cur_len + 1;  { Count it	   }
	      s := concat(s,ch);       { Record it	   }
	      if cur_len=max_len then out_ch(bs); { Pull cursor back if
						    this one went in last
						    char posn }
	    end
(******* else			       { Sitting on last char posn already }
	    begin
	      write([addr(out_ch)],ch,bs);
	      s[cur_len] := ch; 	{ Record new char here }
	    end ********************** 7/2/82*********************)
       end
    else if (ch=bs) OR (ch=chr($7F)) then
	    begin
	      if cur_len>0 then 
		 begin
		   delete(s,cur_len,1);      { Pull char out of string }
		   if cur_len<max_len then out_ch(bs);
		   out_ch(' '); out_ch(bs);  { Blank screen posn       }
		   cur_len := cur_len - 1;
		 end;
	    end;
					UNTIL false;
END;

PROCEDURE ucase(source:string; var up:string);
VAR
  l : integer;
BEGIN
  up := source; 	  { Necessary to set length byte }
  for l:= 1 to length(source) do
      if source[l] in ['a'..'z'] then up[l] := chr(ord(source[l]) & $5F)
				 else up[l] := source[l];
END;

FUNCTION ch_ucase(c:char):char;
BEGIN
  if c in ['a'..'z'] then ch_ucase := chr(ord(c) & $5F)
		     else ch_ucase := c;
END;

PROCEDURE strip_lead_blanks(var s:string);
BEGIN
  while s[1]=' ' do delete(s,1,1);
END;

PROCEDURE remove_trail_blanks(var s: string);
VAR
  p : integer;
BEGIN
  for p:= length(s) downto 0 do
      begin
	if s[p]<>' ' then exit;
	delete(s,p,1);
      end;
END;

PROCEDURE clean(source:string; var result:string);
BEGIN
  result := source;
  remove_trail_blanks(result);
  strip_lead_blanks(result);
END;

PROCEDURE conv_s_i(s:string; var ires:integer; hex:Boolean;
		   var bad_char:Boolean);
VAR
  source : string;
  negate : Boolean;
  i      : integer;
BEGIN
  bad_char := false;
  i := 0;
  clean(s,source);   { Remove trailing and leading }
  u_case(source,source); { Raise to upper }
  negate := false;
  if source[1]='-' then
     begin
       negate := true;
       delete(source,1,1);
     end
  else if source[1]='+' then delete(source,1,1);
  while length(source)>0 do
    begin
      if hex then
	 begin
	   if source[1] in ['A'..'F'] then
	      i := i*16 + ord(source[1]) - ord('A') + 10
	   else if source[1] in ['0'..'9'] then
		   i := i*16 + ord(source[1]) - ord('0')
	   else bad_char := true;
	 end
      else			{ Decimal case }
	 begin
	   if source[1] in ['0'..'9'] then
	      i := i*10 + ord(source[1]) - ord('0')
	   else bad_char := true;
	 end;
      delete(source,1,1);
    end;   { while }
  if negate then i := -i;
  ires := i;
END;

PROCEDURE conv_i_s(i:integer; var s:string; hex:Boolean);
VAR
  digit : integer;
BEGIN
{ No way for there to be any out of range cases here...}
  s := '';
  if i=0 then s:='0'
  else
    while i<>0 do
      begin
	if hex then begin
	   digit := i MOD 16;
	   if digit<=9 then s := concat(chr(digit+ord('0')),s)
		       else s := concat(chr(digit -10 + ord('A')),s);
	   i := i DIV 16;
	   end
	else
	   begin    { Decimal case }
	     digit := i MOD 10;
	     s := concat(chr(digit + ord('0')),s);
	     i := i DIV 10;
	   end;
      end;
END;

PROCEDURE  p0_create_index(destroy_existing:Boolean);
VAR
  f_name : string[14];
BEGIN
  { First create header file }
  if indx_has_been_read then close(indx,iores1);
  f_name := concat(cpm_drive,':INDEX.ML');
  assign(indx,f_name);
  if destroy_existing then  rewrite(indx)
	     else  reset(indx);
  if ioresult=255 then
     begin
       writeln('Trouble Opening ',f_name);
       ERROR; { Bail out }
     end
END;

FUNCTION f1_find_header(who:string):integer;
VAR
  up_lim,
    l : integer;
  found : Boolean;
  u_name,
    u_who : string[9];
BEGIN
  up_lim := indx^.params.numb_names;
  found := false;
  l := 1;
  while (l<=up_lim) AND (NOT found) do
    with indx^.n_head[l] do
      begin
	ucase(name,u_name);
	ucase(who,u_who);
	if u_name=u_who then
	   begin
	     f1_find_header := l;
	     found := true;
	   end
	else
	   l := l + 1;
      end;
  if NOT found then f1_find_header := null;
END;

PROCEDURE p34_get_escape_sequence(prompt:string; var seq:string;
				  max_len:integer);
VAR
  user_entry: string[10];
  mode : char;
  ch   : char;
  posn,
    char_value : integer;
  bad_char,
    terminated : Boolean;

{internal} PROCEDURE get_mode;
	   BEGIN
	     REPEAT
	       writeln; writeln; writeln;
	       writeln('I need to know the escape sequence for ');
	       writeln('--',prompt,'--');
	       writeln;
	       writeln('Will you enter values as ');
	       writeln('  Hex digits     [H]');
	       writeln('  Decimal digits [D]');
	       writeln('  Raw characters [C]');
	       write(  '          Which? [ ]',bs,bs);
	       mode := ch_u_case(in_echo);
	   		     UNTIL mode in ['C','D','H'];
	   END;

BEGIN
  get_mode;
  REPEAT
    writeln;
    writeln('OK... Enter each member of the escape sequence one line at');
    writeln('a time.  Press <CR> after all are entered. ');
    posn := 1;
    seq := '';
    terminated := false;
    while (posn<=max_len) AND (NOT terminated) do
      begin
	case mode of
	'C': begin
	       write('Keyboard character # ',posn,' [ ]',bs,bs);
	       bad_char := false;
	       ch := in_nech;
	       char_value := ord(ch);
	       terminated := (ch=cr);
	     end;
	'D': begin
	       write('Decimal value # ',posn,' [   ]',bs,bs,bs,bs);
	       p35_read_and_echo_console_string(3,user_entry);
	       conv_s_i(user_entry,char_value,false,bad_char);
	       ch := chr(char_value);
	       terminated := (length(user_entry)=0);
	     end;
	'H': begin
	       write('Hex value # ',posn,' [  ]',bs,bs,bs);
	       p35_read_and_echo_console_string(2,user_entry);
	       conv_s_i(user_entry,char_value,true,bad_char);
	       ch := chr(char_value);
	       terminated := (length(user_entry)=0);
	     end;
	end; {case}
	if bad_char then
	   begin
	     terminated := true; { Force exit from While }
	     writeln('Illegal character!');
	   end
	else
	  begin
	    if NOT terminated then 
	       begin
		 write(' ]     Decimal: ',ord(ch),' Hex: ');
		 conv_i_s(char_value,user_entry,true);
		 writeln(user_entry);
		 seq := concat(seq,ch);
	       end
	  end;
	posn := posn + 1;
      end; {While}
			UNTIL (NOT bad_char);
END;

PROCEDURE p5_get_screen_type(var head:m1_header_block);
CONST
  SI = 15;
  DC1 = 17;
  DC2 = 18;
  DC3 = 19;
  DC4 = 20;
  FS = 28;
  esc = $1B;
  tilde = $7E;
VAR
  ch : char;
  sc : integer;
  answ: string[10];
  bad_char : Boolean;

{internal} PROCEDURE other;
	   BEGIN
	   with head do
	begin
	   writeln; writeln;
	   writeln('Special Terminal:');
	   REPEAT
	     write('Screen length (decimal # lines) [   ]',bs,bs,bs,bs);
	     p35_read_and_echo_console_string(3,answ);
	     conv_s_i(answ,sc,false,bad_char);
	     writeln;
		      UNTIL NOT bad_char;
	   uscrn_len := sc;
	   p34_get_escape_sequence('Clear screen/Home cursor',uclr_scrn,4);
	   p34_get_escape_sequence('Clear to end of line',uclr_line,4);
	   p34_get_escape_sequence('Move cursor to row/col lead-in',ugoto,4);
	   uoff  := 0;
	   REPEAT
	   writeln; writeln;
	   write('In cursor move command, is Row or Column first? [R/C]',
		  ' [ ]',bs,bs);
	   ch := ch_u_case(in_echo);
			    UNTIL ch in ['C','R'];
	   if ch='R' then r_then_c := true
		     else r_then_c := false;
	   REPEAT
	     writeln; writeln;
	     writeln('What decimal offset should be added to row # 1 ',
			'to specify');
	     write('the top row on the screen (e.g. 31 decimal on ADDS) ');
	     p35_read_and_echo_console_string(4,answ);
	     conv_s_i(answ,sc,false,bad_char);
	     uoff := sc;
			      UNTIL NOT bad_char;
{ WARNING! The next expression WILL NOT WORK IF STATED PROPERLY.
		(1+uoff) is evaluated as 255 !!!! (byte vs. integer) }
	   if (1+sc)=0 then 
	      begin
	        writeln; writeln; writeln;
	        writeln('The values you have given will result in cursor address');
		writeln('values of zero begin sent to the terminal.  Some terminals ');
		writeln('(e.g. Hazeltine Esprit) don''t interpret zero properly.');
		writeln('If this doesn''t apply, just hit RETURN for the next',
				' two questions.');
		REPEAT
		  writeln;
		  write('Please enter a decimal value to use for ROW 0 ');
		  p35_read_and_echo_console_screen(4,answ);
		  ur_zero := 0;  
		  if length(answ)>0 then
		     begin
			conv_s_i(answ,sc,true,bad_char);
			ur_zero := sc;
		     end;
				UNTIL NOT bad_char;
		REPEAT
		  writeln; writeln;
		  write('Please enter a decimal value to use for COLUMN 0 ');
		  p35_read_and_echo_console_screen(4,answ);
		  uc_zero := 0;  
		  if length(answ)>0 then
		     begin
			conv_s_i(answ,sc,true,bad_char);
			uc_zero := sc;
		     end;
				UNTIL NOT bad_char;
  	      end; {if home is (0,0)}
	end; {with head}
	   writeln; writeln;
	   END;

BEGIN
  REPEAT
    writeln;
    writeln('What type of terminal will this user be using?');
    writeln('     1  ADDS Regent/Viewpoint');
    writeln('     2  ADM-31');
    writeln('     3  DMS FOX');
    writeln('     4  Hazeltine Esprit'); 
    writeln('     5  Televideo 910/920/925/950');
    writeln('     6  Other');
    write('Which? ');
    conv_s_i(in_echo,sc,false,bad_char);
				UNTIL (sc>0) AND ((sc<=6) AND (NOT bad_char));
{ Defaults }
  head.ur_zero := 0;
  head.uc_zero := 0;

  with head do
  case sc of
    1,3: begin	{ ADDS }
	   uclr_scrn := chr($0C);
	   uclr_line := concat(chr(esc),'K');
	   ugoto     := concat(chr(esc),'Y');
	   uoff      := $1F;
	   r_then_c  := true;
	   uscrn_len := 24;
	 end;

      2: begin { ADM-31 }
	   uclr_scrn := concat(chr(esc),'*');
	   uclr_line := concat(chr(esc),'T');
	   ugoto     := concat(chr(esc),'=');
	   uoff      := $1F;
	   r_then_c  := true;
	   uscrn_len := 24;
	 end;

      5: begin	{ Televideo }
	   uclr_scrn := concat(chr(esc),'*');
	   uclr_line := concat(chr(esc),'T');
	   ugoto     := concat(chr(esc),'=');
	   uoff      := $1F;
	   r_then_c  := true;
	   uscrn_len := 24;
	 end;

      4: begin	{ Hazeltine }
	   uclr_scrn := concat(chr(tilde),chr(FS));
	   uclr_line := concat(chr(tilde),chr(SI));
	   ugoto     := concat(chr(tilde),chr(DC1));
	   uoff      := $FF;   { minus one }
	   r_then_c  := false;
	   ur_zero   := 96;
 	   uc_zero   := 96;
	   uscrn_len := 24;
	 end;

      6: begin	{ Other }
	   other;
	 end;
  end; { Case }
  writeln;
END;

PROCEDURE  p1_get_user_info(frst:integer);
VAR
  l : integer;
  got_one : Boolean;
BEGIN
  with indx^ do
    begin
	l := frst;
	got_one := true;
	while (l<=max_names) AND (got_one) do
	  with n_head[l] do
	    begin
	      p8_get_specifics(l,got_one);
	      if got_one then
		 begin
		   params.numb_names := l;
		   l := l + 1;
		 end;
	      writeln;
	    end;
    { Can get here either if user decided to quit or have
      run out of room. }
      if got_one then writeln('No room for more users!');
    end;
END;

PROCEDURE p8_get_specifics(l:integer;var got_one:Boolean);
VAR
  retry : Boolean;
BEGIN
  retry := false;
  got_one := false;
  with indx^.n_head[l] do
  begin
  REPEAT
    name:='';	   
    name_link := l;
    writeln;
    writeln('Name number ',l);
    write('Name ( <CR> to quit) = [        ]',bs,bs,bs,bs,bs,bs,bs,bs,bs);
    p35_read_and_echo_console_string(8,name);
    clean(name,name);
    writeln;
    if length(name)>0 then
       begin
	 s_no := f1_find_header(name);
       { If we're CHANGING someone's name then we SHOULD find
	 it in the index, at position l }
	 if (s_no<>null) AND (l<>s_no) then begin
		 writeln('An existing user has that name.');
		 writeln('Please try another name.'); 
		 retry := true;
		 end {NO ;}
	 else begin
	   write('What password? (<CR> for none) [      ]',
		    bs,bs,bs,bs,bs,bs,bs); 
	   p35_read_and_echo_console_string(6,Pass); Password := Pass;	
	   writeln;
	   p5_get_screen_type(indx^.n_head[l]);
	   got_one := true;
	   retry := false;
	   end
       end
				UNTIL NOT retry;
  end; { With this user's header info }
END;

PROCEDURE  p2_create_and_link_free_list;
VAR
  f_name : string[14];
  l	     : integer;
BEGIN
{ Complete headers (INDEX.ML) by filling in free list pointer }
  indx^.free := max_names;
  { Records 0..max_names-1 used for headers }
  put(indx); iores1 := ioresult;
  close(indx,iores2);
  if (iores1=0) AND (iores2<>255) then
     begin
       writeln('INDEX.ML created successfully');
     { Create and link message file }
       f_name := concat(cpm_drive,':MSG.ML');
       assign(msg,f_name);
       rewrite(msg);
       if ioresult=255 then
	  begin
	    writeln('Trouble Opening ',f_name);
	    ERROR; { Bail out }
	  end
       else
	 begin
	   for l:=0 to max_names-1 do	    { Create one (wasted) header }
	       with msg^ do		    { block for each potential name }
		    begin
		      name_link := null;
		      msg_link	:= null;
		      response_needed := false;
		      has_been_read := false;
		      filled  := 0;
		      put(msg);   
		    end;
	   l := max_names;	     { Free list header }
	   iores1 := 0;
	   while iores1=0 do
	     begin
	       with msg^ do
		 begin
		   name_link := l+1;  { Point each block to the one }
		   msg_link  := null; { immediately following	    }
		   response_needed := false;
		   has_been_read := false;
		   filled := 0;
		 end;
	       put(msg); iores1:=ioresult;
	       l := l + 1;
	       if (l MOD 100)=0 then
		  writeln('Initialized ',l,' message blocks so far...');
	     end; { while iores1=0 }
	   msg^.name_link := null;
	   seekwrite(msg,l-3);	     { Mark last block in free list }
	   close(msg,iores1);
	   writeln; writeln('Done initializing all message blocks.');
	 end
     end
END;

PROCEDURE p7_read_indx_if_necessary;
BEGIN
  if NOT indx_has_been_read then
     begin
       p0_create_index(false);
       if version<>indx^.params.iversion then
	  begin
	    writeln('Sorry--can''t modify your index.');
	    writeln('Wrong Version of Mail System. ');
	    writeln('MAIL Partition is Version ',indx^.params.iversion);
	    writeln('This is Version ',version);
	    writeln;
	    @HLT;
	  end
       else  indx_has_been_read := true;
     end;
END;

PROCEDURE ERROR;
BEGIN
  writeln('Giving up.  Please check drive assignments.');
  @HLT;
END;


{ ************************************************************** }

BEGIN
  bs := chr($08);
  cr := chr($0D);
  c_init;
  indx_has_been_read := false;
  for l:= 1 to 20 do writeln;
  writeln('MAIL Initialization Version 1.5  2/2/83');
  version := 5; { IMPORTANT! Update with major changes }
  writeln;
  REPEAT
    write('Which drive is the Mail Partition? ');
    cpm_drive := ch_ucase(in_echo);
    writeln;
		UNTIL cpm_drive in ['A'..'D'];
  REPEAT
  REPEAT
    writeln; writeln;
    writeln('Add to list of users    [A]');
    writeln('Change a user           [C]');
    writeln('Initialize from scratch [I]');
    writeln('Quit                    [Q]');
    write(  '              Which?    [ ]',chr(8),chr(8));
    ch := in_echo; writeln;
    com_ch := ch_ucase(ch);
				UNTIL com_ch in ['A','C','I','Q'];

  case com_ch of
  'A': begin { Add new users }
	 p7_read_indx_if_necessary;
(******* p1_get_user_info((indx^.params.numb_names)+1); *****)
	 mt_err := indx^.params.numb_names + 1;
	 p1_get_user_info(mt_err);
       end;

  'C': begin { Change a user }
	 p7_read_indx_if_necessary;
	 REPEAT
	   writeln; writeln;
	   write('Change which user''s information? ');
	   readln(name);
	   if length(name)>0 then begin
	      s_no := f1_find_header(name);
	      if s_no=null then begin
		 writeln('No existing user has that name.');
		 writeln('Enter another name (or <CR> to quit)'); 
		 end;
	      end;
			     UNTIL (s_no<>null) or (length(name)=0);
	 if length(name)>0 then 
	    p8_get_specifics(s_no,got_a_name);
	    
       end;

  'I': begin { Initialize from scratch }
	 writeln('Are you SURE?  This will destroy any existing mail.');
	 write('You''re positive.  Right? [y/other]');
	 safety := in_echo; writeln;
	 if safety in ['y','Y'] then
	    begin
	       writeln('Initializing on drive ',cpm_drive);
	       p0_create_index(true);
	       with indx^.params do
		 begin
		   iversion := version;
		   unique := 1234;
		   numb_names := 0;
		 end;
	       p1_get_user_info(1);
	       p2_create_and_link_free_list;
	       writeln;
	       writeln('Done initializing MAIL partition.');
	    end;
       end;
  else begin end;
  end; { Case }
				UNTIL com_ch in ['I','Q'];

  if indx_has_been_read then
     begin
	seekwrite(indx,0); iores1 := ioresult;
	close(indx,iores2);
	if (iores1=0) AND (iores2<>255) then
	   begin
	     writeln('INDEX.ML updated successfully');
	   end
	else writeln('Trouble writing new INDEX.ML');
     end;
  EXIT; { Normal Termination }

END.
