REM *** MBASEPDS 3.0 ***  MAG/base PROGRAM DEVELOPMENT STRUCTURE
REM
REM WRITTEN: mm/dd/yy  UPDATED: mm/dd/yy
REM
REM PROPRIETARY SOFTWARE OF:
REM  MICRO APPLICATIONS GROUP
REM  20201 SHERMAN WAY, SUITE 205
REM  CANOGA PARK, CA 91306
REM
REM  (C) COPYRIGHT MAG 1979-1982 ALL RIGHTS RESERVED


REM	This structure is provided to enable you to develop
REM	customized applications more quickly using the MAG/base
REM	programming aids.
REM
REM	It presents a basic framework around which a user program
REM	ma b writte utilizing structure codin techniques.


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
	REM  *          INCLUDED FUNCTIONS AND MODULES               *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	The following INCLUDE statements incorporate pre-written
REM	MAG/base subroutines in your program.  


%INCLUDE MBASECOM
REM
REM   COMMON STATEMENT
REM
REM	Defines variables common to all programs using MAG/base.
REM
REM	Always required.	*** DO NOT REMOVE ***

%INCLUDE MBASEMS
REM
REM   MAG/sam KEYED FILE MANAGEMENT SYSTEM
REM
REM	Provides keyed access to MAG/base files directly through MAG/sam.
REM
REM	Required by file management functions (MBASEFM).

%INCLUDE MBASEFM
REM
REM   FILE MANAGEMENT FUNCTIONS
REM
REM	Provides access to the MAG/base data dictionary file (MBASEFDF).
REM
REM	Required by data management language (MBASEDML).

%INCLUDE MBASEMD
REM
REM   DATE EDIT MODULE
REM
REM	Perpetual calendar used in editting dates.
REM
REM	Required by screen management functions (MBASESM).

%INCLUDE MBASESM
REM
REM   SCREEN MANAGEMENT FUNCTIONS		
REM
REM	Utilizes MAG/base terminal definition to allow user programs to
REM	interface with most terminals without change.  Provides display,
REM	data entry, and editting functions.
REM
REM	Optional - suggested for any program using formatted screen.

%INCLUDE MBASESF
REM
REM   STANDARD FUNCTIONS
REM
REM	Provides MIN and MAX functions.
REM
REM	Optional.

%INCLUDE MBASEDML
REM
REM   DATA MANAGEMENT LANGUAGE FUNCTIONS
REM
REM	Hi-level access to MAG/base files through data dictionary.
REM	User programs may be written without concern to actual
REM	data structure in file definition.
REM	
REM	Optional.


REM	Insert your INCLUDE statements, if any, here.


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
100	REM  *             INITIALIZATION ROUTINE                    *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	Routines exectued only once upon entry into the program
REM	should be inserted here.  Could display initial screens,
REM	open files, etc.
REM
REM	Line numbers:  110-299
REM
REM	Sample:
REM
REM	110	logic to display initial screens, open files, etc.
REM		  .
REM		  .
REM		  .
REM		GOTO 300


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
300	REM  *             MAINLINE LOGIC                            *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	The central portion of the program goes here.  Usually IF's 
REM	and/or GOSUB's calling Main Logic Subroutines.
REM
REM	Line numbers:  310-899
REM
REM	Sample:
REM
REM	310	IF condition1 THEN GOSUB 1000: GOTO 390: REM PROCESS condition1
REM		IF condition2 THEN GOSUB 2000: GOTO 390: REM PROCESS condition2
REM		IF condition3 THEN GOSUB 3000: GOTO 390: REM PROCESS condition3
REM		IF condition4 THEN GOSUB 4000: GOTO 390: REM PROCESS condition4
REM		GOSUB 5000
REM		GOTO 310
REM	390	GOTO 900


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
900	REM  *             TERMINATION ROUTINE                       *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	Routines exectued only once upon exit from the program
REM	should be inserted here.  Could close files, display 
REM	termination messages, etc.
REM
REM	Line numbers:  910-999
REM
REM	Sample:
REM
REM	910	logic for termination routines
REM		  .
REM		  .
REM		  .
REM	999	DUM$=FN.CHNRTN$: REM  RETURN TO CALLING PROGRAM (USUALLY MENU)


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
	REM  *              MAIN LOGIC SUBROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	Main logic subroutines called from Main logic go here.
REM
REM	Line numbers:  1000-9999
REM
REM	Sample:
REM
REM	1000	main logic for processing condition1
REM		  .
REM		  .	could display screens, update files, etc.
REM		  .
REM	1090	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
10000	REM  *              DISPLAY/INPUT ROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	Routines involving display, entry, and edit of data should
REM	be inserte here.
REM
REM	Line numbers:  10100-19999
REM
REM	Sample:
REM
REM	10100	REM DISPLAY INITIAL SCREEN
REM		  .
REM		  .
REM		  .
REM	10190	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
20000	REM  *              PRINT ROUTINES                           *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	Routines involving printing information (reports) should be
REM	inserted here.
REM
REM	Line numbers:  20100-29999
REM
REM	Sample:
REM
REM	20100	REM PRINT REPORT HEADINGS
REM		  .
REM		  .
REM		  .
REM	20190	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
30000	REM  *              DISK I/O ROUTINES                        *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	Routines involving reading and writing MAG/base files should
REM	be inserted here.
REM
REM	Line numbers:  30100-39999
REM
REM	Sample:
REM
REM	30100	REM OPEN MAG/base DATA FILE
REM		  .
REM		  .
REM		  .
REM	30190	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
40000	REM  *              MISCELLANEOUS ROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


REM	Routines involving miscellaneous processes such as calculations 
REM	and string manipulation should be inserted here.
REM
REM	Line numbers:  40100-59999
REM
REM	Sample:
REM
REM	40100	REM CALCULATE GROSS PAY
REM		  .
REM		  .
REM		  .
REM	40190	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
90000	REM  *              ERROR ROUTINES                           *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	
REM	Routines that display error messages (line 24) should be
REM	inserted here.
REM
REM	Line numbers:  90100-99999
REM
REM	Sample:
REM
REM	90100	REM INVALID ENTRY ERROR
REM		  .
REM		  .
REM		  .
REM	90190	RETURN


	END

