REM *** MBASEDML 3.0 ***    MAG/base DATA MANAGEMENT LANGUAGE
REM
REM CB80 VERSION - REAL RECORD NUMBERS
REM
REM WRITTEN: 09/20/80  UPDATED: 05/23/82 FROM 04/07/82 VERSION
REM
REM PROPRIETARY SOFTWARE OF:
REM  MICRO APPLICATIONS GROUP
REM  20201 SHERMAN WAY, SUITE 205
REM  CANOGA PARK, CA 91306
REM
REM  (C) COPYRIGHT MAG 1980-1982 ALL RIGHTS RESERVED
%NOLIST

	DEF FN.DML$(FP.FUNCTION$,FP.PARM$)

	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
.00300	REM  *             MAINLINE LOGIC                            *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

.00330	REM ENTRY POINT TO DATA MANAGMENT LANGUAGE
	REM FUNCTION VECTOR LOGIC

	DML.ERROR%=0
	DML.ERROR$=""
	DML.FUNC$=""

	IF FP.FUNCTION$="DMI" THEN GOSUB .00810: GOTO .00390: REM INITIALIZE
	IF FP.FUNCTION$="DMT" THEN GOSUB .00910: GOTO .00390: REM TERMINATE
	IF FP.FUNCTION$="DOO" THEN GOSUB .08000: GOTO .00390: REM OPEN
	IF FP.FUNCTION$="DCL" THEN GOSUB .08100: GOTO .00390: REM CLOSE
	IF FP.FUNCTION$="DBB" THEN GOSUB .01000: GOTO .00390: REM BATCH BEGIN
	IF FP.FUNCTION$="DBA" THEN GOSUB .01100: GOTO .00390: REM BATCH ADD
	IF FP.FUNCTION$="DBE" THEN GOSUB .01200: GOTO .00390: REM BATCH END
	IF FP.FUNCTION$="DWA" THEN GOSUB .01300: GOTO .00390: REM WRITE ADD
	IF FP.FUNCTION$="DHU" THEN GOSUB .02100: GOTO .00390: REM HOLD UPDATE
	IF FP.FUNCTION$="DWU" THEN GOSUB .02000: GOTO .00390: REM WRITE UPDATE
	IF FP.FUNCTION$="DDR" THEN GOSUB .03000: GOTO .00390: REM DELETE
	IF FP.FUNCTION$="DRG" THEN GOSUB .04000: GOTO .00390: REM READ GENERIC
	IF FP.FUNCTION$="DRN" THEN GOSUB .04100: GOTO .00390: REM READ NEXT
	IF FP.FUNCTION$="DRK" THEN GOSUB .04200: GOTO .00390: REM READ KEY
	IF FP.FUNCTION$="DGF" THEN GOSUB .05000: GOTO .00390: REM GET FLD DEF
	IF FP.FUNCTION$="DGK" THEN GOSUB .05100: GOTO .00390: REM GET KEY DEF
	IF FP.FUNCTION$="DSF" THEN GOSUB .06000: GOTO .00390: REM SELECT FILE
	IF FP.FUNCTION$="DSK" THEN GOSUB .07000: GOTO .00390: REM SELECT KEY
	GOSUB .90100	:REM INVALID FUNCTION

.00390	FN.DML$=STR$(DML.ERROR%)
	RETURN

	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
.00800	REM  *             INITIALIZATION ROUTINE                    *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

.00810	REM DMI - INITIALIZE FILE DEFINITION FILE, ETC.
	IF DML.INITSTAT$="I" THEN GOSUB .90300 : GOTO .00890

	DIM MAGDATE$(9),MAGDATE%(12)
	DIM MAGSAM$(20),MAGSAM(20)
	DIM FLD.VAL$(50)

	DML.SPACE$="                                   ": REM 3.0
	DML.ZERO$="00000000000000": REM 3.0

	DML.FILENO$="": DML.MKEY%=0
	
	REM OPEN FILE DEF FILE
	IF END # 18 THEN .00820
	GOSUB .32100: REM OPEN FILE DEF FILE
	IF DML.ERROR%<>0 THEN GOTO .00890
	IF END # 19 THEN .00820	
	GOSUB .31500: REM READ FILE DEF HEADER
	IF DML.ERROR%<>0 THEN GOTO .00890
	GOTO .00830
.00820	GOSUB .91100
	GOTO .00890		:REM OPEN FILE DEF FILE ERROR
.00830	REM  CHECK TERMINAL DEFINITION IN MEMORY
	IF TDR.RTYP$<>"TDR" THEN \
	   GOSUB .91300: \
	   GOTO .00890
	GOSUB .34900		:REM OPEN WORK FILE FOR ADD
	GOSUB .34700		:REM OPEN WORK FILE FOR CHANGE
	DML.INITSTAT$="I"		:REM SET INITIALIZED
.00890	RETURN		:REM FINISHED INITIALIZE


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
.00900	REM  *             TERMINATION ROUTINE                       *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

.00910	REM TERMINATE - CLEAR SYSTEM FOR EXIT
	IF DML.INITSTAT$<>"I" THEN GOSUB .90400: GOTO .00990

	DML.FILENO$="":DML.MKEY%=0:DML.INITSTAT$="T" :REM SET DML TERMINATED

	FOR DML.I%=1 TO 9			:REM CLEAR MAGDATE ARRAYS
	   MAGDATE$(DML.I%)=""
	NEXT DML.I%
	FOR DML.I%=1 TO 20			:REM CLEAR MAGSAM ARRAY
	   MAGSAM$(DML.I%)=""
	NEXT DML.I%

	GOSUB .32300: REM CLOSE FILE DEF FILE
	GOSUB .34800: REM CLOSE WORK FILES
.00990	RETURN

	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
	REM  *              MAIN LOGIC SUBROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

.01000	REM  ADD RECORDS - BATCH BEGIN
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .01090
	DML.FUNC$="ADD"
	IF DML.INDSTAT$<>"O" THEN GOSUB .90500: GOTO .01090 :REM FILE NOT OPEN
	DML.WKRNO%=0
	DML.BATCHSTAT$="B"
.01090	RETURN		:REM FINISHED BATCH ADD INITIALIZE


.01100	REM ADD ONE RECORD IN BATCH
	DML.FUNC$="ADD"
	IF DML.BATCHSTAT$<>"B" THEN GOSUB .90600:GOTO .01190:REM NO BATCH BEG
	IF DML.INDSTAT$<>"O" THEN GOSUB .90500:GOTO .01190 :REM FILE NOT OPEN
	DML.DATAREC=0	:REM RESET DATA RECORD NUMBER (FOR UNIQUE CHECK)
	GOSUB .30100	:REM ADD NEW RECORD
	IF DML.ERROR%<>0 THEN GOTO .01190: REM ERROR
	GOSUB .31600	:REM UPDATE AUTO INDEX
.01190	RETURN		:REM FINISHED RECORD ADD


.01200	REM BATCH ADD - END ADD
	DML.FUNC$="ADD"
	IF DML.BATCHSTAT$<>"B" THEN GOSUB .90600:GOTO .01295:REM NO BATCH BEG
	IF DML.INDSTAT$<>"O" THEN GOSUB .90500 : GOTO .01295:REM FILE NOT OPEN
	IF DML.WRKNO%=0 THEN GOTO .01290
	GOSUB .31400			:REM WRITE DUPLICATE KEYS
.01290	DML.BATCHSTAT$="E"			:REM END BATCH FLAG
	IF DML.INDWKEY%=DML.MKEY% THEN GOTO .01295
	IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE CURRENT INDEX
	DML.WKEY%=DML.MKEY%
	GOSUB .34300 				:REM OPEN KEY INDEX SELECTED
.01295	RETURN

.01300	REM DWA - WRITE ADD (SINGLE)
	GOSUB .01000		:REM BATCH BEGIN
	IF DML.ERROR%<>0 THEN DML.BATCHSTAT$="E": GOTO .01390
	GOSUB .01100		:REM ADD
	IF DML.ERROR%<>0 THEN DML.BATCHSTAT$="E": GOTO .01390
	GOSUB .01200		:REM BATCH END
.01390	RETURN

.02000	REM  UPDATE RECORDS
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .02095: REM BATCH ERROR
	DML.FUNC$="UPDATE"
	IF DML.INDSTAT$<>"O" THEN GOSUB .90500:GOTO .02095: REM FILE CLOSED
	IF DML.UPDSTAT$<>"U" THEN GOSUB .92400:GOTO .02095 :REM NO UPDATE HOLD
	DML.WKEY%=DML.MKEY%
.02080	REM CHANGE RECORD
	GOSUB .31200		:REM ADD RECORD
	IF DML.INDWKEY%=MKEY% THEN GOTO .02095
	IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE CURRENT INDEX
	DML.WKEY%=DML.MKEY%
	GOSUB .34300 				:REM OPEN KEY INDEX SELECTED
.02095	RETURN

.02100	REM  HOLD CURRENT KEYS FOR UPDATE 
	IF DML.UPDSTAT$="U" THEN GOSUB .92500:GOTO .02195:REM ALREADY DID HOLD
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .02195: REM BATCH ERROR
	DML.FUNC$="UPDATE"
	IF DML.INDSTAT$<>"O" THEN GOSUB .90500:GOTO .02195: REM FILE CLOSED
	GOSUB .31300		:REM BUILD WORK FILE OF OLD KEYS
	DML.UPDSTAT$="U"
.02195	RETURN

.03000	REM  DELETE RECORDS
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .03090: REM BATCH ERROR
	DML.FUNC$="DELETE"
	IF DML.INDSTAT$<>"O" THEN \
		GOSUB .90500: GOTO .03090 	:REM ERROR: DATA FILE CLOSED
	IF DML.DATAREC<1 THEN \
		GOSUB .90700: GOTO .03090 	:REM BAD RECORD NUM

	GOSUB .30200				:REM DELETE KEYS
	IF DML.ERROR%<>0 THEN GOTO .03090		:REM ERROR ON DELETE

	GOSUB .43100				:REM CLEAR FLDS
	MAGSAM(9)=DML.DATAREC
	GOSUB .31100				:REM WRITE DELETED RECORD
	IF DML.INDWKEY%=DML.MKEY% THEN GOTO .03090
	IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE CURRENT INDEX
	DML.WKEY%=DML.MKEY%
	GOSUB .34300 				:REM OPEN KEY INDEX SELECTED
.03090	RETURN

.04000	REM DRG - DATA READ GENERIC 
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .04090: REM BATCH ERROR
	DML.FUNC$="BROWSE"
	DML.WKEY%=DML.MKEY%
	IF DML.INDSTAT$<>"O" THEN \
			GOSUB .90500: GOTO .04090 :REM ERROR: DATA FILE CLOSED
	DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	GOSUB .32500			:REM READ KEY DEFINITION
	GOSUB .43200			:REM BUILD KEY
	GOSUB .30600			:REM READ RECORD (RG)
	IF DML.ERROR%<>0 THEN GOTO .04090	:REM ERROR IN READ
	IF DML.RET$="51" THEN \ NO KEY
	   GOSUB .90200:GOTO .04090		:REM END OF FILE ERROR 
	IF DML.RET$<>"" THEN \
	   GOSUB .91400: GOTO .04090		:REM FATAL FILE ERROR
	DML.DATAREC=MAGSAM(9)	:REM SAVE DATA RECORD NUMBER
.04090	RETURN


.04100	REM READ NEXT RECORD
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .04190: REM BATCH ERROR
	DML.FUNC$="BROUSE"
	IF DML.INDSTAT$<>"O" THEN \
		GOSUB .90500: GOTO .04190 	:REM ERROR: DATA FILE CLOSED
	IF DML.KEYLENGTH%<>0 THEN GOTO .04150	

	DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS% :REM INITIALIZE KEY LENGTH
	GOSUB .32500			:REM READ KEY DEFINITION
	GOSUB .43200			:REM BUILD KEY

.04150	GOSUB .30700				:REM READ NEXT
	IF DML.ERROR%<>0 THEN GOTO .04190
	IF DML.RET$<>"" THEN GOSUB .90200:GOTO .04190	:REM END OF FILE
	DML.DATAREC=MAGSAM(9)
.04190	RETURN

.04200	REM DRK - DATA READ KEY 
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .04290: REM BATCH ERROR
	DML.FUNC$="BROUSE"
	DML.WKEY%=DML.MKEY%
	IF DML.INDSTAT$<>"O" THEN \
			GOSUB .90500: GOTO .04290 :REM ERROR: DATA FILE CLOSED
	DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	GOSUB .32500			:REM READ KEY DEFINITION
	GOSUB .43200			:REM BUILD KEY
	GOSUB .30800			:REM READ KEY (RK)
	IF DML.ERROR%<>0 THEN GOTO .04290	:REM RK ERROR
	IF DML.RET$="51" THEN \ NO KEY
	   GOSUB .90200:GOTO .04290		:REM END OF FILE ERROR 
	IF DML.RET$<>"" THEN \
	   GOSUB .91400: GOTO .04290		:REM FATAL FILE ERROR
	DML.DATAREC=MAGSAM(9)	:REM SAVE DATA RECORD NUMBER
.04290	RETURN

.05000	REM DGF - GET FIELD DEFINITION
	DML.FUNC$="FIELD"
	IF DML.FILENO$="" THEN GOSUB .90800: GOTO .05090:REM NO FILE SELECTED
	DML.I%=VAL(FP.PARM$)
	IF DML.I%<1 OR DML.I%>FLR.FLDS%  \
		THEN GOSUB .90900:GOTO .05090:REM BAD FIELD NUM
	DML.RECNO%=DML.I%+DML.FLRNO%
	GOSUB .32400		:REM READ FIELD DEFINITION
.05090	RETURN

.05100	REM DGK - GET KEY DEFINITION
	DML.FUNC$="KEY"
	IF DML.FILENO$="" THEN GOSUB .90800: GOTO .05190:REM NO FILE SELECTED
	DML.I%=VAL(FP.PARM$)
	IF DML.I%<1 OR DML.I%>FLR.KEYS%  \
		THEN GOSUB .91500:GOTO .05190:REM BAD KEY NUM
	DML.RECNO%=DML.I%+DML.FLRNO%+FLR.FLDS%
	GOSUB .32500		:REM READ KEY DEFINITION
.05190	RETURN

.06000	REM  SELECT FILE FOR PROCESSING
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .06095: REM BATCH ERROR
	IF DML.INITSTAT$<>"I" THEN GOSUB .90400: GOTO .06095: REM NO INIT
	IF DML.INDSTAT$="O" THEN GOSUB .91900: GOTO .06095: REM FILE OPEN
	DML.FUNC$="SELECTF"
	DML.MKEY%=0
	DML.DATAREC=0
	REM FILE NUMBER IS PASSED IN FP.PARM$
	DML.FILENO$=FP.PARM$
	IF VAL(DML.FILENO$)<1 OR VAL(DML.FILENO$)>FHR.FILS% \
		THEN GOSUB .92300: GOTO .06090		:REM INVALID FILE NUM
	GOSUB .41200: REM INITIALIZE FILE FOR PROCESSING
.06090	IF DML.ERROR%<>0 THEN DML.FILENO$=""		:REM FILE NOT ON DISK
.06095	RETURN


.07000	REM SELECT NEW KEY FOR PROCESSING
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .07090: REM BATCH ERROR
	IF DML.INDSTAT$="O" THEN GOSUB .91900: GOTO .07090: REM FILE OPEN
	DML.FUNC$="SELECTK"
	IF DML.FILENO$="" THEN GOSUB .90800: GOTO .07090 :REM NO FILE SELECTED
	DML.MKEY%=0
	DML.KEYNO$=FP.PARM$
	GOSUB .41300
.07090	RETURN

.08000	REM OPEN DATA (AND INDEX/OVERFLOW) FILE
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .08090: REM BATCH ERROR
	IF DML.FILENO$="" \
		THEN GOSUB .90800: GOTO .08090	:REM NO FILE SELECTED
	IF DML.MKEY%=0 \
		THEN GOSUB .91800: GOTO .08090	:REM NO KEY SELECTED
	IF DML.INDSTAT$="O" THEN GOSUB .91900:GOTO .08090:REM FILE OPEN
	DML.WKEY%=DML.MKEY%
	GOSUB .34100	:REM OPEN FILES ON CURRENT INDEX (MKEY%)
.08090	RETURN

.08100	REM CLOSE DATA (AND INDEX/OVERFLOW) FILE
	IF DML.INDSTAT$<>"O" THEN GOSUB .90500: GOTO .08190:REM FILE NOT OPEN
	IF DML.BATCHSTAT$="B" THEN GOSUB .92200: GOTO .08190: REM BATCH ERROR
	IF DML.FILENO$="" \
		THEN GOSUB .90800: GOTO .08190	:REM NO FILE SELECTED
	IF DML.MKEY%=0 \
		THEN GOSUB .91800: GOTO .08190	:REM NO KEY SELECTED
	GOSUB .34200	:REM CLOSE FILES
.08190	RETURN

	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
.30000	REM  *              DISK I/O ROUTINES                        *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

.30100	REM  WRITE DATA RECORD AND ALL KEYS
	FOR DML.WKEY%=1 TO FLR.KEYS%

	   IF DML.KEY.TYPE$(DML.WKEY%)="D" \
				 AND DML.WKEY%>1 \ SKIP DUPS (EXCEPT 1ST)
			THEN GOTO .30150
	   IF DML.INDWKEY%=DML.WKEY% THEN GOTO .30120 :REM SKIP IF SAME KEY

	   IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE FILES
	   GOSUB .34300			:REM OPEN APPROPRIATE KEY FILE

.30120	   DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	   GOSUB .32500			:REM READ KEY DEFINITION
.30130	   GOSUB .43200		 	:REM BUILD KEY

	   IF DML.WKEY%=1 THEN GOSUB .30900 	\    WA DATA AND FIRST KEY
		      ELSE GOSUB .30500	:REM SA ALL OTHER KEYS

	   IF DML.RET$="61" AND KDR.TYPE$="U" THEN \
		GOSUB .92100: GOSUB .30200: GOTO .30190   :REM DUP KEY ERROR
	   IF DML.RET$<>"" THEN GOSUB .91400: GOTO .30190 :REM MAGSAM ERROR

.30150	NEXT DML.WKEY%

.30190	RETURN

.30200	REM DELETE KEYS (INSERTED THUS FAR IF DUPLICATE ERROR FROM ADD)
	IF DML.FUNC$="DELETE" \			SET DELETE LOOP
		THEN DML.LASTKEY%=FLR.KEYS% \	DELETE RECORD
		ELSE DML.LASTKEY%=DML.WKEY%-1		:REM ADD DELETE
	FOR DML.WKEY%=1 TO DML.LASTKEY%

	   IF DML.FUNC$="DELETE" THEN GOTO .30210
	   IF DML.KEY.TYPE$(DML.WKEY%)="D"  \
				AND DML.WKEY%>1 \ SKIP DUPLICATES (EXCEPT 1ST)
			THEN GOTO .30250	:REM WHEN ON ADD ERROR DELETE

.30210	   IF DML.INDWKEY%=DML.WKEY% THEN GOTO .30220:REM SKIP CLS/OPN IF SAME

	   IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE FILES
	   GOSUB .34300			:REM OPEN APPROPRIATE KEY FILE

.30220	   DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	   GOSUB .32500			:REM READ KEY DEFINITION
.30230	   GOSUB .43200		 	:REM BUILD KEY

	   IF DML.WKEY%=1 THEN GOSUB .30400 \	DELETE RECORD OF FIRST
		      ELSE GOSUB .30300		:REM ELSE DELETE KEY
 
	   IF DML.RET$<>"" THEN GOSUB .91400: GOTO .30290 :REM MAGSAM ERROR

.30250	NEXT DML.WKEY%

.30290	RETURN


.30300	REM KEY DELETE
	DML.MAGSAMOP$="KD"
	GOSUB .31900
	RETURN


.30400	REM  DELETE (DR) DATA RECORD
	DML.MAGSAMOP$="DR"
	GOSUB .31900
	RETURN

.30500	REM  WRITE (SA) SECONDARY KEYS
	DML.MAGSAMOP$="SA"
	MAGSAM(5)=DML.DATAREC
	GOSUB .31900
	RETURN

.30600	REM  READ (RG) DATA RECORD
	DML.MAGSAMOP$="RG"
	GOSUB .31900
	IF DML.ERROR%<>0 OR DML.RET$<>"" THEN GOTO .30690
	IF MAGSAM(9)<1 THEN GOSUB .91400:GOTO .30690 :REM BAD RECORD RETURN
	DML.REC$=""
	GOSUB .36100: REM READ REC AND BLD FLD VALUES (3.0)
.30690	RETURN

.30700	REM  READ (RN) DATA RECORD
	DML.MAGSAMOP$="RN"
	GOSUB .31900			:REM DO MAGSAM OPERATION
	IF DML.ERROR%<>0 OR DML.RET$<>"" THEN GOTO .30790
	DML.DATAREC=MAGSAM(9)
	DML.REC$=""
	GOSUB .36100: REM READ REC AND BLD FLD VALUES (3.0)
	DML.KEY$=MAGSAM$(2)
.30790	RETURN

.30800	REM  READ (RK) DATA RECORD
	DML.MAGSAMOP$="RK"
	GOSUB .31900			:REM DO MAGSAM OPERATION
	IF DML.ERROR%<>0 OR DML.RET$<>"" THEN GOTO .30890
	DML.REC$=""
	GOSUB .36100: REM READ REC AND BLD FLD VALUES (3.0)
.30890	RETURN

.30900	REM WRITE ADD "PRIMARY" KEY AND DATA RECORD
	DML.MAGSAMOP$="WA"
	GOSUB .31900
	IF DML.ERROR%<>0 OR DML.RET$<>"" THEN GOTO .30990

	DML.DATAREC=MAGSAM(9)
	DML.WRKNO%=DML.WRKNO%+1		:REM INCREIMENT NUMBER OF WORK RECS
	PRINT #5, DML.WRKNO%; DML.DATAREC	:REM SAVE DATA RECORD NUM

	GOSUB .31100			:REM WRITE DATA RECORD

.30990	RETURN


.31100	REM  WRITE DATA RECORD 
	IF FLR.MODE$="N" THEN \ (3.0)
	   GOSUB .42100 \ BLD NORMAL MODE DATA REC
	ELSE \ (3.0)
	   GOSUB .44100: REM BLD EXTENDED MODE DATA REC (3.0)
	IF DML.ERROR%<>0 THEN GOTO .31190
	PRINT USING "&"; # 2, MAGSAM(9); DML.REC$
.31190	RETURN

.31200	REM ADD CHANGE RECORD
	DML.UNIQUEFLG$="U"

.31210	FOR DML.WKEY%=1 TO FLR.KEYS%
	   IF DML.UNIQUEFLG$="U" THEN GOTO .31215 :REM TEST FOR UNIQUE KEYS

	   IF DML.KEY.TYPE$(DML.WKEY%)="U" \
		THEN GOTO .31250 \	:REM SKIP UNIQUE KEYS
		ELSE GOTO .31220	:REM PROCESS DUPLICATE KEYS

.31215	   IF DML.KEY.TYPE$(DML.WKEY%)="D" \ SKIP DUPLICATE KEYS FIRST TIME
		THEN GOTO .31250 	:REM DUPLICATE

.31220	REM PROCESS - CHANGE KEY
	   IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE FILES
	   GOSUB .34300			:REM OPEN APPROPRIATE KEY FILE
	   DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	   GOSUB .32500			:REM READ KEY DEFINITION
	   GOSUB .43200		 	:REM BUILD KEY
	   READ #4, DML.WKEY%;DML.K.KEY$
	   IF DML.KEY$=DML.K.KEY$ THEN GOTO .31250	:REM KEY NOT CHANGED

	REM DELETE OLD KEY AND ADD NEW KEY
	   DML.I.KEY$=DML.KEY$
	   DML.KEY$=DML.K.KEY$ 
	   DML.KEYLENGTH%=LEN(DML.KEY$)
	   GOSUB .30300					:REM DELETE OLD KEY
	   IF DML.ERROR%<>0 THEN GOTO .31290
	   IF DML.RET$<>"" THEN GOSUB .91400: GOTO .31290 :REM FATAL KEY ERROR 
	   DML.KEY$=DML.I.KEY$
	   GOSUB .30500					:REM WRITE NEW KEY
	   IF DML.ERROR%<>0 THEN GOTO .31290		:REM WRITE ERROR
	   IF DML.RET$="61" AND KDR.TYPE$="U" THEN \
	      GOSUB .31700: GOSUB .92100 : GOTO .31290 	:REM DUPLICATE KEY
	   IF DML.RET$<>"" THEN GOSUB .91400: GOTO .31290 :REM MAGSAM ERROR

.31250	NEXT DML.WKEY%
	IF DML.UNIQUEFLG$="U"  \
		THEN DML.UNIQUEFLG$="D":GOTO .31210:REM PROCESS DUPS

	MAGSAM(9)=DML.DATAREC		:REM RESET DATA RECORD NUMBER
	GOSUB .31100			:REM RE-WRITE DATA RECORD
.31290	RETURN

.31300	REM BUILD KEY WORK FILE (OLD KEYS)
	FOR DML.WKEY%=1 TO FLR.KEYS%
	   DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	   GOSUB .32500			:REM READ KEY DEFINITION
	   GOSUB .43200			:REM BUILD KEY
	   PRINT #4, DML.WKEY%; DML.KEY$	:REM PUT TO WORK FILE
	NEXT DML.WKEY%
	RETURN

.31400	REM WRITE DUPLICATE KEYS (BATCH)
	IF FLR.KEYS%=1 THEN GOTO .31490	:REM NO MORE KEYS TO WRITE

	FOR DML.WKEY%=2 TO FLR.KEYS%
	   IF DML.KEY.TYPE$(DML.WKEY%)="U" THEN GOTO .31450 :REM SKIP UNIQUES
	   IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE LAST INDEX
	   GOSUB .34300				:REM OPEN THIS INDEX
	   DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	   GOSUB .32500			:REM READ KEY DEFINITION RECORD
	   
	   FOR DML.DATA%=1 TO DML.WRKNO%  :REM WRITE NEW KEYS FOR THIS INDEX
	      READ #5, DML.DATA%; DML.DATAREC	:REM READ DATA RECORD NUM
	      DML.REC$=""
	      READ #2, DML.DATAREC; LINE DML.REC$	:REM READ DATA RECORD 
	      IF FLR.MODE$="N" THEN \ 3.0
	         GOSUB .42200 \ BLD FLD VALUES NORMAL REC
	      ELSE \ 3.0
	         GOSUB .44200: REM BLD FLD VALUES EXTENDED REC 3.0
	      IF DML.ERROR%<>0 THEN GOTO .31490	:REM PARSING ERROR
	      GOSUB .43200			:REM BUILD KEY
	      GOSUB .30500			:REM WRITE KEY
	      IF DML.RET$<>"" \
			THEN GOSUB .91400: GOTO .31490:REM MAGSAM ERROR-EXIT
	   NEXT DML.DATA%

.31450	NEXT DML.WKEY%

.31490	RETURN


.31500	REM  READ FILE DEFINITION HEADER
	DML.DUM$=FN.RDFHR$
	RETURN

.31600	REM UPDATE AUTO INDEX IN FLR
	FLR.INDEX%=FLR.INDEX%+FLR.INCR%
	DML.DUM$=FN.PTFLR$(DML.FLRREC%)
	RETURN

.31700	REM DELETE ALL CHANGED KEYS BACK
	DML.LASTKEY%=DML.WKEY%-1
	FOR DML.WKEY%=1 TO DML.LASTKEY%
	   IF DML.KEY.TYPE$(DML.WKEY%)="D" \
		THEN GOTO .31750		:REM NO ENTRY YET OF DUPS
	   IF DML.INDSTAT$="O" THEN GOSUB .34400	:REM CLOSE FILES
	   GOSUB .34300			:REM OPEN APPROPRIATE KEY FILE
	   DML.RECNO%=DML.WKEY%+DML.FLRNO%+FLR.FLDS%
	   GOSUB .32500			:REM READ KEY DEFINITION
	   GOSUB .43200		 	:REM BUILD KEY
	   READ #4, DML.WKEY%;DML.K.KEY$
	   IF DML.KEY$=DML.K.KEY$ THEN GOTO .31750	:REM KEY NOT CHANGED

	REM DELETE NEW KEY AND ADD BACK OLD KEY
	   DML.KEYLENGTH%=LEN(DML.KEY$)
	   GOSUB .30300					:REM DELETE NEW KEY
	   IF DML.ERROR%<>0 THEN GOTO .31790
	   IF DML.RET$<>"" THEN GOSUB .91400: GOTO .31790 :REM FATAL KEY ERROR 
	   DML.KEY$=DML.K.KEY$
.31730	   GOSUB .30500					:REM RE-WRITE OLD KEY
	   IF DML.ERROR%<>0 THEN GOTO .31790		:REM WRITE ERROR
	   IF DML.RET$<>"" THEN GOSUB .91400: GOTO .31790 :REM MAGSAM ERROR

.31750	NEXT DML.WKEY%
.31790	RETURN


.31800	REM  READ (SK) FILE DEF RECORD
	DML.RET$=FN.SKFDF$(DML.FHRFIL%,"K")	:REM READ KEY FILE DEF 
	IF DML.RET$<>"" THEN GOSUB .91000: GOTO .31890
	DML.FLRREC%=MAGSAM(9)
.31890	RETURN

.31900	REM COMMON SUBROUTINE TO CALL MAGSAM
	DML.RET$=""
	MAGSAM(1)=1:MAGSAM(2)=2:MAGSAM(3)=3:MAGSAM(4)=DML.KEYLENGTH%
	IF DML.BUFFLG$<>"B" THEN GOSUB .35100	:REM MAGSAM OPEN
	IF DML.ERROR%<>0 THEN GOTO .31990
	MAGSAM$(1)=DML.MAGSAMOP$
	MAGSAM$(2)=DML.KEY$
	MAGSAM$(3)=KDR.TYPE$
	IF MAGSAM$(3)="D" THEN MAGSAM(5)=DML.DATAREC
	MAGSAM$(6)=DML.BUFFLG$
	DML.DUM$=FN.MAGSAM$
	IF MAGSAM(8)<>0 THEN \
	   DML.RET$=STR$(MAGSAM(8))
.31990	RETURN

.32100	REM  OPEN FILE DEF FILE
	DML.DUM$=FN.OOFDF$
	RETURN

.32300	REM  CLOSE FILE DEF FILE
	DML.DUM$=FN.CLFDF$
	RETURN

.32400	REM  READ FIELD DEF RECORD
	DML.DUM$=FN.RDFDR$(DML.RECNO%)
	RETURN

.32500	REM  READ KEY DEF RECORD
	DML.DUM$=FN.RDKDR$(DML.RECNO%)
	RETURN

.34100	REM  OPEN DATA FILE AND INDEX FILE
	GOSUB .34300		:REM OPEN WORKING KEY FILE
	GOSUB .34500		:REM OPEN DATA FILE
	RETURN

.34200	REM CLOSE DATA FILE AND WORKING INDEX
	GOSUB .34400	:REM CLOSE WORKING KEY FILE
	GOSUB .34600	:REM CLOSE DATA FILE
	GOSUB .32300	:REM CLOSE FILE DEF FILE (3.0)
	GOSUB .32100	:REM OPEN FILE DEF FILE TO RESET INDEX (3.0)
	RETURN

.34300	REM OPEN WORKING KEY FILE
	DML.FILE$=FLR.DRIVE$+":"+FLR.ID$+"."
	DML.FILEX$=RIGHT$("00"+STR$(DML.WKEY%),2)
	OPEN DML.FILE$+"I"+DML.FILEX$ RECL 256 AS 1
	OPEN DML.FILE$+"O"+DML.FILEX$ RECL 256 AS 3
	DML.INDSTAT$="O"
	DML.INDWKEY%=DML.WKEY%
	DML.BUFFLG$=""		:REM FORCE AN MAGSAM OPEN
	DML.KEYLENGTH%=0	:REM FORCE KEY BUILD IN READ NEXT (DRN)
	RETURN

.34400	REM CLOSE WORKING KEY FILE
	CLOSE 1,3
	DML.INDSTAT$="C"
	DML.INDWKEY%=0
	RETURN

.34500	REM OPEN DATA FILE
	IF END #2 THEN .34570
	DML.FILE$=FLR.DRIVE$+":"+FLR.ID$+"."
	OPEN DML.FILE$+"DAT" RECL FLR.PRECL% AS 2
	DML.RET$=""
	GOTO .34590

.34570	DML.RET$="EOF"
.34590	RETURN

.34600	REM CLOSE DATA FILE
	CLOSE 2
	RETURN

.34700	REM OPEN WORK FILE FOR CREATE
	DML.RECLEN%=128
.34720	DML.FILE$="CHGWORK.$$$"
	DML.WRKNO%=0
	IF END #4  THEN .34750
	OPEN DML.FILE$ RECL DML.RECLEN% AS 4
	GOTO .34790

.34750	CREATE DML.FILE$ RECL DML.RECLEN% AS 4
.34790	RETURN

.34800	REM CLOSE WORK FILE
	CLOSE 4,5
	RETURN

.34900	REM OPEN WORK FILE FOR ADD
	DML.RECLEN%=16
.34920	DML.FILE$="ADDWORK.$$$"
	DML.WRKNO%=0
	IF END #5  THEN .34950
	OPEN DML.FILE$ RECL DML.RECLEN% AS 5
	GOTO .34990

.34950	CREATE DML.FILE$ RECL DML.RECLEN% AS 5
.34990	RETURN

.35100	REM MAGSAM OPEN FUNCTION CALL (PARAMETERS SET BY CALLING SEGMENT)
	DML.RET$=""
	MAGSAM$(1)="OO":MAGSAM$(6)="B"
	DML.DUM$=FN.MAGSAM$
	IF MAGSAM(8)<>0 THEN \
		DML.RET$=STR$(MAGSAM(8)): \
		GOSUB .91400: GOTO .35190
	DML.BUFFLG$="B"
.35190	RETURN

.36100	REM READ DATA RECORD (3.0)
	READ # 2, MAGSAM(9); LINE DML.REC$
	IF FLR.MODE$="N" THEN \
	   GOSUB .42200 \ BLD FLD VALUES NORMAL REC
	ELSE \
	   GOSUB .44200: REM BLD FLD VALUES EXTENDED REC
	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
.40000	REM  *              MISCELLANEOUS ROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	REM .40100 RESERVED FOR OTHER MAG/base FUNCTIONS
	REM .40200 RESERVED FOR OTHER MAG/base FUNCTIONS
	REM .40300 RESERVED FOR OTHER MAG/base FUNCTIONS
	REM .40400 RESERVED FOR OTHER MAG/base FUNCTIONS

.40500	REM  BUILD SINGLE FIELD KEY VALUE (3.0)
	FDR.TYPE$=KDR.FTP$(DML.I.KEY%)
	DML.PAD%=KDR.LEN%(DML.I.KEY%)-LEN(DML.KEY$)
	IF FDR.TYPE$="A" OR FDR.TYPE$="Y" \ ALPHA FIELDS
	   OR FDR.TYPE$="R" THEN \
	      DML.KEY$=DML.KEY$+LEFT$(DML.SPACE$,DML.PAD%): \
	      GOTO .40590
	REM NUMERIC FIELDS (N,$,D,I)
	DML.M%=MATCH("#",DML.KEY$,1): REM MAKE LEADING BLANKS ...
	IF DML.M%>0 THEN DML.M%=DML.M%-1
	DML.KEY$=LEFT$(DML.ZERO$,DML.PAD%+DML.M%)+ \
	   RIGHT$(DML.KEY$,LEN(DML.KEY$)-DML.M%): REM ZEROS
	IF FDR.TYPE$="D" THEN \ MAKE DATE YYMMDD
		DML.KEY$=RIGHT$(DML.KEY$,2) + LEFT$(DML.KEY$,4)
.40590	RETURN

.41200	REM  INITIALIZE FILE FOR PROCESSING
	DML.FHRFIL%=VAL(DML.FILENO$)
	GOSUB .31800: REM READ FILE DEF FILE
	IF DML.ERROR%<>0 THEN GOTO .41290
	DML.FLRNO%=MAGSAM(9)
	DML.RECNO%=MAGSAM(9)+1

	IF DML.NOFLDS%=0 THEN  GOTO .41210	:REM SET ARRAY TO NULL
	   FOR DML.I%=1 TO DML.NOFLDS%
	      FLD.VAL$(DML.I%)=""
	   NEXT DML.I%

.41210	DML.NOFLDS%=FLR.FLDS%
	DML.REC$=""
	REM INTERNAL STORAGE FOR FIELD VALUES
	DIM FLD.VAL$(DML.NOFLDS%)	
	DML.DUM$=FN.INITKDR$	:REM INITIALIZE KEY DEFINITION RECORD

	REM CREATE TABLE OF KEY TYPES
	IF DML.KEY.TYPE%=0 THEN GOTO .41220
	   FOR DML.I%=1 TO DML.KEY.TYPE%	:REM NULL OUT ARRAY BEFORE DIM
	      DML.KEY.TYPE$(DML.I%)=""
	   NEXT DML.I%

.41220	DML.KEY.TYPE%=FLR.KEYS%
	DIM DML.KEY.TYPE$(FLR.KEYS%)
	FOR DML.I%=1 TO FLR.KEYS%
	   DML.RECNO%=DML.FLRNO%+FLR.FLDS%+DML.I%
	   GOSUB .32500			:REM READ KEY DEFINITION
	   DML.KEY.TYPE$(DML.I%)=KDR.TYPE$
	NEXT DML.I%


.41260	REM TEST IF FILE IS ON MOUNTED DISKS
	GOSUB .34500		:REM OPEN DATA
	IF DML.RET$="EOF" THEN GOTO .41270		:REM NO DATA FILE
	GOSUB .34600		:REM CLOSE DATA
	DML.RET$=""
	GOTO .41290

.41270	REM MOUNT NEW DISKS
	GOSUB .91700: GOTO .41290	:REM ERROR EXIT
	
.41290	RETURN

.41300	REM REQUEST KEY NUMBER
	REM KEY NUMBER IS PASSED IN DML.KEYNO$
	DML.MKEY%=VAL(DML.KEYNO$)	:REM MATCH KEY NUMBER
	IF DML.MKEY%<1 OR DML.MKEY%>FLR.KEYS% \
		THEN DML.MKEY%=0: GOSUB .91500: REM INVALID KEY NUM
.41390	RETURN


.42100	REM  BUILD DATA RECORD BEFORE WRITE
	DML.REC$=""
	DML.UPDSTAT$=""				:REM RESET UPDATE HOLD
	FOR DML.SB.I%=1 TO FLR.FLDS%
	   DML.RECNO%=DML.SB.I%+DML.FLRNO%
	   GOSUB .32400		:REM READ IN FIELD DEFINITION
	   IF FDR.TYPE$="A" OR FDR.TYPE$="Y" \
		OR FDR.TYPE$="R" THEN \
	      DML.REC$=DML.REC$+""""+FLD.VAL$(DML.SB.I%)+"""," \
	   ELSE \ NUMERIC FIELDS (N,$,I,D) (3.0)
	      DML.REC$=DML.REC$+FLD.VAL$(DML.SB.I%)+","
	NEXT DML.SB.I%
	DML.REC$=LEFT$(DML.REC$,LEN(DML.REC$)-1): REM REMOVE LAST COMMA
	RETURN

.42200	REM  ASSIGN FIELD VALUES AFTER READ (3.0)
	DML.UPDSTAT$=""				:REM RESET UPDATE HOLD
	GOSUB .43100				:REM NULL DISPLAY ARRAY
	DML.POS%=1
	FOR DML.I%=1 TO FLR.FLDS%
	   IF DML.POS%=0 \
		THEN FLD.VAL$(DML.I%)="" : \ FILL IN NULL FOR MISSING FIELDS
		  GOSUB .91200 : GOTO .42270	:REM GIVE ERROR MSG
	   DML.QLOC%=MATCH("""",DML.REC$,DML.POS%)	:REM LOOK FOR QUOTE
	   DML.CLOC%=MATCH(",",DML.REC$,DML.POS%)	:REM LOOK FOR COMMA
	   IF DML.QLOC%=0 THEN GOTO .42230	:REM NUMERIC
	   IF DML.CLOC%=0 THEN GOTO .42250	:REM ALPHA
	   IF DML.QLOC%<DML.CLOC% THEN GOTO .42250	:REM ALPHA FIELD
.42230	REM ELSE NUMERIC FIELD
	   IF DML.CLOC%=0 THEN \ IF NO COMMA LOOK FOR SPACE (3.0)
		DML.CLOC%=MATCH(" ",DML.REC$,DML.POS%): REM (3.0)
	   IF DML.CLOC%>0 \
		THEN DML.LEN%=DML.CLOC%-DML.POS% \
		ELSE DML.LEN%=LEN(DML.REC$)-DML.POS%+1
	   FLD.VAL$(DML.I%)=MID$(DML.REC$,DML.POS%,DML.LEN%): REM SET FLD VALUE
	   IF DML.CLOC%=0 THEN DML.POS%=0 : GOTO .42270	:REM END OF RECORD
	   DML.POS%=DML.CLOC%+1
	   GOTO .42270
.42250	REM ALPHA FIELD
	   DML.POS%=DML.POS%+1			:REM POSITION PAST QUOTE
	   DML.QLOC%=MATCH("""",DML.REC$,DML.POS%)	:REM LOOK FOR QUOTE
	   IF DML.QLOC%>0 \
		THEN DML.LEN%=DML.QLOC%-DML.POS% \
		ELSE FLD.VAL$(DML.I%)="" : \ FILL IN NULL FOR MISSING FIELDS
		  GOSUB .91200 : GOTO .42270	:REM GIVE ERROR MSG
	   FLD.VAL$(DML.I%)=MID$(DML.REC$,DML.POS%,DML.LEN%): REM SET FLD VALUE
	   DML.POS%=DML.QLOC%+2: REM POSITION PAST DELIMITING COMMA
.42270	NEXT DML.I%
	RETURN

.43100	REM  INITIALIZE FIELD VALUES
	FOR DML.I%=1 TO FLR.FLDS%
	   FLD.VAL$(DML.I%)=""
	NEXT DML.I%
	RETURN

.43200	REM  BUILD SECONDARY KEY VALUE 
	IF KDR.TYPE$="D" THEN DML.END%=10 ELSE DML.END%=1
	DML.KEYLENGTH%=0: DML.K.KEY$=""

	FOR DML.I.KEY%=1 TO DML.END%
	   DML.KEY$=LEFT$(FLD.VAL$(KDR.FLD%(DML.I.KEY%)),KDR.LEN%(DML.I.KEY%))
	   GOSUB .40500		:REM PAD KEY TO LENGTH
	   DML.KEYLENGTH%=DML.KEYLENGTH% + KDR.LEN%(DML.I.KEY%)
	   DML.K.KEY$=DML.K.KEY$+DML.KEY$
	NEXT DML.I.KEY%
	DML.KEY$=DML.K.KEY$
	RETURN

.44100	REM  BUILD DATA RECORD BEFORE WRITE - FIXED FLD LEN (3.0)
	DML.REC$=""
	DML.UPDSTAT$=""				:REM RESET UPDATE HOLD
	FOR DML.SB.I%=1 TO FLR.FLDS%
	   DML.RECNO%=DML.SB.I%+DML.FLRNO%
	   GOSUB .32400		:REM READ IN FIELD DEFINITION
	   DML.FLDLEN%=FDR.MAXL%
	   IF FDR.DEC%>0 THEN \
	      DML.FLDLEN%=DML.FLDLEN%+1
	   IF FDR.TYPE$="A" OR FDR.TYPE$="Y" \ ALPHA FIELDS
		OR FDR.TYPE$="R" THEN \
	      DML.REC$=DML.REC$+FLD.VAL$(DML.SB.I%)+ \ PAD ON RIGHT
	         LEFT$(DML.SPACE$,DML.FLDLEN%-LEN(FLD.VAL$(DML.SB.I%))) \
	   ELSE \ NUMERIC FIELDS (N,$,D,I) - PAD ON LEFT
	      DML.REC$=DML.REC$+LEFT$(DML.SPACE$,DML.FLDLEN% - \
	         LEN(FLD.VAL$(DML.SB.I%)))+FLD.VAL$(DML.SB.I%)
	NEXT DML.SB.I%
	RETURN

.44200	REM  ASSIGN FIELD VALUES AFTER READ - FIXED FLD LEN (3.0)
	DML.UPDSTAT$=""				:REM RESET UPDATE HOLD
	GOSUB .43100				:REM NULL DISPLAY ARRAY
	DML.POS%=1
	FOR DML.I%=1 TO FLR.FLDS%
	   DML.RECNO%=DML.I%+DML.FLRNO%
	   GOSUB .32400		:REM READ IN FIELD DEFINITION
	   DML.FLDLEN%=FDR.MAXL%
	   IF FDR.DEC%>0 THEN \
	      DML.FLDLEN%=DML.FLDLEN%+1
	   FLD.VAL$(DML.I%)=MID$(DML.REC$,DML.POS%,DML.FLDLEN%)
	   DML.POS%=DML.POS%+DML.FLDLEN%
	NEXT DML.I%
	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
.90000	REM  *              ERROR ROUTINES                           *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

REM	NOTE:   IN THE FOLLOWING ERROR ROUTINES, THE TEXT FOR THE
REM		ERROR MESSAGES HAS BEEN COMMENTED OUT TO ACCOMODATE
REM		48K SYSTEMS.  IF YOU HAVE SUFFICIENT MEMORY, YOU MAY
REM		REMOVE THE 'REM' SO THAT THE TEXT IS ALSO RETURNED.

.90100	REM  INVALID FUNCTION
	REM	DML.ERROR$="Invalid function."
	DML.ERROR%=1
	RETURN

.90200	REM  KEY NOT FOUND
	REM	DML.ERROR$="Key does not exist on file."
	DML.ERROR%=2
	RETURN

.90300	REM  DML ALREADY INITIALIZED
	REM	DML.ERROR$="DML has already been initialized."
	DML.ERROR%=3
	RETURN

.90400	REM DML NOT INITIALIZED
	REM	DML.ERROR$="DML has not been initialized."
	DML.ERROR%=4
	RETURN

.90500	REM DATA FILE NOT OPEN
	REM	DML.ERROR$="Data file has not been opened."
	DML.ERROR%=5
	RETURN

.90600	REM NO BATCH BEGIN
	REM	DML.ERROR$="No Batch Begin function has been initiated."
	DML.ERROR%=6
	RETURN

.90700	REM INVALID DATA RECORD NUMBER
	REM	DML.ERROR$="Invalid data record number."
	DML.ERROR%=7
	RETURN

.90800	REM NO DATA FILE SELECTED
	REM	DML.ERROR$="Data file has not been selected"
	DML.ERROR%=8
	RETURN

.90900	REM INVALID FIELD NUMBER
	REM	DML.ERROR$="Invalid field number."
	DML.ERROR%=9
	RETURN

.91000	REM  FATAL ERROR IN FILE DEF FILE (3.0)
	DML.ERROR$="Func="+MAGSAM$(1)+"  Error="+DML.RET$+ \
	   "  Key Value="+MAGSAM$(2)
	DML.ERROR%=10
	RETURN
	
.91100	REM  NO FILE DEF FILE
	REM	DML.ERROR$="No file definition file."
	DML.ERROR%=11
	RETURN
	
.91200	REM  FIELD PARSING ERROR
	REM	DML.ERROR$="Parsing Field: "+STR$(DML.I%)+ \
	   " Pos="+STR$(DML.POS%)
	DML.ERROR%=12
	RETURN
  	
.91300	REM  NO FILE DEF FILE
	REM	DML.ERROR$="Terminal definition not in memory."
	DML.ERROR%=13
	RETURN

.91400	REM  FATAL DATA FILE ERROR
	DML.ERROR$=LEFT$("Func="+ MAGSAM$(1) +"  Error="+DML.RET$ \
	+"  Key Number="+STR$(DML.WKEY%) +"  Key Value="+MAGSAM$(2),60)
	DML.ERROR%=14
	RETURN

.91500	REM INVALID KEY NUMBER
	REM	DML.ERROR$="Invalid key number."
	DML.ERROR%=15
	RETURN
	
.91600	REM KEY DOES NOT MATCH READ GENERIC RETURN
	REM	DML.ERROR$="No matching key, next higher shown."
	DML.ERROR%=16
	RETURN

.91700	REM WARNING - FILE NOT ON MOUNTED DISKS
	REM	DML.ERROR$="File not on mounted disks."
	DML.ERROR%=17
	RETURN

.91800	REM NO KEY SELECTED
	REM	DML.ERROR$="Key has not been selected."
	DML.ERROR%=18
	RETURN

.91900	REM FILE ALREADY OPEN
	REM	DML.ERROR$="File has already been opened."
	DML.ERROR%=19
	RETURN

.92100	REM DUPLICATE KEY
	REM DML.ERROR$="Key already exists on file (Key "+STR$(DML.WKEY%)+")"
	DML.ERROR%=21
	RETURN

.92200	REM CURRENTLY IN BATCH MODE
	REM	DML.ERROR$="Currently in Batch Add mode."
	DML.ERROR%=22
	RETURN

.92300	REM INVALID FILE NUMBER
	REM	DML.ERROR$="Invalid file number specified."
	DML.ERROR%=23
	RETURN

.92400	REM NO HOLD FOR UPDATE
	REM	DML.ERROR$="No hold was initiated for update."
	DML.ERROR%=24
	RETURN

.92500	REM HOLD ALREADY INITIATED
	REM	DML.ERROR$="Hold already initiated for update."
	DML.ERROR%=25
	RETURN

	FEND
	
%LIST
