/*    IIIIII      OOOOOO
      IIIIII     OOOOOOOO
        II      OO      OO
        II      OO      OO 
        II      OO      OO
        II      OO      OO
        II      OO      OO 
      IIIIII     OOOOOOOO
      IIIIII      OOOOOO	*/

/* this module contains the following merker-defined modules 

version		0
revision	1
	All these routines check keyboard and load the circular 
	keyboard buffer 

	gts	 -  moves char from console to buffer
	gtch     -  get a char from key buffer
	gtstch   -  get stat or char from key buffer
	gtchna   -  no abort on control c
	gtstchna -  no abort on control c
	ungtch   -  shoves char back in buffer
        upgtch   -  get upper case char
	upgtstch -  get upper case stat or char
	intostring - reads chars from bufferitno a string
	charErase  - puts to screen BS ' ' BS
	repchar - repaets a char to screen 

	ptch     -  straight putchar
	putz     -  put a string 
	printz   -  printf using putz    
	gptch	 -  output with no input for graphics
	gputz	 -   "       "  "    "    "     "

					*/
#define MAXLINE 135     /* same as in library */

#include	"equs.c";
#include	"data.c";

keyinit()
	{ keyin = 0;
	  keyout = 0; }

	/* moves char from keybaord to buffer */
gts ()
	{

	char chr;
	while (chr = bdos (6,0xFF))
		{
		keybuff [keyin] = chr;
		if (++keyin >= KBUFFSIZE)
			keyin = 0;
		}
	}

	/* get char if waiting or status 0 if not */
char gtstch()	
	{
	char chr;
	
	gts();	
	if (keyin == keyout) 
		chr = 0;
	else
		{
		chr = keybuff [keyout];
		if (++keyout >= KBUFFSIZE)
			keyout = 0;
		}
	if (chr == CTRLC) 
		{
		printz ("^C");	
		dummy = abort();
		}
	return (chr);
	}	


	/* get a char from keyboard */
char gtch()
	{
	char  chr;
	while ((chr = gtstch()) == 0)
		;
	return (chr);
	}

	/* get char with no abort */
char gtstchna()	
	{
	char chr;
	
	gts();	
	if (keyin == keyout) 
		chr = 0;
	else
		{
		chr = keybuff [keyout];
		if (++keyout >= KBUFFSIZE)
			keyout = 0;
		}
	return (chr);
	}	

	/* get a char with no abort */
char gtchna()
	{
	char  chr;
	while ((chr = gtstchna()) == 0)
		;
	return (chr);
	}

ungtch (chr)
	char	chr;
	{
	keyout--;
	if (keyout < 0)
		keyout = KBUFFSIZE - 1;
	keybuff [keyout] = chr;
	if (keyout == keyin)
		{
		keyin--;
		if (keyin < 0) keyin = KBUFFSIZE - 1;
		}
	}		

char upgtstch()
	{
	return (toupper (gtstch()));
	}

upgtch()
	{
	return (toupper (gtch()));
	}


/* input (and display) string to ptr till cr or max reached */
int	intostring (ptr,max)
	char 	*ptr;
	int	max;
{
	int 	i;

	i = 0;
	while (i < max)
		{
		*ptr = gtch();
		if ((*ptr == CR) || (*ptr == LF))
			{
			*ptr = '\0';
			putz ("\n");
			return (i);
			}	/* if CR or LF */
		if ((*ptr >= ' ') && (*ptr < DEL))
			{
			ptch (*ptr);
			ptr++;
			i++;
			}
		if (((*ptr == BS) || (*ptr == DEL)) && (i > 0))
			{
			*ptr = '\0';
			ptr--;
			*ptr = '\0';
			charErase();
			i--;
			}
		}  /* while 1 */
	*ptr = '\0'; /* full buffer */			
	putz ("\n");
	return (i);
}	/* end of intostring */

charErase() {ptch (BS); ptch (' '); ptch (BS); } 


/* repeat outputting a character */
repchar(chr,num)
	char	chr,num;
{	char	i;
	for (i = 0; i < num; i++)
		ptch (chr);
}




ptch (s)
	char s;
	{
	gptch (s);
	gts();
	}

gptch (s)      /* no input, for grapihcs mode */
	char s;
	{
	if (s != 0xFF)
		dummy = bdos (6,s);
	else dummy = bdos (2,s);
	}


putz(s)   /* modified puts, using putch not putchar*/
char *s;
{	
	while (*s) 
		{
		if (*s == '\n')
			{ptch (CR); ptch (LF);}
		else ptch (*s);
		s++;
		}  /* while *s */
}

sputz (s)  /* put out without expanding \n */
char *s;
{ while (*s)
	{ ptch (*s); s++; }
}


gputz(s)   /* modified putz, no input (for graphics mode) */
char *s;
{	
	while (*s) 
		{
		if (*s == '\n')
			{gptch (CR); gptch (LF);}
		else gptch (*s);
		s++;
		}  /* while *s */
}

/* modified printf, uses putz not puts, cpm function 6 output call */
printz(format)
char *format;
{
	char line[MAXLINE];
	_spr(line,&format);	/* use "_spr" to form the output */
	putz(line);		/* and print out the line	 */
}
scroll (num)
	int	num;
{	int	i;
	
	for (i = 0; i < num; i++)
		printz ("\n");
}

