/*
	***   ***     *    *       *   ****
        *  *  *  *   * *   *       *       *
        *  *  ***   *   *  *   *   *    *** 
        *  *  *  *  *****   * * * *    *
        ***   *   * *   *    *   *     *****

*/
/* utility file for chardraw */

#include  	"equs.c"
#include	"b:data.c"


/* resets pixxel in new char def and blanks cell on screen */
blankcell (cb)
	struct cellbuild *cb;
{	int	x,y,i,topwitdh;
	char	setbyte,topwidth;

	if (st.isSmall) topwidth = 7;
	else topwidth = gdwidth;

	doblank (cb->wcell,cb->hcell);
	/* reset bit in char map */;
	setbyte = 1;
	setbyte = setbyte << (topwidth - cb ->wcell - 1);
	cb -> charmap [gdheight - cb->hcell] &= ~setbyte;
	sampledisp (cb);

} /* end of blank cell */

/* blanks gird element */
doblank (x,y)
	int	x,y;
{	int	i;

	/* is not horiz fill block gets displayed to lower left,not
	   upper left of cursor position */
	x = (XBASE + (x * (CELLWIDTH + 1)) + 1); 
	y = (YBASE + (y * (CELLWIDTH + 1)) +1);
	if (!isHoriz) y += (CELLWIDTH-1);
	

	GRmove (x,y);
	gputz (GRandseq);
	gputz (showshapeseq);
	gptch (FILLSHAPE);
	gputz (GRorseq);



}  /* end of do blank  */

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* sets pixel in char definition and fills cell on screen */
fillcell (cb)
	struct cellbuild *cb;
{	char   setbyte;
	int	x,y,topwidth;

	if (st.isSmall) topwidth = 7;
	else topwidth = gdwidth;
	dofill (cb->wcell,cb->hcell);
	/* set bit in char map */
	setbyte = 1;
	setbyte = setbyte << (topwidth - cb->wcell - 1);
	cb -> charmap [gdheight - (cb->hcell)] |= setbyte;
	sampledisp (cb);

} /* end of fillcell */

/* fills gird element */
dofill (x,y)
	int	x,y;
{
	/* is not horiz fill block gets displayed to lower left,not
	   upper left of cursor position */

	x = (XBASE + (x * (CELLWIDTH + 1)) + 1); 
	y = (YBASE + (y * (CELLWIDTH + 1)) +1);
	if (!isHoriz) y += (CELLWIDTH-1);

	GRmove (x,y);
	gputz (showshapeseq);
	gptch (FILLSHAPE );
	

}  /* end of do fill */

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* load cell cefinition with blanks */
cellclear (cb)
	struct	cellbuild *cb;
{	int	i;
	for (i = 0; i <= BIGHEIGHT; i++)
		cb -> charmap [i] = '\0';
}  /* cell build */


/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* display character built from defintion */
sampledisp (cb)
	struct	cellbuild *cb;
{	int	i,j,x,y;
	char	sampstr[9],hold;

/* put out blanks, use lines for now */
	CHmode();
	CHcurPos (14,28);
	printz ("Character looks like this >");
	if (st.isSmall)
		{ x = XLITSAMPLE;
		  y = YLITSAMPLE;
		  if (!isHoriz)
			{ x += 55;
			  y -= 15;
			}
		}
	else	
		{ x = XSAMPLE;
		  y = YSAMPLE;
		}
	gputz (GRandseq);
	for (i = 0; i < 8; i++)
		{ GRmove ((x + i),(y - BIGDESCEND));
		  GRdraw ((x + i),(y + gdheight));
		}
	gputz (GRorseq);

	/* define char */
	/* if vert move data into a sideways display block */
	if (!isHoriz) 
		{ for (i = 0; i < 8; i++)
			sampstr[i] = 0; 
		  movechar (sampstr,cb->charmap,HtoV);
		/* reverse order of bytes */
		 for (i = 0; i < 4; i++)
			{ hold = sampstr[i];
			  sampstr[i] = sampstr [7-i];
			  sampstr [7-i] = hold;
			}
		}  /* !ishoriz */

	gputz (defshapeseq);
	gptch (CURSHAPE);
	gptch (gdheight+1);
	gptch (0);
	gptch (1);
	for (i = gdheight; i >= 0 ; i--)
		{
		if (isHoriz) ptch (cb->charmap[i]);
		else ptch (sampstr [i]);
		}
/* put char */
	/* set coordinates for start of block display */
	if (!st.isSmall)
		{
		x = XSAMPLE;
		y = YSAMPLE;
		if (cb->isDescend) y -= BIGDESCEND;		
		}   /* large chars */
	else
		{
		y = YLITSAMPLE;
		if (cb->isDescend) y -= LITDESCEND;
		x = XLITSAMPLE;
		if (!isHoriz) 
			{   /* height of sample */ 
			  x += 55;
			  y -= 7;
			}
		}  /* small chars */

	GRmove (x,y);
	gputz (showshapeseq);
	gptch (CURSHAPE);

}  /* end of sample disp */

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* CLEAR SCREEN SEQUENCE */	
clearsc()
{	gputz (clearseq); }

/* PUT IN 5000 GRAPHICS MODE */
GRmode()
{	gputz (graphseq);
	gputz (g5000seq);	
}

/* CHARACTER MODE */
CHmode()
{	gputz (charseq);	
}

/* POSITION CURSOR */
CHcurPos (r,c)
	int r,c;
{	if (st.isSmall)
		{ if (isHoriz) r += 18;
		  else r += 37;
		}

	ptch (CR); /* because of 4010 emulation */
	putz (positseq);
	gptch (0x20 + r);
	gptch (0x20 + c);
}

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* draw grid on screen */
drawgrid (cb)
	struct	cellbuild	*cb;
{	int	i,j,k,hold;
	char    setbyte;
	
/* draw base lines */
	GRmove (XBASE, YBASE);
	GRdraw ((XBASE + (gdwidth * (CELLWIDTH + 1))), YBASE );
	GRmove (XBASE, YBASE);
	GRdraw (XBASE, (YBASE + (gdheight * (CELLWIDTH + 1))));

/* draw vertical lines */
	for (i = 1; i <= gdwidth; i++)
		{
		GRmove ((XBASE + (i * (CELLWIDTH+1))),YBASE);
		GRdraw ((XBASE + (i * (CELLWIDTH+1))),(YBASE + ((CELLWIDTH + 1) * gdheight)));
		} /* for i < gdwidth */
		/* draw horizontal lines */
	for (i = 1;i <= gdheight; i++)
		{
		GRmove (XBASE,(YBASE + (i * (CELLWIDTH+1))));
		GRdraw ((XBASE + ((CELLWIDTH+1) * gdwidth)),(YBASE + (i * (CELLWIDTH + 1))));
		} /* for i < 8 */

/* draw dotted line for line bottom */
	/* set j to normal line, k to descender line,then
	   if descender is on switch the values */
	j = YBASE;
	if (st.isSmall) k = YBASE + (LITDESCEND * (CELLWIDTH + 1));
	else k = YBASE + (BIGDESCEND * (CELLWIDTH + 1));
	if (cb->isDescend) 
		{ hold = j;
		  j = k;
		  k = hold;
		} /* switch values */

	/* draw line by xoring every other half cell width */
	putz (GRxorseq);
	for (i = 0;i < gdwidth; i++)
		{ GRmove ((XBASE + (i * (CELLWIDTH+1)) + CELLWIDTH/4),j);
		  GRdraw ((XBASE + (i * (CELLWIDTH+1)) + (3 * CELLWIDTH/4)),j);
		}  /* i to gdwidth */
	putz (GRorseq);
	/* now cancel old line extenders(k) and draw the new ones (j) */
	putz (GRandseq);
	GRmove ((XBASE-1),k);
	GRdraw ((XBASE-CELLWIDTH),k);
	GRmove ((XBASE + (gdwidth * (CELLWIDTH+1)) + 1),k);
	GRdraw ((XBASE + (gdwidth * (CELLWIDTH+1)) + CELLWIDTH),k);
	putz (GRorseq);
	GRmove ((XBASE-1),j);
	GRdraw ((XBASE-CELLWIDTH),j);
	GRmove ((XBASE + (gdwidth * (CELLWIDTH+1)) + 1),j);
	GRdraw ((XBASE + (gdwidth * (CELLWIDTH+1)) + CELLWIDTH),j);

	GRcurse (cb->wcell,cb->hcell);
	
}  /* end of draw grid */

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* fills grib with current character */
griddisp (cb)
	struct cellbuild *cb;
{	int i,j,setbyte,topwidth;


	/* now fill gridb with char */
	for (i = (gdheight -1); i >= 0; i--)
		{ if (st.isSmall) setbyte = 0x04;
		  else setbyte = 1;
		  for (j = gdwidth - 1; j >= 0; j--)
			{ if ((cb->charmap [(gdheight - i)]) & setbyte)
				dofill (j,i);
			  else doblank (j,i);
			  setbyte = (setbyte << 1);
			} /* j to width */
		}  /* i to gdheight */
	sampledisp (cb);
	GRcurse (cb->wcell,cb->hcell);

}   /* end of grid disp */

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

GRmove (x,y)
	int	x,y;
{	gputz (graphseq);
	GRdraw (x,y);
}

#define	HIGHY	0x20
#define	LOWY	0x60
#define	HIGHX	0x20
#define	LOWX	0x40

GRdraw (x,y)
	int	x,y;
{	char outchar;

	outchar = ((y/32) | HIGHY);
	gptch (outchar);
	outchar = ((y - (32 * (y/32))) | LOWY);
	gptch (outchar);
	outchar = ((x/32) | HIGHX);
	gptch (outchar);
	outchar = ((x - (32 * (x/32))) | LOWX);
	gptch (outchar);

}

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* move grid cursor to center of cell */
GRcurse (x,y)
	int	x,y;
{	/* set complement draw mode then draw cross hairs */
	gputz (GRxorseq);
	x = (XBASE + (x * (CELLWIDTH+1)) + 1);
	y = (YBASE + (y * (CELLWIDTH+1)) + 1);
	
	GRmove ((x + CELLWIDTH - 1),y);
	GRdraw (x,(y + CELLWIDTH - 1));
	GRmove (x,y);
	GRdraw ((x + CELLWIDTH - 1),(y + CELLWIDTH-1));
	gputz (GRorseq);
	CHmode();
	putz (crinvseq);
	CHcurPos (1,1);
}  /* end of GRcurse */

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* clear screen and then set character size */
setsize()
{
	clearsc();
	if (st.isSmall) putz (smallseq);
	else putz (largeseq);
}  /* set size */

/***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***
 ***   ***   ***   ***   ***  ***  ***   ***   ***
    ***   ***   ***   ***   ***  ***  ***   ***   ***/

/* create fill shape */
fillbuild()
{	int i;
	gputz (defshapeseq);
	gptch (FILLSHAPE);  /* shape number */
	gptch (CELLWIDTH);   /* height */
	gptch (0);	    /* height */
	gptch (CELLWIDTH/8); /* width */
	for (i = 0; i < (CELLWIDTH * (CELLWIDTH/8)); i++)
		gptch (0xFF);
} /* end of blankbuild */

/* sets to character mode for input */
char Ggtch()	
{	CHmode();
	return (gtch());
}
 