
	.title	'LOGIN - log into the HiNet'
	.sbttl	'LOGIN'
version ==	3
revision==	1
	.pabs
	.phex
	.loc	100h
;----------
; Log into the HiNet by grabbing 
; the network code and executing it
; 
;
;   Version 3.0   The login program has been completely
;		rewritten.  The program simply shuts off
;		the timer interupt, and executes a 
;		patched prom image.
;
;		  Login now logs into HiNet by deter-
;		mining what prom the user has, copying
;		down that prom from high memory, and
;		jumping down to 0 to execute.  Each of
;		the proms is patched to run through the
;		initialization code and jump into the
;		network boot routine.
;
;		NOTE: Whenever either of the proms are
;		updated, so must this program. Here is
;		a sample of code from PROM 4.23 and how
;		it was patched to automatically attempt
;		a network boot.
;   
;   Version 3.1 Works for Separated Boot.  Recovers
;		 serial number from BIOS.
; 	 	 4.23 PROMs do a checksum test which must
;		 be patched around.
;
; (Initialization section)..
; (don't execute RAM test)
;
; Prepare to enter monitor if front panel switch is on
;
;	in	PIOAD
;	bit	7,A	; check front-panel switch
;	jnz	ramok   ; <<<---THROUGH ZDT THIS WAS
;			      MADE INTO AN UNCONDITONAL
;			      JUMP.	
;
; (Before auto-boot check)
;
;	in	PIOAD	;if front panel switch is
;	bit	7,A	;on.go to the Monotor 
;	jnz	Monitor ; <<< CHANGE THIS TO 
;			      3 NOPS.
;
;
; (Check for auto-boot)
;
;	in	SIO1AC	;  DCD	STS
;	bit	3,A	;  ---	---
;	jnz	Network <<<---THROUGH ZDT THIS WAS MADE
;	bit	5,A	      AN UNCONDITIONAL JUMP.
;	jnz	Harddisk;   0	 1   Harddisk boot
;	jmp	Floppy
;
;
;   How to construct LOGIN:
;
;		A>azm login o
;		A>zdti login.hex
;		 -iprom.com
;		 -r1000 	; DSC3/4 prom
;		 -ifoxprom.com
;		 -r1800 	; Fox prom 
;		 -(Patch both proms as demonstrated
;		 - above. Remember the offsets! )
;		 -^C		
;		A>save xx login.com
;
; Port definitions:
DMA	==	38h	; DMA chip
CTC3	==	33h	; CTC channel 3
; Misc constants:
cr	==	0Dh	; carriage return
lf	==	0Ah	; line feed
DSC3	==	1	; product type
DSC4	==	2
DMS1280 ==	3
DMS3C	==	4
loutnet	==	1fh	;logout command
loutack	==	'A'	;logout ack
timeout	==	07h	;timeout response
CRC	==	60h	;crc/ovr
Poll	==	01h	;Poll received
nakoff	==	72h	;Bios offset of NACKPOLL
sendoff	==	6ch	;Sendnet offset
recoff	==	6fh	;recnet offset
Descoff	==	93h	;Describe table call offset
seroff	==	1ch	;serial no offset in above table
Biosrev	==	48	;Earliest Bios that can run Login
versoff	==	sendoff-3 ;rev no offset in Bios
; Addresses:
NETusr	==	47h	; HiNet user number
stack	==	9400h	; Share stack with PROM
IOByte	==	03h
BDOS	==	05h	; BDOS entry point
;----------
; Step 1 - Greet the user, then flush floppy buffer
	lxi	sp,stack	; always need a stack
	lxi	D,greeting
	mvi	C,9
	call	BDOS	; greet the user
;
; Step 2 - Preserve serial number. If Bios is
; too early to have the serial no, give up
;
	call	getserial ; 
	jrc	cant	  ; Bios rev too early to have
			  ; the serial no still intact
;
; Check for master/stand alone status
;
	lda	NETusr
	sta	loutusr
	ora	A
	jrnz	..ok	; if not master, then OK
	lxi	D,master
	mvi	C,9
	call	BDOS	; If master, then we can't 
	jmp	0	; login. We boot.

;----------
; Step 3 - Send logout command if not stand alone
..ok:	inr	a	  ;
	jrz	..ctc
	call	logout	  ;send instant logout
	jrc	cant	  ;error

;----------
; Step 4 - Disable interupts from the CTC clock timer.
..ctc:	mvi	A,43h	  ;Disable code
	out	CTC3	  ;goes to channel 3.


;----------
; Step 5 - Determine the genre of machine we are on.

CKIOBYTE:		  ; If DSC/3, figure out whether 
	lda	IOByte 
	ani	3	; Use only console bits
	cpi	02	; Are we on a Fox (parallel)
	jz	FOX	; Jump up to high mem and
			;download appropriate prom.
	cpi	00	; Serial console....
	jz	DSC	; Jump up to high mem and
			;download appropriate prom.
cant:	lxi	D,CANTmsg
	call	prtmsg	; Tell user we cant login
	jmp	0	; and boot.


; We stick the utilites and messages in low memory
;to be written over when one of the proms is down-
;loaded.

;----------
; Messages
greeting:.ascii [cr][lf]"HiNet Login version "
	.byte	version+'0','.',revision+'0'
	.ascii	[cr][lf][lf]" Please stand by..."
	.ascii	[cr]"$"
master: .ascii	[cr][lf]
	.ascii	"Sorry, the master can't re-login.$"
waiting:.ascii	[cr][lf]"*** Waiting$"
CANTmsg:.ascii	[cr][lf]"Sorry, LOGIN can't be used "
	.ascii	"here. Use the PROM's BN command.$"
loutmsg:.byte	loutnet
loutusr:.byte	0
loutrep:.byte	0

;----------
; Send instant logout command to master
LOGOUT:	lhld	1	  ;get Bios address
	lxi	d,..log1  ;ret address
	push	d
;
; wait for poll
;
	lxi	d,nakoff  ;Nackpoll offset
	dad	d
	pchl		  ;wait for Poll
..log1:	bit	poll,a	  ;poll received?
	jrnz	logout	  ;no,try again	
	call	ckstat	  ;check receive status
	jrc	logout	  ;net error,try again
	stc
	rz		  ;timeout,give up		
;
; send logout command
;
	lxi	d,..log2
	push	d	  ;return address
	lhld	1
	lxi	d,sendoff  ;Sendnet offset
	dad	d
	push	h
	lxi	h,loutmsg
	lxi	b,2
	sub	a
	ret		  ;send logout command
;
; receive response to logout response
;
..log2:	lxi	d,..log3
	push	d
	lxi	b,1
	lda	47h	  ;user number
	lhld	1
	lxi	d,recoff
	dad	d	  ;RECNET address
	push	h
	lxi	h,loutrep ;response area
	ret		  ; 'call' recnet
..log3:	call	ckstat
	rc		  ; error
	lda	loutresp
	cpi	loutack	  ;ok response?
	stc
	rnz
	ora	a	
	ret		  ;ok

;----------
; Check received status
CKSTAT:	stc
	bit	timeout,a
	rz
	ani	crc
	jrz	..ck1
	stc
	ret
..ck1:	ori	0ffh
	ret
;----------
; Print a message to the console
PRTMSG: mvi	C,9
	call	BDOS	; BDOS presumed to still exist
	ret


; This code had better not be past 800h!  If so,|
;change high mem location.			|
;-----------------------------------------------|

; These are high memory routines.  From here we
;load one of the prom images down into low memory
;and jump to the appropriate network boot location.

;------------
; Step 5 - Copy down the appropriate ROM image and
;	jump into the BN section.

	.loc	800h

DSC:	di		  ;No stray interupts
	lxi	H,DSCprom ;Copy the DSC3/4 prom down
	lxi	D,0	  ;into its natural address
	lxi	B,800h	  ;space.
	LDIR
	call	MoveSN	  ; fix serial number
	ei		  ;Re-enable 
	jmp	0	  ;jump into prom intialization

FOX:	di		  ;No stray interupts
	lxi	H,FOXprom ;Copy the fox prom down
	lxi	D,0	  ;into its natural address
	lxi	B,800h	  ;space.
	LDIR
	call	Movesn
	ei
	jmp	0	  ;jump into prom initialization

; Get and save the serial number from the Bios
;
getserial:
	lhld	1	  ;Bios address
	lxi	d,versoff ;get Bios version no
	dad	d
	mov	a,m	  ;check Bios is recent 
	cpi	Biosrev	  ;enough for 'Describe' call
	rc		  ;sorry,too early
	lhld	1
	lxi	d,descoff ;get serial no pointer
	dad	d
	lxi	d,..get1
	push	d
	pchl		  ;'Describe' Bios call
..get1:	lxi	d,seroff
	dad	d	  ; point to serial no
	lxi	d,serial
	jmp	mov1	  ; copy into local area
;
; Move the serial no into the Prom image
;
MoveSN:	lxi	h,serial  ; copy into the
	lxi	D,03FEh   ; Prom area
mov1:	lxi	B,4	  
	LDIR
	ora	a
	ret
;
; safe place for serial number..
;
serial:	.blkb	4

; The DSC3/4 prom code is loaded here.
	.loc	1000h
DSCprom:.blkb	800h   ; Prom allowed to be 2k.

;----------
; The FOX prom code is loaded here.

FOXprom:.blkb	800h	; Can be up to 2k.

.end




