/* **************************************************************
 *								*
 *			  SYSLIB4.C				*
 *	      VERIFY CORRESPONDENCE BETWEEN TABLES		*
 *		  last modified 01/26/84 dsb			*
 *								*
 ************************************************************** */

#include "libc.h"
#include "syslib.h"
#include "hardio.h"

/* ***************** REVISION HISTORY OF THIS MODULE ***************   

    01/18/84	Turned module into an overlay
    01/26/84	Fixed typos in messages
*/
/* *********************** MISCELLANEOUS EQUATES ******************** */


#define MAX_PROD 20	   /* consider any higher product numbers invalid */

#define FIND  'f'
#define PRINT 'p'

/*page*/
ovmain() 
{
    int probs = 0;
    int orphans = 0;

    probs += vf_os_lists(FIND); /* First, see if any OS needs a support file */
				/* that isn't in the System  Directory. */
    probs += vf_prods(FIND);   /* Now check for missing boot loaders, login  */
			       /* programs or OS menus.  */

    if(probs)
    {
	printf("\nFOUND (%d) ERRORS IN THE TABLES.",probs);
	printf(" Any key stops/restarts ERROR REPORT.");
	waitkey();
	vf_os_lists(PRINT);
	printf("\n");
	check_wait();
	vf_prods(PRINT);
	printf("\n");
    }
    else
	printf("\nTHERE ARE NO ENTRY ERRORS IN THE TABLES.");

    orphans = vf_orphans(); /* grounds for suspicion: a file which appears */
			    /* in the System Directory but not in any load */
			    /* list or product table entry. */

    if(orphans)
	printf("\nFound (%d) files that may not be needed.",orphans);
    waitkey();
    printf("\n\n");
} /* verify */


vf_os_lists(func)	/* find whether any OS requires files it can't get */
char func;		/* FIND or PRINT */
{
    struct OSTentry *ostp;
    int max_os;
    int missing = 0;
    int miss_this_ent;
    char *cp;
    int i,j;

    ostp = (struct OSTentry *)ostable.buffer;
    max_os = ost_entries();
    for(i=0;  i<max_os;  ++i, ++ostp)
    {
	miss_this_ent = 0;
	cp = ostp->load_list;	
	for(j=0;  (j<8) && ostp->load_list[j][0];  ++j, cp +=8)
	    if(find_sd(cp) == NULL)
	    {
		++missing;
		if(func == PRINT)
		{
		    if(missing == 1)
		    {
			printf("\nThese entries in the OS table refer to non");
			printf("-existent files:\n\nOS Filename    Missing ");
			printf("Files\n-----------    -------------");
			check_wait();
		    }
		    prt_os_prob(ostp,++miss_this_ent,cp);
		    check_wait();
		} /* if printing */
	    } /* if a file is missing */
	    /* loop until whole load-list for this entry is checked */
    }	    /* outer loop until all entries are checked */
    return(missing);
} /* vf_os_lists */


prt_os_prob(ent,num,cp) 	   /* dump problems about an OS entry */
struct OSTentry *ent;
int num;
char *cp;
{
    if(num % 4 == 1)
	printf("\n");
    if(num == 1)	/* if first error this entry, print entry name */
    {
	print8(ent->load_list);
	printf("\t   ");
    }
    if(num == 5)
	printf("\t\t   ");
    print8(cp); 	    /* print name of missing file */
    printf("   ");
} /* prt_os_prob */


/*page*/

vf_prods(func)
char func;
{
    struct PTentry *ptp;
    int max_prods;
    int missing = 0;
    int miss_this_prod;
    char *cp;
    int i,j;

    ptp = (struct PTentry *)prodtable.buffer;
    max_prods = pr_entries();
    for(i=0;  i<max_prods;  ++i, ++ptp)
    {
	miss_this_prod = 0;
	cp = ptp->bp2_name;   
	for(j=0;  j<3 ;  ++j, cp +=8)
	    if(find_sd(cp) == NULL)
	    {
		++missing;
		if(func == PRINT)
		{
		    if(missing == 1)
		    {
			printf("\n\nThese Product Table entries refer to non");
			printf("-existent files:\n\n     Product            ");
			printf("Missing File    Needed For\n     -------    ");
			printf("        ------------    ----------");
			check_wait();
		    }
		    prt_prod_prob(ptp,j,++miss_this_prod,cp);
		    check_wait();
		} /* if printing */
	    } /* if an file is missing */
	    /* loop until all 3 files for this entry are checked */
    }	    /* outer loop until all entries are checked */
    return(missing);

} /* vf_prods */

prt_prod_prob(ent,pos,num,cp)	    /* print product table error */
struct PTentry *ent;
int pos, num;
char *cp;    
{
    if(num == 1)
	printf("\n%-2d - %-22.19s",ent->type,product[ent->type]);
    else
	printf("\n\t\t\t   ");
    print8(cp);
    switch(pos)
    {
	default:    printf("\tNo good reason (*BUG*)");
		    break;
	case 0:     printf("\tBoot Loader");
		    break;
	case 1:     printf("\tLogin Program");
		    break;
	case 2:     printf("\tOS Menu Program");
		    break;
    }
} /* prt_prod_prob */

    
vf_orphans()
{
    return(0);
} /* vf_orphans */


 Menu Program");
		    break;
    }
} /* prt_prod_prob */

    
vf_orphans()
{
    return(0);
} /* vf_orphan