	.title	'dms 8/16 character set rom'
	.ident	char816
	.pabs
	.phex
	.loc	0h

ver	==	'1'
rev	==	'1'
mod	==	'H'

; Update history (most recent first):
;
; 1.1.h 02/08/84	lower case p
; 1.1.g 02/08/84	back ' still too high
; 1.1.f 02/07/84	Q and back '
; 1.1.e 02/07/84	fixed that stupid W
; 1.1.d 02/06/84	fixed up some more chars
;			as per Doug's comments MEP
; 1.1.c 12/14/83	modified a few characters
;			for clarity. MChY 
; 1.1.b 09/29/83	added two blank bytes
;			between each character. MChY
; 1.1.a	08/08/83	macro and several chars
;			were developed.	MEP


;
; The following equate and macro definition allow
; a simple method of visually creating a character
; rom set.  The first parameter is for documentation
; purposes only and does not generate any data.
; The second thru ninth parameters should specify
; an X wherever a character pixel should be on
; and a space to turn off the pixel.
; The macro converts the X's to 1's and skipped
; parameters to 0's and constructs the hex code
; for the pattern.

; The IBM PC character set uses a 9 by 14 pixel font.
; The ninth column is either off, or duplicates the
; eighth column, depending on the range of ascii
; values the character is within.

; The following character set definition defines each
; character found on the PC, but not necessarily in
; the same pixel pattern.

x0	==	1
	.define row[aa,a7(0),a6(0),a5(0),a4(0),a3(0),a2(0),a1(0),a0(0)] =
		[
.xlist
		xx = a7'0<7+a6'0<6+a5'0<5+a4'0<4+a3'0<3+a2'0<2+a1'0<1+a0'0
		.list
.byte xx]

.page

; 0	CHARACTER BLANK

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 1	CHARACTER SMILE

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X
	ROW	4,	X, , , , , , ,X
	ROW	5,	X, ,X, , ,X, ,X
	ROW	6,	X, , , , , , ,X
	ROW	7,	X, , , , , , ,X
	ROW	8,	X, ,X, , ,X, ,X
	ROW	9,	X, , ,X,X, , ,X
	ROW	10,	X, , , , , , ,X
	ROW	11,	 ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 2	CHARACTER INVERSE SMILE

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X
	ROW	4,	X,X,X,X,X,X,X,X
	ROW	5,	X,X, ,X,X, ,X,X
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	X,X, ,X,X, ,X,X
	ROW	9,	X,X,X, , ,X,X,X
	ROW	10,	X,X,X,X,X,X,X,X
	ROW	11,	 ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 3

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 ,X,X,X,X,X,X,X
	ROW	6,	 ,X,X,X,X,X,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 , ,X,X,X,X,X
	ROW	10,	 , , ,X,X,X
	ROW	11,	 , , , ,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 4


	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , , ,X
	ROW	5,	 , , ,X,X,X
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 , , ,X,X,X
	ROW	10,	 , , , ,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 5

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X,X,X
	ROW	5,	 , ,X,X,X,X
	ROW	6,	X,X,X, , ,X,X,X
	ROW	7,	X,X,X, , ,X,X,X
	ROW	8,	X,X,X, , ,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 6

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X,X,X
	ROW	5,	 ,X,X,X,X,X,X
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	 ,X,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 7

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , , ,X,X
	ROW	7,	 , ,X,X,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 8

	ROW	1,	X,X,X,X,X,X,X,X
	ROW	2,	X,X,X,X,X,X,X,X
	ROW	3,	X,X,X,X,X,X,X,X
	ROW	4,	X,X,X,X,X,X,X,X
	ROW	5,	X,X,X,X,X,X,X,X
	ROW	6,	X,X,X, , ,X,X,X
	ROW	7,	X,X, , , , ,X,X
	ROW	8,	X,X, , , , ,X,X
	ROW	9,	X,X,X, , ,X,X,X
	ROW	10,	X,X,X,X,X,X,X,X
	ROW	11,	X,X,X,X,X,X,X,X
	ROW	12,	X,X,X,X,X,X,X,X
	ROW	13,	X,X,X,X,X,X,X,X
	ROW	14,	X,X,X,X,X,X,X,X
	ROW	15
	ROW	16

; 9

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , ,X,X,X,X
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X, , , , ,X
	ROW	8,	 ,X, , , , ,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 10

	ROW	1,	X,X,X,X,X,X,X,X
	ROW	2,	X,X,X,X,X,X,X,X
	ROW	3,	X,X,X,X,X,X,X,X
	ROW	4,	X,X,X,X,X,X,X,X
	ROW	5,	X,X, , , , ,X,X
	ROW	6,	X, , ,X,X, , ,X
	ROW	7,	X, ,X,X,X,X, ,X
	ROW	8,	X, ,X,X,X,X, ,X
	ROW	9,	X, , ,X,X, , ,X
	ROW	10,	X,X, , , , ,X,X
	ROW	11,	X,X,X,X,X,X,X,X
	ROW	12,	X,X,X,X,X,X,X,X
	ROW	13,	X,X,X,X,X,X,X,X
	ROW	14,	X,X,X,X,X,X,X,X
	ROW	15
	ROW	16

; 11

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X,X,X
	ROW	4,	 , , , , ,X,X,X
	ROW	5,	 , , , ,X,X, ,X
	ROW	6,	 , , ,X,X, , ,X
	ROW	7,	 , ,X,X,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 12

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X
	ROW	4,	 ,X,X, , ,X,X
	ROW	5,	 ,X,X, , ,X,X
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 , ,X,X,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 ,X,X,X,X,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 13

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X,X
	ROW	5,	 , , ,X,X,X,X
	ROW	6,	 , , ,X, ,X,X
	ROW	7,	 , , ,X, , ,X
	ROW	8,	 , , ,X
	ROW	9,	 ,X,X,X
	ROW	10,	X,X,X,X
	ROW	11,	X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 14

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X,X,X,X,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , ,X,X,X
	ROW	10,	X,X,X, , ,X,X,X
	ROW	11,	X,X,X, , ,X,X
	ROW	12,	X,X
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 15

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	X, , ,X,X, , ,X
	ROW	5,	 ,X, ,X,X, ,X
	ROW	6,	 , ,X,X,X,X
	ROW	7,	X,X,X, , ,X,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 ,X, ,X,X, ,X
	ROW	10,	X, , ,X,X, , ,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 16

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 ,X
	ROW	5,	 ,X,X,X
	ROW	6,	 ,X,X,X,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 ,X,X,X,X,X
	ROW	9,	 ,X,X,X
	ROW	10,	 ,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 17

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , , , , , ,X
	ROW	5,	 , , , , ,X,X,X
	ROW	6,	 , , ,X,X,X,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 , , ,X,X,X,X,X
	ROW	9,	 , , , , ,X,X,X
	ROW	10,	 , , , , , , ,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 18

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X,X,X
	ROW	5,	 ,X,X,X,X,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 ,X,X,X,X,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 19

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , ,X,X
	ROW	4,	 ,X,X, , ,X,X
	ROW	5,	 ,X,X, , ,X,X
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 ,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 20

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	X,X, ,X,X, ,X,X
	ROW	5,	X,X, ,X,X, ,X,X
	ROW	6,	X,X, ,X,X, ,X,X
	ROW	7,	 ,X,X,X,X, ,X,X
	ROW	8,	 , , ,X,X, ,X,X
	ROW	9,	 , , ,X,X, ,X,X
	ROW	10,	 , , ,X,X, ,X,X
	ROW	11,	 , , ,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 21

	ROW	1
	ROW	2,	 , ,X,X,X,X,X
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , , ,X,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , , ,X,X,X
	ROW	11,	 , , , , ,X,X
	ROW	12,	 ,X,X, , , ,X,X
	ROW	13,	 , ,X,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 22

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9,	 ,X,X,X,X,X,X,X
	ROW	10,	 ,X,X,X,X,X,X,X
	ROW	11,	 ,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 23

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X,X,X
	ROW	5,	 ,X,X,X,X,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 ,X,X,X,X,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 ,X,X,X,X,X,X
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 24

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X,X,X
	ROW	5,	 ,X,X,X,X,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 25

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 ,X,X,X,X,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 26

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 , , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 27

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , , ,X,X
	ROW	6,	 , ,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 28

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X
	ROW	7,	 ,X,X
	ROW	8,	 ,X,X
	ROW	9,	 ,X,X,X,X,X,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 29

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , ,X, , ,X
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 , ,X, , ,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 30

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , , ,X
	ROW	5,	 , , ,X,X,X
	ROW	6,	 , , ,X,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 ,X,X,X,X,X,X,X
	ROW	10,	 ,X,X,X,X,X,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 31

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 ,X,X,X,X,X,X,X
	ROW	5,	 ,X,X,X,X,X,X,X
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 , , ,X,X,X
	ROW	9,	 , , ,X,X,X
	ROW	10,	 , , , ,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 32

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 33

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X,X,X
	ROW	5,	 , ,X,X,X,X
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 34

	ROW	1
	ROW	2,	 ,X,X, , , ,X,X
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X, , , , ,X
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 35

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 ,X,X,X,X,X,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	 , ,X,X, ,X,X
	ROW	9,	 ,X,X,X,X,X,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 36

	ROW	1,	 , , , ,X
	ROW	2,	 , , , ,X
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, ,X, ,X,X
	ROW	5,	 ,X,X, ,X, , ,X
	ROW	6,	 ,X,X, ,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 , , , ,X, ,X,X
	ROW	9,	 ,X, , ,X, ,X,X
	ROW	10,	 ,X,X, ,X, ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12,	 , , , ,X
	ROW	13,	 , , , ,X
	ROW	14
	ROW	15
	ROW	16

; 37
	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 ,X,X, , , , ,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X, , , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 38

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , , ,X,X,X
	ROW	7,	 , ,X,X,X, ,X,X
	ROW	8,	 ,X,X, ,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 39

	ROW	1
	ROW	2,	 , ,X,X
	ROW	3,	 , ,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 ,X,X
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 40

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 , ,X,X
	ROW	7,	 , ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 41

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5,	 , , , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , , , , ,X,X
	ROW	9,	 , , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 42

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 ,X,X, , ,X,X
	ROW	6,	 , ,X,X,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 43

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 44

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , ,X,X
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 45

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 46

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 47

	ROW	1
	ROW	2
	ROW	3,	 , , , , , , ,X
	ROW	4,	 , , , , , ,X,X
	ROW	5,	 , , , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 48

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , ,X,X,X
	ROW	7,	 ,X,X, ,X, ,X,X
	ROW	8,	 ,X,X,X, , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 49

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X
	ROW	4,	 , , ,X,X,X
	ROW	5,	 , ,X,X,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 50

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 , , , , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 51

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 , , , , , ,X,X
	ROW	6,	 , , , , , ,X,X
	ROW	7,	 , , ,X,X,X,X
	ROW	8,	 , , , , , ,X,X
	ROW	9,	 , , , , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 52

	ROW	1
	ROW	2
	ROW	3,	 , , , , ,X,X
	ROW	4,	 , , , ,X,X,X
	ROW	5,	 , , ,X,X,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 , , , , ,X,X
	ROW	10,	 , , , , ,X,X
	ROW	11,	 , , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 53

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	 ,X,X
	ROW	5,	 ,X,X
	ROW	6,	 ,X,X
	ROW	7,	 ,X,X,X,X,X,X
	ROW	8,	 , , , , , ,X,X
	ROW	9,	 , , , , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 54

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 ,X,X
	ROW	6,	 ,X,X
	ROW	7,	 ,X,X,X,X,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 55

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 , , , , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 56

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 57

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 , ,X,X,X,X,X,X
	ROW	8,	 , , , , , ,X,X
	ROW	9,	 , , , , , ,X,X
	ROW	10,	 , , , , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 58

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6
	ROW	7
	ROW	8
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

;  59

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6
	ROW	7
	ROW	8
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 60

	ROW	1
	ROW	2
	ROW	3,	 , , , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , ,X,X
	ROW	7,	 ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 61

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X,X,X,X,X
	ROW	7
	ROW	8
	ROW	9,	 ,X,X,X,X,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16
; 62

	ROW	1
	ROW	2
	ROW	3,	 ,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , ,X,X
	ROW	11,	 ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 63

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 64

;	ROW	1
;	ROW	2
;	ROW	3,	 , ,X,X,X,X,X
;	ROW	4,	 ,X,X, , , ,X,X
;	ROW	5,	 ,X, , , , , ,X
;	ROW	6,	 ,X, , ,X,X, ,X
;	ROW	7,	 ,X, ,X, , ,X,X
;	ROW	8,	 ,X, ,X, , ,X,X
;	ROW	9,	 ,X, , ,X,X,X,X
;	ROW	10,	 ,X,X
;	ROW	11,	 , ,X,X,X,X,X
;	ROW	12
;	ROW	13
;	ROW	14
;	ROW	15
;	ROW	16
;				@
	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X, , ,X, , ,X
	ROW	6,	 ,X, ,X, ,X, ,X
	ROW	7,	 ,X, ,X, ,X, ,X
	ROW	8,	 ,X, ,X,X,X,X,X
	ROW	9,	 ,X, , , , , ,
	ROW	10,	 ,X,X, , , , ,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 65

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X
	ROW	4,	 , , ,X,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X, , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 66

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 , ,X,X, , ,X,X
	ROW	6,	 , ,X,X, , ,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16
; 67

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 ,X,X, , , , ,X
	ROW	6,	 ,X,X
	ROW	7,	 ,X,X
	ROW	8,	 ,X,X
	ROW	9,	 ,X,X, , , , ,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 68

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 , ,X,X, , ,X,X
	ROW	6,	 , ,X,X, , ,X,X
	ROW	7,	 , ,X,X, , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 69

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 , ,X,X, , , ,X
	ROW	6,	 , ,X,X, ,X
	ROW	7,	 , ,X,X,X,X
	ROW	8,	 , ,X,X, ,X
	ROW	9,	 , ,X,X, , , ,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 70

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 , ,X,X, , , ,X
	ROW	6,	 , ,X,X, ,X
	ROW	7,	 , ,X,X,X,X
	ROW	8,	 , ,X,X, ,X
	ROW	9,	 , ,X,X
	ROW	10,	 , ,X,X
	ROW	11,	 ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 71

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 ,X,X, , , , ,X
	ROW	6,	 ,X,X
	ROW	7,	 ,X,X
	ROW	8,	 ,X,X, ,X,X,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 , , ,X,X,X, ,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 72

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X, , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 73

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X,X
	ROW	4,	 , , , ,X,X
	ROW	5,	 , , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 74

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X,X,X
	ROW	4,	 , , , , ,X,X
	ROW	5,	 , , , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , , , , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 75

;	ROW	1
;	ROW	2
;	ROW	3,	 ,X,X,X, , ,X,X
;	ROW	4,	 , ,X,X, , ,X,X
;	ROW	5,	 , ,X,X, ,X,X
;	ROW	6,	 , ,X,X, ,X,X
;	ROW	7,	 , ,X,X,X,X
;	ROW	8,	 , ,X,X, ,X,X
;	ROW	9,	 , ,X,X, ,X,X
;	ROW	10,	 , ,X,X, , ,X,X
;	ROW	11,	 ,X,X,X, , ,X,X
;	ROW	12
;	ROW	13
;	ROW	14
;	ROW	15
;	ROW	16

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X, , ,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , ,X,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 76

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 , ,X,X
	ROW	7,	 , ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 , ,X,X, , , , ,X
	ROW	10,	 , ,X,X, , , ,X,X
	ROW	11,	 ,X,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 77

	ROW	1
	ROW	2
	ROW	3,	X,X, , , , ,X,X
	ROW	4,	X,X,X, , ,X,X,X
	ROW	5,	X,X,X,X,X,X,X,X
	ROW	6,	X,X, ,X,X, ,X,X
	ROW	7,	X,X, , , , ,X,X
	ROW	8,	X,X, , , , ,X,X
	ROW	9,	X,X, , , , ,X,X
	ROW	10,	X,X, , , , ,X,X
	ROW	11,	X,X, , , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 78

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 ,X,X,X, , ,X,X
	ROW	5,	 ,X,X,X,X, ,X,X
	ROW	6,	 ,X,X,X,X,X,X,X
	ROW	7,	 ,X,X, ,X,X,X,X
	ROW	8,	 ,X,X, , ,X,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X, , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 79

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , , ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 80

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 , ,X,X, , ,X,X
	ROW	6,	 , ,X,X, , ,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 , ,X,X
	ROW	11,	 ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 81
;	ROW	3,	 , ,X,X,X,X,X
;	ROW	4,	 ,X,X, , , ,X,X
;	ROW	5,	 ,X,X, , , ,X,X
;	ROW	6,	 ,X,X, , , ,X,X
;	ROW	7,	 ,X,X, , , ,X,X
;	ROW	8,	 ,X,X, ,X, ,X,X
;	ROW	9,	 ,X,X, ,X,X,X,X
;	ROW	10,	 , ,X,X,X,X,X
;	ROW	11,	 , , , , ,X,X
;	ROW	12,	 , , , , ,X,X,X

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, ,X, ,X,X
	ROW	10,	 , ,X, ,X,X,X
	ROW	11,	 , , ,X,X,X
	ROW	12,	 , , , , ,X,X
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 82

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 , ,X,X, , ,X,X
	ROW	6,	 , ,X,X, , ,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 , ,X,X, ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 83

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 , ,X,X
	ROW	7,	 , , ,X,X,X
	ROW	8,	 , , , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 84

	ROW	1
	ROW	2
	ROW	3,	X,X,X,X,X,X,X,X
	ROW	4,	X,X, ,X,X, ,X,X
	ROW	5,	X, , ,X,X, , ,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 85

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16
; 86

	ROW	1
	ROW	2
	ROW	3,	X,X, , , , ,X,X
	ROW	4,	X,X, , , , ,X,X
	ROW	5,	X,X, , , , ,X,X
	ROW	6,	X,X, , , , ,X,X
	ROW	7,	X,X, , , , ,X,X
	ROW	8,	X,X, , , , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 87

;	ROW	1
;	ROW	2
;	ROW	3,	X,X, , , , ,X,X
;	ROW	4,	X,X, , , , ,X,X
;	ROW	5,	X,X, , , , ,X,X
;	ROW	6,	X,X, , , , ,X,X
;	ROW	7,	X,X, ,X,X, ,X,X
;	ROW	8,	X,X, ,X,X, ,X,X
;	ROW	9,	X,X,X,X,X,X,X,X
;	ROW	10,	 ,X,X, , ,X,X
;	ROW	11,	 ,X,X, , ,X,X
;	ROW	12
;	ROW	13
;	ROW	14
;	ROW	15
;	ROW	16

	ROW	1
	ROW	2
	ROW	3,	X,X, , , , ,X,X
	ROW	4,	X,X, , , , ,X,X
	ROW	5,	X,X, , , , ,X,X
	ROW	6,	X,X, , , , ,X,X
	ROW	7,	X,X, ,X,X, ,X,X
	ROW	8,	X,X, ,X,X, ,X,X
	ROW	9,	X,X,X,X,X,X,X,X
	ROW	10,	X,X,X, , ,X,X,X
	ROW	11,	 ,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 88

	ROW	1
	ROW	2
	ROW	3,	X,X, , , , ,X,X
	ROW	4,	X,X, , , , ,X,X
	ROW	5,	 ,X,X, , ,X,X
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	X,X, , , , ,X,X
	ROW	11,	X,X, , , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 89

	ROW	1
	ROW	2
	ROW	3,	X,X, , , , ,X,X
	ROW	4,	X,X, , , , ,X,X
	ROW	5,	X,X, , , , ,X,X
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 , ,X,X,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 90

	ROW	1
	ROW	2
	ROW	3,	X,X,X,X,X,X,X,X
	ROW	4,	X,X, , , , ,X,X
	ROW	5,	X, , , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 ,X,X, , , , ,X
	ROW	10,	X,X, , , , ,X,X
	ROW	11,	X,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 91

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 , ,X,X
	ROW	7,	 , ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 92

	ROW	1
	ROW	2
	ROW	3,	 ,X
	ROW	4,	 ,X,X
	ROW	5,	 ,X,X,X
	ROW	6,	 , ,X,X,X
	ROW	7,	 , , ,X,X,X
	ROW	8,	 , , , ,X,X,X
	ROW	9,	 , , , , ,X,X,X
	ROW	10,	 , , , , , ,X,X
	ROW	11,	 , , , , , , ,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 93

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X,X,X
	ROW	4,	 , , , ,X,X
	ROW	5,	 , , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 94

	ROW	1,	 , , , ,X
	ROW	2,	 , , ,X,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 95

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13,	X,X,X,X,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 96 	back '

	ROW	1
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , , ,X,X
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 97

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 98

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 , ,X,X, , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X, ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 99

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 100

	ROW	1
	ROW	2
	ROW	3,	 , , , , ,X,X,X
	ROW	4,	 , , , , ,X,X
	ROW	5,	 , , , , ,X,X
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 101

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 102

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, , ,X
	ROW	6,	 , ,X,X
	ROW	7,	 ,X,X,X,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 , ,X,X
	ROW	11,	 ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 103

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 , ,X,X,X,X,X
	ROW	11,	 , , , , ,X,X
	ROW	12,	 ,X,X, , ,X,X
	ROW	13,	 , ,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 104

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X,X, ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 105

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5
	ROW	6,	 , , ,X,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 106

	ROW	1
	ROW	2
	ROW	3,	 , , , , ,X,X
	ROW	4,	 , , , , ,X,X
	ROW	5
	ROW	6,	 , , , ,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , , , , ,X,X
	ROW	9,	 , , , , ,X,X
	ROW	10,	 , , , , ,X,X
	ROW	11,	 ,X,X, , ,X,X
	ROW	12,	 ,X,X, , ,X,X
	ROW	13,	 , ,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 107

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 , ,X,X, , ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 108

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , , , ,X,X
	ROW	5,	 , , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 109

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X,X, , ,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	X,X, ,X,X, ,X,X
	ROW	9,	X,X, ,X,X, ,X,X
	ROW	10,	X,X, ,X,X, ,X,X
	ROW	11,	X,X, ,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 110

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X, ,X,X,X
	ROW	7,	 , ,X,X, , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 , ,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 111

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 112

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X,X,X,X,X
	ROW	7,	 , ,X,X, , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X,X,X,X
	ROW	11,	 , ,X,X
	ROW	12,	 , ,X,X
	ROW	13,	 ,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 113

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 , ,X,X,X,X,X
	ROW	11,	 , , , , ,X,X
	ROW	12,	 , , , , ,X,X
	ROW	13,	 , , , , ,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 114

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X, ,X,X,X
	ROW	7,	 , ,X,X, , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 , ,X,X
	ROW	11,	 ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 115

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 , ,X,X,X
	ROW	9,	 , , , ,X,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 116

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 ,X,X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X, , ,X
	ROW	11,	 , , , ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 117

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 118

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X, , , , ,X,X
	ROW	7,	X,X, , , , ,X,X
	ROW	8,	X,X, , , , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 119

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X, , , , ,X,X
	ROW	7,	X,X, , , , ,X,X
	ROW	8,	X,X, ,X,X, ,X,X
	ROW	9,	X,X, ,X,X, ,X,X
	ROW	10,	X,X,X,X,X,X,X,X
	ROW	11,	 ,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 120

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	 , , ,X,X,X
	ROW	9,	 , , ,X,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 ,X,X, , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 121

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 , ,X,X,X,X,X,X
	ROW	11,	 , , , , , ,X,X
	ROW	12,	 , , , , ,X,X
	ROW	13,	 , ,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 122

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X,X,X,X,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 ,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 123

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 ,X,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , , ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 124

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 125

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , , ,X,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 126
;	ROW	5,	 , , , , ,X,X
;	ROW	6,	X, , , ,X, , ,X
;	ROW	7,	X, , ,X, , , ,X
;	ROW	8,	 ,X,X

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , , , ,X,X,X
	ROW	6,	X,X, ,X,X, ,X,X
	ROW	7,	X,X, ,X,X, ,X,X
	ROW	8,	 ,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 127

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , , , ,X
	ROW	6,	 , , ,X,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X,X,X,X,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 128

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5,	 ,X,X, , , , ,X
	ROW	6,	 ,X,X
	ROW	7,	 ,X,X
	ROW	8,	 ,X,X, , , , ,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , , ,X,X,X,X
	ROW	11,	 , , , ,X
	ROW	12,	 , , , , ,X
	ROW	13,	 , , ,X,X
	ROW	14
	ROW	15
	ROW	16

; 129

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , ,X,X
	ROW	4,	 ,X,X, , ,X,X
	ROW	5
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 130

	ROW	1
	ROW	2,	 , , , , ,X,X
	ROW	3,	 , , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 131

	ROW	1
	ROW	2,	 , , , ,X
	ROW	3,	 , , ,X, ,X
	ROW	4,	 , ,X, , , ,X
	ROW	5
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 132

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , ,X,X
	ROW	4,	 ,X,X, , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 133

	ROW	1
	ROW	2,	 , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 134

	ROW	1
	ROW	2,	 , , ,X,X
	ROW	3,	 , ,X, , ,X
	ROW	4,	 , , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 135

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 , ,X,X,X,X,X
	ROW	11,	 , , , ,X
	ROW	12,	 , , , , ,X
	ROW	13,	 , , ,X,X
	ROW	14
	ROW	15
	ROW	16

; 136

	ROW	1
	ROW	2,	 , , , ,X
	ROW	3,	 , , ,X, ,X
	ROW	4,	 , ,X, , , ,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 137

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X, , ,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 138

	ROW	1
	ROW	2,	 , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 139

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X, , ,X,X
	ROW	4,	 , ,X,X, , ,X,X
	ROW	5
	ROW	6,	 , , ,X,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 140

	ROW	1
	ROW	2,	 , , , ,X
	ROW	3,	 , , ,X, ,X
	ROW	4,	 , ,X, , , ,X
	ROW	5
	ROW	6,	 , , ,X,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 141

	ROW	1
	ROW	2,	 , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5
	ROW	6,	 , , ,X,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 142

	ROW	1
	ROW	2,	 ,X,X, , , ,X,X
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 , , , ,X
	ROW	5,	 , , ,X,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X,X,X,X,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X, , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 143

	ROW	1,	 , , ,X,X,X
	ROW	2,	 , ,X, , , ,X
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , , , ,X
	ROW	5,	 , , ,X,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X,X,X,X,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X, , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 144

	ROW	1,	 , , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , ,X,X
	ROW	4
	ROW	5,	 ,X,X,X,X,X,X,X
	ROW	6,	 , ,X,X, , , ,X
	ROW	7,	 , ,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 , ,X,X, , , ,X
	ROW	11,	 ,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 145

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X,X, , ,X,X
	ROW	7,	 , , ,X,X, , ,X
	ROW	8,	 ,X,X,X,X,X,X,X
	ROW	9,	X, , ,X,X
	ROW	10,	X, , ,X,X, , ,X
	ROW	11,	 ,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 146

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X,X,X
	ROW	4,	 , ,X,X,X, , ,X
	ROW	5,	 ,X, ,X,X
	ROW	6,	X, , ,X,X
	ROW	7,	X,X,X,X,X,X,X
	ROW	8,	X, , ,X,X
	ROW	9,	X, , ,X,X
	ROW	10,	X, , ,X,X, , ,X
	ROW	11,	X, , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 147

	ROW	1
	ROW	2,	 , , , ,X
	ROW	3,	 , , ,X, ,X
	ROW	4,	 , ,X, , , ,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 148

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 149

	ROW	1
	ROW	2,	 , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 150

	ROW	1
	ROW	2,	 , , , ,X
	ROW	3,	 , , ,X, ,X
	ROW	4,	 , ,X, , , ,X
	ROW	5
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 151

	ROW	1
	ROW	2,	 , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 152

	ROW	1
	ROW	2
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 , ,X,X,X,X,X,X
	ROW	11,	 , , , , , ,X,X
	ROW	12,	 , , , , ,X,X
	ROW	13,	 , ,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

; 153

	ROW	1
	ROW	2,	 ,X,X, , , ,X,X
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4,	 , , ,X,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , , ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 154

	ROW	1
	ROW	2,	 ,X,X, , , ,X,X
	ROW	3,	 ,X,X, , , ,X,X
	ROW	4
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 155

	ROW	1
	ROW	2,	 , , , ,X
	ROW	3,	 , , , ,X
	ROW	4,	 , ,X,X,X,X,X
	ROW	5,	 ,X, , ,X, , ,X
	ROW	6,	 ,X, , ,X
	ROW	7,	 ,X, , ,X
	ROW	8,	 ,X, , ,X, , ,X
	ROW	9,	 , ,X,X,X,X,X
	ROW	10,	 , , , ,X
	ROW	11,	 , , , ,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 156

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X
	ROW	4,	 , , ,X, , ,X
	ROW	5,	 , , ,X
	ROW	6,	 , ,X,X,X
	ROW	7,	 , , ,X
	ROW	8,	 , , , ,X
	ROW	9,	 , ,X, ,X,
	ROW	10,	 ,X, ,X, , , ,X
	ROW	11,	 , ,X, ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 157

	ROW	1
	ROW	2
	ROW	3,	X,X, , , , ,X,X
	ROW	4,	 ,X,X, , ,X,X
	ROW	5,	 , ,X,X,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	X,X,X,X,X,X,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 158

	ROW	1
	ROW	2,	X,X,X,X,X,X
	ROW	3,	 ,X,X, , ,X,X
	ROW	4,	 ,X,X, , ,X,X
	ROW	5,	 ,X,X,X,X,X
	ROW	6,	 ,X,X, , , ,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, ,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	X,X,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

;159

	ROW	1
	ROW	2,	 , , , ,X,X,X
	ROW	3,	 , , ,X,X, , ,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 ,X,X,X,X,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	X, , ,X,X
	ROW	13,	 ,X,X,X
	ROW	14
	ROW	15
	ROW	16

;160

	ROW	1
	ROW	2,	 , , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 161

	ROW	1
	ROW	2,	 , , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 162

	ROW	1
	ROW	2,	 , , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X
	ROW	5
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 163

	ROW	1
	ROW	2,	 , , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , ,X,X
	ROW	5
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 164

	ROW	1
	ROW	2,	 ,X, , , ,X,X
	ROW	3,	 ,X, , ,X, , ,X
	ROW	4,	 , ,X,X, , , ,X
	ROW	5
	ROW	6,	 ,X,X, ,X,X,X
	ROW	7,	 , ,X,X, , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X, , ,X,X
	ROW	11,	 , ,X,X, , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 165

	ROW	1,	 , ,X,X, , , ,X
	ROW	2,	 ,X, , ,X,X,X
	ROW	3
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X,X, , ,X,X
	ROW	6,	 ,X,X,X,X, ,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 ,X,X, ,X,X,X,X
	ROW	9,	 ,X,X, , ,X,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X, , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 166

	ROW	1
	ROW	2,	 , ,X,X,X
	ROW	3,	 ,X, , ,X
	ROW	4,	 ,X, , ,X
	ROW	5,	 , ,X,X,X,X
	ROW	6
	ROW	7,	 ,X,X,X,X,X
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 167

	ROW	1
	ROW	2,	 , ,X,X,X
	ROW	3,	 ,X, , , ,X
	ROW	4,	 ,X, , , ,X
	ROW	5,	 , ,X,X,X
	ROW	6
	ROW	7,	 ,X,X,X,X,X
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

;168

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 , ,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 169

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 ,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 170

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 , , , , , ,X,X
	ROW	9,	 , , , , , ,X,X
	ROW	10,	 , , , , , ,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 171

	ROW	1
	ROW	2,	 ,X,X
	ROW	3,	X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , ,X,X
	ROW	6,	 ,X,X, ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , ,X,X
	ROW	9,	 ,X,X, ,X,X,X
	ROW	10,	X,X, , , , ,X,X
	ROW	11,	 , , , , ,X,X
	ROW	12,	 , , , ,X,X
	ROW	13,	 , , ,X,X,X,X,X
	ROW	14
	ROW	15
	ROW	16

;172

	ROW	1
	ROW	2,	 ,X,X
	ROW	3,	X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , ,X,X
	ROW	6,	 ,X,X, ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X,X
	ROW	10,	X,X, , ,X,X, ,X
	ROW	11,	 , , ,X,X,X,X,X
	ROW	12,	 , , , , , ,X,X
	ROW	13,	 , , , , , ,X,X
	ROW	14
	ROW	15
	ROW	16

; 173

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , ,X,X,X,X
	ROW	9,	 , ,X,X,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 174

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 ,X,X, ,X,X
	ROW	8,	 , ,X,X, ,X,X
	ROW	9,	 , , ,X,X, ,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 175

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , , ,X,X, ,X,X
	ROW	8,	 , ,X,X, ,X,X
	ROW	9,	 ,X,X, ,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 176

	ROW	1,	 , , ,X, , , ,X
	ROW	2,	 ,X, , , ,X
	ROW	3,	 , , ,X, , , ,X
	ROW	4,	 ,X, , , ,X
	ROW	5,	 , , ,X, , , ,X
	ROW	6,	 ,X, , , ,X
	ROW	7,	 , , ,X, , , ,X
	ROW	8,	 ,X, , , ,X
	ROW	9,	 , , ,X, , , ,X
	ROW	10,	 ,X, , , ,X
	ROW	11,	 , , ,X, , , ,X
	ROW	12,	 ,X, , , ,X
	ROW	13,	 , , ,X, , , ,X
	ROW	14,	 ,X, , , ,X
	ROW	15
	ROW	16

; 177

	ROW	1,	 ,X, ,X, ,X, ,X
	ROW	2,	X, ,X, ,X, ,X
	ROW	3,	 ,X, ,X, ,X, ,X
	ROW	4,	X, ,X, ,X, ,X
	ROW	5,	 ,X, ,X, ,X, ,X
	ROW	6,	X, ,X, ,X, ,X
	ROW	7,	 ,X, ,X, ,X, ,X
	ROW	8,	X, ,X, ,X, ,X
	ROW	9,	 ,X, ,X, ,X, ,X
	ROW	10,	X, ,X, ,X, ,X
	ROW	11,	 ,X, ,X, ,X, ,X
	ROW	12,	X, ,X, ,X, ,X
	ROW	13,	 ,X, ,X, ,X, ,X
	ROW	14,	X, ,X, ,X, ,X
	ROW	15
	ROW	16

; 178

	ROW	1,	X,X, ,X,X,X, ,X
	ROW	2,	 ,X,X,X, ,X,X,X
	ROW	3,	X,X, ,X,X,X, ,X
	ROW	4,	 ,X,X,X, ,X,X,X
	ROW	5,	X,X, ,X,X,X, ,X
	ROW	6,	 ,X,X,X, ,X,X,X
	ROW	7,	X,X, ,X,X,X, ,X
	ROW	8,	 ,X,X,X, ,X,X,X
	ROW	9,	X,X, ,X,X,X, ,X
	ROW	10,	 ,X,X,X, ,X,X,X
	ROW	11,	X,X, ,X,X,X, ,X
	ROW	12,	 ,X,X,X, ,X,X,X
	ROW	13,	X,X, ,X,X,X, ,X
	ROW	14,	 ,X,X,X, ,X,X,X
	ROW	15
	ROW	16

; 179

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 180

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

;181

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 182

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	X,X,X,X, ,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 183

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	X,X,X,X,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 184

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 185

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	X,X,X,X, ,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	X,X,X,X, ,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 186

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	 , ,X,X, ,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 187

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X,X,X,X,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	X,X,X,X, ,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 188

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	X,X,X,X, ,X,X
	ROW	7,	 , , , , ,X,X
	ROW	8,	X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 189

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 190

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 191

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 192

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 193

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 194

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 195

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 196

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 197

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 198

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 199

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	 , ,X,X, ,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 200

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X,X
	ROW	7,	 , ,X,X
	ROW	8,	 , ,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 201

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X,X
	ROW	7,	 , ,X,X
	ROW	8,	 , ,X,X, ,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 202

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	X,X,X,X, ,X,X,X
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 203

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7
	ROW	8,	X,X,X,X, ,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 204

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X,X
	ROW	7,	 , ,X,X
	ROW	8,	 , ,X,X, ,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 205

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 206

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	X,X,X,X, ,X,X,X
	ROW	7
	ROW	8,	X,X,X,X, ,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 207

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 208

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 209

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 210

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 211

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	 , ,X,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 212

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 213

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , , ,X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 214

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	 , ,X,X,X,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 215

	ROW	1,	 , ,X,X, ,X,X
	ROW	2,	 , ,X,X, ,X,X
	ROW	3,	 , ,X,X, ,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 , ,X,X, ,X,X
	ROW	6,	 , ,X,X, ,X,X
	ROW	7,	 , ,X,X, ,X,X
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	 , ,X,X, ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , ,X,X, ,X,X
	ROW	12,	 , ,X,X, ,X,X
	ROW	13,	 , ,X,X, ,X,X
	ROW	14,	 , ,X,X, ,X,X
	ROW	15
	ROW	16

; 216

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 217

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	X,X,X,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 218

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	 , , ,X,X,X,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 219

	ROW	1,	X,X,X,X,X,X,X,X
	ROW	2,	X,X,X,X,X,X,X,X
	ROW	3,	X,X,X,X,X,X,X,X
	ROW	4,	X,X,X,X,X,X,X,X
	ROW	5,	X,X,X,X,X,X,X,X
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	X,X,X,X,X,X,X,X
	ROW	10,	X,X,X,X,X,X,X,X
	ROW	11,	X,X,X,X,X,X,X,X
	ROW	12,	X,X,X,X,X,X,X,X
	ROW	13,	X,X,X,X,X,X,X,X
	ROW	14,	X,X,X,X,X,X,X,X
	ROW	15
	ROW	16

; 220

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	X,X,X,X,X,X,X,X
	ROW	9,	X,X,X,X,X,X,X,X
	ROW	10,	X,X,X,X,X,X,X,X
	ROW	11,	X,X,X,X,X,X,X,X
	ROW	12,	X,X,X,X,X,X,X,X
	ROW	13,	X,X,X,X,X,X,X,X
	ROW	14,	X,X,X,X,X,X,X,X
	ROW	15
	ROW	16

; 221

	ROW	1,	X,X,X,X
	ROW	2,	X,X,X,X
	ROW	3,	X,X,X,X
	ROW	4,	X,X,X,X
	ROW	5,	X,X,X,X
	ROW	6,	X,X,X,X
	ROW	7,	X,X,X,X
	ROW	8,	X,X,X,X
	ROW	9,	X,X,X,X
	ROW	10,	X,X,X,X
	ROW	11,	X,X,X,X
	ROW	12,	X,X,X,X
	ROW	13,	X,X,X,X
	ROW	14,	X,X,X,X
	ROW	15
	ROW	16

; 222

	ROW	1,	 , , , ,X,X,X,X
	ROW	2,	 , , , ,X,X,X,X
	ROW	3,	 , , , ,X,X,X,X
	ROW	4,	 , , , ,X,X,X,X
	ROW	5,	 , , , ,X,X,X,X
	ROW	6,	 , , , ,X,X,X,X
	ROW	7,	 , , , ,X,X,X,X
	ROW	8,	 , , , ,X,X,X,X
	ROW	9,	 , , , ,X,X,X,X
	ROW	10,	 , , , ,X,X,X,X
	ROW	11,	 , , , ,X,X,X,X
	ROW	12,	 , , , ,X,X,X,X
	ROW	13,	 , , , ,X,X,X,X
	ROW	14,	 , , , ,X,X,X,X
	ROW	15
	ROW	16

; 223

	ROW	1,	X,X,X,X,X,X,X,X
	ROW	2,	X,X,X,X,X,X,X,X
	ROW	3,	X,X,X,X,X,X,X,X
	ROW	4,	X,X,X,X,X,X,X,X
	ROW	5,	X,X,X,X,X,X,X,X
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 224

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X, ,X,X
	ROW	7,	 ,X,X, ,X,X,X
	ROW	8,	 ,X,X, ,X,X
	ROW	9,	 ,X,X, ,X,X
	ROW	10,	 ,X,X, ,X,X,X
	ROW	11,	 , ,X,X,X, ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 225

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , ,X,X,X,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X,X,X,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 ,X,X,X,X,X,X
	ROW	11,	 ,X,X
	ROW	12,	X,X
	ROW	13,	X
	ROW	14
	ROW	15
	ROW	16

; 226

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X
	ROW	7,	 ,X,X
	ROW	8,	 ,X,X
	ROW	9,	 ,X,X
	ROW	10,	 ,X,X
	ROW	11,	 ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 227

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , , , ,X,X,X
	ROW	6,	X, , ,X, ,X, ,X
	ROW	7,	 ,X,X, , ,X
	ROW	8,	 , ,X, , ,X
	ROW	9,	 , ,X, , ,X
	ROW	10,	 , ,X, , ,X
	ROW	11,	 , ,X, , ,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 228

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X,X
	ROW	4,	 ,X,X, , , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , ,X,X
	ROW	10,	 ,X,X, , , ,X,X
	ROW	11,	 ,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 229

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X,X,X,X
	ROW	7,	 ,X,X, ,X,X
	ROW	8,	 ,X,X, ,X,X
	ROW	9,	 ,X,X, ,X,X
	ROW	10,	 ,X,X, ,X,X
	ROW	11,	 , ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 230

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X, , ,X,X
	ROW	7,	 , ,X,X, , ,X,X
	ROW	8,	 , ,X,X, , ,X,X
	ROW	9,	 , ,X,X, , ,X,X
	ROW	10,	 , ,X,X,X,X,X
	ROW	11,	 , ,X,X
	ROW	12,	 , ,X,X
	ROW	13,	 ,X,X
	ROW	14
	ROW	15
	ROW	16

; 231

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 , ,X,X,X, ,X,X
	ROW	7,	 ,X,X, ,X,X,X
	ROW	8,	 , , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10,	 , , , ,X,X
	ROW	11,	 , , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 232

	ROW	1
	ROW	2
	ROW	3,	 ,X,X,X,X,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , ,X,X,X,X
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	 ,X,X, , ,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 , ,X,X,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 233

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 ,X,X, , , ,X,X
	ROW	9,	 ,X,X, , , ,X,X
	ROW	10,	 , ,X,X, ,X,X
	ROW	11,	 , , ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 234

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X
	ROW	4,	 , ,X,X, ,X,X
	ROW	5,	 ,X,X, , , ,X,X
	ROW	6,	 ,X,X, , , ,X,X
	ROW	7,	 ,X,X, , , ,X,X
	ROW	8,	 , ,X,X, ,X,X
	ROW	9,	 , , ,X, ,X
	ROW	10,	 ,X, ,X, ,X, ,X
	ROW	11,	 ,X,X,X, ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 235

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 ,X,X, , ,X,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10,	 ,X,X, , ,X,X
	ROW	11,	 , ,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 236

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6,	 ,X,X, , ,X,X
	ROW	7,	X, , ,X,X, , ,X
	ROW	8,	X, , ,X,X, , ,X
	ROW	9,	 ,X,X, , ,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 237

	ROW	1
	ROW	2
	ROW	3,	 , , , , , ,X,X
	ROW	4,	 , , , , ,X,X
	ROW	5,	 ,X,X,X,X,X,X
	ROW	6,	X,X, ,X,X, ,X,X
	ROW	7,	X,X, ,X,X, ,X,X
	ROW	8,	X,X,X,X, , ,X,X
	ROW	9,	 ,X,X,X,X,X,X
	ROW	10,	 ,X,X
	ROW	11,	X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 238

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , ,X,X,X,X,X
	ROW	5,	 , ,X
	ROW	6,	 ,X
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8,	 ,X
	ROW	9,	 , ,X
	ROW	10,	 , , ,X,X,X,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 239

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 , , ,X,X,X
	ROW	5,	 , ,X, , , ,X
	ROW	6,	 ,X, , , , , ,X
	ROW	7,	 ,X, , , , , ,X
	ROW	8,	 ,X, , , , , ,X
	ROW	9,	 ,X, , , , , ,X
	ROW	10,	 ,X, , , , , ,X
	ROW	11,	 ,X, , , , , ,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 240

	ROW	1
	ROW	2
	ROW	3
	ROW	4,	 ,X,X,X,X,X,X,X
	ROW	5
	ROW	6
	ROW	7,	 ,X,X,X,X,X,X,X
	ROW	8
	ROW	9
	ROW	10,	 ,X,X,X,X,X,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 241

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	X,X,X,X,X,X,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10
	ROW	11,	X,X,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 242

	ROW	1
	ROW	2
	ROW	3,	 , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , , ,X,X
	ROW	6,	 , , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , ,X,X
	ROW	10
	ROW	11,	 ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 243

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , ,X,X
	ROW	6,	 ,X,X
	ROW	7,	 , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , , ,X,X
	ROW	10
	ROW	11,	 ,X,X,X,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 244

	ROW	1
	ROW	2
	ROW	3,	 , , , ,X,X,X
	ROW	4,	 , , ,X,X, ,X,X
	ROW	5,	 , , ,X,X, ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	 , , ,X,X
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12,	 , , ,X,X
	ROW	13,	 , , ,X,X
	ROW	14,	 , , ,X,X
	ROW	15
	ROW	16

; 245

	ROW	1,	 , , ,X,X
	ROW	2,	 , , ,X,X
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5,	 , , ,X,X
	ROW	6,	 , , ,X,X
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9,	X,X, ,X,X
	ROW	10,	X,X, ,X,X
	ROW	11,	 ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 246

	ROW	1
	ROW	2
	ROW	3,	 , , ,X,X
	ROW	4,	 , , ,X,X
	ROW	5
	ROW	6
	ROW	7,	X,X,X,X,X,X,X,X
	ROW	8
	ROW	9
	ROW	10,	 , , ,X,X
	ROW	11,	 , , ,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 247

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , ,X,X,X, ,X,X
	ROW	6,	 ,X,X, ,X,X,X
	ROW	7
	ROW	8,	 , ,X,X,X, ,X,X
	ROW	9,	 ,X,X, ,X,X,X
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 248

	ROW	1
	ROW	2,	 , ,X,X,X
	ROW	3,	 ,X,X, ,X,X
	ROW	4,	 ,X,X, ,X,X
	ROW	5,	 , ,X,X,X
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 249

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7,	 , , ,X,X
	ROW	8,	 , , ,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 250

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8,	 , , ,X,X
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 251

	ROW	1
	ROW	2,	 , , , ,X,X,X,X
	ROW	3,	 , , , ,X,X
	ROW	4,	 , , , ,X,X
	ROW	5,	 , , , ,X,X
	ROW	6,	 , , , ,X,X
	ROW	7,	 , , , ,X,X
	ROW	8,	X,X,X, ,X,X
	ROW	9,	 ,X,X, ,X,X
	ROW	10,	 , ,X,X,X,X
	ROW	11,	 , , ,X,X,X
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 252

	ROW	1
	ROW	2,	X,X, ,X,X
	ROW	3,	 ,X,X, ,X,X
	ROW	4,	 ,X,X, ,X,X
	ROW	5,	 ,X,X, ,X,X
	ROW	6,	 ,X,X, ,X,X
	ROW	7,	 ,X,X, ,X,X
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 253

	ROW	1
	ROW	2,	 ,X,X,X
	ROW	3,	X,X, ,X,X
	ROW	4,	 , ,X,X
	ROW	5,	 ,X,X
	ROW	6,	X,X, , ,X
	ROW	7,	X,X,X,X,X
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 254

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5,	 , ,X,X,X,X,X
	ROW	6,	 , ,X,X,X,X,X
	ROW	7,	 , ,X,X,X,X,X
	ROW	8,	 , ,X,X,X,X,X
	ROW	9,	 , ,X,X,X,X,X
	ROW	10,	 , ,X,X,X,X,X
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

; 255

	ROW	1
	ROW	2
	ROW	3
	ROW	4
	ROW	5
	ROW	6
	ROW	7
	ROW	8
	ROW	9
	ROW	10
	ROW	11
	ROW	12
	ROW	13
	ROW	14
	ROW	15
	ROW	16

	.ascii	'DMS-816 character set -- version '
	.byte	ver
	.byte	rev
	.byte	mod
.end
