
/*======================================================================*/
/* ZDIRNET.C - additional routines needed for the Z80 version of DIRNET */
/*======================================================================*/
/* 			Change History 					*/
/*----------------------------------------------------------------------*/
/*  2/29/84 - Written using parts of XFER.C			  - jjc */
/*======================================================================*/

#include "c:which.cpm" /* this module is cpm80 only! */
#include "c:switch.os"
#include "cpmstruct.def"

#define READ	0
#define WRITE	1

#define NORMwrite	0

#define	DATtrack	0x0
#define	DATsector	0x78
#define DATlength	8

/*page*/
/*======================================================================*/
/* GetDirNet - read the alloc table from partition zero.		*/
/*======================================================================*/
GetDirNet (vol, dir)
int	vol;
CHAR	*dir;

{
	P0_xfer (READ, vol, DATtrack, DATsector, dir, DATlength);
	return 0;
}

/*page*/
/*======================================================================*/
/* P0_xfer - Reads partition zero, code copied from bios_xfer		*/
/*======================================================================*/
P0_xfer( way, vol, track, sector, dma, count )
int	vol, way, track, sector, dma, count;

{
	struct DPH	*dph;
	struct DPB	*dpb;

	register CHAR save_disk;
	register int	i;		/* MUST be an int !!!	*/


	save_disk = CurDisk();	/* bdos call */

	dph = seldisk( 1 );		/* bios call, select drive B. */
	seldisk( save_disk );	/* bios call */

	i = dph->dpb_address;
	i -= 16;			/* non pointer arithmetic to get to	*/
	/* DMS dpb beginning.			*/
	dpb = i;

#ifdef debug
	printf ("STARTING P0_xfer...\n  way: ");
	if ( way == WRITE )
		printf ("WRITE");
	else
		printf ("READ");
	printf ("  vol %xh trk: %xh  sec: %xh  dma: %xh  count: %xh\n",
	vol, track, sector, dma, count );
#endif

	P0Assign( 1, vol);

	for ( i = 0; i < count; i++)

	{
		settrk( track );
		setsect( sectran( sector, dph->translate_table) );
		setdma( dma );
		dma += 128;
		switch( way )

		{
		case WRITE:
			bioswrite( NORMwrite );
			break;
		case READ:
			biosread();
			break;
		default:
			printf ("unknown P0_xfer direction.\n");
			zabort();
		}

#ifdef debug
		printf("    track: %x    sector+1: %x\n", track, sector+1);
#endif
		sector = ++sector % dpb->sect_per_track;
		track += sector / dpb->sect_per_track;

	}/*for #recs in table*/

	P0Unassign();


} /* P0_xfer */


