



/*======================================================================*/
/*	PW	- System Password Utility				*/
/*======================================================================*/

#include "pw.os"
#include "c:switch.os"
/*======================================================================*/
/*			CHANGE HISTORY					*/
/*----------------------------------------------------------------------*/
/* 1.0b - 03/14/84	- Change help screen				*/
/* 1.0a - 02/27/84 	- Add HELP, ENABLE and DISABLE commands		*/
/* 1.0	- 02/15/84	- Uses HARDIO so can only run on a floppy	*/
/*======================================================================*/

#define true	1
#define	false	0

#ifdef cpm80
#define	USERNO	(*(CHAR *) 0x47)
#else
#define USERNO	What? I don't know!
#endif
#define NODEBUG

/*#define	LEN_STAT	4
CHAR	statbuf [LEN_STAT];
CHAR	hd_type;
int	error = false;
int	abort_req = false;
*/


/*page*/
/*======================================================================*/
/*			M E S S A G E S					*/
/*======================================================================*/
#define Banner	"PW - Password Utility - 1.0b for Separated boot\n"
#define AbortPW			"\nAborting PW!\n"
#define DidAuto			"System passwords disabled\n"
#define DidManual		"System passwords enabled\n"
#define EnterCurrent		"Please enter the current password\n"
#define EnterManagerPswd	"Please enter the system manager password\n"
#define EnterNewPswd		"Please enter new password.\n"
#define EnterOperatorPswd	"Please enter the system operator password\n"
#define FloppyOnly		"PW CLEAR can only be used when booted from a floppy\n"
#define NoCurrentPswd		"There is no current password.\n" 
#define PswdCleared		"System password table cleared\n"
#define PswdSet			"New password set\n"
#define MastOrFloppy		"PW can only be used from a floppy booted system.\n"
extern CHAR *Help_Message[]; /* in PWHELP.C */

#define	INTERACTIVE	0
#define	AUTO		31
#define	MANUAL		32
#define	CLEAR		33
#define	SET		34
#define HELP		35
#define	Manager		1
#define	Operator	2
struct LookUp 
{
	CHAR	*sym;
	int	tok;
};

/*======================================*/
/*	GLOBAL VARIABLES		*/
/*======================================*/
int	Level;		/* level of password			*/
int	Action;		/* Action to perform on password	*/
#define	MAXArgs	12
struct	LookUp	Args [MAXArgs] = 
{
	"AUTO",		AUTO,
	"MANUAL",	MANUAL,
	"MANAGER",	Manager,
	"OPERATOR",	Operator,
	"CLEAR",	CLEAR, 
	"SET",		SET,
	"?",		HELP,
	"HELP",		HELP,
	"ENABLE",	MANUAL,
	"DISABLE",	AUTO,
	"ZERO",		CLEAR,
	NULL,		INTERACTIVE
};

/*======================================================================*/
/* getargs - scan args, and set action, level 				*/
/*======================================================================*/
getargs (argc, argv)
int	argc;
CHAR	*argv[];

{
	struct	LookUp	*p;

	Action = INTERACTIVE;
	Level  = INTERACTIVE;
	listUpper (argc, argv);
	while (--argc > 0) 
	{
		++argv;
		Args [MAXArgs].sym = *argv;
		for (p = Args; strcmp (*argv, p->sym); p++)
			;
		Level = Action = p->tok;
#ifndef NODEBUG
		printf ("SCANNED:'%s' Level = %d Action = %d\n", 
		p->sym, Level, Action);
#endif
	}
}
/*page*/
/*======================================================================*/
/* show_help - show help message and exit				*/
/*======================================================================*/
show_help () 
{
	CHAR	**p;

	for (p = Help_Message; *p != NULL; ++p)
		printf (*p); 
	exit (0);
}

/*page*/
/*======================================================================*/
/* zabort	- abort this program					*/
/*======================================================================*/
zabort () 
{
	printf (AbortPW);
	exit (1);
}

/*page*/
/*======================================================================*/
/*			M A I N						*/
/*======================================================================*/
main (argc, argv) 
int	argc;
CHAR	*argv[];

{

	printf (Banner);
	if (!(USERNO == 0 || USERNO == 0xFF)) 
	{
		printf (MastOrFloppy);
		show_help ();
		zabort ();
	}
	if (!hd_init ()) 
	{
		printf ("ERROR. The hard disk is not operational.\n");
		show_help ();
		zabort ();
	}
	if (!SepBoot())  
	{
		printf ("ERROR. this disk has not been upgraded to seperated boot!\n");
		show_help ();
		zabort ();
	}
	if (!(USERNO == 0 || USERNO == 0xFF)) 
	{
		printf (MastOrFloppy);
		show_help ();
		zabort ();
	}
	getargs (argc, argv);


	switch (Action) 
	{
	case AUTO :
		/*==== Auto ====================*/
		if (IsPW (Manager)) 
		{
			printf (EnterManagerPswd);
			GetPW (Manager);
		}
		AutoPW (TRUE);
		printf (DidAuto);
		break;
	case MANUAL :
		/*==== Manual ==================*/
		AutoPW (FALSE);
		printf (DidManual);
		break;
	case CLEAR :
		/*==== Clear ===================*/
		if (USERNO == 0) 
		{
			printf (FloppyOnly);
			zabort ();
		}
		if (IsPW (Manager)) 
		{
			printf (EnterManagerPswd);
			GetPW (Manager);
		}
		ClrPW ();
		printf (PswdCleared);
		break;
	case Operator:
	case Manager :
		if (IsPW (Level)) 
		{
			printf (Level == Manager ? 
			EnterManagerPswd : EnterOperatorPswd);
			GetPW (Level);
		}
		else printf (NoCurrentPswd);
		printf (EnterNewPswd);
		SetPW (Level);
		printf (PswdSet);
		break;
	case SET :
		/*==== Set =====================*/
		if (IsPW (Level)) 
		{
			printf (EnterCurrentPswd);
			GetPW (Level);
		}
		else printf (NoCurrentPswd);

		printf (EnterNewPswd);
		SetPW (Level);
		printf (PswdSet);
		break;
	case INTERACTIVE :
		/*==== Interactive =============*/
		printf ("Interactive mode is not implemented yet!\n");
		show_help (); /* until interactive mode becomes real.*/
		break;
	case HELP :
	default :
		show_help ();
		break;
	}
}


