/*							*/
/*			NETLOCK Utility			*/
/*			main program			*/

#define ver 1
#define rev 1
#define mod 'A'
#defin as 'c'

#define bufl	20
#define fnnlock 29

#include "netlock.os"
#include "c:switch.os"

CHAR *getline();
struct sstring {
	CHAR	length;
	CHAR	name[20];
};

main(argc, argv)
int	argc;
CHAR	*argv[];

{
	int len;
	CHAR buf[bufl];
	CHAR *s;
	CHAR *r = "RETURN";

	s = buf;
	printf("Send a lock string to the lock table, version %d.%d%c%c\n\n",ver,rev,mod,asm);
	printf("To lock a file, enter the file name and file type.\n");
	printf("Separate the file name from the file type with a period.\n\n");
	printf("To lock a partition, enter the partition name.\n\n");
	
	if (argc == 1)	{
		do	{
			printf ("Enter your lock string: ");
	} while (!(len = getline (s, bufl)));
		}
	else
		len = strlen (s = argv[1]);
#ifdef dbg
	printf("Lock string length = %d\n", len);
#endif
	if (len > 13)
		printf("Lock string is too long.\n");
	else	
		dolock (len, s);
#ifdef cpm86
	qexit();
#endif
}
/*page*/
dolock (l, p)
int	l;
char	*p;
{
	struct	sstring t;
	CHAR	*u = t.name;
	int	result;

	t.length = l;
	while (*u++  = toupper (*p++))
		;
	result = (bios86 (3,fnnlock, &t) & 0XFF);
#ifdef dbg
	printf ( "result = %x\n", result);
#endif
	switch (result) {
		case 0:
			printf("Your lock string is stored in the lock table.\n");
			break;
		case 1:
			printf("*** This file or partition is locked.\n");
			printf("-------------------------------------\n");
			break;
		case 2:
			printf("The lock table is full.\n");
			break;
		default:
			printf("Unknown result = %x\n", result);
			break;
		}
	return;
}
#ifdef dbg
prstk(arg)
int arg;
{
	int i, *s;

	for (s = &arg, i = 0; i++ < 20; printf("%5x", *s++));
}
#endif
