/* **************************************************************
 *								*
 *			   MACHINE1.C				*
 *		ADD / CHANGE MACHINE TABLE ENTRIES		*
 *		  last modified 02/22/84 dsb			*
 *								*
 ************************************************************** */

/* #define DBUG YES */

#include "libc.h"
#include "machine.h"
#include "hardio.h"

#define MAX_PROD  20	   /* consider any higher product numbers invalid */
#define MAX_MACH  128

struct MTentry *mt_find();



struct MTentry *
mt_find(num)
long num;  
{
    struct MTentry *entry;
    int i,max;

    entry = (struct MTentry *)machtable.buffer;
    max = mt_entries();
    for(i=0; (i<max) && !long_eq(entry->sernum,num); i++, entry++)
	;
    if(i < max)
	return(entry);
    return(NULL);
} /* mt_find */

/*page*/
/* *********************************************************************

    This is a monster routine and one of the next modifications should
    be chopping it down to a manageable size
 
************************************************************************ */


mt_a_m(which)
char which;
{
    register int  i;
    int type;
    struct MTentry entry;
    register struct MTentry *new_ptr;
    register int new_num;
    long serial,serial2;
    char *p;
    int prod_changed = FALSE;
    int ser_changed = FALSE;
    char adding;
    char *add_msg = 
	   "The Machine Table entry which you have created looks like this:";
    char *mod_1_msg = 
	   "You have asked to modify this Machine Table entry:";
    char *mod_2_msg =
	   "The modified Machine Table entry looks like this:";
    char model_code[10];
    struct CONFIGURE *fig;  

    if(adding = (which==ADDING))
    {
	if ((new_num = mt_entries()) >= MAX_MACH)
	{
	    printf("\nThe Machine Table is full -- you cannot make any more");
	    printf("entries.  \nThis is an unusual condition and may ");
	    printf("indicate a\ncorrupted Control Area or a bug in this ");
	    printf("program.");
	    waitkey();
	    return();
	}
	new_ptr = ((struct MTentry *)MTbuf) + new_num;
	printf("\n\nADDING NEW MACHINE\nPress ESC to abandon this addition "); 
	printf("and go back to the main menu\n");
    } /* if adding */

/*page*/
    else
    {
	printf("\nEnter serial number of machine you wish to modify --> ");
	get_serial(&serial,FALSE);	 /* default not ok here */
	if(abort_req)
	    return();
	if((new_ptr=mt_find(serial)) == NULL)
	{
	    printf("\n\07That is a new machine.  It must be added, ");
	    printf("not modified.");
	    return();
	}

	new_num = ((int)new_ptr -(int)MTbuf)/sizeof(struct MTentry);
	printf("\nYou have asked to modify this machine:");
	mt_prt_vert(new_ptr);
	if(!is_correct())
	    return();
	blockmv(&entry,new_ptr,sizeof(struct MTentry));
	ret_esc_msg();
    } /* if not adding */
 

    do	  
    {
	if(adding)
	{
	    mt_prod_menu();
	    printf("\nWhich model code of machine would you like to add ");
	    printf("to the list? --> ");
	}
	else
	    printf("\nEnter the new model code --> ");

	clear(model_code,9,'\0');
	if(!(i=dgets(model_code,9)))
	    if(adding)			    /* return not valid in add mode */
	    {
		error = TRUE;
		continue;
	    }
	    else			    /* but fine in modify mode */
		break;
	else if(model_code[0] == ESC)
	    return();
/*page*/
	else
	{
	    for(i=0; model_code[i] = toupper(model_code[i]); i++)
		;
	    fig = (struct CONFIGURE *)desc_code;
	    for(i=0, error = TRUE; error && (i<MAXDESC); i++,fig++)
		error = strcmp(model_code,fig->short_name);
	    fig--;
	    if(error)
	    {
		printf("\n%s is not a valid model code.",model_code);
		if(!adding)
		   mt_prod_menu();	/* (adding displays it anyhow) */
	    }
	    else
	    {
		prod_changed = TRUE;
		blockmv(&(entry.product),&(fig->prod),7);
	    }  /* if a good model code was entered */
	} /* if a model code was entered */
    } while(error);

    help_find_serial(mt_findmodel(&(entry.product)));

    if(adding)
	printf("\nEnter the Serial Number of the new machine model %s --> ",   
		  fig->long_name);
    else
    {
	ret_esc_msg();
	printf("\nEnter new Serial Number --> ");
    }

    if(!get_new_serial(&serial,adding))     /* 0 means RETURN or ESC hit */
	if(long_eq(serial,(long)ESC))
	    return();
	else
	    serial = new_ptr->sernum;
    else
	ser_changed = !match(&serial,&(new_ptr->sernum),4);

    if(ser_changed && (mt_find(serial) != NULL))
    {
	p = (char *)&serial;
	printf("\n\07Machine number %02x%02x%02x%02x is already in the table",
		    *p,*(p+1),*(p+2),*(p+3));
	return();
    }

    entry.sernum = serial;

    entry.iobyte = new_ptr->iobyte;			/* get iobyte */
    if(get_iobyte(&entry,adding,!prod_changed) < 0)
	return();

    blockmv(new_ptr,&entry,sizeof(struct MTentry));
    if(adding || ser_changed)
	sort(machtable.buffer,sizeof(struct MTentry),new_num+1);

#ifdef DBUG
    printf("\n*DBUG* about to write file to track %x, sector %x",
	    machtable.track, machtable.sector);
#endif
    putfile(machtable);

    return();
} /* mt_a_m (add to or modify product table) */
 
mt_ent_confirm(msg,ent,num)
char *msg;
struct MTentry *ent;
int num;
{
    printf("\n%s\n",msg);
    mt_header();
    printf("\n  %2x\t",num);
    mt_prt(ent);
    return(yorn("\n\nIs this correct") == 'Y');
}

/*page*/
mt_prod_menu()	 /* display the mnemonics and full descriptions for products */
{
    int i,j;
    struct CONFIGURE *p;

    printf("\nThese are the model codes for DMS equipment.");
    printf("\n(Any key stops / starts listing)\n");
    for(j=0; j<4000; j++) 
	;
    printf("\nModel         You Enter       Description");
    printf("\n-----         ---------       -----------");
    for(i=0,p=(struct CONFIGURE *)desc_code; i<MAXDESC; i++,p++)
    {
	printf("\n%-15s%-15s",p->long_name,p->short_name);
	if(p->description)
	    printf("%s",p->description);
	check_wait();
	for(j=0; j<1000; j++)	    /* delay so user doesn't panic */
	    ;
    }
    printf("\n");
} /* mt_prod_menu */

it();
	for(j=0; j