/*======================================================================*/
/*	EXPAND1.C	- main routine and user interface for the 	*/
/*			  EXPAND program.				*/
/*======================================================================*/

#include "expand.os"
#include "switch.os"
#include "hardio.h"
#include "expand.h"

/*======================================================================*/
/*			CHANGE HISTORY					*/
/*======================================================================*/
/* 0.0a	- 12/29/83 -	Initially written			  - jjc	*/
/* 0.0b - 01/30/84 -	Password stuff added			  - jjc */
/*======================================================================*/

#define MANAGER		1

#ifdef cpm80
#define USERNO	(*(CHAR *) 0x47)
#else
#define USERNO	WHAT?, I don't know!
#endif
/*page*/
/*======================================================================*/
/*				Messages				*/
/*======================================================================*/

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*CantBeMaster [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"===================================================================\n",
"=        This program will not work on a running master.          =\n",
"=        You can run EXPAND if you boot from a floppy disk.       =\n", 
"===================================================================\n",
"\n",
NULL
};


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*caution_msg [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"===============================================================================\n",
"=         HAVE YOU MADE A BACKUP OF THE DISK YOU WISH TO EXPAND?              =\n",
"===============================================================================\n",
"This program increases the size of partition zero on your disk.\n",
"\n",
"Before running this program you should make a backup of the disk you\n",
"wish to expand.  Be sure to backup the whole disk, including partition\n",
"zero.  Failure to take this precaution may result in the loss of your data\n",
"\n",
"Have you made a backup of the disk you wish to expand,\n",
"including partition 0?\n",
"(Y or N) --> ",
NULL
};

#define	DoBkupMsg	"\nPlease backup your disk before running EXPAND\n"

#define EnterPw		"Please enter the System Manager Password to continue.\n" 

#define ExitExpand	"Exiting EXPAND, expansion aborted.\n"

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*Expanded [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"\n",
"Expansion completed.\n",
"Returning to CP/M\n",
NULL
};


#define NoHD		"The Hard Disk is not operative.\n"

#define SpaceNeeded	"EXPAND needs %uK more to expand partition zero\n"


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*MaxPart0 [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"=====================================================================\n",
"=      Sorry - expansion of your partition zero is not possible     =\n",
"=      since there are already 8 Megabytes allocated for            =\n",
"=      partition zero.  This is the maximum partition size for any  =\n", 
"=      partition.                                                   =\n",
"=====================================================================\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*NoSepMsg [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"============================================================================\n",
"=      Sorry this program can only be run on a seperated boot system.      =\n",
"=      Please upgrade your system to seperated boot before running expand. =\n",
"============================================================================\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*NotEnoughRoom [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

"Your Hard Disk does not have enough free space to expand partition zero.\n",
"Please delete enough partitions to make room.\n",
NULL
};

#define OldAndNew	"\nPartition Zero is being expanded from %s to %s\n"

#define Sure_msg	"\nAre you sure this is what you want to do? (Y or N) --> "

#define	YesNoPlease	"Please type Y or N: "

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*WontWriteMaster [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"=================================================================\n",
"=           This program cannot be run on a network,            =\n",
"=          please boot from a floppy disk to run EXPAND.        =\n",
"=================================================================\n",
"\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


/*======================================================================*/
/*			Imports from EXPAND2				*/
/*======================================================================*/
extern unsigned int	needed;		/* Kbytes needed to expand 	*/
extern unsigned int	allocated;	/* Kbytes allocated 		*/ 
extern unsigned int	disk_size;	/* Kbytes of space on the disk	*/

/*page*/
/*==============================================================*/
/*	AreYouSure	- tell what the new size will be and ask*/
/*==============================================================*/
AreYouSure () {

CHAR	c;

	printf (OldAndNew, oPart0Size (), nPart0Size ());
	printf (Sure_msg);
	return (!get_yesno (YesNoPlease));
	}


/*page*/
/*==============================================================*/
/*	backup_warning	- issue a warning about the importance	*/
/*			  backups and give the user a chance to	*/
/*			  back out of doing the expansion	*/
/*==============================================================*/
backup_warning () {
CHAR	c;

	show_menu (caution_msg);
	if (!get_yesno (YesNoPlease)) {
		printf (DoBkupMsg);
		exit_expand ();
		}
	else
		putchar ('\n');
	 
	}


/*page*/
/*======================================================================*/
/*	exit_expand	-	abort the expand program		*/
/*======================================================================*/
exit_expand () {
	printf (ExitExpand);
	exit (1);
	}
zabort () {exit_expand (); }

/*page*/
/*======================================================================*/
/*	init_hard_disk	-	initialize hard disk			*/
/*======================================================================*/
init_hard_disk () {
	if (!USERNO) {
		beep ();
		show_menu (CantBeMaster);
		exit_expand ();
		}

	if (USERNO != 0xFF) {
		beep ();
		show_menu (WontWriteNet);
		exit_expand ();
		}

	if (!hd_init ()) {
		beep ();
		printf (NoHD);
		exit_expand ();
		}
	if (!SepBoot ()) {
		beep ();
		show_menu (NoSepMsg);
		exit_expand ();
		}
	}


/*page*/
/*======================================================================*/
/*				MAIN					*/
/*======================================================================*/
main () {
	printf (Banner);
	init_hard_disk ();
	if (IsPW (MANAGER)) {
		printf (EnterPw);
		GetPW (MANAGER);
		}
	backup_warning ();
	initialize ();

	scan_DAT ();
	if (needed > (disk_size - allocated)) {
		beep ();
		message (NotEnoughRoom);
		printf (SpaceNeeded, needed - (disk_size - allocated));
		exit_expand ();
		}
	
	if (Part0atMAX ()) {
		message (MaxPart0);
		exit_expand ();
		}
	if (AreYouSure()) 
		exit_expand ();

	BuildMoveTab ();
	MovePartitions ();
	message (Expanded);
	return (0);
	}

/*======================================================================*/

