/*==============================================================*/
/*	SYSUP2.H 	System Tables - old and new		*/
/*==============================================================*/

#define SECTSIZE	128

/*==============================================================*/
/*	Cold Boot Loader					*/
/*==============================================================*/
#define CBtrack		0x02
#define CBsector	0x01

/*==============================================================*/
/*	Disk Allocation Table					*/
/*==============================================================*/
#define	DATtrack	0x00
#define DATsector	0x79
#define DATlength	8	/* in sectors */

#define DATMAX	64
#define DATSIZE	(DATMAX * sizeof (struct DATentry))
struct DATentry {
	CHAR	size;
	CHAR	Part_Name [8];
	CHAR	Part_Password [6];
	CHAR	control;
	};
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* DAT control byte mappings:

	bit	use
	---	---
	0,1	00 = CPM		01 = MSDOS
		10 = unused		11 = unused
	2,3	unused
	4,5	00 = Read/Write		01 = Read/Only
		10 = First/Write	11 = unused
	6	HiDos shared	(Separate from bits 4,5 for speed of
				 checking, i.e only one bit test.)
	7	Tape backup
*/
/* Macros for testing control byte */
#define WM_MASK	0x70	/* Write Mode mask */
#define DAT_r_w(n) ((n & WM_MASK) == 0x00)
#define DAT_r_o(n) ((n & WM_MASK) == 0x10)
#define DAT_f_w(n) ((n & WM_MASK) == 0x20)
#define DAT_HiDos(n) ((n & WM_MASK) == 0x40)

/*==============================================================*/
/*	First Write Table					*/
/*==============================================================*/
#define FWTtrack	0x01
#define FWTsector	0x15
#define FWTlength	2

#define FWTMAX	64
#define MAXVOLS 4
#define FWTSIZE	(MAXVOLS * sizeof (struct FWTentry))
struct FWTentry {
	CHAR	partition [FWTMAX];
	};
#define FWT_RW		((CHAR) 0xFE)
#define FWT_RO		((CHAR) 0xFD)
#define FWT_FW		((CHAR) 0xFF)
#define FWT_HiDos	((CHAR) 0xFC)

/*==============================================================*/
/*	Machine Table						*/
/*==============================================================*/
#define MTtrack		0x01
#define MTsector	0x09
#define MTlength	12	/* in sectors	*/

#define MTMAX	128
#define MTSIZE	(MTMAX * sizeof (MTentry))
struct MTentry {
	CHAR	Serial_Number [4];
	CHAR	Product_Number;
	CHAR	Option_Map [6];
	CHAR	IOBYTE;
	};

/*==============================================================*/
/*	Operating System Table					*/
/*==============================================================*/
#define OSTtrack	0x01
#define OSTsector	0x21
#define	OSTlength	96

#define	OSTMAX	128
#define OSTSIZE	(OSTMAX * sizeof (struct OSTentry))
struct OSTentry {
	CHAR	os;
	CHAR	prod_map [16];
	CHAR	opt_map [6];
	CHAR	load_list [8] [8];
	int	length;
	CHAR	OSTreserved [7];
	};

/*==============================================================*/
/*	Password Table						*/
/*==============================================================*/
#define PWTtrack	0x01
#define PWTsector	0x18
#define PWTlength	1	/* in sectors	*/

#define PWTMAX	21
#define PWTSIZE (PWTMAX * sizeof (struct PWTtype))

#define SEPBOOT		"SB0000"

#define PWlen	6
struct PWTentry {
	CHAR	Sys_Password [PWlen];
	};

struct PWTtype {
	struct PWTentry	table [PWTMAX];
	CHAR		autoflag;
	CHAR		PWreserved;
	};

/*==============================================================*/
/*	Product Type Table					*/
/*==============================================================*/
#define PTtrack		0x01
#define PTsector	0x19
#define PTlength	8	/* in sectors	*/

#define	PTMAX	40
#define PTSIZE	(PTMAX * sizeof (struct PTentry))
struct PTentry {
	CHAR	type;
	CHAR	bp2_name [8];
	CHAR	lgn_name [8];
	CHAR	osm_name [8];
	};

/*==============================================================*/
/*	System Directory					*/
/*==============================================================*/
#define SDtrack		0x02
#define SDsector	0x09
#define SDlength	24	/* in sectors */

#define	SDMAX	128
#define SDSIZE	(SDMAX * sizeof (struct SDentry))
struct SDentry {
	CHAR	name [8];
	CHAR	volume;
	CHAR	unit;
	int	track;
	CHAR	sector;
	int	length;
	long	load_addr;
	int	exec_off;
	CHAR	prog_flag;
	CHAR	SDreserved [2];
	};


/*==============================================================*/
/*	User Configuration Table - the new style		*/
/*==============================================================*/
#define UCTtrack	0x00
#define	UCTsector	0x39
#define UCTlength	64	/* in sectors */

#define	UCTMAX	128
#define UCTSIZE	(UCTMAX * sizeof (struct UCTentry))
struct UCTentry {
	CHAR	Adrive [8];
	CHAR	Bdrive [8];
	CHAR	Cdrive [8];
	CHAR	Ddrive [8];
	CHAR	lth_typeahead;
	CHAR	typeahead [31];
	};

/*==============================================================*/
/*	User Configuration Table - the old style		*/
/*==============================================================*/
#define oUCTtrack	0x04
#define	oUCTsector	0x01
#define	oUCTlength	128	/* in sectors */

#define	oUCTSIZE	(UCTMAX * sizeof (struct oUCTentry))
struct oUCTentry {
	CHAR	Adrive [8];
	CHAR	Bdrive [8];
	CHAR	Cdrive [8];
	CHAR	Ddrive [8];
	CHAR	dfltIOBYTE;
	CHAR	olth_typeahead;
	CHAR	otypeahead [31];
	CHAR	UCTreserved [63];
	};

/*==============================================================*/
/*	User Name Table	- the new style	(old style is the same	*/
/*			  size.					*/	
/*==============================================================*/
#define	oUNTtrack	0x03
#define	oUNTsector	0x01
#define oUNTlength	16	/* in sectors	*/

#define UNTtrack	0x00
#define UNTsector	0x29
#define	UNTlength	16	/* in sectors	*/

#define UNTMAX	128
#define UNTSIZE	(UNTMAX * sizeof (struct UNTentry))
struct UNTentry {
	CHAR	User_Name [8];
	CHAR	Password  [6];
	CHAR	OS_Code;
	CHAR	flags;
	};
#define DFLTOS		0x10	/* default OS is generic CP/M	*/
#define DFLTFLAGS	0x00	/* default Full Service		*/


/*==============================================================*/

