
/*======================================================*/
/*		Filecopy Utility Program		*/
/*			INCLUDE FILE			*/
/*======================================================*/

/* Change History:
ver	0
rev	0
mod	a
patch	6
		last change: 8 December 1983	tpl

	0.0a 10/10/83	Extracted from filecopy.c
*/
#define NEWFEAT	0
/*
#define debug	* global debugging flag *
#define debugP	* procedure name output upon call, debugging flag. *

#define dbg	* local debugging flag *
#define dbg1	* another local debugging flag *
*/

/* possible second file name options */

#define error	0
#define dir	1
#define tree	2
#define tofile	3	

/* possible filecopy directions */

#define tonative 1
#define toforeign 2
#define bothms 3

/* miscellaneous definitions */

#define found == 0
#define true	1
#define false	0
#define success 1
#define fail	0
#define forever 1

/*page*/

#ifdef  msdos

CHAR	*native  = "MSDOS";
CHAR	*foreign = "CP/M";

#else

CHAR	*native  = "CP/M";
CHAR	*foreign = "MSDOS";

/* msdos directory attributes */

#define readonly 	0x01
#define hidden  	0x02
#define systemfile 	0x04
#define vollabel 	0x08
#define dirtype 	0x10
#define archive		0x20

#endif	/* msdos */

/* Define forward definitions that c86 cannot handle */

extern	CHAR *copytil();
extern	CHAR *copytiln();

/*page*/
/* Define useful structures */

#define LENpart 8
#define LENpath 80
#define LENfname 8
#define LENftype 3
#define LENfcb 32
#define LENdir 32
#define ENDdir	 0xff
#define ENDdirMS 0xffff
#define	FAIL	0xffff
#define ROOTdir 0

#define FROMforeign	0
#define FROMnative	1


typedef struct  {
	CHAR	drive;
	CHAR	fname[ LENfname];
	CHAR	ftype[ LENftype];
	CHAR	attribute;
	CHAR	reserved[ LENfcb-(2+LENfname+LENftype)];
	} msdosfcb;

typedef struct	{
	CHAR	fname[ LENfname];
	CHAR	ftype[ LENftype];
	CHAR	attribute;
	CHAR	reserved[ 10];
	CHAR 	updtime[ 2];
	CHAR	upddate[ 2];
	int	cluster;
	CHAR	filesize[ 4];
	}	msdosdir;

typedef struct  {
	CHAR	drive;
	CHAR	fname[ LENfname];
	CHAR	ftype[ LENftype];
	CHAR	extent;
	CHAR	s1;
	CHAR	s2;
	CHAR	reccnt;
	CHAR	datamap[16];
	} cpmfcb;

typedef struct	{
	CHAR	user;
	CHAR	fname[ LENfname];
	CHAR	ftype[ LENftype];
	CHAR	extent;
	CHAR	s1;
	CHAR	s2;
	CHAR	reccnt;
	CHAR	datamap[16];
	} cpmdir;

#ifdef cpm
#define forgnfcb msdosfcb
#define nativfcb cpmfcb
#define forgndir msdosdir
#define nativdir cpmdir
#else
#define	forgnfcb cpmfcb
#define nativfcb msdosfcb
#define forgndir cpmdir
#define nativdir msdosdir
#endif

typedef struct	{
	CHAR 	part[ LENpart];
	CHAR	path[ LENpath];
	CHAR	fname[ LENfname];
	CHAR	ftype[ LENftype];
	CHAR	fcb[ LENfcb];
	} filespec;

