;	BOOT ROUTINE FOR CP/M ON CORVUS DISC
;		VERSION 1.3S/TT
;	        ( S100/TRS80 II VERSION )
;
; THIS PROGRAM WILL LOAD IN CP/M FROM THE CORVUS DISC.
; IT IS FIRST LOADED IN WITH THE "CLOADR" PROGRAM.
;
; THIS PROGRAM IS 1 SECTOR LONG AND MUST BE STORED ON DISC.
;  IT MUST BE CHANGED WHENEVER THE CP/M SIZE IS CHANGED.
;
;
;$I CRVSYS.S		; SYSTEM EQUATES
;	----	S100/TRS80 II9 PORT ADDRESSES & MASKS	----
;
STAT	EQU	0DFH	; STATUS I/O PORT
DATA	EQU	0DEH	; DATA I/O PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DRDYST	EQU	0	; IF BIT 0 = 0 THEN DRIVE READY
DIFAC	EQU	2	; MASK FOR DRIVE ACTIVE BIT
HTD	EQU	2	; IF BIT 1 SET THEN HOST-TO-DRIVE STATUS
DTH	EQU	0	; IF BIT 1 = 0 THEN DRIVE-TO-HOST
;
;
;
;$I CBOOT.BDY		; BODY OF CBOOT
;
; ---- CORVUS DISK EQUATES ----
RDCOM	EQU	12H	; READ COMMAND (VERS. 1 CCODE)
SSIZE	EQU	128	; SECTOR SIZE (IN BYTES)
;
BDRIVE	EQU	1	; DRIVE # TO BOOT FROM
BSEC	EQU	12	; DISC ADDRESS TO BOOT FROM (RESERVE A FEW SEC.)
CSEC	EQU	BSEC+1	; STARTING SECTOR FOR CP/M ON DISC
;
;--- CP/M EQUATES ----
;
MSIZE	EQU	20	; CP/M MEMORY SIZE IN KB
DELTA	EQU	0000H	; OFFSET FROM STD CP/M SIZE
BIAS	EQU	(MSIZE-20)*1024-DELTA
CCP	EQU	3400H+BIAS	; CP/M LOAD ADDRESS (CP/M 2.0)
BIOS	EQU	CCP+1600H	; BASE OF BIOS (CP/M 2.0)
BOOT	EQU	BIOS	; ENTRY POINT AFTER BOOT
NSEC	EQU	63	; NUMBER OF SECTORS TO LOAD (COULD BE SMALLER)
;
CBOOT	EQU	0	; ORIGIN OF BOOT PROGRAM 
;
	ORG	CBOOT
;
LDCPM:	MVI	C,NSEC	; GET # SECTORS TO LOAD
	LXI	H,CCP	; GET LOAD RAM ADDRESS
	LXI	D,CSEC	; GET STARTING DISC ADDRESS
LD1:	CALL	READ	; READ IN ONE SECTOR
	INX	D	; INCREMENT SECTOR COUNT
	DCR	C	; COUNT DOWN # SECTORS
	JNZ	LD1	; LOOP UNTIL DONE
	JMP	BOOT	; IF DONE, ENTER CP/M
;
READ:	MVI	A,RDCOM	; GET READ COMMAND
	CALL	WAITO	; SEND IT TO CONTROLLER
	MVI	A,BDRIVE	; GET DRIVE #
	CALL	WAITO
	MOV	A,E	; GET LOW BYTE OF DISC ADDRESS
	CALL	WAITO
	MOV	A,D	; GET UPPER BYTE OF DISC ADDRESS
	CALL	WAITO
	CALL	TURN	; WAIT FOR BUSS TO TURN AROUND
	CALL	WAITI	; READ ERROR CODE
	ANI	80H	; LOOK AT FATAL BIT
RD1:	JNZ	RD1	; IF ERROR, LOOP
	MVI	B,SSIZE	; GET SECTOR SIZE
RLP:	CALL	WAITI	; 1.3 - USE WAITI ROUTINE
	MOV	M,A	; SAVE IT IN MEMORY
	INX	H
	DCR	B
	JNZ	RLP	; LOOP UNTIL DONE
	RET
;
;
;$I CRV.IO		; BASIC CORVUS IO ROUTINES
;FILEID: CRV.IO
;

TURN:				; WAIT FOR DRIVE-TO-HOST STATUS AND
	IN	STAT		; DELAY TILL DATA STABLE
	ANI	DRDY OR DIFAC	; TEST STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	TURN		; IF NOT THEN LOOP
	MVI	B,6		; SET DELAY COUNT
	CALL	DELAY		; GOOD AT 4MHZ ALSO
	RET			;
;
DELAY:	DCR	B
	JNZ	DELAY
	RET
;
WAITI:	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	WAITI	; LOOP UNTIL READY
	IN	DATA	; READ BYTE FROM DISC
	RET
;
WAITO:	PUSH	PSW	; SAVE COMMAND
	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR HTD	; IS DRIVE READY & HOST-TO-DRIVE
	JNZ	WAITO+1	; LOOP UNTIL READY
	POP	PSW
	OUT	DATA	; WRITE BYTE TO DISC
	RET

	END
