
*
* TSC 8080 ASSEMBLER (F)
*
* COPYRIGHT (C) 1978 BY
* TECHNICAL SYSTEMS CONSULTANTS, INC.
* BOX 2574, W. LAFAYETTE, IN 47906
*

* DISK EQUATES

SLECTF	EQU	14
OPENF	EQU	15
CLOSEF	EQU	16
DELETF	EQU	19
READF	EQU	20
WRITEF	EQU     21
MAKEF	EQU	22
RENAMF	EQU	23
IDNF	EQU	25
SDMAF	EQU	26

BDOS	EQU	0005
TBUFF	EQU	0080H

* ASSEMBLER EQUATES

FIELD1	EQU	09		;AUTO-EXPAND FIELD 1
FIELD2	EQU	16		;AUTO-EXPAND FIELD 2
FIELD3	EQU	26		;AUTO-EXPAND FIELD 3
HSHCNT	EQU	40		;MAXIMUM HASH COUNT
SMCOLN	EQU	3BH		;SEMI-COLON FOR COMMENTS
COLON	EQU	':'		;LABEL POSTFIX
CMNTCH	EQU	'*'		;ASTERISK FOR COMMENT LINES
RCSZ	EQU	10H		;TAPE RECORD SIZE


* START OF PROGRAM

	ORG	100H

START	LXI	H,0000
	DAD	SP
	SHLD	OLDSP		;SAVE OLD STACK POINTER
	LXI	SP,STACK	;SETUP NEW STACK
DASMB	XRA	A
	STA	OPTPAG		;TURN OFF PAGING
	LXI	H,MESSG		;PRINT HEADER
	CALL	PTRMNL
	MVI	A,0FFH
	STA	HEXBUF		;SET BUFFER POINTERS
	STA	PRNBUF
	MVI	A,7FH
	STA	SRCBUF
	MVI	A,32		;SET DEFAULT SYMBOL
	STA	STSIZE		;TABLE SIZE IN PAGES
	MVI	C,IDNF		;GET LOGGED IN DRIVE
	CALL	BDOS
	STA	LOGDR		;SAVE IT
	LXI	H,CLRFCB
	LXI	D,HEXFCB
	CALL	XFR16		;INITIALIZE HEX FCB
	LXI	H,TBUFF		;INSERT A RETURN AT THE
	MOV	A,M		;END OF THE COMMAND LINE
	INX	H
	PUSH	H
	CALL	ADAHL
	MVI	M,0DH
	POP	H
	CALL	SKIP		;SKIP SPACES
	LXI	D,SRCFCB
	CALL	GETFN		;GET SOURCE FILE SPEC
	JC	ILLFL		;JUMP IF AN ERROR
	LDA	SRCFCB+33
	STA	PRNFCB+33	;SET PRN DEFAULT DRIVE
	CALL	SKIP		;SKIP TO NEXT NON-SPACE
	CPI	0DH
	JZ	DASMB1		;JUMP IF A RETURN
	CPI	5BH		;LEFT BRACKET
	JZ	DPARS2		;JUMP IF OPTION LIST
	XCHG
	LXI	H,EXT		;SET IN A DEFAULT
	MVI	M,'H'		;EXTENSION OF 'HEX'
	INX	H
	MVI	M,'E'
	INX	H
	MVI	M,'X'
	XCHG
	LXI	D,HEXFCB
	CALL	GETFN		;GET HEX FILE SPEC
	JC	ILLFL		;JUMP IF AN ERROR
	CALL	SKIP
	CPI	0DH
	JZ	DASMB1		;JUMP IF A RETURN
	CPI	5BH		;LEFT BRACKET
	JZ	DPARS2		;JUMP IF OPTION LIST
	LXI	H,ERRM6		;ELSE, REPORT ERROR
	JMP	PREXIT
DPARS2	INX	H
DPRS25	MOV	A,M		;GET NEXT CHARACTER
	CPI	0DH
	JZ	DASMB1		;SKIP IF A RETURN
	CPI	5DH		;RIGHT BRACKET
	JZ	DPARS6		;SKIP IF OPTION END
	CALL	VALID1		;ELSE CHECK VALID
	JNC	ILLOPT		;ERROR IF NOT
	XCHG
	MOV	B,A
	LXI	H,CMDOPT	;SEARCH OPTION TABLE
DPARS3	MOV	A,M		;FOR CHARACTER
	ORA	A
	JZ	DPARS5		;JUMP IF FOUND
	CMP	B
	JZ	DPARS4
	INX	H
	INX	H
	JMP	DPARS3
DPARS4	INX	H
	MOV	A,M		;GET DATA
	MOV	B,A
	ANI	0FH		;FIND DISPLACEMENT INTO
	LXI	H,AUXOPT		;AUXILIARY OPTION LIST
	CALL	ADAHL
	MOV	M,B		;SET CORRESPONDING BYTE
	XCHG
	MVI	A,0F9H		;WAS IT 'P' OPTION ?
	CMP	B
	JNZ	DPARS2		;LOOP BACK IF NOT
	INX	H
	MOV	A,M
	CPI	':'		;NEXT CHAR A COLON ?
	JNZ	DPRS25		;LOOP BACK IF NOT
	INX	H
	MOV	A,M		;GET DRIVE SPECIFICATION
	SUI	'A'		;IS IT A TO D ?
	JC	ILLOPT
	CPI	04
	JNC	ILLOPT		;ERROR IF NOT
	STA	PRNFCB+33	;SET PRN FILE DRIVE
	JMP	DPARS2
DPARS5	MOV	A,B
	CPI	'9'+1		;A DIGIT ?
	JNC	ILLOPT		;ERROR IF NOT
	MVI	B,18H		;SETUP DUMMY POSTFIX
	CALL	DECML1		;CONVERT NUMBER
	MOV	A,H
	ORA	A		;GREATER THAN 255 ?
	JNZ	ILLOPT		;ERROR IF SO
	MOV	A,L
	ORA	A		;EQUAL TO ZERO ?
	JZ	ILLOPT		;ERROR IF SO
	STA	STSIZE		;ELSE SET TABLE SIZE
	XCHG
	JMP	DPRS25		;LOOP BACK
DPARS6	INX	H
	CALL	SKIP		;SKIP SPACES
	CALL	GETDEC		;GET LOW PAGE NBR
	JC	DPARS7		;JUMP IF NOT VALID
	SHLD	LOPAGE
	XCHG
	MOV	A,M
	CPI	0DH
	JZ	DASMB1		;JUMP IF NO HI PAGE
	CPI	'-'
	JNZ	ILLOPT
	INX	H
	CALL	GETDEC		;GET HI PAGE NBR
	JC	DPARS7		;JUMP IF NOT VALID
	SHLD	HIPAGE
DPARS7	XCHG
	MOV	A,M
	CPI	0DH		;LOOK FOR END OF LINE
	JNZ	ILLOPT		;ERROR IF NOT
	JMP	DASMB1		;GO SETUP FILES

* GET A DECIMAL NUMBER FROM COMMAND LINE

GETDEC	CALL	CLASS		;CLASSIFY CHARACTER
	XCHG
	JZ	GETDC1		;CONTINUE IF A DIGIT
	STC			;ELSE RETURN ERROR
	RET
GETDC1	MVI	B,18H		;SETUP DUMMY POSTFIX
	CALL	DECML1		;CONVERT NUMBER
	ORA	A		;CLEAR CARRY
	RET

* DISK ERROR ROUTINES

ILLOPT	LXI	H,OPTERR
	JMP	PREXIT
ILLFL	LXI	H,IFSERR
	JMP	PREXIT
OPENER	LXI	H,OFERR
	JMP	PREXIT
NDSPC	LXI	H,NDSERR
PREXIT	CALL	PTRMNL		;PRINT MESSAGE
PEXIT1	LDA	LOGDR		;GET DRIVE WHICH WAS
	MOV	E,A		;LOGGED IN ON ENTRY
	MVI	C,SLECTF	;SELECT IT
	CALL	BDOS
	LHLD	OLDSP
	SPHL			;RESTORE OLD STACK PTR
	RET

* SETUP DISK FILES

DASMB1	LDA	OPTBIN
	ORA	A		;BIN OPTION ON ?
	JZ	DASM15		;SKIP IF NOT
	MVI	A,75H		;ELSE SUPPRESS HEX
	STA	AUXOPT+5
DASM15	LXI	D,SRCFCB
	CALL	OPEN		;OPEN SOURCE FILE
	CPI	-1
	JNZ	DASMB2
	LXI	H,FNFERR	;ERROR IF NOT FOUND
	JMP	PREXIT
DASMB2	XRA	A
	STA	SRCFCB+32	;CLEAR NR BYTE

* SETUP OBJECT FILE

	LDA	OPTBIN		;CHECK BIN FILE OPTION
	ORA	A		;IS BINARY ON ?
	JNZ	DASM25		;SKIP IF SO
	LDA	AUXOPT+5	;CHECK HEX FILE OPTION
	ORA	A		;IS HEX FILE SUPPRESSED ?
	JNZ	DASMB5		;SKIP IF SO
DASM25	LDA	HEXFCB+1
	CPI	' '		;WAS HEX FILE SPECIFIED ?
	JNZ	DASMB3		;SKIP IF SO
	LXI	D,HEXFCB
	CALL	XFRSRC		;COPY SOURCE NAME TO HEX
	LXI	H,HEXFCB+9	;SET IN 'HEX' EXTENSION
	MVI	M,'H'
	INX	H
	MVI	M,'E'
	INX	H
	MVI	M,'X'
	LDA	SRCFCB+33
	STA	HEXFCB+33	;SET DRIVE EQ SOURCE DRIVE
DASMB3	LDA	OPTBIN
	ORA	A		;BINARY OPTION ON ?
	JZ	DASM35		;SKIP IF NOT
	LXI	H,HEXFCB+9	;ELSE, IF EXTENSION IS
	MVI	A,'H'		;A 'HEX' CHANGE IT
	CMP	M		;TO A 'BIN'
	JNZ	DASM35
	INX	H
	MVI	A,'E'
	CMP	M
	JNZ	DASM35
	INX	H
	MVI	A,'X'
	CMP	M
	JNZ	DASM35
	MVI	M,'N'
	DCX	H
	MVI	M,'I'
	DCX	H
	MVI	M,'B'
DASM35	LDA	OPTDEL
	ORA	A		;AUTO DELETE OPTION ?
	JNZ	DASMB4		;JUMP IF SO
	LXI	D,HEXFCB
	CALL	OPEN		;OPEN HEX FILE
	CPI	-1
	JZ	DASMB4		;JUMP IF NOT FOUND
	LXI	H,DOLDHX
	CALL	PTRMNL		;ASK TO DELETE HEX
	CALL	INCH		;GET RESPONSE
	ANI	5FH		;ENSURE UPPER CASE
	CPI	'Y'
	JNZ	PEXIT1		;EXIT IF NOT YES
DASMB4	LXI	D,HEXFCB
	CALL	DELETE		;DELETE EXISTING HEX
	MVI	C,MAKEF		;CREATE NEW HEX FILE
	CALL	BDOS
	CPI	-1
	JZ	NDSPC		;JUMP IF AN ERROR
	XRA	A
	STA	HEXFCB+32	;CLEAR NR BYTE

* NOW SETUP PRN FILE

DASMB5	LDA	OPTPRN
	ORA	A		;PRINT OPTION ON ?
	JZ	CONTRL		;JUMP IF NOT
	LXI	D,PRNFCB
	CALL	XFRSRC		;COPY SOURCE NAME
	LXI	H,PRNFCB+9	;SET IN 'PRN' EXTENSION
	MVI	M,'P'
	INX	H
	MVI	M,'R'
	INX	H
	MVI	M,'N'
	LDA	OPTDEL		;AUTO DELETE OPTION ON ?
	ORA	A
	JNZ	DASMB6		;JUMP IF SO
	LXI	D,PRNFCB
	CALL	OPEN		;OPEN PRN FILE
	CPI	-1
	JZ	DASMB6		;JUMP IF NOT FOUND
	LXI	H,DOLDPR
	CALL	PTRMNL		;ASK TO DELETE PRN FILE
	CALL	INCH		;GET RESPONSE
	ANI	5FH		;ENSURE UPPER CASE
	CPI	'Y'
	JNZ	PEXIT1		;EXIT IF NOT YES
DASMB6	LXI	D,PRNFCB
	CALL	DELETE		;DELETE EXISTING PRN FILE
	MVI	C,MAKEF		;CREATE PRN FILE
	CALL	BDOS
	CPI	-1
	JZ	NDSPC		;JUMP IF ERROR
	XRA	A
	STA	PRNFCB+32	;CLEAR NR BYTE

* ACTUAL CONTROL ROUTINE FOR ASSEMBLER.
* AT THIS POINT THE FILES HAVE ALL BEEN PROPERLY
* OPENED, AND IT IS NOW TIME TO FILL THE BUFFER
* AND PERFORM THE ASSEMBLY PASSES AS REQUIRED.

CONTRL	LXI	H,RAMBEG
	SHLD	SYMBEG		;SET SYMBOL TABLE BEGIN
	LHLD	BDOS+1
	DCR	H
	SHLD	BUFEND		;SET BUFFER END
	CALL	SIZE		;DETERMINE END OF SYM TBL
	SHLD	SYMEND		;SET IT
	INX	H
	SHLD	SRCBEG		;SET SOURCE BEGIN
	XRA	A
	STA	JNKCNT		;CLEAR JUNK COUNT
	CALL	P1INIT		;DO PASS 1 INITIALIZATION
	XRA	A
	STA	ALLIN
CNTRL1	CALL	FILLBF		;FILL BUFFER FROM DISK
	SHLD	SRCEND		;SET SOURCE END
	CALL	PASS1		;DO PASS 1
	LDA	ENDFLG
	ORA	A		;WAS END STATEMENT HIT ?
	JNZ	CNTRL2		;SKIP IF SO
	LDA	ALLIN		;MORE SOURCE ON DISK ?
	ORA	A
	JZ	CNTRL1		;LOOP IF SO
CNTRL2	MVI	B,09
	LXI	D,AUXOPT
	LXI	H,OPTSYM
CNTRL3	LDAX	D		;NOW SET IN OPTIONS
	ORA	A		;SPECIFIED IN THE COMMAND
	JZ	CNTRL4		;LINE AND STORED IN AUXOPT
	ANI	80H
	MOV	M,A
CNTRL4	INX	D
	INX	H
	DCR	B
	JNZ	CNTRL3
	LDA	OPTLST		;IS LIST OPTION OFF ?
	ORA	A
	JNZ	CTRL45		;SKIP IF NOT
	CMA			;TURN ON LINE NUMBERS
	STA	OPTNUM		;IF LIST OPTION IS OFF
CTRL45	XRA	A		;SETUP SOURCE FOR REWIND
	STA	SRCFCB+12
	STA	SRCFCB+15
	STA	SRCFCB+32
	LXI	D,SRCFCB
	CALL	OPEN		;RE-OPEN (REWIND) SOURCE
	CPI	-1
	JZ	OPENER		;JUMP IF ERROR
	MVI	A,7FH
	STA	SRCBUF
	CALL	P2INIT		;DO PASS 2 INITIALIZATION
	XRA	A
	STA	ALLIN
CNTRL5	CALL	FILLBF		;FILL BUFFER FROM DISK
	SHLD	SRCEND		;SET SOURCE END
	CALL	PASS2		;DO PASS 2
	LDA	ENDFLG
	ORA	A		;WAS END STATEMENT HIT ?
	JNZ	DONE		;EXIT IF SO
	LDA	ALLIN
	ORA	A		;ANY MORE SOURCE ?
	JZ	CNTRL5		;LOOP IF SO
	CALL	ENDUP		;ELSE, FINISH UP

* EXIT FROM ASSEMBLER ROUTINE

DONE	LDA	OPTBIN		;IS BIN FILE ON ?
	ORA	A
	CNZ	CLSOBJ		;CLOSE IF SO
	LDA	OPTTAP		;IS HEX FILE OPTION ON ?
	ORA	A
	CNZ	CLSOBJ		;CLOSE HEX FILE IF SO
	LDA	OPTPRN		;IS PRN FILE OPTION ON ?
	ORA	A
	CNZ	CLSPRN		;CLOSE PRN FILE IF SO

	JMP	WARMS		;RE-BOOT DOS

* DETERMINE SYMBOL TABLE END ADDRESS

SIZE	LDA	STSIZE		;GET SIZE BYTE
	MOV	D,A		;SET INTO DE
	MVI	E,00
	LHLD	SYMBEG		;GET TABLE BEGIN
	DAD	D		;ADD LENGTH
	XCHG
	LHLD	BUFEND		;GET BUFFER END
	DCR	H		;RESERVE AT LEAST 256 BYTES
	CALL	CMPDH		;ENOUGH ROOM ?
	RC			;RETURN IF NOT
	XCHG
	RET

* ROUTINE TO FILL BUFFER FROM DISK

FILLBF	LHLD	BUFEND		;GET END ADDRESS
	XCHG
	LHLD	SRCBEG		;GET BEGIN ADDRESS
FILBF4	CALL	READCH		;READ A CHARACTER
	JC	FILBF7
	CPI	1AH		;END OF FILE
	JZ	FILBF7		;JUMP IF END OF FILE
	CPI	0DH
	JZ	FILBF6		;JUMP IF A RETURN
	CPI	09		;A TAB CHARACTER ?
	JZ	FILBF5		;ACCEPT TABS
	CPI	20H		;A CONTROL CHARACTER ?
	JC	FILBF4		;IGNORE IF SO
FILBF5	MOV	M,A		;PUT CHAR IN MEMORY
	INX	H
	JMP	FILBF4		;LOOP BACK
FILBF6	MOV	M,A		;PUT CR IN MEMORY
	INX	H
	CALL	CMPDH		;IS BUFFER FULL ?
	JC	FILBF4		;LOOP IF NOT
	JMP	FILBF8
FILBF7	MVI	A,01		;SET ALL IN FLAG
	STA	ALLIN
FILBF8	DCX	H
	MOV	A,M		;FIND LAST CR
	CPI	0DH
	JNZ	FILBF8
	RET			;RETURN POINTING TO IT

* CLOSE FILE ROUTINES

CLSOBJ	XRA	A
	STA	PRN		;SET HEX FILE FLAG
	JMP	CLOSE
CLSPRN	MVI	A,01
	STA	PRN		;SET PRN FILE FLAG
CLOSE	MVI	A,1AH		;END OF FILE
	CALL	WRTCH		;WRITE AN END OF FILE
	LXI	H,HEXBUF	;POINT TO PROPER BUFFER
	LDA	PRN		;DEPENDING ON THE STATE
	ORA	A		;OF THE PRN FLAG
	JZ	CLOSE1
	LXI	H,PRNBUF
CLOSE1	MOV	A,M
	ORA	A		;IS DMA BUFFER FULL ?
	JZ	CLOSE2		;JUMP IF SO
	MVI	A,1AH		;END OF FILE
	CALL	WRTCH		;PUT IN AN END OF FILE
	JMP	CLOSE1		;LOOP TILL FULL
CLOSE2	LXI	D,HEXFCB	;GET PROPER FCB ADDRESS
	LDA	PRN
	ORA	A
	JZ	CLOSE3
	LXI	D,PRNFCB
CLOSE3	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,CLOSEF	;CLOSE THE FILE
	CALL	BDOS
	CPI	-1
	RNZ
	LXI	H,CERR		;REPORT ANY ERROR
	CALL	PTRMNL
	RET

* READ A CHARACTER FROM DISK

READCH	PUSH	H		;SAVE HL
	LXI	H,SRCBUF	;GET SOURCE DMA BUFFER
	INR	M		;INCR DMA BUFFER PTR
	MOV	A,M
	CPI	80H		;IS BUFFER DEPLETED ?
	JNZ	READC3		;SKIP IF NOT
RDDSK	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	INX	H		;ADJUST BUFFER POINTER
	XCHG
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,SRCFCB	;GET SOURCE FCB ADDRESS
	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,READF		;READ A SECTOR
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	CPI	00
	JZ	READC2		;SKIP IF NO ERRORS
	CPI	01		;READ PAST EOF ?
	JNZ	RDERR		;SKIP IF NOT
	MVI	M,7FH		;SET BYTES
	MVI	A,1AH		;END OF FILE
	POP	H		;RESTORE HL
	STC			;SET ERROR FLAG
	RET
READC2	MOV	M,A		;SET DMA BUFFER POINTER
READC3	INX	H
	CALL	ADAHL		;GET BYTE ADDRESS
	MOV	A,M		;GET THE CHARACTER
	ORA	A		;CLEAR CARRY
	POP	H		;RESTORE HL
	RET
RDERR	LXI	H,RERR		;REPORT READ ERROR
	CALL	PTRMNL
	JMP	DONE		;EXIT ASSEMBLER

* WRITE A CHARACTER TO DISK

WRTCH	PUSH	H
	PUSH	PSW		;SAVE THE CHARACTER
	LXI	H,HEXBUF	;GET PROPER BUFFER ADDRESS
	LDA	PRN		;DEPENDING ON THE STATE
	ORA	A		;OF THE PRN FLAG
	JZ	WRTCH1
	LXI	H,PRNBUF
WRTCH1	INR	M		;INCR DMA BUFFER PTR
	MOV	A,M
	CPI	80H		;IS BUFFER FULL ?
	JNZ	WRTCH3		;SKIP IF NOT
WRDSK	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	INX	H
	XCHG
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,HEXFCB	;GET PROPER FCB ADDRESS
	LDA	PRN
	ORA	A
	JZ	WRDSK1
	LXI	D,PRNFCB
WRDSK1	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,WRITEF	;WRITE A SECTOR
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	CPI	00		;ANY ERRORS ?
	JZ	WRTCH2		;SKIP IF NOT
	CPI	02		;IS DISK FULL ?
	JNZ	WRDSK2		;SKIP IF NOT
	LXI	H,DFERR		;POINT TO FULL STRING
	JMP	WRDSK3
WRDSK2	LXI	H,WERR		;POINT TO ERROR STRING
WRDSK3	CALL	PTRMNL		;PRINT IT
	POP	PSW		;ADJUST STACK
	POP	PSW
	POP	PSW
	JMP	DONE		;EXIT THE ASSEMBLER
WRTCH2	MOV	M,A		;SET DMA BUFFER PTR
WRTCH3	INX	H
	CALL	ADAHL		;GET CHARACTER ADDRESS
	POP	PSW		;RESTORE THE CHARACTER
	MOV	M,A		;PUT IT IN BUFFER
	POP	H
	RET

* GET FILE SPECIFICATION ROUTINE

GETFN	PUSH	D
	PUSH	H
	XCHG
	SHLD	FCBADR		;SAVE FCB ADDRESS
	MOV	D,H
	MOV	E,L
	MVI	A,33
	CALL	ADAHL		;POINT TO DRIVE NUMBER
	LDA	LOGDR
	MOV	M,A		;SET TO LOGIN DRIVE
	LXI	H,CLRFCB
	CALL	XFR16		;INITIALIZE THE FCB
	POP	H
	POP	D
	INX	D		;POINT TO FCB NAME
	INX	H		;POINT TO 2ND CHAR
	MOV	A,M
	CPI	':'		;IS IT DRIVE SEPARATOR ?
	JZ	SETDRV		;IF SO, SET DRIVE
	DCX	H		;ELSE BACKUP POINTER
GETFN3	MOV	A,M		;GET A CHARACTER
	CALL	VALID2		;A VALID LETTER ?
	JNC	GFNERR		;ERROR IF NOT
	MVI	C,08		;SET MAX LENGTH
	CALL	GETNM		;GET THE NAME
	JC	GFNERR		;JUMP IF ERROR
	CPI	'.'		;WAS DELIMITER A PERIOD ?
	JNZ	DFTEXT		;DEFAULT EXTENSION IF NOT
	INX	H		;PASS UP PERIOD
GETFN4	XCHG
	LHLD	FCBADR		;GET EXTENSION ADDRESS
	MVI	A,09		;WITHIN THE FCB
	CALL	ADAHL
	XCHG
	MVI	C,03		;SET MAX LENGTH
	CALL	GETNM		;GET EXTENSION
	JC	GFNERR		;SKIP IF ERROR
	CPI	'.'		;CHECK TERMINATOR
	JZ	GFNERR		;PERIOD IS INVALID
	ORA	A		;CLEAR CARRY
GETFN5	XCHG
	LHLD	FCBADR		;RESTORE FCB ADDRESS
	XCHG
	RET
GFNERR	STC			;SET ERROR FLAG
	JMP	GETFN5		;GO RESTORE FCB ADDRESS
DFTEXT	PUSH	H
	LXI	H,EXT		;POINT TO DEFAULT EXT
	CALL	GETFN4		;COPY INTO FCB
	POP	H
	RET
SETDRV	DCX	H		;POINT TO DRIVE CHAR
	MOV	A,M
	SUI	'A'		;CHECK FOR A TO D
	JC	GFNERR
	CPI	04
	JNC	GFNERR		;ERROR IF NOT
	PUSH	H
	PUSH	PSW
	LHLD	FCBADR		;PUT IN DRIVE NUMBER
	MVI	A,33		;POSITION OF FCB
	CALL	ADAHL
	POP	PSW
	MOV	M,A
	POP	H
	INX	H
	INX	H
	JMP	GETFN3		;NOW GET NAME

* GET NAME FROM HL INTO DE

GETNM	INR	C
GETNM1	MOV	A,M		;GET A CHARACTER
	CALL	VALID		;A VALID NAME CHARACTER ?
	JNC	GETNM2		;EXIT IF NOT
	DCR	C		;DECR MAX COUNT
	JZ	SETCRY		;AN ERROR IF HIT MAX
	STAX	D		;PUT IN FCB
	INX	D
	INX	H
	JMP	GETNM1		;GO GET NEXT CHAR
GETNM2	CALL	ISTERM		;SPC LEFTBRACKET , . OR CR ?
	JC	CLRCRY		;RETURN IF ONE OF ABOVE
	STC			;SET ERROR FLAG IF NOT
	RET

* CHECK FOR NAME TERMINATOR

ISTERM	CPI	5BH		;LEFT BRACKET
	JZ	SETCRY		;LEFT BRACKET IS GOOD
	CPI	'.'
	JZ	SETCRY		;PERIOD IS GOOD
ISTRM1	CPI	' '
	JZ	SETCRY		;SPACE IS GOOD
	CPI	','
	JZ	SETCRY		;COMMA IS GOOD
	CPI	0DH
	JZ	SETCRY		;RETURN IS GOOD
CLRCRY	ORA	A		;ELSE NOT A DELIMITER
	RET
SETCRY	STC
	RET

* CHECK FOR A VALID FILE NAME CHARACTER

VALID	CPI	'-'
	JZ	SETCRY		;HYPHEN IS VALID
	CPI	5FH		;UNDERSCORE
	JZ	SETCRY		;UNDERSCORE IS VALID
VALID1	CPI	'0'		;CHECK FOR A DIGIT
	JC	VALID2
	CPI	'9'+1
	JC	SETCRY		;A VALID DIGIT
VALID2	CPI	61H		;CHECK FOR LOWER CASE
	JC	VALID3
	CPI	7BH
	JNC	VALID3
	SUI	20H		;CONVERT TO UPPER CASE
VALID3	CPI	'A'		;CHECK FOR A LETTER
	JC	CLRCRY
	CPI	'Z'+1
	JC	SETCRY		;A VALID LETTER
	ORA	A
	RET

* SKIP SPACES AND ONE COMMA

SKIP	CALL	SKPSP		;SKIP SPACES
	CPI	','		;IS NEXT CHAR A COMMA ?
	RNZ			;RETURN IF NOT
	INX	H		;ELSE, PASS IT UP
	CALL	SKPSP		;SKIP SPACES
	RET

* SELECT THE PROPER DRIVE

SELECT	PUSH	D		;SAVE FCB ADDRESS
	XCHG
	MVI	A,33		;GET DRIVE NUMBER FROM FCB
	CALL	ADAHL
	MOV	E,M		;PUT IN E
	MVI	C,SLECTF	;SELECT THAT DRIVE
	CALL	BDOS
	POP	D		;RESTORE FCB ADDRESS
	RET

* OPEN FILE ROUTINE

OPEN	CALL	SELECT		;SELECT THE FILE
	MVI	C,OPENF		;OPEN THE FILE
	CALL	BDOS
	RET

* DELETE FILE ROUTINE

DELETE	PUSH	D		;SAVE FCB ADDRESS
	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,DELETF	;DELETE THE FILE
	CALL	BDOS
	POP	D		;RESTORE FCB ADDRESS
	RET

* PRINT STRING TO TERMINAL

PTRMNL	LDA	OPTOUT
	PUSH	PSW		;SAVE OUTPUT OPTION
	LDA	OPTPRN
	PUSH	PSW		;SAVE PRINT FILE OPTION
	XRA	A
	STA	OPTOUT		;CLEAR THEM
	STA	OPTPRN
	CMA
	STA	OUTFLG		;ENSURE PRINTING ON
	CALL	PSTRG		;PRINT THE STRING
	POP	PSW		;RESTORE THE OPTIONS
	STA	OPTPRN
	POP	PSW
	STA	OPTOUT
	RET

* TRANSFER FROM HL TO DE

XFRSRC	LXI	H,SRCFCB
XFR16	MVI	B,16		;SET COPY COUNT
TRNSFR	MOV	A,M		;GET CHAR FROM HL
	INX	H
	STAX	D		;STORE AT DE
	INX	D
	DCR	B
	JNZ	TRNSFR		;LOOP UNTIL DONE
	RET


**************************************************
*
* EXTERNAL I/O ROUTINES
*
OUTCH	PUSH	H		;OUTPUT CHARACTER ROUTINE
	PUSH	D
	PUSH	B
	PUSH	PSW
	LDA	OPTPRN		;PRINT OPTION ON ?
	ORA	A
	JZ	DOUTC1		;SKIP IF NOT
	STA	PRN
	POP	PSW		;GET THE CHARACTER
	PUSH	PSW
	CALL	WRTCH		;SEND TO DISK
	JMP	DOUTC2
DOUTC1	LDA	OPTOUT		;OUTPUT TO LISTER ON ?
	ORA	A
	JZ	DOUTC3		;SKIP IF NOT
	POP	PSW		;GET THE CHARACTER
	PUSH	PSW
	MOV	E,A
	MVI	C,05		;WRITE LIST FUNCTION
	CALL	BDOS
DOUTC2	LDA	OPTECH		;ECHO OPTION ON ?
	ORA	A
	JZ	DOUTC4		;SKIP IF NOT
DOUTC3	POP	PSW		;GET THE CHARACTER
	PUSH	PSW
	MOV	E,A
	MVI	C,02		;WRITE CONSOLE FUNCTION
	CALL	BDOS
DOUTC4	POP	PSW		;RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET

INCH	PUSH	H		;INPUT CHARACTER ROUTINE
	PUSH	D
	PUSH	B
	MVI	C,01		;READ CONSOLE FUNCTION
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	RET

TOUCH	PUSH	PSW		;HEX FILE CHAR ROUTINE
	XRA	A
	STA	PRN		;SET HEX FILE FLAG
	POP	PSW		;GET THE CHARACTER
	CALL	WRTCH		;WRITE TO DISK
	RET

WARMS	LDA	LOGDR		;GET DRIVE WHICH WAS
	MOV	E,A		;LOGGED IN ON ENTRY
	MVI	C,SLECTF	;SELECT IT
	CALL	BDOS
	JMP	0000		;WARM REBOOT


* CHECK FOR INPUT ROUTINE.
* THIS ROUTINE SHOULD CHECK THE TERMINAL INPUT
* DEVICE FOR A CHARACTER BEING INPUT.  IF NONE,
* THE CARRY IS CLEARED AND A RETURN IS EXECUTED.
* IF A CHARACTER HAS BEEN HIT, IT IS PLACED IN THE
* A REGISTER WITH ITS PARITY BIT CLEARED, THE
* CARRY IS SET TO INDICATE INPUT, AND A RETURN IS
* PERFORMED.  IN EITHER CASE, ONLY THE A REGISTER
* MAY BE ALTERED.

CHKIN	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	MVI	C,11		;CONSOLE READY FUNCTION
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	RAR			;GET STATUS INTO CARRY
	RNC			;RETURN IF NOT READY
	CALL	INCH		;ELSE, GET CHARACTER
	STC
	RET

**************************************************

* OUTPUT A CHARACTER IF OUTFLG IS SET.
* THIS ROUTINE OUTPUTS THE CHARACTER IN THE A
* REGISTER AND RETURNS, PROVIDED THAT OUTFLG
* IS SET.  IF NOT SET, WE SIMPLY RETURN.
* USES A.

OUTCHR	PUSH	PSW		;SAVE THE CHARACTER
	LDA	OUTFLG
	ORA	A		;IS PRINTING ON ?
	JNZ	OUTCH1		;SKIP IF SO
	POP	PSW		;FIX STACK
	RET
OUTCH1	POP	PSW		;RESTORE THE CHARACTER
	CALL	OUTCH		;PRINT IT
	RET

* TYPE TABLE

TYPTBL	DW	TYPE0		;MACHINE OP W/ NO OPERAND
	DW	TYPE1		;W/ SINGLE REGISTER SPECS
	DW	TYPE2		;W/ REGISTER PAIR SPECS
	DW	TYPE3		;W/ 8 BIT DATA
	DW	TYPE4		;W/16 BIT DATA
	DW	OPSPC		;SPACE PSEUDO-OP
	DW	OPPAGE		;PAGE EJECT PSEUDO-OP
	DW	OPOPT		;SET OPTIONS PSEUDO-OP
	DW	OPTTL		;TITLE PSEUDO-OP
	DW	OPORG		;ORG PSEUDO-OP
	DW	OPDS		;DEFINE STORAGE PSEUDO-OP
	DW	DBDW		;DEFINE BYTE PSEUDO-OP
	DW	DBDW		;DEFINE BYTE PSEUDO-OP
	DW	OPSEQ		;SET PSEUDO-OP
	DW	OPSEQ		;EQUATE PSEUDO-OP
	DW	OPEND		;END PSEUDO-OP

* PRINT TABLE

PRTTBL	DW	PRT1
	DW	PRT2
	DW	PRT0
	DW	PRT0
	DW	PRT3
	DW	PRT2
	DW	PRT0

* COMMAND OPTION LIST

CMDOPT	DB	'S',70H
	DB	'G',71H
	DB	'L',72H
	DB	'H',75H
	DB	'N',0F8H
	DB	'P',0F9H
	DB	'E',0FAH
	DB	'D',0FBH
	DB	'O',0FCH
	DB	'B',0FDH
	DB	00

* REGISTER TABLE

REGTBL	DB	'A',07
	DB	'B',00
	DB	'C',01
	DB	'D',02
	DB	'E',03
	DB	'H',04
	DB	'L',05
	DB	'M',06
	DB	'S',86H
	DB	'P',16H
	DB	'F',16H
	DB	00

* OPTION TABLE

OPTTBL	DB	'NOS'
	DB	'NOG'
	DB	'NOL'
	DB	'NOP'
	DB	'NOM'
	DB	'NOT'
	DB	'OCT'
	DB	'NOE'
	DB	'NON'
	DB	-1
	DB	'SYM'
	DB	'GEN'
	DB	'LST'
	DB	'PAG'
	DB	'NOM'
	DB	'NOT'
	DB	'HEX'
	DB	'EXP'
	DB	'NUM'
	DB	00

******************************************************
* MNEMONIC AND OPCODE TABLE
*    THIS TABLE HAS THREE PARTS TO EACH ENTRY:
*    1) A VARIABLE LENGTH ASCII MNEMONIC.
*    2) ONE BYTE CONTAINING THE BYTE COUNT IN THE LEFT
*       HALF AND THE TYPE IN THE RIGHT HALF.  THE 8TH
*       BIT IS SET TO TERMINATE THE MNEMONIC STRING.
*    3) THE ACTUAL OPCODE (IF ANY).
******************************************************

OPCTBL	DB	'ACI'
	DB	0A3H
	DB	0CEH
	DB	'ADC'
	DB	91H
	DB	88H
	DB	'ADD'
	DB	91H
	DB	80H
	DB	'ADI'
	DB	0A3H
	DB	0C6H
	DB	'ANA'
	DB	91H
	DB	0A0H
	DB	'ANI'
	DB	0A3H
	DB	0E6H
	DB	'CALL'
	DB	0B4H
	DB	0CDH
	DB	'CC'
	DB	0B4H
	DB	0DCH
	DB	'CM'
	DB	0B4H
	DB	0FCH
	DB	'CMA'
	DB	90H
	DB	2FH
	DB	'CMC'
	DB	90H
	DB	3FH
	DB	'CMP'
	DB	91H
	DB	0B8H
	DB	'CNC'
	DB	0B4H
	DB	0D4H
	DB	'CNZ'
	DB	0B4H
	DB	0C4H
	DB	'CP'
	DB	0B4H
	DB	0F4H
	DB	'CPE'
	DB	0B4H
	DB	0ECH
	DB	'CPI'
	DB	0A3H
	DB	0FEH
	DB	'CPO'
	DB	0B4H
	DB	0E4H
	DB	'CZ'
	DB	0B4H
	DB	0CCH
	DB	'DAA'
	DB	90H
	DB	27H
	DB	'DAD'
	DB	92H
	DB	09
	DB	'DB'
	DB	8BH
	DB	00
	DB	'DCR'
	DB	91H
	DB	05
	DB	'DCX'
	DB	92H
	DB	0BH
	DB	'DI'
	DB	90H
	DB	0F3H
	DB	'DS'
	DB	8AH
	DB	00
	DB	'DW'
	DB	8CH
	DB	00
	DB	'EI'
	DB	90H
	DB	0FBH
	DB	'EJECT'
	DB	86H
	DB	00
	DB	'END'
	DB	8FH
	DB	00
	DB	'EQU'
	DB	8EH
	DB	00
	DB	'HLT'
	DB	90H
	DB	76H
	DB	'IN'
	DB	0A3H
	DB	0DBH
	DB	'INR'
	DB	91H
	DB	04
	DB	'INX'
	DB	92H
	DB	03
	DB	'JC'
	DB	0B4H
	DB	0DAH
	DB	'JHS'
	DB	0B4H
	DB	0D2H
	DB	'JLO'
	DB	0B4H
	DB	0DAH
	DB	'JM'
	DB	0B4H
	DB	0FAH
	DB	'JMP'
	DB	0B4H
	DB	0C3H
	DB	'JNC'
	DB	0B4H
	DB	0D2H
	DB	'JNZ'
	DB	0B4H
	DB	0C2H
	DB	'JP'
	DB	0B4H
	DB	0F2H
	DB	'JPE'
	DB	0B4H
	DB	0EAH
	DB	'JPO'
	DB	0B4H
	DB	0E2H
	DB	'JZ'
	DB	0B4H
	DB	0CAH
	DB	'LDA'
	DB	0B4H
	DB	3AH
	DB	'LDAX'
	DB	92H
	DB	0AH
	DB	'LHLD'
	DB	0B4H
	DB	2AH
	DB	'LXI'
	DB	0B2H
	DB	01
	DB	'MOV'
	DB	91H
	DB	40H
	DB	'MVI'
	DB	0A1H
	DB	06
	DB	'NOP'
	DB	90H
	DB	00
	DB	'OPT'
	DB	87H
	DB	00
	DB	'ORA'
	DB	91H
	DB	0B0H
	DB	'ORG'
	DB	89H
	DB	00
	DB	'ORI'
	DB	0A3H
	DB	0F6H
	DB	'OUT'
	DB	0A3H
	DB	0D3H
	DB	'PAGE'
	DB	86H
	DB	00
	DB	'PCHL'
	DB	90H
	DB	0E9H
	DB	'POP'
	DB	92H
	DB	0C1H
	DB	'PUSH'
	DB	92H
	DB	0C5H
	DB	'RAL'
	DB	90H
	DB	17H
	DB	'RAR'
	DB	90H
	DB	1FH
	DB	'RC'
	DB	90H
	DB	0D8H
	DB	'RET'
	DB	90H
	DB	0C9H
	DB	'RLC'
	DB	90H
	DB	07
	DB	'RM'
	DB	90H
	DB	0F8H
	DB	'RNC'
	DB	90H
	DB	0D0H
	DB	'RNZ'
	DB	90H
	DB	0C0H
	DB	'RP'
	DB	90H
	DB	0F0H
	DB	'RPE'
	DB	90H
	DB	0E8H
	DB	'RPO'
	DB	90H
	DB	0E0H
	DB	'RRC'
	DB	90H
	DB	0FH
	DB	'RST'
	DB	93H
	DB	0C7H
	DB	'RZ'
	DB	90H
	DB	0C8H
	DB	'SBB'
	DB	91H
	DB	98H
	DB	'SBI'
	DB	0A3H
	DB	0DEH
	DB	'SET'
	DB	8DH
	DB	00
	DB	'SHLD'
	DB	0B4H
	DB	22H
	DB	'SPACE'
	DB	85H
	DB	00
	DB	'SPC'
	DB	85H
	DB	00
	DB	'SPHL'
	DB	90H
	DB	0F9H
	DB	'STA'
	DB	0B4H
	DB	32H
	DB	'STAX'
	DB	92H
	DB	02
	DB	'STC'
	DB	90H
	DB	37H
	DB	'SUB'
	DB	91H
	DB	90H
	DB	'SUI'
	DB	0A3H
	DB	0D6H
	DB	'TITLE'
	DB	88H
	DB	00
	DB	'TTL'
	DB	88H
	DB	00
	DB	'XCHG'
	DB	90H
	DB	0EBH
	DB	'XRA'
	DB	91H
	DB	0A8H
	DB	'XRI'
	DB	0A3H
	DB	0EEH
	DB	'XTHL'
	DB	90H
	DB	0E3H
	DB	0,0,0,0,0,0,0
*******************************

* PRINT STRINGS

CRLF	DB	0DH,0AH,4,0,0,0,0
EJSTR	DB	0DH,0CH,4,0,0
ERRHD	DB	'**   ',4
ASMMSG	DB	'         TSC 8080 ASSEMBLER   PAGE',4
ERRDET	DB	' ERROR(S) DETECTED',4
SYMHD	DB	'SYMBOL TABLE:',4

* ERROR MESSAGES

ERRM0	DB	'SYMBOL TABLE FULL',4
ERRM1	DB	'UNDEFINED SYMBOL',4
ERRM2	DB	'MULTIPLY DEFINED SYMBOL',4
ERRM3	DB	'UNRECOGNIZABLE MNEMONIC',4
ERRM4	DB	'ILLEGAL SYMBOL',4
ERRM5	DB	'ILLEGAL OPERAND',4
ERRM6	DB	'SYNTAX ERROR',4
ERRM7	DB	'ILLEGAL REGISTER SPECIFICATION',4
ERRM8	DB	'ILLEGAL CONSTANT',4
ERRM9	DB	'ILLEGAL OPTION SWITCH',4

* DISK STRINGS

BSECHO	DB	08,4,0,0,0
CNECHO	DB	07,4,0,0,0

EXT	DB	'TXT '
CLRFCB	DB	0,'           ',0,0,0,0

MESSG	DB	'TSC ASSEMBLER',4
LASTB	DB	'LAST ADDRESS',4
DOLDHX	DB	'DELETE EXISTING OBJECT FILE (Y-N)? ',4
DOLDPR	DB	'DELETE EXISTING PRN FILE (Y-N)? ',4
OPTERR	DB	'OPTION ERROR',4
FNFERR	DB	'FILE NOT FOUND',4
NDSERR	DB	'NO DIRECTORY SPACE',4
DFERR	DB	'DISK FULL',4
OFERR	DB	'OPEN FILE ERROR',4
IFSERR	DB	'ILLEGAL FILE SPECIFICATION',4
CERR	DB	'CLOSE ERROR',4
WERR	DB	'WRITE ERROR',4
RERR	DB	'READ ERROR',4


***
*
* PASS ONE INITIALIZATION ROUTINE
* SETS UP ASSEMBLER FOR PASS ONE
* USES ALL
*
***

P1INIT	LHLD	SYMEND		;GET SYMBOL TABLE PTRS
	XCHG
	LHLD	SYMBEG
	CALL	NEGRP
	DAD	D		;TAKE SYMEND - SYMBEG
	INX	H
	MOV	A,L
	ANI	0F8H		;TRUNCATE SYM TBL TO * 8
	MOV	L,A
	DCX	H
	XCHG			;SAVE IN DE
	LHLD	SYMBEG
	DAD	D		;GET NEW SYM TBL END
	SHLD	SYMEND		;SAVE IT AWAY
	MOV	A,D		;DETERMINT APPROX NBR OF
	MVI	B,04		;K IN SYMBOL TABLE
	CMP	B		;1K
	JC	P1INT1
	MVI	B,08		;2K
	CMP	B
	JC	P1INT1
	MVI	B,16		;4K
	CMP	B
	JC	P1INT1
	MVI	B,32		;8K
	CMP	B
	JC	P1INT1
	MVI	B,64		;16K
P1INT1	DCR	B
	MOV	A,B		;APPROX SYM TBL SIZE IN K
	STA	SYMTBK		;SAVE IT
	MVI	A,-1
	STA	OPTLST		;SET OPTION FLAGS
	STA	OPTGEN
	STA	OPTSYM
	STA	OPTHEX
	STA	OPTEXP
	STA	OPTTAP
	XRA	A
	STA	OPTPAG		;CLEAR FLAGS
	STA	OPTNUM
	STA	ENDFLG
	XCHG
	LHLD	SYMBEG
CLRSYM	MVI	M,00		;CLEAR OUT SYMBOL TABLE
	INX	H
	CALL	CMPDH		;DONE YET ?
	JNZ	CLRSYM		;LOOP IF NOT
	MVI	M,00
	LXI	H,TITLL
	MVI	B,32
	MVI	A,' '
	CALL	CLEAR		;CLEAR OUT TITLE
	MVI	M,04		;SET EOT FOR TITLE
	LXI	H,0000
	SHLD	LC		;CLEAR LOCATION COUNTER
	RET

***
*
* PASS ONE ROUTINE
*    PERFORMS ASSEMBLY PASS #1
*  USES ALL
*
***

PASS1	XRA	A
	STA	PASS		;SET PASS ONE
	LHLD	SRCBEG		;POINT TO BEGIN OF SOURCE
	DCX	H
PASS1A	CALL	GETLIN		;GET A LINE OF SOURCE
	CALL	PARSE		;PARSE IT
	LHLD	LC
	XCHG
	LHLD	BYTES		;GET NBR OF BYTES IN INSTR
	DAD	D		;ADD TO LOCATION COUNTER
	SHLD	LC		;SAVE NEW LC
	CALL	FNDCR		;FIND END OF LINE
	LDA	ENDFLG		;CHECK FOR END FLAG
	ORA	A
	RNZ			;FINISHED PASS 1 IF SET
	XCHG
	LHLD	SRCEND
	XCHG
	CALL	CMPDH		;AT END OF SOURCE ?
	JC	PASS1A		;LOOP IF NOT
	RET			;EXIT IF SO

***
*
* PASS TWO INITIALIZATION ROUTINE
*    PERFORMS INITIALIZATION FOR PASS #2
*  USES ALL
*
***

P2INIT	XRA	A
	STA	PAGENO		;CLEAR PAGE NUMBER
	STA	PAGENO+1
	CMA
	STA	OUTFLG		;SET PRINT FLAG
	LDA	OPTLST
	ORA	A		;LIST OPTION ON ?
	JZ	P2INT1		;FINISHED IF NOT
	LDA	OPTPAG
	MOV	C,A
	ORA	A		;PAGE OPTION ON ?
	CNZ	EJECT1		;IF SO PRINT TITLE

P2INT1	NOP			;*************************
	NOP			;* SPACE FOR REWIND CALL *
	NOP			;*************************

	XRA	A		;CLEAR FLAGS AND DATA
	STA	ENDFLG
	STA	LINENO
	STA	LINENO+1
	STA	ERRORS
	STA	ERRORS+1
	STA	OBJYET
	STA	BBYTCT
	STA	XFRFLG
	STA	BUFCNT
	STA	P3FLG
	LXI	H,0000
	SHLD	LC		;CLEAR THE LOCATION COUNTER
	RET

***
*
* PASS TWO ROUTINE
*    PERFORMS ASSEMBLY PASS #2
*  USES ALL
*
***

PASS2	MVI	A,01
	STA	PASS		;SET PASS 2 FLAG
	LHLD	SRCBEG		;POINT TO BEGIN OF SOURCE
	DCX	H
PASS2A	CALL	GETLIN		;GET A LINE OF SOURCE
	XCHG
	LHLD	LINENO
	INX	H		;INCR LINE NUMBER
	SHLD	LINENO
	XCHG
	CALL	PARSE		;PARSE AND EXECUTE
	LDA	P3FLG
	ORA	A
	JNZ	PASS2E		;SKIP IF PASS 3
	LDA	DBDWF
	ORA	A		;A DB OR DW INSTRUCTION ?
	JZ	PASS2B		;SKIP IF NOT
	LHLD	OPRPRT		;POINT TO OPERAND
	SHLD	LINPTR
	XRA	A
	STA	DBSIP		;CLEAR DB IN PROGRESS
	CALL	SCAN		;SCAN FOR ERRORS
	LHLD	OPRPRT
	SHLD	LINPTR
	CALL	DBDW		;RE-PARSE THE OPERAND
PASS2B	CALL	ANYERR		;ANY ERRORS ?
	JNZ	PASS2C		;SKIP IF SO
	LDA	OPTLST
	ORA	A		;LIST OPTION ON ?
	JZ	PASS2E		;SKIP IF NOT
PASS2C	CALL	PRTOBJ		;PRINT ADDRESS AND DATA
	LDA	OPTYPE
	CPI	0FFH		;CHECK FOR SPACE OR EJECT
	CNZ	PRTSRC		;PRINT SOURCE IF NOT
PASS2E	LDA	P3FLG
	ORA	A
	JZ	PASS2F		;SKIP IF NOT PASS 3
	CALL	PUNCH		;IF SO, PUNCH OBJECT CODE
	JMP	PASS2G		;FINISH UP LINE
PASS2F	LDA	OPTTAP
	ORA	A		;TAPE OPTION ON ?
	CNZ	PUNCH		;IF SO, PUNCH OBJECT CODE
	LDA	OPTBIN
	ORA	A		;BINARY OPTION ON ?
	CNZ	PUTBIN		;IF SO, GO PUT CODE
PASS2G	LHLD	LC
	XCHG
	LHLD	BYTES
	DAD	D		;ADD NBR OF BYTES TO LC
	SHLD	LC		;SAVE NEW LC
	LDA	DBDWF
	ORA	A		;A DB OR DW INSTRUCTION ?
	JNZ	PASS2J		;SKIP IF SO
PASS2H	CALL	FNDCR		;FIND END OF LINE
	LDA	P3FLG
	ORA	A		;PASS THREE ?
	CZ	PRTERR		;PRINT ANY ERRORS
	LDA	ENDFLG
	ORA	A		;AN END INSTRUCTION ?
	JNZ	ENDUP		;IF SO, GO FINISH
	XCHG
	LHLD	SRCEND
	XCHG
	CALL	CMPDH		;AT END OF SOURCE ?
	JC	PASS2A		;GO DO ANOTHER LINE IF NOT
	RET			;ELSE, FINISHED
PASS2J	LDA	DATA
	ORA	A		;ANY DATA LEFT ?
	JZ	PASS2H		;GO BACK IF NOT
	CALL	DBDW1		;ELSE GET MORE DATA
	LDA	P3FLG
	ORA	A		;PASS THREE ?
	JNZ	PASS2E		;GO PUNCH IF SO
	CALL	ANYERR		;ELSE CHECK FOR ERRORS
	JNZ	PASS2K		;SKIP IF SOME FOUND
	LDA	OPTLST
	ORA	A
	JZ	PASS2E		;SKIP IF LIST OFF
PASS2K	LDA	OPTGEN
	ORA	A		;IS GEN OPTION ON ?
	JZ	PASS2E		;SKIP IF NOT
	CALL	PCRLF
	LDA	OPTNUM
	ORA	A		;IS LINE NBR OPTION ON ?
	JZ	PASS2L		;GO PRINT DATA IF NOT
	CALL	OUT3S		;ELSE, SKIP OVER IT
	CALL	OUT3S
	CALL	OUTSP
PASS2L	CALL	PRT0Z		;NOW PRINT THE DATA
	JMP	PASS2E		;LOOP BACK

***
*
* PASS THREE INITIALIZATION
*    PERFORMS INITIALIZATION FOR PASS #3
*  USES ALL
*
***

P3INIT	JMP	P2INT1		;ALMOST SAME AS PASS 2

***
*
* PASS THREE ROUTINE
*    PERFORMS ASSEMBLY PASS #3 WHICH IS
*    IDENTICAL TO PASS TWO EXCEPT THAT
*    LIST IS ALWAYS OFF AND AN OBJECT
*    CODE TAPE IS ALWAYS PRINTED.
*  USES ALL
*
***

PASS3	MVI	A,01
	STA	P3FLG		;SET PASS THREE FLAG
	JMP	PASS2

* END OF ASSEMBLY CLEAN UP
*    THIS ROUTINE IS EXECUTED AT THE END OF
*    PASS 2 WHEN AN END STATEMENT IS HIT.
*    IT COMPLETES THE PUNCHING OF A TAPE AND
*    THE PUTTING OF CODE INTO MEMORY IF THESE
*    OPTIONS HAVE BEEN SELECTED, PRINTS THE
*    NUMBER OF ERRORS ENCOUNTERED, AND PRINTS
*    A SORTED SYMBOL TABLE IF THAT OPTION IS ON.
*  USES ALL

ENDUP	LDA	P3FLG
	ORA	A		;PASS THREE ?
	JNZ	ENDPUN		;FINISH PUNCH IF SO
	MVI	A,01
	STA	OUTFLG		;TURN PRINT ON
	LDA	OPTECH
	PUSH	PSW		;SAVE ECHO OPTION
	MVI	A,01
	STA	OPTECH		;TURN ON TERMINAL ECHO
	CALL	PCRLF
	CALL	PCRLF
	CALL	OUT3S		;SPACE OVER
	LHLD	ERRORS
	CALL	OUTDC		;PRINT NBR OF ERRORS
	LXI	H,ERRDET
	CALL	PDATA		;PRINT "DETECTED" STRING
	POP	PSW
	STA	OPTECH		;RESTORE ECHO OPTION
	LDA	OPTOUT
	PUSH	PSW		;SAVE OUTPUT OPTION
	LDA	OPTPRN
	PUSH	PSW		;SAVE PRINT FILE OPTION
	XRA	A
	STA	OPTOUT		;CLEAR THEM
	STA	OPTPRN
	CALL	PCRLF		;DO A LINE FEED
	CALL	OUT3S		;SPACE OVER
	CALL	OUT3S
	CALL	OUT3S
	LXI	H,LASTB		;LAST ADDRESS MESSAGE
	CALL	PDATA
	LHLD	LC		;GET LAST ADDRESS
	DCX	H
	CALL	PRTAD0		;PRINT IT
	POP	PSW		;RESTORE OPTIONS
	STA	OPTPRN
	POP	PSW
	STA	OPTOUT
	LDA	OPTTAP
	ORA	A		;CHECK TAPE OPTION
	CNZ	ENDPUN		;FINISH PUNCHING IF ON
	LDA	OPTBIN
	ORA	A		;CHECK BINARY OPTION
	CNZ	ENDBIN		;FINISH PUTTING IF ON
	LDA	OPTSYM
	ORA	A		;CHECK SYMBOL TABLE OPTION
	CNZ	PSYMTB		;PRINT SYMBOL TABLE IF ON
	LDA	OPTLST
	ORA	A		;LIST OPTION ON ?
	RZ			;RETURN IF NOT
	LDA	OPTPAG
	ORA	A		;CHECK PAGE OPTION
	JZ	ENDUP2		;SKIP IF OFF
	LXI	H,EJSTR
	JMP	PDATA		;EJECT AND EXIT
ENDUP2	MVI	B,4
ENDUP3	CALL	PCRLF		;SPACE DOWN
	DCR	B
	JNZ	ENDUP3
	RET

* GET A LINE OF SOURCE INTO RAM
*    IF SOURCE IS BEING ASSEMBLED LINE AT A
*    TIME AND IS TO COME FROM OTHER THAN
*    RAM, REPLACE THESE 3 BYTES WITH A CALL TO
*    A USER-SUPPLIED ROUTINE TO GET A LINE OF
*    SOURCE INTO RAM AND RETURN WITH THE H/L
*    REGISTER POINTING TO THE FIRST BYTE.  ANY
*    OTHER REGISTERS MAY BE TRASHED DURING
*    THIS ROUTINE.

GETLIN	INX	H
	CALL	BREAK
	RET

* PRINT ASSEMBLED CODE FOR 1 LINE
*    DETERMINES TYPE OF DATA TO BE PRINTED
*    AND PRINTS IT ACCORDINGLY.

PRTOBJ	LDA	OPTYPE		;GET OP TYPE
	DCR	A
	JM	PRT0		;INSTR IS NOT A PSEUDO-OP
	ANI	0FEH
	LXI	H,PRTTBL
	CALL	ADAHL
	MOV	A,M		;GET ADDRESS OF PRINT TYPE
	INX	H		;FROM PRINT TABLE
	MOV	H,M
	MOV	L,A
	PCHL		;JUMP TO IT

* PRINT TYPE 0
*    USED FOR NON PSEUDO-OPS, ORG'S,
*    DS'S, DB'S, AND DW'S.  PRINTS
*    ADDRESS AND ANY BYTES OF DATA.

PRT0	CALL	PRTNO		;PRINT LINE NUMBER
PRT0Z	LHLD	LC
	CALL	PRTADR		;PRINT ADDRESS
	LXI	H,OPCODE		;POINT TO CODE
	LDA	OPTYPE
	CPI	06		;IS THIS A DS ?
	JZ	PRT0Y		;SKIP IF SO
	LDA	BYTES		;GET NBR OF BYTES OF CODE
	MOV	B,A
PRT0A	DCR	B		;ANY BYTES LEFT ?
	JM	PRT0B		;SKIP IF NOT
	MOV	A,M		;ELSE, GET A BYTE
	INX	H		;POINT TO NEXT
	CALL	OUTSB		;PRINT A BYTE OF CODE
	JMP	PRT0A		;LOOP BACK
PRT0B	LXI	H,BYTES
PRT0Y	MVI	A,03
	SUB	M		;FIND OUT HOW MANY BYTES
	MOV	B,A		;TO SPACE PAST
PRT0C	DCR	B		;ANY MORE ?
	JM	OUT2S		;EXIT IF NOT
	CALL	SKPBYT		;SPACE PAST 1 BYTE
	JMP	PRT0C		;LOOP BACK

* PRINT TYPE 1
*    USED FOR SPACE AND PAGE PSEUDO-OPS.
*    DOES NO PRINTING, EXCEPT FOR ERRORED LINES.

PRT1	CALL	ANYERR		;CHECK FOR ERRORS
	JNZ	PRT2		;PRINT LINE IF SO
	MVI	A,0FFH
	STA	OPTYPE		;SET FLAG
	RET

* PRINT TYPE 2
*    USED FOR OPT, NAME, TTL, END, AND
*    COMMENT LINES.  PRINTS LINE NUMBER
*    ONLY.

PRT2	CALL	PRTNO		;PRINT LINE NUMBER
	MVI	B,05
	CALL	PRT0C		;SKIP ADDRESS AND DATA
	RET

* PRINT TYPE 3
*    USED FOR SET AND EQUATE.  PRINTS
*    LINE NUMBER AND THEN THE VALUE
*    OF THE SET OR EQUATE.

PRT3	CALL	PRTNO		;PRINT LINE NUMBER
	CALL	SKPBYT		;SPACE OVER SOME
	CALL	SKPBYT
	CALL	SKPBYT
	LHLD	RESULT		;GET VALUE
	CALL	PRTADR		;PRINT IT
	JMP	OUT2S

* PRINT LINE NUMBER
*    PRINTS DECIMAL LINE NUMBER IF THAT OPTION
*    IS SELECTED.

PRTNO	CALL	PCRLF
	LDA	OPTNUM
	ORA	A		;IS LINE NUMBER OPTION ON ?
	RZ			;RETURN IF NOT
	CALL	OUTSP
	LHLD	LINENO
	CALL	OUTDC		;PRINT THE LINE NUMBER
	CALL	OUTSP
	RET

* PRINT ADDRESS
*    PRINTS THE VALUE IN THE H/L REGISTER IN
*    EITHER HEX OR OCTAL DEPENDING ON THE 
*    OPTION SELECTED.
*  USES A

PRTADR	LDA	OPTHEX		;CHECK FOR HEX OR OCT
	ORA	A
	CNZ	OUTSP		;SPACE IF HEX
PRTAD0	MOV	A,H		;GET M.S. BYTE
	CALL	OUTSB		;OUTPUT THE BYTE
	LDA	OPTHEX		;CHECK HEX OR OCT AGAIN
	ORA	A
	JNZ	PRTAD1		;SKIP IF HEX
	MVI	A,'.'	
	CALL	OUTCHR		;PRINT A PERIOD
PRTAD1	MOV	A,L		;GET L.S. BYTE
	CALL	OUTBYT		;PRINT IT
	RET

* OUTPUT A SINGLE BYTE IN HEX OR OCT
*    CHECKS OPTION AND PRINTS THE BYTE
*    IN "A" IN HEX OR OCTAL ACCORDINGLY.
*  USES A

OUTSB	PUSH	PSW
	CALL	OUTSP		;PRINT A SPACE
	POP	PSW
OUTBYT	PUSH	PSW
	LDA	OPTHEX		;CHECK HEX OR OCTAL
	ORA	A
	JNZ	OUTHEX		;JUMP IF HEX
OUTOCT	POP	PSW
	PUSH	PSW		;SAVE THE CHARACTER TWICE
	PUSH	PSW
	ORA	A		;GET M.S. DIGIT INTO
	RAL			;RIGHT HALF OF A FOR
	RAL			;OCTAL OUTPUT
	RAL
	CALL	OCTR		;OUTPUT MS DIGIT
	POP	PSW		;RESTORE CHARACTER
	RRC			;GET NEXT DIGIT IN PLACE
	RRC
	RRC
	CALL	OCTR		;PRINT 2ND DIGIT
	POP	PSW		;RESTORE CHARACTER
OCTR	ANI	07		;MASK OFF GARBAGE
OUTHR	ANI	0FH		;MASK OFF LEFT HALF
	ADI	'0'			;ADD IN ASCII BIAS
	JMP	OUTCHR		;GO PRINT IT
OUTHEX	POP	PSW		;GET CHARACTER
	PUSH	PSW		;SAVE CHARACTER
	CALL	HEXL		;PRINT M.S. DIGIT
	CALL	OUTCHR
	POP	PSW		;RESTORE CHARACTER
	CALL	HEXR		;PRINT L.S. DIGIT
	JMP	OUTCHR

* HEXADECIMAL TO ASCII CONVERSION
*    CHANGES EITHER HALF OF "A" INTO ITS
*    EQUIVALENT ASCII VALUE.
*  USES A

HEXL	RLC			;SHIFT DIGIT OVER
	RLC
	RLC
	RLC
HEXR	ANI	0FH		;MASK OFF GARBAGE
	ADI	90H		;CONVERT IT TO ASCII
	DAA
	ACI	40H
	DAA
	RET

* OUTPUT SPACES
*    OUTPUTS 1, 2, OR 3 SPACES.
*  USES A

OUT3S	CALL	OUTSP
OUT2S	CALL	OUTSP
OUTSP	MVI	A,' '			;PRINT A SPACE
	JMP	OUTCHR

* SKIP A BYTE
*    SPACES PAST A SINGLE BYTE OF CODE.
*  USES A

SKPBYT	LDA	OPTHEX		;HEX OR OCTAL ?
	ORA	A
	CZ	OUTSP		;NEED A SPACE IF OCTAL
	CALL	OUT3S
	RET

* OUTPUT A DECIMAL NUMBER
*    OUTPUTS THE BINARY VALUE IN THE H/L REG-
*    ISTER IN 5 DECIMAL DIGITS WITH LEADING
*    ZEROES REPLACED BY SPACES.
*  USES A, B, D, E, H, L

OUTDC	MVI	B,80H		;SET NO PRINTING FLAG
	LXI	D,-10000		;GET CONSTANT
	CALL	DIGIT		;PRINT 1ST POSITION
	LXI	D,-1000		;GET CONSTANT
	CALL	DIGIT		;PRINT 2ND POSITION
	LXI	D,-100		;GET CONSTANT
	CALL	DIGIT		;PRINT 3RD POSITION
	LXI	D,-10		;GET CONSTANT
	CALL	DIGIT		;PRINT 4TH POSITION
	MVI	B,00		;CLEAR NO PRINT FLAG
	LXI	D,-1		;GET CONSTANT AND PRINT 5TH
DIGIT	INR	B
	DAD	D		;SUBTRACT OFF
	JC	DIGIT		;LOOP IF GT ZERO
	DCR	B		;BACKUP VALUE
	XCHG
	CALL	NEGRP		;NEGATE CONSTANT
	XCHG
	DAD	D		;ADD BACK IN
	MOV	A,B
	CPI	80H		;ANY PRINTING YET ?
	JZ	OUTSP		;A SPACE IF NOT
	CALL	OUTHR		;ELSE, PRINT DIGIT
	MVI	B,00		;CLEAN NO PRINTING FLAG
	RET

* PRINT STRING ROUTINE
*    PRINTS A CRLF AND THEN PRINTS THE DATA
*    POINTED TO BY THE H L REGISTER UNTIL AN
*    EOT OR 04 IS FOUND.
*  USES A,H,L

PSTRG	CALL	PCRLF		;PRINT A CR AND LF
PDATA	MOV	A,M		;GET A CHARACTER
	CPI	04		;IS IT EOT ?
	RZ			;RETURN IF SO
	CALL	OUTCHR		;ELSE, PRINT THE CHARACTER
	INX	H		;POINT TO NEXT CHAR
	JMP	PDATA		;LOOP BACK

* PRINT A CARRIAGE RETURN AND LINE FEED
*    PRINTS A CRLF AND CHECKS TO SEE IF
*    THE BOTTOM OF PAGE IS REACHED.  IF
*    SO, AND IF THE PAGING OPTION IS
*    SELECTED, A PAGE EJECT IS ISSUED.
*  USES A

PCRLF	PUSH	H		;SAVE H/L
	CALL	BREAK		;CHECK FOR A BREAK
	LXI	H,CRLF		;POINT TO CRLF STRING
	CALL	PDATA		;PRINT IT
	LDA	LINCNT
	INR	A		;INCREMENT LINE COUNT
	STA	LINCNT
	INR	A		;ADD IN BIAS OF 1
	LXI	H,LINES		
	CMP	M		;COMPARE TO PAGE LENGTH
	JZ	PCRLF1		;SKIP IF EQUAL
	PUSH	B		
	PUSH	D
	CNC	EJECT		;PAGE EJECT IF GREATER
	POP	D
	POP	B
PCRLF1	POP	H		;RESTORE H/L
	RET

* BREAK ROUTINE
*    IF A CHKIN ROUTINE IS SUPPLIED, BREAK WILL ALLOW
*    YOU TO HALT ASSEMBLY WITH A 'CTRL C' OR PAUSE
*    WITH AN 'ESC' UNTIL ANOTHER 'ESC' IS HIT.
*  USES A

BREAK	CALL	CHKIN		;CHECK FOR INPUT
	RNC			;RETURN IF NONE
	CPI	03		;IS IT A BREAK ?
	JZ	DONE		;EXIT IF SO
	CPI	1BH		;IS IT AN ESCAPE ?
	RNZ			;RETURN IF NOT
BREAK1	CALL	CHKIN		;CHECK AGAIN
	JNC	BREAK1		;WAIT FOR INPUT
	CPI	03		;A BREAK ?
	JZ	DONE		;EXIT IF SO
	CPI	1BH		;ANOTHER ESCAPE ?
	JNZ	BREAK1		;LOOP IF NOT
	RET

* PRINT SOURCE ROUTINE
*    PRINTS THE SOURCE LINE.  IF THE AUTO-
*    FIELDING OPTION IS SELECTED, THE OPCODE,
*    OPERAND, AND COMMENTS FIELDS WILL BE
*    AUTOMATICALLY JUSTIFIED.  OTHERWISE THE
*    LINE WILL BE PRINTED AS IS.

PRTSRC	LHLD	LINBEG		;GET LINE BEGIN POINTER
	LDA	OPTEXP		;CHECK AUTO-FIELD OPTION
	ORA	A
	JNZ	PRTS2		;SKIP IF SET
PRTS1	MOV	A,M		;GET A CHARACTER
	INX	H		;INCREMENT POINTER
	CPI	0DH		;A CARRIAGE RETURN ?
	RZ			;RETURN IF SO
	CALL	OUTCHR		;ELSE PRINT THE CHARACTER
	JMP	PRTS1		;LOOP BACK
PRTS2	MVI	C,01		;SET COLUMN COUNT
	MOV	A,M		;GET A CHARACTER
	CPI	CMNTCH		;A COMMENT ?
	JZ	PRTS1		;PRINT LINE IF SO
	CPI	SMCOLN		;A COMMENT LINE ?
	JZ	PRTS1		;PRINT LINE IF SO
PRTS3	MOV	A,M		;GET A CHARACTER
	CALL	ISITD2		;A SEMICOLON OR RETURN ?
	JNZ	PRTS9		;IF SO, PRINT REMAINDER
	CALL	ISITD1		;A SPACE OR TAB ?
	JNZ	PRTS5		;GO TO FIELD 1
	CPI	COLON		;A COLON ?
	JNZ	PRTS4		;SKIP IF NOT
	CALL	OUTCHR		;ELSE, PRINT CHARACTER
	INX	H
	INR	C		;INCREMENT COLUMN COUNT
	JMP	PRTS5		;GO TO FIELD 1
PRTS4	CALL	OUTCHR		;PRINT THE CHARACTER
	INX	H		;POINT TO NEXT CHARACTER
	INR	C		;INCREMENT COLUMN COUNT
	JMP	PRTS3		;LOOP BACK
PRTS5	MVI	B,FIELD1		;GET FIELD 1 COLUMN
	CALL	EXPAND		;SPACE OVER TO IT
PRTS6	MOV	A,M		;GET A CHARACTER
	CALL	ISITD2		;A SEMICOLON OR RETURN ?
	JNZ	PRTS9		;IF SO, PRINT REMAINDER
	CALL	ISITD1		;A SPACE OR TAB ?
	JNZ	PRTS7		;IF SO, GO TO FIELD 2
	CALL	OUTCHR		;ELSE PRINT CHARACTER
	INX	H
	INR	C		;INCREMENT COLUMN COUNT
	JMP	PRTS6		;LOOP BACK
PRTS7	MVI	B,FIELD2	;GET FIELD 2 COLUMN
	CALL	EXPAND		;SPACE OVER TO IT
	LDA	ERR3		;AN INVALID MNEMONIC ?
	ORA	A
	JNZ	PRTS1		;IF SO, PRINT REMAINDER
	LDA	ERR7		;ILLEGAL REG SPEC. ?
	ORA	A
	JNZ	PRTS1		;IF SO, PRINT REMAINDER
	LDA	OPTYPE
	CPI	04		;A TTL PSEUDO-OP ?
	JZ	PRTS1		;IF SO, PRINT REMAINDER
	CPI	07		;A DB PSEUDO-OP ?
	JZ	PRTS1		;IF SO, PRINT REMAINDER
	ORA	A		;ANY OTHER PSEUDO-OP ?
	JNZ	PRTS8		;SKIP IF SO
	LDA	OPCODE
	ORA	A		;A NOP ?
	JZ	PRTS9		;IF SO GO TO FIELD 3
	CPI	76H		;A HALT ?
	JZ	PRTS9		;IF SO GO TO FIELD 3
	MOV	B,A		;SAVE OPCODE
	ANI	0C7H
	CPI	0C0H		;ONE OF THE RETURNS ?
	JZ	PRTS9		;IF SO, GO TO FIELD 3
	MOV	A,B
	ANI	0C7H		;ROTATES, DAA, CMA
	CPI	07		;STC, OR CMC ?
	JZ	PRTS9		;IF SO, GO TO FIELD 3
	MOV	A,B
	ANI	0CFH
	CPI	0C9H		;A RET, PCHL OR SPHL ?
	JZ	PRTS9		;IF SO, GO TO FIELD 3
	MOV	A,B
	ANI	0E7H
	CPI	0E3H		;AN XTHL, DI, XCHG OR EI ?
	JZ	PRTS9		;IF SO, GO TO FIELD 3
PRTS8	MOV	A,M		;GET A CHARACTER
	CPI	0DH		;A CARRIAGE RETURN ?
	RZ			;EXIT IF SO
	CPI	09		;A TAB ?
	JZ	PRTS9		;IF SO, GO TO FIELD 3
	CALL	ISITD1		;A SPACE OR SEMICOLON ?
	JZ	PRTS85		;SKIP IF NOT
	INX	H		;CHECK NEXT CHAR
	MOV	A,M
	DCX	H		;RESET POINTER
	CPI	''''			;A SINGLE QUOTE ?
	JNZ	PRTS9		;IF NOT, GO TO FIELD 3
	MOV	A,M		;ELSE, RESTORE CHARACTER
PRTS85	CALL	OUTCHR		;PRINT THE CHARACTER
	INX	H
	INR	C		;INCREMENT COLUMN COUNT
	JMP	PRTS8		;LOOP BACK
PRTS9	MVI	B,FIELD3		;GET FIELD 3 COLUMN
	CALL	EXPAND		;SPACE OVER TO IT
	JMP	PRTS1		;FINISH THE LINE
EXPAND	CALL	SKPSP		;SKIP SPACES
	MOV	A,M		;GET CHARACTER
	CPI	0DH		;A RETURN ?
	JNZ	EXPND1		;SKIP IF NOT
	POP	PSW		;FIX STACK
	RET			;EXIT ROUTINE
EXPND1	CALL	OUTSP		;PRINT A SPACE
	INR	C		;INCREMENT COLUMN COUNT
	MOV	A,C		;GET COLUMN COUNT
	CMP	B		;COMPARE TO FIELD COLUMN
	JC	EXPND1		;LOOP IF LESS
	RET			;ELSE, EXIT ROUTINE

* PRINT SORTED SYMBOL TABLE
*    SORTS THE SYMBOL TABLE AND THEN PRINTS IT OUT
*    WITH 'LBLINE' LABELS PER LINE.

PSYMTB	CALL	EJECT		;EJECT IF PAGING ON
	LDA	OPTPAG
	ORA	A
	CZ	ENDUP2		;ELSE SPACE DOWN
	LXI	H,SYMHD		;PRINT S.T. HEADER
	CALL	PDATA
	CALL	PCRLF
	CALL	SORT		;SORT SYMBOL TABLE
	LHLD	SYMEND		;GET POINTERS
	XCHG
	LHLD	SYMBEG
	MOV	A,M		;ANY SYMBOLS IN TABLE ?
	ORA	A
	RZ			;EXIT IF NOT
PSTB1	CALL	PCRLF
	LDA	LBLINE		;GET NBR OF LABELS/LINE
	MOV	C,A
PSTB2	MVI	B,06		;SET LABEL LENGTH
PSTB3	MOV	A,M		;GET A CHARACTER
	CALL	OUTCHR		;PRINT IT
	INX	H
	DCR	B
	JNZ	PSTB3		;LOOP TILL DONE
	PUSH	H		;SAVE POINTER
	MOV	A,M		;GET LABEL'S VALUE
	INX	H
	MOV	H,M
	MOV	L,A
	CALL	PRTAD0		;PRINT VALUE
	CALL	OUT3S		;PRINT 3 SPACES
	POP	H		;RESTORE POINTER
	INX	H		;POINT TO NEXT SYMBOL
	INX	H
	CALL	CMPDH		;END OF TABLE ?
	RNC			;EXIT IF SO
	MOV	A,M		;MORE LABELS IN TABLE ?
	ORA	A
	RZ			;EXIT IF NOT
	DCR	C		;ENOUGH ON THIS LINE ?
	JNZ	PSTB2		;LOOP IF NOT
	JMP	PSTB1		;NEW LINE IF SO

* CHECK FOR ANY ERRORS
*    CHECKS ERROR BYTES AND RETURNS NON-ZERO IF
*    ANY ERRORS FOUND.
*  USES A,B,H,L

ANYERR	LXI	H,ERR0		;POINT TO ERROR BYTES
	MVI	B,10		;SET COUNT
	XRA	A
ANYER1	CMP	M		;AN ERROR ?
	RNZ			;RETURN IF SO
	INX	H		;ELSE, POINT TO NEXT
	DCR	B		;DECREMENT COUNT
	JNZ	ANYER1		;LOOP IF NOT DONE
	RET

* PRINT ERROR MESSAGES
*    SCANS ERROR BYTES AND PRINTS A CORRESPONDING
*    MESSAGE IF ANY ARE FOUND.  MESSAGE COMES
*    FROM ERROR TABLE.
*  USES A,B,C,D,E

PRTERR	PUSH	H
	MVI	B,00
	LXI	D,ERR0		;POINT TO ERROR BYTES
PRTER1	LDAX	D		;GET ERROR BYTE
	ORA	A		;AN ERROR ?
	JZ	PRTER4		;SKIP IF NOT
	LHLD	ERRORS
	INX	H		;INCREMENT ERROR COUNT
	SHLD	ERRORS
	LXI	H,ERRHD		;POINT TO ERROR HEADER
	CALL	PSTRG		;PRINT IT
	LXI	H,ERRM0		;GET START OF MESSAGES
	MOV	C,B		;GET ERROR NUMBER
	JMP	PRTER3
PRTER2	MOV	A,M		;GET CHARACTER
	INX	H
	CPI	04		;IS IT END OF MESSAGE ?
	JNZ	PRTER2		;LOOP IF NOT
PRTER3	DCR	C		;AT RIGHT MESSAGE
	JP	PRTER2		;LOOP IF NOT
	CALL	PDATA		;ELSE, PRINT IT
PRTER4	INX	D		;NEXT ERROR BYTE
	INR	B
	MOV	A,B
	CPI	10		;THRU ERROR LIST ?
	JNZ	PRTER1		;LOOP IF NOT
	POP	H
	RET

* CHECK FOR VALID LABEL
*    RETURNS IF THERE WAS NO LABEL.  IF THERE
*    WAS A LABEL, WE FALL THRU TO SYNTAX ERROR.

LCHECK	LDA	VLDLBL		;CHECK FOR LABEL
	ORA	A
	RZ			;RETURN IF NONE

* SYNTAX ERROR
*    SETS SYNTAX ERROR FLAG AND RETURNS.
*  USES A

SYNTAX	MVI	A,06		;SET SYNTAX ERROR

* SET ERROR FLAG
*    SETS ERROR #N, WHERE N IS THE VALUE IN
*    THE "A" REGISTER UPON CALLING.
*  USES A

ERROR	PUSH	H		;SAVE H/L
	LXI	H,ERR0		;POINT TO BASE OF ERRORS
	CALL	ADAHL		;POINT TO CORRECT ERROR
	MVI	M,01		;SET THE FLAG
	POP	H		;RESTORE H/L
	RET

* PARSE A LINE OF SOURCE
*    PARSES A LINE OF SOURCE, PUTTING LABELS IN
*    THE SYMBOL TABLE IF PASS 1.  IF PASS TWO,
*    MULTIPLY DEFINED LABELS ARE FOUND.  THE
*    OPCODE IS THEN DETERMINED IF POSSIBLE.  IF
*    PASS 1, ONLY CERTAIN PSEUDO-OPS ARE EXECUTED
*    ALTHOUGH THE LOCATION COUNTER IS KEPT
*    UPDATED.  IF PASS 2, THE PARSING IS CONTINUED
*    INTO THE OPERAND AND CODE IS GENERATED.
*    ON ENTRY THE H-L REGISTER CONTAINS THE
*    ADDRESS OF THE FIRST BYTE OF THE LINE.
*  USES ALL

PARSE	XRA	A		;CLEAR FLAGS
	STA	VLDLBL
	STA	DBSIP
	STA	BYTES
	STA	BYTES+1
	STA	DATA
	STA	DBDWF
	XCHG
	CALL	CLRCOD		;CLEAR ASSEMBLED CODE
	CALL	CLRERR		;CLEAR ERROR FLAGS
	XCHG
	MVI	A,0CH
	STA	OPTYPE		;SET OPTYPE TO COMMENT
	DCX	H
	LDA	JNKCNT		;GET JUNK COUNT
PARSE1	INX	H		;SKIP PAST JUNK
	DCR	A
	JP	PARSE1		;LOOP IF NOT DONE
	SHLD	LINPTR
	SHLD	LINBEG		;SAVE LINE BEGINNING
	MOV	A,M		;GET FIRST CHAR OF LINE
	CALL	ISITD2		;A SEMICOLON OR RETURN ?
	RNZ			;EXIT IF SO
	CPI	CMNTCH		;A COMMENT CHARACTER ?
	RZ			;EXIT IF SO
	CALL	ISITD1		;A SPACE OR TAB ?
	JNZ	FNDOPC		;IF SO, NO LABEL
	CALL	LBLCLS		;VALID LABEL CHAR ?
	JNZ	PARSE3		;SKIP IF SO
	INX	H		;POINT TO NEXT CHARACTER
	JMP	PARSE5		;GO SET ERROR
PARSE3	CALL	COPLBL		;COPY LABEL INTO LBL REG
PARSE4	MOV	A,M		;GET CHARACTER
	CALL	ISITD1		;SPACE, SMCOLN OR RETURN ?
	JNZ	PARSE7		;SKIP IF SO
	INX	H
	CPI	COLON		;WAS IT A COLON ?
	JZ	PARSE7		;GOT LABEL IF SO
PARSE5	MVI	A,04
	CALL	ERROR		;SET LABEL ERROR
	CALL	CPLBL2		;SCAN REST OF LABEL
	JMP	PARSE4
PARSE7	SHLD	LINPTR
	LDA	ERR4
	ORA	A		;WAS THERE A LABEL ERROR ?
	JNZ	FNDOPC		;GO TO OPCODE IF SO
	LDA	PASS
	ORA	A		;PASS NUMBER ONE ?
	JNZ	PARSE8		;SKIP IF NOT
	CALL	PUTLBL		;PUT LABEL IN SYMBOL TABLE
	LDA	ERR0
	ORA	A		;SYMBOL TABLE FULL ?
	JNZ	FNDOPC		;GO TO OPCODE IF SO
	MVI	A,01
	STA	VLDLBL		;SET VALID LABEL FLAG
	JMP	FNDOPC
PARSE8	CALL	FNDLBL		;FIND LABEL IN SYM TBL
	JZ	OVERFL		;S.T. OVERFLOW IF NOT FOUND
	MOV	A,M		;GET 1ST CHAR OF LABEL
	ORA	A		;MULTIPLY DEFINED ?
	JP	PARSE9		;SKIP IF NOT
	MVI	A,02
	CALL	ERROR		;SET MULTIPLY DEFINED ERR
PARSE9	MVI	A,01
	STA	VLDLBL		;SET VALID LABEL FLAG
	JMP	FNDOPC		;GO TO OPCODE
OVERFL	MVI	A,00
	CALL	ERROR		;SET S.T. OVERFLOW ERROR

* FIND OPCODE
*    A CONTINUATION OF THE PARSE ROUTINE, THIS
*    ROUTINE FINDS THE MNEMONIC IN THE SOURCE
*    LINE AND LOOKS IT UP IN THE MNEMONIC TABLE.
*    THE OPCODE AND OPTYPE BYTES ARE SET ACCORD-
*    INGLY AND IF PASS 2, PARSING CONTINUES INTO
*    THE OPERAND (ALSO IN PASS 1 FOR CERTAIN
*    PSEUDO-OPS).
*  USES ALL

FNDOPC	LHLD	LINPTR
	CALL	SKPSP		;SKIP SPACES
	CALL	CLASS		;CLASSIFY CHARACTER
	SHLD	LINPTR		;SAVE POINTER
	JZ	OPCERR		;ERROR IF A NUMBER
	JP	FNDOP1		;CONTINUE IF A LETTER
	MOV	A,M		;GET THE CHARACTER
	CALL	ISITD2		;A SMCOLN OR RETURN ?
	JZ	OPCERR		;ERROR IF NOT
	LDA	VLDLBL		;WAS THERE A LABEL ?
	ORA	A
	RZ			;EXIT IF NOT
	MVI	A,0DH
	STA	OPTYPE		;ELSE SET LONE LABEL
	RET
FNDOP1	LXI	D,OPCTBL		;POINT TO TABLE
FNDOP2	LHLD	LINPTR		;POINT TO MNEMONIC
FNDOP3	LDAX	D		;GET A CHAR FROM TABLE
	ORA	A		;AT END OF TABLE ?
	JZ	OPCERR		;EXIT IF SO
	JM	FNDOP4		;SKIP IF A TYPE VALUE
	CMP	M		;ELSE, COMPARE TO SOURCE
	JZ	FDOP35
	ORI	20H		;CHECK LOWER CASE TOO
	CMP	M
	JNZ	FNDOP5		;IF NO MATCH, NEXT OPCODE
FDOP35	INX	H		;ELSE, POINT TO NEXT LETTERS
	INX	D
	JMP	FNDOP3		;LOOP BACK
FNDOP4	MOV	A,M		;GET SOURCE CHARACTER
	CALL	ISITD1		;A SPC, SMCOLN OR RETURN ?
	JNZ	FNDOP7		;GOT MNEMONIC IF SO
FNDOP5	LDAX	D
	ORA	A		;CHECK TABLE CHARACTER
	JM	FNDOP6		;SKIP IF A TYPE VALUE
	INX	D		;ELSE POINT TO NEXT
	JMP	FNDOP5		;LOOP BACK
FNDOP6	INX	D		;PASS UP TYPE
	INX	D		;PASS UP OPCODE
	JMP	FNDOP2		;TRY AGAIN
FNDOP7	SHLD	LINPTR		;SAVE ADDRESS
	LDAX	D		;GET TYPE
	RRC			;SHIFT BYTE COUNT OVER
	RRC
	RRC
	RRC
	ANI	03		;MASK OFF GARBAGE
	STA	BYTES		;SET BYTE COUNT
	XRA	A
	STA	BYTES+1
	INX	D
	LDAX	D		;GET OPCODE
	STA	OPCODE		;SAVE IT
	DCX	D		;BACK TO TYPE
	LDAX	D
	ANI	0FH		;MASK OFF GARBAGE
	SUI	4		;PRODUCE OPTYPE VALUE
	JP	FNDOP8
	XRA	A
FNDOP8	STA	OPTYPE
	LDAX	D		;GET TYPE AGAIN
	ANI	0FH		;MASK OFF GARBAGE
	RLC
	LXI	H,TYPTBL	;POINT TO TYPE TABLE
	CALL	ADAHL		;GET TO CORRECT TYPE
	MOV	A,M		;GET TYPE ADDRESS IN H/L
	INX	H
	MOV	H,M
	MOV	L,A
	LDA	PASS
	ORA	A		;IS THIS PASS ONE ?
	JNZ	EXCUTE		;SKIP IF NOT
	LDA	OPTYPE		;CHECK FOR WHICH OP'S TO
	CPI	3		;EXECUTED IN PASS ONE
	RM
EXCUTE	XCHG
	LHLD	LINPTR
	CALL	SKPSP		;SKIP SPACES
	SHLD	LINPTR		;AND SAVE LINE POINTER
	SHLD	OPRPRT		;ALSO OPERAND POINTER
	XCHG
	PCHL		;JUMP TO TYPE
OPCERR	MVI	A,3
	CALL	ERROR		;SET OPCODE ERROR FLAG
	XRA	A
	STA	OPTYPE		;SET OPTYPE
	LXI	H,0003
	SHLD	BYTES		;SET 3 BYTES OF CODE
	CALL	CLRCOD		;MAKE THEM NOP'S
	RET

* TYPE 0 OPERATION
*    TYPE 0 OPERATIONS ARE OPCODES THAT HAVE
*    NO OPERAND.  NO OPERATIONS ARE REQUIRED.

TYPE0	RET

* TYPE 1 OPERATION
*    TYPE 1 OPERATIONS ARE OPCODES THAT HAVE
*    SINGLE REGISTER SPECIFICATIONS IN THERI
*    OPERANDS.

TYPE1	CALL	GETRG		;GET 1ST REG SPEC
	JNC	REGERR		;EXIT IF AN ERROR
	ANI	0F7H
	MOV	C,A		;PUT REG SPEC IN "C"
	LDA	OPCODE
	ORA	A		;CHECK OPCODE
	MOV	A,C
	JP	TYPE1C		;SKIP IF NOT ACC OPRTN
TYPE1A	CALL	INSLO		;MERGE REG SPEC AND OPCODE
	JZ	REGERR		;EXIT IF AN ERROR
	LDA	OPCODE
	CPI	76H		;WAS IT A MOV M,M ?
	JZ	REGERR		;ERROR IF SO
TYPE1B	MOV	A,M		;GET NEXT CHARACTER
	CALL	ISITD1		;A SPC, SMCOLN OR RETURN ?
	JZ	SYNTAX		;SYNTAX ERROR IF NOT
	RET
TYPE1C	CALL	INSHI		;MERGE REG SPEC AND OPCODE
	JZ	REGERR		;EXIT IF AN ERROR
	LDA	OPCODE		;GET OPCODE
	ANI	46H
	CPI	6		;A MVI INSTRUCTION ?
	JZ	TYPE1E		;SKIP IF SO
	JM	TYPE1B		;EXIT IF NOT A MOV INSTR
	MOV	A,M		;GET NEXT CHARACTER
	CPI	','	
	JNZ	REGERR		;ERROR IF NOT A COMMA
	INX	H
	SHLD	LINPTR
	CALL	GETRG		;GET REGISTER SPEC
	JNC	REGERR		;EXIT IF AN ERROR
	ANI	0F7H
	JMP	TYPE1A
TYPE1E	MOV	A,M		;GET NEXT CHARACTER
	CPI	','		;A COMMA ?
	JNZ	SYNTAX		;ERROR IF NOT
	INX	H
	SHLD	LINPTR
	CALL	EVAL		;EVALUATE IMMEDIATE DATA
	SHLD	BYTE2		;PUT IN CODE
	RET

* TYPE 2 OPERATION
*    TYPE 2 OPERATIONS ARE OPCODES THAT HAVE
*    REGISTER PAIR SPECIFICATIONS IN THEIR
*    OPERANDS.

TYPE2	CALL	GETRG		;GET REGISTER SPEC
	JNC	REGERR		;EXIT IF AN ERROR
	MOV	B,A
	CPI	6		;"M" REGISTER SPEC ?
	JZ	REGERR		;ERROR IF SO
	RRC			;EVEN REGISTER ?
	JC	REGERR		;ERROR IF NOT
	LDA	OPCODE
	MOV	C,A
	CPI	0C0H		;CHECK FOR PUSH OR POP
	JNC	TYPE2D		;SKIP IF SO
	RRC			;CHECK FOR LDAX OR STAX
	JNC	TYPE2C		;SKIP IF SO
	MOV	A,B
	CPI	16H		;WAS REG SPEC A "PSW" ?
	JZ	REGERR		;ERROR IF SO
TYPE2B	ANI	07
	CALL	INSHI		;MERGE REG SPEC AND OPCODE
	MOV	A,C
	CPI	1		;WAS IT AN "LXI" ?
	JNZ	TYPE1B		;DONE IF NOT
	JMP	TYPE1E		;ELSE GET IMMEDIATE DATA
TYPE2C	MOV	A,B
	CPI	03		;IS REG SPEC = "B" OR "D"
	JNC	REGERR		;ERROR IF NOT
	CALL	INSHI		;MERGE REG SPEC AND OPCODE
	JMP	TYPE1B
TYPE2D	MOV	A,B
	CPI	86H		;IS REG SPEC A "SP" ?
	JNZ	TYPE2B		;IF NOT, GO BACK
REGERR	CALL	CLRCOD		;SET IN NOP'S
	MVI	A,7
	JMP	ERROR		;GO SET REG ERROR

* TYPE 3 OPERATION
*    TYPE 3 OPERATION HAS 8 BIT DATA VALUE
*    AS ITS OPERAND.

TYPE3	CALL	EVAL		;EVALUATE THE DATA
	SHLD	BYTE2		;PUT IN ASSEMBLED CODE
	LDA	OPCODE
	CPI	0C7H		;A RESTART INSTRUCTION ?
	RNZ			;DONE IF NOT
	MOV	A,H		;CHECK UPPER 8 BITS
	ORA	A		;ZERO ?
	JNZ	TYPE3A		;ERROR IF NOT
	MOV	A,L		;GET RESTART VECTOR
	CALL	INSHI		;FIX OPCODE
	RNZ			;EXIT IF NO ERRORS
TYPE3A	CALL	CLRCOD		;ELSE SET IN NOP
	MVI	A,5
	JMP	ERROR		;SET OPERAND ERROR

* TYPE 4 OPERATION
*    TYPE 4 OPERATION HAS 16 BIT DATA VALUE 
*    AS ITS OPERAND.

TYPE4	CALL	EVAL		;EVALUATE THE DATA
	SHLD	BYTE2		;PUT IN ASSEMBLED CODE
	RET

* INSERT A REGISTER SPECIFICATION INTO OPCODE
*    INSHI AND INSLO PUT THE 3 BIT REGISTER
*    SPEC INTO THE OPCODE IN PLACE OF BITS
*    3-5 AND 0-2 RESPECTIVELY.  THE REG SPEC
*    IS ASSUMED TO BE IN "A" UPON CALLING.
*    ON RETURN, THE ZERO FLAG IS SET IF THERE
*    IS AN ERROR.
*  USES A,B

INSHI	CPI	8		;IS SPEC IN RANGE ?
	JNC	INSBAD		;ERROR IF NOT
	RLC			;SHIFT TO BITS 3-5
	RLC
	RLC
	JMP	INSERT
INSLO	CPI	8		;IS SPEC IN RANGE ?
	JNC	INSBAD		;ERROR IF NOT
INSERT	MOV	B,A
	LDA	OPCODE		;GET THE OPCODE
	ORA	B		;OR IN REGISTER SPEC
	STA	OPCODE
	RET
INSBAD	XRA	A		;SET ZERO FLAG
	RET

* GET REGISTER SPECIFICATION
*    GETS REGISTER SPECIFICATION FROM INPUT
*    SOURCE.  IF NOT A LETTER, EVAL IS CALLED
*    TO DETERMINE THE EQUIVALENT REGISTER
*    NUMBER AS FOLLOWS:
*	A = 7
*	B = 0
*	C = 1
*	D = 2
*	E = 3
*	H = 4
*	L = 5
*	M = 6
*	SP OR S = 6
*	PSW OR F = 6
*    TO DIFFERENTIATE BETWEEN SPECS OF
*    M, SP, AND PSW, THE RETURNED VALUES ARE
*    06, 86H AND 16H RESPECTIVELY.  IF A
*    NUMBER IS GIVEN INSTEAD OF A LETTER,
*    AND THE NUMBER IS 6, IT IS RETURNED
*    AS A 0EH WHICH MAY BE ANY OF THE
*    THREE SPECS M, SP, OR PSW.  IF AN
*    ERROR IS DETECTED, THE CARRY IS CLEARED
*    ON RETURN.
*  USES ALL

GETRG	LHLD	LINPTR
	LXI	D,REGTBL-2	;POINT TO TABLE
GETRG1	INX	D		;POINT TO NEXT ENTRY
	INX	D
	LDAX	D
	ORA	A		;END OF TABLE ?
	JZ	GETRG4		;EXIT IF SO
	CMP	M		;COMPARE CHARACTERS
	JZ	GTRG15
	ORI	20H		;CHECK LOWER CASE TOO
	CMP	M
	JNZ	GETRG1		;LOOP IF NOT SAME
GTRG15	MOV	A,M
	ANI	5FH
	INX	H		;POINT TO NEXT CHAR
	CPI	'P'		;WAS LAST A "P" ?
	JZ	GETRG2		;SKIP IF SO
	CPI	'S'		;WAS IT AN "S" ?
	JNZ	GETRG3		;IF NOT, GOT REGISTER
	MOV	A,M		;GET NEW CHARACTER
	ANI	5FH
	CPI	'P'		;CHECK FOR A "P"
	JNZ	GETRG3		;EXIT IF NOT
	INX	H		;IF SO, BUMP POINTER
	JMP	GETRG3
GETRG2	MOV	A,M
	ANI	5FH
	CPI	'S'		;IS NEXT CHAR AN "S" ?
	JNZ	GETRG4		;EXIT IF NOT
	INX	H
	MOV	A,M		;GET NEXT CHARACTER
	ANI	5FH
	CPI	'W'		;IS IT A "W" ?
	JNZ	GETRG4		;EXIT IF NOT
	INX	H		;ELSE WE GOT A "PSW"
GETRG3	SHLD	LINPTR
	INX	D
	LDAX	D		;GET REGISTER VALUE
	STC			;SET NO ERROR FLAG
	RET
GETRG4	LHLD	LINPTR		;RESTORE LINE POINTER
	XRA	A
	STA	OPRATR
	CALL	GETNO		;GET EQUIV REG VALUE
	JZ	GETRG5		;SKIP IF VALID
	JNC	GETRG7		;EXIT IF AN ERROR
	XRA	A		;ELSE, IT'S A "COMMA ERROR"
	STA	ERR5		;SO CLEAR OPERAND ERROR
GETRG5	MOV	A,H
	ORA	A		;SEE IF VALUE IS IN RANGE
	JNZ	GETRG8		;EXIT IF NOT
	MOV	A,L
	CPI	8
	JP	GETRG8
	CPI	6
	JNZ	GETRG6
	ORI	08		;CHANGE 6'S TO 0E'S
GETRG6	LHLD	LINPTR
	STC			;SET VALID SPEC FLAG
	RET
GETRG7	XRA	A
	STA	ERR8		;CHANGE TO REG ERROR
GETRG8	MVI	A,7
	CALL	ERROR		;SET REG SPEC ERROR
	XRA	A		;CLEAR CARRY (INVALID REG)
	RET

* SPACE PSEUDO-OP
*    A COMMAND " SPACE N " WILL CAUSE N LINE
*    FEEDS TO BE INSERTED IN THE LISTING IF
*    LIST OPTION IS SELECTED.  THE DEFAULT
*    VALUE FOR N IS 1.

OPSPC	CALL	LCHECK		;CHECK FOR LABEL
	LDA	OPTLST		;LIST OPTION ON ?
	ORA	A
	RZ			;EXIT IF NOT
	LDA	P3FLG		;PASS THREE ?
	ORA	A
	RNZ			;RETURN IF SO
	LDAX	D		;GET CHARACTER
	SUI	0DH		;NO OPERAND ?
	JZ	OPSPC1		;SKIP IF NONE
	CALL	EVAL		;EVALUATE NBR OF SPACES
	MOV	A,L
	DCR	A		;DECREMENT AMOUNT BY 1
OPSPC1	STA	SPCCNT		;SAVE IT
OPSPC2	CALL	PCRLF		;PERFORM A LINE FEED
	LDA	SPCCNT
	DCR	A		;DECREMENT COUNT
	STA	SPCCNT
	JP	OPSPC2		;LOOP IF NOT DONE
	RET

* PAGE EJECT OPTION
*    A COMMAND " PAGE M " WILL CAUSE A PAGE
*    EJECT WITH THE NEW PAGE BEING NUMBER M.
*    M DEFAULTS TO THE NEXT CONSECUTIVE
*    PAGE NUMBER IF IT IS OMITTED.
*    THE PAGING OPTION MUST BE SELECTED FOR
*    THIS PSEUDO-OP TO HAVE ANY EFFECT.

OPPAGE	CALL	LCHECK		;CHECK FOR A LABEL
	LDA	OPTPAG		;PAGING OPTION ON ?
	ORA	A
	RZ			;EXIT IF NOT
	LDA	OPTLST		;LIST OPTION ON ?
	ORA	A
	RZ			;EXIT IF NOT
	LDA	P3FLG		;PASS THREE ?
	ORA	A
	RNZ			;RETURN IF SO
	LDAX	D
	CPI	0DH		;ANY OPERAND ?
	JZ	EJECT		;DEFAULT IF NONE
	CALL	EVAL		;GET NEW PAGE NUMBER
	JNZ	EJECT		;DEFAULT IF AN ERROR
	DCX	H
	SHLD	PAGENO		;SAVE NEW PAGE NBR

* PAGE EJECT ROUTINE
*    PERFORMS A PAGE EJECT AND THEN PUTS THE
*    HEADER INFORMATION AND PAGE NBR IN THE
*    LISTING (ASSUMING THE PAGING OPTION IS
*    SELECTED).
*  USES ALL

EJECT	LDA	OPTPAG
	MOV	C,A
	ORA	A		;IS PAGE OPTION ON ?
	RZ			;EXIT IF NOT
	LXI	H,EJSTR		;POINT TO EJECT STRING
	CALL	PDATA		;OUTPUT IT
EJECT1	XRA	A
	STA	OPTPAG		;DISABLE PAGING
	STA	LINCNT		;ZERO LINE COUNT
	STA	OUTFLG		;TURN OFF FLAG
	LHLD	PAGENO
	INX	H		;INCREMENT PAGE NUMBER
	SHLD	PAGENO
	XCHG
	LHLD	HIPAGE		;GET UPPER LIMIT
	CALL	CMPDH		;COMPARE
	JC	DONE		;EXIT IF ABOVE
	LHLD	LOPAGE		;GET LOWER LIMIT
	XCHG
	CALL	CMPDH		;COMPARE
	JC	EJECT2		;SKIP IF BELOW
	MVI	A,1
	STA	OUTFLG		;SET PRINT FLAG
EJECT2	MVI	B,3		;SET TOP MARGIN
TOPMRG	CALL	PCRLF		;LINE FEED
	DCR	B
	JNZ	TOPMRG		;LOOP TILL DONE
	LXI	H,TITLL		;PRINT THE TITLE
	CALL	PDATA
	LXI	H,ASMMSG		;PRINT HEADER
	CALL	PDATA
	LHLD	PAGENO
	CALL	OUTDC		;PRINT LINE NUMBER
	CALL	PCRLF
	CALL	PCRLF
	XRA	A
	STA	SPCCNT		;DON'T ALLOW MORE SPACES
	MOV	A,C
	STA	OPTPAG		;RESTORE PAGE OPTION
	RET

* OPTION PSEUDO-OP
*    SCANS THE OPTION LIST AND SETS OR CLEARS
*    OPTIONS ACCORDINGLY.  BAD OPTION
*    SPECIFICATIONS WILL BE REPORTED, BUT
*    IGNORED.  THIS ERROR CHECKING TAKES
*    PLACE DURING PASS 1 AND 2 BUT THE OPTIONS
*    ARE SET ONLY DURING PASS 1.

OPOPT	CALL	LCHECK		;CHECK FOR LABEL
	XCHG			;GET LINPTR
OPOPT1	MVI	C,0		;SET "OFF" FLAG
	LXI	D,OPTTBL	;POINT TO OPTION TABLE
OPOPT2	MVI	B,3		;SET COUNT
OPOPT3	LDAX	D		;GET CHARACTER
	ORA	A		;END OF "OFF LIST" ?
	JP	OPOPT4		;SKIP IF NOT
	MVI	C,0F0H		;SET "ON" FLAG
	INX	D
	JMP	OPOPT3		;GO CONTINUE SEARCH
OPOPT4	JZ	OPOPT9		;JUMP IF END OF "ON LIST"
	CMP	M		;COMPARE SOURCE CHARACTER
	JZ	OPOPT6		;JUMP IF A MATCH
	ORI	20H		;CHECK UPPER CASE TOO
	CMP	M
	JZ	OPOPT6
OPOPT5	INX	D		;GET TO NEXT OPTION
	INX	H
	DCR	B		;DECREMENT COUNT
	JNZ	OPOPT5		;LOOP IF NOT DONE
	DCX	H		;REPOSITION SOURCE POINTER
	DCX	H
	DCX	H
	INR	C		;INCREMENT OPT POSITION
	JMP	OPOPT2		;TRY NEXT OPTION
OPOPT6	INX	D
	INX	H
	DCR	B
	JNZ	OPOPT3		;LOOP IF NOT DONE
	LDA	PASS
	ORA	A		;PASS #1 ?
	JNZ	OPOPT8		;SKIP IF NOT
	XCHG
	LXI	H,OPTSYM		;GET BASE OF OPT LIST
	MOV	A,C
	ANI	0FH		;GET OPT POSITION
	CALL	ADAHL		;FIND ADDRESS OF OPTION
	MOV	A,C
	ANI	0F0H		;GET "ON" OR "OFF" FLAG
	MOV	M,A		;SET OPTION FLAG
	XCHG
OPOPT8	MOV	A,M		;GET SOURCE CHARACTER
	CALL	ISITD1		;A SPC, SMCOLN OR RETURN ?
	RNZ			;EXIT IF SO
	INX	H		;ELSE, POINT TO NEXT
	CPI	','		;WAS LAST CHAR A COMMA ?
	JZ	OPOPT1		;GET NEXT OPT IF SO
	JMP	OPOPT8		;GO FIND NEXT DELIM
OPOPT9	MVI	A,9
	CALL	ERROR		;SET OPTION ERROR
	JMP	OPOPT8		;FINISH UP

* TITLE PSEUDO-OP
*    ALL CHARACTERS (EXCLUDING LEADING BLANKS)
*    FOLLOWING THE MNEMONIC ARE TRANSFERRED
*    TO THE TITLE BUFFER FOR LATER USE.

OPTTL	CALL	LCHECK		;CHECK FOR LABEL
	XCHG			;GET LINE POINTER
	CALL	SKPSP		;SKIP LEADING SPACES
	LXI	D,TITLL		;POINT TO TITLE BUFFER
	MVI	B,32		;GET LENGTH OF BUFFER
OPTTL1	MOV	A,M		;GET A CHARACTER
	CPI	0DH		;A CARRIAGE RETURN
	RZ			;DONE IF SO
	STAX	D		;ELSE PUT IN BUFFER
	INX	H		;POINT TO NEXT CHAR
	INX	D		;BUMP BUFFER POINTER
	DCR	B		;DECREMENT LENGTH COUNT
	JNZ	OPTTL1		;LOOP IF NOT DONE
	RET

* ORG PSEUDO-OP
*    SETS UP A NEW ORG ADDRESS IN THE LC.

OPORG	CALL	LCHECK		;CHECK FOR LABEL
	CALL	EVAL		;EVALUATE THE ADDRESS
	SHLD	LC
	RET

* DEFINE STORAGE PSEUDO-OP (DS)
*    SAVES A STORAGE BLOCK IN THE MEMORY
*    ADDRESS SPACE FOLLOWING.

OPDS	CALL	EVAL		;GET SIZE OF BLOCK
	SHLD	BYTES		;PUT IN BYTE COUNT
	RET			;FOR LATER ADDITION TO LC

* DEFINE BYTE AND DEFINE WORD PSEUDO-OPS (DB AND DW)
*    IF PASS ONE, THE SOURCE IS MERELY SCANNED,
*    COUNTING BYTES REQUIRED AND FINDING ERRORS.
*    IN PASS 2 DATA IS ASSEMBLED AND PUT IN THE
*    CODE AREA.  ONLY 3 BYTES AT A TIME ARE
*    EVALUATED (2 BYTES FOR DW'S).  IF THERE IS
*    MORE DATA IN THE SOURCE LINE, A FLAG CALLED
*    "DATA" IS SET TO INDICATE MORE PARSING AND
*    EVALUATION MUST GO ON.  IF THIS IS THE CASE,
*    DURING PASS 2, THE DATA CAN BE OBTAINED 3
*    BYTES AT A TIME BY CALLING DBDW1.

DBDW	MVI	A,1
	STA	DBDWF		;SET DB OR DW FLAG
	LDA	PASS
	ORA	A		;IS THIS PASS 1 ?
	JNZ	DBDW1		;SKIP IF NOT
	CALL	SCAN		;HOW MANY BYTES REQUIRED ?
	SHLD	BYTES		;PUT NUMBER IN BYTES
	RET
DBDW1	MVI	A,1
	STA	DATA		;SET DATA FLAG
	MVI	B,0		;ZERO BYTE COUNT
DBDW2	PUSH	B
	CALL	EVAL
	POP	B
	JZ	DBDW5		;JUMP IF NO ERROR
	JNC	DBDW3		;NON-COMMA ERROR
	CALL	INCLP		;PASS UP COMMA
	JMP	DBDW6
DBDW3	XCHG			;SAVE RESULT
	LHLD	LINPTR		;GET LINE POINTER
	DCX	H
DBDW4	INX	H
	MOV	A,M		;GET NEXT CHARACTER
	CALL	ISITD		;A DELIMITER ?
	JZ	DBDW4		;LOOP IF NOT
	SHLD	LINPTR
	XCHG			;RESTORE RESULT
	CPI	','		;IS DELIM A COMMA ?
	JNZ	DBDW5		;SKIP IF NOT
	CALL	INCLP		;PASS UP COMMA
	JMP	DBDW6
DBDW5	XRA	A
	STA	DATA		;NO MORE DATA
DBDW6	INR	B		;INCREMENT BYTE COUNT
	LDA	OPTYPE
	CPI	8		;IS THIS A DW ?
	JZ	DBDW7		;SKIP IF SO
	MOV	C,L		;SAVE BYTE IN "C"
	LXI	H,OPCODE-1
	MOV	A,B
	CALL	ADAHL		;POINT TO CODE POSITION
	MOV	M,C		;PUT IN BYTE
	MOV	A,B
	CPI	3		;3 BYTES ASSEMBLED ?
	JZ	DBDW8		;EXIT IF SO
	LDA	DATA
	ORA	A		;MORE DATA ?
	JZ	DBDW8		;EXIT IF NOT
	JMP	DBDW2		;ELSE, GO GET MORE
DBDW7	INR	B		;INCREMENT BYTE COUNT
	MOV	A,L
	STA	OPCODE		;GET ASSEMBLED CODE
	MOV	A,H
	STA	BYTE2
DBDW8	MOV	L,B		;PUT NUMBER OF BYTES
	MVI	H,0		;INTO H/L REGISTER
	SHLD	BYTES		;SAVE IT
	RET

* SCAN A DB OR DW FOR BYTE COUNT AND ERRORS
*    PARSES THE OPERAND OF A DB OR DW AND
*    RETURNS WITH THE NUMBER OF BYTES
*    REQUIRED IN THE H-L REGISTER PAIR.
*    ERRORS ARE ALSO DETECTED.
*  USES ALL

SCAN	LXI	H,0000		;ZERO BYTE COUNT
SCAN1	INX	H
	LDA	OPTYPE
	CPI	8		;A DW PSEUDO-OP ?
	JNZ	SCAN2
	INX	H		;IF SO, BUMP BYTE COUNT
SCAN2	PUSH	H
	CALL	EVAL		;EVALUATE ONE ITEM
	POP	H
	RZ			;RETURN IF NO ERROR
	JC	SCAN5		;SKIP IF A "COMMA ERROR"
	XCHG			;SAVE COUNT IN D/E
	LHLD	LINPTR		;GET LINE POINTER
	DCX	H
SCAN4	INX	H
	MOV	A,M		;GET NEXT CHARACTER
	CALL	ISITD		;A DELIMITER ?
	JZ	SCAN4		;LOOP IF NOT
	SHLD	LINPTR
	XCHG			;RESTORE COUNT
	CPI	','		;IS DELIM A COMMA ?
	RNZ			;RETURN IF NOT
SCAN5	CALL	INCLP		;PASS UP COMMA
	JMP	SCAN1		;LOOP BACK

* INCREMENT LINE POINTER
*    INCREMENTS THE SOURCE LINE POINTER BY ONE.
*  USES NONE

INCLP	PUSH	H		;SAVE H/L
	LHLD	LINPTR
	INX	H		;INCREMENT LINE POINTER
	SHLD	LINPTR
	POP	H		;RESTORE H/L
	RET

* SET OR EQUATE PSEUDO-OPS (SET AND EQU)
*    GETS VALUE OF OPERAND AND PUTS IT IN THE
*    SYMBOL TABLE ALONG WITH THE LABEL GIVEN.

OPSEQ	LDA	VLDLBL		;WAS THERE A LABEL ?
	ORA	A
	JNZ	OPSEQ1		;SKIP IF SO
	LDA	ERR4		;ILLEGAL SYMBOL ?
	ORA	A
	RNZ			;RETURN IF SO
	LDA	ERR0		;SYMBOL TABLE FULL ?
	ORA	A
	RNZ			;RETURN IF SO
	JMP	SYNTAX		;ELSE, SYNTAX ERROR
OPSEQ1	CALL	EVAL		;EVALUATE EXPRESSION
	LHLD	LBLTMP		;GET TO LABEL
	MOV	A,M
	ORA	A		;MULTIPLY DEFINED ?
	JP	OPSEQ2		;SKIP IF NOT
	LDA	OPTYPE
	CPI	9		;IS THIS A SET PSEUDO-OP ?
	JNZ	OPSEQ3		;SKIP IF NOT
	XRA	A
	STA	ERR2		;CLEAR MULT DEF ERROR
OPSEQ2	MVI	A,6
	CALL	ADAHL		;POINT TO LABEL'S VALUE
	LDA	RESULT
	MOV	M,A		;PUT RESULT IN TABLE
	INX	H
	LDA	RESULT+1
	MOV	M,A
	RET
OPSEQ3	MVI	A,6
	CALL	ADAHL		;GET TO VALUE IN S.T.
	MOV	A,M		;GET VALUE INTO H/L
	INX	H
	MOV	H,M
	MOV	L,A
	SHLD	RESULT		;PUT IN RESULT FOR PRINTING
	RET

* END PSEUDO-OP
*    SETS END FLAG AND RETURNS.

OPEND	CALL	LCHECK		;CHECK FOR A LABEL
	MVI	A,1
	STA	ENDFLG		;SET END FLAG
	LDAX	D
	CPI	0DH		;TRANSFER ADDRESS SPECIFIED ?
	RZ			;EXIT IF NOT
	CALL	EVAL		;EVALUATE EXPRESSION
	SHLD	XFRADR		;SAVE IT
	MVI	A,1
	STA	XFRFLG		;SET FLAG
	RET

* RANDOM NUMBER GENERATOR (FOR HASHING)
*    PRODUCES A PSEUDO RANDOM NUMBER FROM THE
*    "SEED" AND LEAVES IT THERE AS A NEW
*    SEED IF NECESSARY.
*  USES A

RANDM	PUSH	H		;SAVE H/L
	PUSH	B		;SAVE B/C
	MVI	B,24		;SET COUNTER
RLOOP	LXI	H,SEED
	MVI	C,3		;SET ROTATE COUNTER
	MOV	A,M		;GET M.S. BYTE OF SEED
	RLC			;SHIFT LEFT THREE TIMES
	RLC			;TO GET BIT #28 IN LINE
	RLC			;WITH BIT #31
	XRA	M		;XOR WITH SEED
	RAL			;GET BIT 28 .XOR. 31
	RAL			;PUT IT IN CARRY
	LXI	H,SEED+2
RROTA	MOV	A,M		;ROTATE ALL THREE BYTES
	RAL			;OF THE SEED, PUTTING THE
	MOV	M,A		;CARRY INTO THE LSB
	DCX	H
	DCR	C
	JNZ	RROTA
	DCR	B
	JNZ	RLOOP		;DO LOOP 24 TIMES
	POP	B		;RESTORE B/C
	POP	H		;RESTORE H/L
	RET

* HASH FUNCTION
*    PRODUCES A HASH ADDRESS INTO THE SYMBOL
*    TABLE FROM THE SEED GIVEN TO THE RANDOM
*    NUMBER ROUTINE.  A COUNT IS KEPT IN THE
*    B REG OF THE NUMBER OF HASH ATTEMPTS
*    MADE.  THE HASH ADDRESS IS RETURNED IN THE
*    H-L REGISTER PAIR.
*  USES ALL

HASH	LHLD	LABEL		;FOLD THE LABEL IN HALF
	XCHG			;TO FORM A SEED FOR THE
	LHLD	LABEL+2		;RANDOM NUMBER ROUTINE
	MOV	A,H
	ADD	L
	STA	SEED
	LHLD	LABEL+4
	MOV	A,D
	ADD	L
	STA	SEED+1
	MOV	A,E
	ADD	H
	STA	SEED+2
	MVI	B,0		;SET HASH COUNT TO 0
REHASH	INR	B		;BUMP HASH COUNT
AGAIN	CALL	RANDM		;GET A RANDOM NUMBER
	LDA	SEED+2
	ANI	0F8H		;MAKE IT A MULTIPLE OF 8
	MOV	E,A
	LDA	SYMTBK		;GET APPROX S.T. SIZE
	MOV	C,A
	LDA	SEED+1
	ANA	C		;LIMIT NBR TO THAT SIZE
	MOV	D,A
	LHLD	SYMBEG		;GET S.T. BEGINNING
	DAD	D		;ADD ON HASH VALUE
	LDA	SYMEND+1
	CMP	H		;COMPARE TO S.T. END
	JC	AGAIN		;TRY AGAIN IF LARGER
	RNZ
	LDA	SYMEND		;CHECK L.S. HALF
	CMP	L
	JC	AGAIN		;TRY AGAIN IF .GE.
	JZ	AGAIN
	RET

* PUT LABEL INTO SYMBOL TABLE
*    PUTS LABEL INTO SYMBOL TABLE AND PUTS
*    THE PRESENT LOCATION COUNTER VALUE IN
*    WITH IT.  IF LABEL IS ALREADY IN TABLE,
*    A MULTIPLY DEFINED FLAG IS SET (THE PARITY
*    BIT OF THE FIRST CHARACTER OF THE LABEL).
*    IF MORE THAN "HSHCNT" (EQUATED TO 40)
*    ATTEMPTS ARE MADE TO PUT THE LABEL, THE
*    SYMBOL TABLE IS CONSIDERED TO BE FULL AND
*    AN ERROR IS SET.
*  USES ALL

PUTLBL	CALL	HASH		;GET HASH ADDRESS
CHKFRE	SHLD	LBLTMP		;SAVE ADDRESS
	MOV	A,M		;GET 1ST CHAR THERE
	ORA	A		;IS THERE A LABEL THERE ?
	JZ	PUTIT		;IF NOT, PUT LABEL
	CALL	CHKLBL		;IS IT THIS LABEL ?
	JNZ	COLISN		;COLLISION IF NOT
	MOV	A,M		;ELSE, GET 1ST CHAR
	ORI	80H		;SET MULT DEFINED FLAG
	MOV	M,A
	RET
COLISN	CALL	REHASH		;GET ANOTHER ADDRESS
	MOV	A,B		;CHECK HASH COUNT
	CPI	HSHCNT		;TOO MANY TRIES ?
	JNZ	CHKFRE		;LOOP IF NOT
	MVI	A,0
	JMP	ERROR		;SYMBOL TABLE IS FULL
PUTIT	LXI	D,LABEL		;POINT TO LABEL
	MVI	C,6
PUTIT1	LDAX	D
	MOV	M,A		;TRANSFER LABEL TO S.T.
	INX	D
	INX	H
	DCR	C
	JNZ	PUTIT1		;LOOP TILL DONE
	LDA	LC		;GET CURRENT ADDRESS
	MOV	M,A		;PUT IT IN TABLE
	INX	H		;ALONG WITH THE SYMBOL
	LDA	LC+1
	MOV	M,A
	RET

* FIND A LABEL IN THE SYMBOL TABLE
*    SEARCHES OUT THE LABEL IN THE SYMBOL TABLE
*    AND RETURNS ITS ADDRESS IN H/L AND LBLTMP.
*    IF FOUND, THE ZERO FLAG IS CLEARED ON RETURN
*    (SET IF NOT FOUND).
*  USES ALL

FNDLBL	CALL	HASH		;GET HASH ADDRESS
FNDLB1	MOV	A,M		;GRAB 1ST CHARACTER
	ORA	A		;A LABEL THERE ?
	RZ			;CLEAR A IF NOT FOUND
	CALL	CHKLBL		;COMPARE LABEL
	JZ	GOTLBL		;GOT LABEL IF SAME
	CALL	REHASH		;ELSE, GET ANOTHER ADDRESS
	MOV	A,B		;GET NUMBER OF TRIES
	CPI	HSHCNT		;COMPARE TO MAX
	JNZ	FNDLB1		;LOOP IF NOT THERE
	XRA	A		;ELSE, NOT FOUND
	RET
GOTLBL	SHLD	LBLTMP		;SAVE LABEL'S ADDRESS
	MVI	A,1
	ORA	A		;SET FOUND FLAG
	RET

* CHECK LABEL AGAINST SYMBOL TABLE
*    COMPARES THE LABEL IN THE LABEL STORE AREA
*    AGAINST THE ONE IN THE SYMBOL TABLE POINTED
*    TO BY THE H-L REGISTER.  IF EQUAL, THE ZERO
*    FLAG IS SET ON RETURN.
*  USES A,D,E

CHKLBL	PUSH	H		;SAVE H/L
	XCHG
	LXI	H,LABEL		;POINT TO LABEL AREA
	LDAX	D		;GET 1ST CHAR OF LABEL
	ANI	7FH		;MASK OFF MULT DEF BIT
CHKLB1	CMP	M		;COMPARE WITH S.T.
	JNZ	CHKDNE		;EXIT IF NOT SAME
	INX	D
	INX	H
	LDAX	D
	CMP	M		;COMPARE 2ND CHARACTERS
	JNZ	CHKDNE		;EXIT IF NOT SAME
	INX	D
	INX	H
	LDAX	D
	CMP	M		;COMPARE 3RD CHARACTERS
	JNZ	CHKDNE		;EXIT IF NOT SAME
	INX	D
	INX	H
	LDAX	D
	CMP	M		;COMPARE 4TH CHARACTERS
	JNZ	CHKDNE		;EXIT IF NOT SAME
	INX	D
	INX	H
	LDAX	D
	CMP	M		;COMPARE 5TH CHARACTERS
	JNZ	CHKDNE		;EXIT IF NOT SAME
	INX	D
	INX	H
	LDAX	D
	CMP	M		;COMPARE 6TH CHARACTERS
CHKDNE	POP	H		;RESTORE H/L
	RET

* COPY LABEL FROM SOURCE INTO LABEL AREA
*    COPIES CHARACTERS FROM THE ADDRESS POINTED
*    TO BY THE H-L REGISTER, UNTIL AN INVALID
*    LABEL CHARACTER IS HIT.  IF THE 6 BYTES OF
*    THE LABEL STORE AREA GET FILLED, THE ROUTINE
*    CONTINUES SCANNING THE SOURCE LOOKING FOR
*    INVALID CHARACTERS FOR A LABEL, STOPPING
*    WHEN IT RECEIVES ONE.
*  USES A,C,D,E,H,L

COPLBL	XCHG
	CALL	CLRLBL		;CLEAR LABEL REGISTER
	XCHG
	MVI	C,6		;SET MAX LENGTH
	LXI	D,LABEL		;POINT TO LABEL STORE AREA
CPLBL1	CALL	LBLCHR		;A LEBAL CHARACTER
	RZ			;RETURN IF NOT
	STAX	D		;PUT IN LABEL AREA
	INX	H
	INX	D
	DCR	C		;SIX CHARACTERS YET ?
	JNZ	CPLBL1		;LOOP IF NOT
CPLBL2	CALL	LBLCHR		;A VALID LABEL CHAR ?
	RZ			;RETURN IF NOT
	INX	H
	JMP	CPLBL2		;SCAN REST OF LABEL

* VALID LABEL CHARACTER CHECK
*    CHECKS TO SEE IF CHARACTER IN A REGISTER IS
*    BETWEEN "?" AND "Z" OR IF IT IS A DIGIT.
*    IF SO, THE ZERO FLAG IS CLEARED.
*  USES A,B

LBLCHR	CALL	CLASS		;CHECK FOR A DIGIT
	JZ	GOODD		;EXIT IF SO

* LABEL CHARACTER CLASSIFY ROUTINE
*    CLASSIFIES THE CHARACTER IN THE A REGISTER
*    AS A VALID OR INVALID LABEL CHARACTER.  A
*    CHARACTER IS VALID IF BETWEEN "?" AND "Z".
*    IF VALID, THE ZERO FLAG IS CLEARED (SET FOR
*    INVALID).
*  USES NONE

LBLCLS	CPI	'?'		;CHECK FOR A ?, @, OR
	JC	NOTD		;A LETTER
	CPI	5BH
	JC	GOODD
	CPI	61H		;CHECK LOWER CASE TOO
	JC	NOTD
	CPI	7BH
	JNC	NOTD
	ORA	A		;SET NON-ZERO IF VALID
	RET

* CLASSIFY ROUTINE
*    CLASSIFIES THE CHARACTER POINTED TO BY THE
*    H-L REGISTER AS A NUMBER (B=1), A LETTER
*    (B=2), OR OTHER (B=0).  UPON EXIT IF THE
*    CHARACTER WAS A NUMBER, THE ZERO FLAG WILL
*    BE SET.  IF A LETTER, THE SIGN FLAG WILL
*    BE CLEARED.  OTHERWISE THE SIGN FLAG WILL
*    BE SET.  THE CHARACTER IS IN THE A REGISTER
*    UPON EXIT.
*  USES A,B

CLASS	MOV	A,M		;GET THE CHARACTER
	MVI	B,0
	CPI	'0'			;CHECK FOR A NUMBER
	JC	CLASS3
	CPI	'9'+1
	JNC	CLASS1
	INR	B		;IF SO, SET B=1
	JMP	CLASS3
CLASS1	ANI	5FH		;LOWER OR UPPER
	CPI	'A'			;CHECK FOR A LETTER
	JC	CLASS3
	CPI	'Z'+1
	JNC	CLASS3		;IF NOT, LEAVE B=0
	MVI	B,2		;IF SO, SET B=2
CLASS3	MOV	A,B
	CPI	1		;COMPARE B TO 1
	MOV	A,M		;RESTORE THE CHARACTER
	RET

* CHECK FOR A DELIMITER
*    CHECKS THE CHARACTER IN THE A REGISTER
*    FOR A COMMA, SPACE, SEMI-COLON, OR A
*    CARRIAGE RETURN.  IF ONE OF THESE, THE
*    ZERO FLAG IS CLEARED ON RETURN.  ELSE
*    THE ZERO FLAG IS SET.
*  USES NONE

ISITD	CPI	','	
	JZ	GOODD		;COMMA IS GOOD
ISITD1	CPI	' '	
	JZ	GOODD		;SPACE IS GOOD
	CPI	9
	JZ	GOODD		;TAB IS GOOD
ISITD2	CPI	SMCOLN	
	JZ	GOODD		;SEMI-COLON IS GOOD
	CPI	0DH
	JZ	GOODD		;CARRIAGE RETURN IS GOOD
NOTD	CMP	A		;ELSE, SET ZERO FLAG
	RET
GOODD	ORA	A		;CLEAR ZERO FLAG
	RET

* CHECK FOR A "SEPARATOR"
*    CHECKS FOR A "DELIMITER" AS ABOVE AND IF
*    NONE OF THOSE, CHECKS FOR A +, -, * OR /
*    CHARACTER.  IF CHARACTER IS ONE OF THESE,
*    THE ZERO FLAG IS CLEARED ON RETURN.
*  USES NONE

ISITS	CALL	ISITD		;SPC, COMMA, SMCLN OR RET ?
	RNZ			;RETURN IF SO
ISITS1	CPI	'.'	
	JZ	NOTD		;PERIOD IS NOT GOOD
	CPI	'*'		;+, -, *, / ARE GOOD
	JC	NOTD
	CPI	'0'	
	JNC	NOTD
	ORA	A		;SO CLEAR ZERO FLAG
	RET

* CONVERT ASCII CHARACTER TO HEX
*    CONVERTS THE ASCII CHARACTER IN THE A
*    REGISTER TO HEXADECIMAL.  IF THE CHAR
*    IS NON-HEX, THE ROUTINE RETURNS WITH
*    THE CARRY CLEARED.
*  USES A

MAKHEX	SUI	'0'			;REMOVE ASCII BIAS
	JC	NOTHEX
	CPI	9+1		;CHECK FOR A NUMBER
	RC			;EXIT IF SO
	ANI	5FH		;FORCE UPPER CASE
	SUI	11H		;BETWEEN "9" AND "A" ?
	JC	NOTHEX		;BAD IF SO
	CPI	6		;BETWEEN "A" AND "F" ?
	RNC			;BAD IF NOT
	ADI	10		;FIX FOR HEX
	STC
	RET
NOTHEX	XRA	A		;CLEAR CARRY
	RET

* FIND A CARRIAGE RETURN
*    LOADS THE LINE POINTER AND SKIPS ALL
*    CHARACTERS IN THE SOURCE LINE UNTIL A
*    CARRIAGE RETURN IS HIT.  RETURNS WITH
*    H-L POINTING TO THE CARRIAGE RETURN.
*  USES A,H,L

FNDCR	LHLD	LINPTR		;GET SOURCE POINTER
FNDCR1	MOV	A,M		;GET A CHARACTER
	CPI	0DH		;IS IT A CARRIAGE RETURN ?
	RZ			;RETURN IF SO
	INX	H
	JMP	FNDCR1		;GO CHECK NEXT CHAR

* SKIP SPACES
*    ASSUMES THE H-L REGISTER POINTS TO SOURCE
*    AND SKIPS ALL SPACES THEREIN, LEAVING THE
*    H-L REGISTER POINTING TO THE FIRST NON-
*    SPACE CHARACTER.
*  USES A,H,L

SKPSP0	INX	H
SKPSP	MOV	A,M		;GET A CHARACTER
	CPI	' '		;IS IT A SPACE ?
	JZ	SKPSP0		;NEXT CHAR IF SO
	CPI	09		;IS IT A TAB ?
	JZ	SKPSP0		;NEXT CHAR IF SO
	RET			;ELSE, RETURN

* NEGATE REGISTER PAIR
*    NEGATES THE VALUE IN THE H/L REGISTER
*    PAIR.
*  USES A,H,L

NEGRP	XRA	A
	SUB	L		;NEGATE L.S. HALF
	MOV	L,A
	MVI	A,0
	SBB	H		;NEGATE M.S. HALF
	MOV	H,A
	RET

* ADD A REGISTER TO THE H/L REGISTER PAIR
*  USES A,H,L

ADAHL	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET

* COMPARE D/E REGISTER PAIR TO H/L PAIR
*    PERFORMS A COMPARE ON THE 2 REGISTER PAIRS
*    SETTING ALL FLAGS THAT A NORMAL MACHINE
*    SINGLE BYTE COMPARE WOULD SET.
*  USES A

CMPDH	MOV	A,H
	CMP	D		;COMPARE D TO H
	RNZ
	MOV	A,L
	CMP	E		;COMPARE E TO L
	RET

* CLEAR ERROR BYTES
*  USES A,B,H,L

CLRERR	LXI	H,ERR0		;POINT TO ERROR BYTE
	MVI	B,10
	XRA	A
	JMP	CLEAR		;GO CLEAR THEM

* CLEAR LABEL STORE AREA
*  USES A,B,H,L

CLRLBL	LXI	H,LABEL		;POINT TO LABEL
	MVI	B,6
	MVI	A,' '		;FILL WITH SPACES
	JMP	CLEAR

* CLEAR ASSEMBLED CODE AREA (NOP'S)
*  USES A,B,H,L

CLRCOD	LXI	H,OPCODE	;POINT TO ASSEMBLED CODE
	MVI	B,3
	XRA	A

* CLEAR A MEMORY AREA
*    FILLS THE NUMBER OF BYTES GIVEN IN THE B
*    REGISTER STARTING WITH THE BYTE POINTED TO
*    BY THE H-L REGISTER PAIR WITH THE CHARACTER
*    STORED IN THE A REGISTER.  (WHEW, THAT WAS
*    A MOUTHFULL).
*  USES B,H,L

CLEAR	MOV	M,A		;PUT CHARACTER IN MEMORY
	INX	H
	DCR	B		;DONE YET ?
	JNZ	CLEAR		;LOOP IF NOT
	RET

* EVALUATE ROUTINE
*    EVALUATES THE ENSUING EXPRESSION AND RETURNS
*    A 16 BIT VALUE IN HL AND IN RESULT.  ADD,
*    SUBTRACT, MULTIPLY AND DIVIDE OPERATIONS ARE
*    ALLOWED WITH LEFT TO RIGHT EVALUATION (NO
*    OPERATOR PRECEDENCE).  UNARY + AND - ARE ALSO
*    ALLOWED.  THE EXPRESSION MAY INVOLVE CONSTANTS
*    (IN HEX, DECIMAL, OCTAL OR BINARY), SYMBOLS,
*    ASCII LITERALS AND CHARACTER STRINGS (ONLY
*    ALLOWED FOR DB PSEUDO-OPS).  IF NO ERROR IS
*    DETECTED DURING EVALUATION, WE RETURN WITH
*    THE ZERO FLAG SET (A ZERO CONDITION).  IF
*    THERE WAS AN ERROR, THE ZERO FLAG IS CLEARED
*    (A NON-ZERO CONDITION).  THERE CAN BE TWO 
*    TYPES OF ERRORS, A NORMAL "OPERAND ERROR"
*    AND A "COMMA ERROR".  A COMMA ERROR IS OB-
*    TAINED WHEN A VALUE HAS BEEN DETERMINED
*    BUT THE DELIMITER CHARACTER FOR THE EX-
*    PRESSION WAS A COMMA AS OPPOSED TO A SPACE,
*    RETURN, OR SEMICOLON.  AN EXCEPTION IS THE
*    DB STRING WHICH ALSO GIVES A COMMA ERROR.
*    A COMMA ERROR RETURNS WITH THE VALUE IN H/L
*    AND RESULT, A NON-ZERO CONDITION, AND THE
*    CARRY BIT SET.  A NORMAL OPERAND ERROR
*    (WHICH IS ANY NON-COMMA ERROR) ZEROES H/L
*    AND RESULT, SETS A NON-ZERO CONDITION AND 
*    CLEARS THE CARRY BIT ON RETURN.
*  USES ALL

EVAL	XRA	A
	STA	OPRATR		;CLER OPERATOR BYTE
EVAL0	LXI	H,0000
	SHLD	TERM		;ZERO THE TERM
	LHLD	LINPTR		;GET SOURCE POINTER
	LDA	DBSIP
	ORA	A		;A DB STRING IN PROGRESS ?
	JNZ	EVAL6		;IF SO, GO TO IT
	XRA	A
	STA	NEGFLG		;CLEAR NEGATE FLAG
	MOV	A,M		;GET 1ST CHARACTER
	CPI	'+'	
	JZ	EVAL1		;SKIP IF A UNARY +
	CPI	'-'			;IS IT A UNARY - ?
	JNZ	EVAL2
	STA	NEGFLG		;IF SO, SET NEGATE FLAG
EVAL1	INX	H
	MOV	A,M		;GET NEXT CHARACTER
EVAL2	CALL	LBLCLS		;A SYMBOL ?
	JNZ	GETSYM		;GET SYMBOL IF SO
	CALL	CLASS		;IF NOT, CLASSIFY CHAR
	JZ	GETNO		;IF A NBR, GO GET IT
	MOV	A,M
	CPI	'%'		;BINARY PREFIX ?
	JZ	GETNO		;GET NUMBER IF SO
	CPI	'&'		;OCTAL PREFIX ?
	JZ	GETNO		;GET NUMBER IF SO
	CPI	'$'		;HEX PREFIX OR PC CHAR ?
	JNZ	EVAL3		;SKIP IF NOT
	INX	H		;CHECK NEXT CHARACTER
	MOV	A,M
	DCX	H
	CALL	MAKHEX		;IS IT A HEX DIGIT ?
	JC	GETNO		;GET HEX NUMBER IF SO
	INX	H		;ELSE, IT WAS A PC CHAR
	SHLD	LINPTR
	LHLD	LC		;GET PC ADDRESS
	SHLD	TERM
	JMP	FINEVL		;FINISH EVALUATION
EVAL3	CPI	''''		;IS CHAR A SINGLE QUOTE ?
	JNZ	EVAL5		;SKIP IF NOT
	INX	H
	MOV	A,M		;GET NEXT CHAR
	CPI	0DH
	JZ	OPRERR		;ERROR IF A RETURN
	MOV	B,A		;ELSE SAVE THE CHARACTER
	INX	H
	MOV	A,M		;GET THE NEXT CHAR
	CPI	''''		;A SINGLE QUOTE ?
	JNZ	EVAL4		;SKIP IF NOT
	INX	H
	SHLD	LINPTR
	MOV	L,B		;ELSE, PUT ASCII CHARACTER
	MVI	H,0		;INTO RESULT
	SHLD	TERM
	JMP	FINEVL		;GO FINISH EVALUATION
EVAL4	DCX	H		;REPOSITION POINTER
	DCX	H
	MOV	A,M		;GET CHARACTER
EVAL5	CPI	20H		;A CONTROL CHARACTER ?
	JC	OPRERR		;ERROR IF SO
	CPI	','		;A COMMA ?
	JZ	OPRERR		;ERROR IF SO
	LDA	OPTYPE
	CPI	7		;IS THIS A DB INSTRUCTION ?
	JNZ	OPRERR		;ERROR IF NOT

* EVALUATE A DB STRING
*    IF WE ARRIVE HERE WE HAVE A DB STRING.  THE
*    STRING IS PARSED WITH THE DELIMITER SAVED
*    AND THE NEXT CHARACTER (IF ONE IS AVAILABLE)
*    BEING PICKED UP AND ITS ASCII REPRESENTATION
*    PLACED IN RESULT.  IF MORE CHARACTERS REMAIN
*    IN THE STRING, THE DBSIP FLAG (DB STRING IN
*    PROGRESS FLAG) IS SET TO INDICATE SUCH.
*    SUBSEQUENT CALLS TO EVAL WILL THEN CAUSE A
*    JUMP DIRECTLY INTO EVAL6 WHERE THE DELIMITER
*    IS PICKED UP AND THE NEXT CHARACTER READ.
*    NOTE THAT TWO DELIMITERS IN A ROW WILL
*    APPEAR AS ONE SUCH CHARACTER IN THE STRING
*    AND WILL NOT TERMINATE THE STRING.

	LDA	OPRATR
	ORA	A		;IS THERE AN OPERATOR ?
	JNZ	OPRERR		;ERROR IF SO
	LDA	NEGFLG
	ORA	A		;IS NEGATE FLAG SET ?
	JNZ	OPRERR		;ERROR IF SO
	MOV	A,M		;GET FIRST CHARACTER
	STA	DELIM		;MAKE IT STRING DELIMITER
	INX	H
EVAL6	LDA	DELIM		;GET DELIMITER
	MOV	B,A		;SAVE IT IN "B"
	MOV	A,M		;GET A CHARACTER
	CPI	0DH		;A CARRIAGE RETURN ?
	JZ	DBSERR		;ERROR IF SO
	CMP	B		;A DELIMITER ?
	JNZ	EVAL7		;SKIP IF NOT
	INX	H
	MOV	A,M		;CHECK NEXT CHARACTER
	CMP	B		;A DELIMITER ?
	JNZ	EVAL9		;DONE IF NOT
EVAL7	STA	RESULT		;GET ASCII IN RESULT
	XRA	A
	STA	RESULT+1
	INX	H
	MOV	A,M		;CHECK NEXT CHARACTER
	CMP	B		;A DELIMITER ?
	JNZ	EVAL8		;GOT CHARACTER IF NOT
	INX	H
	MOV	A,M		;CHECK NEXT CHARACTER
	CMP	B		;A DELIMITER ?
	JNZ	EVAL9		;DONE IF NOT
	DCX	H
EVAL8	MVI	A,1		;SET THE DB STRING IN
	STA	DBSIP		;PROGRESS FLAG
	DCX	H		;BACKUP POINTER
	SHLD	LINPTR
	JMP	CMMERR		;EXIT WITH A COMMA ERROR
EVAL9	XRA	A
	STA	DBSIP		;CLEAR IN PROGRESS FLAG
	MOV	A,M		;GET A CHARACTER
	SHLD	LINPTR
	LHLD	RESULT
	CPI	','		;IS CHARACTER A COMMA ?
	JZ	FINEV2
	CALL	ISITS1		;IS IT AN OPERATOR ?
	JZ	FINEV2
	JMP	OPRERR		;ERROR IF AN OPERATOR

* GET A SYMBOL
*    FINDS THE SYMBOL POINTED TO BY THE H/L REGISTER
*    IN THE SYMBOL TABLE, AND GETS THE VALUE
*    ASSOCIATED WITH THAT SYMBOL INTO TERM FOR
*    USE IN EVALUATION OF AN OPERAND.

GETSYM	LDA	ERR4		;GET SYMBOL ERROR BYTE
	STA	ERRTMP		;SAVE IT
	XRA	A
	STA	ERR4		;CLEAR ERROR BYTE
	XCHG			;SAVE SOURCE POINTER
	LHLD	LBLTMP
	SHLD	LBLTP2		;SAVE LABEL ADDRESS
	XCHG			;RESTORE SOURCE POINTER
	CALL	COPLBL		;COPY TO LABEL AREA
GETSM1	MOV	A,M		;GET LABEL TERMINATOR
	CALL	ISITS		;IS IT A SEPARATOR ?
	JNZ	GETSM3		;SKIP IF SO
	MVI	A,4
	CALL	ERROR		;ELSE SET SYMBOL ERROR
	INX	H
	CALL	CPLBL2		;SCAN REST OF SYMBOL
	JMP	GETSM1
GETSM3	SHLD	LINPTR
	LDA	ERR4		;WAS THERE AN ERROR ?
	ORA	A
	JZ	GETSM4		;SKIP IF NOT
	MVI	C,4
	JMP	GETSM5		;IF SO, EXIT
GETSM4	CALL	FNDLBL		;FIND LABEL IN S.T.
	JNZ	GETSM6		;SKIP IF FOUND
	MVI	C,1		;ELSE SET UNDEFINED ERROR
GETSM5	LHLD	LBLTP2
	SHLD	LBLTMP		;RESTORE LABEL ADDRESS
	LXI	H,ERR4		;POINT TO ERROR BYTE
	LDA	ERRTMP		;GET TEMP ERROR
	ORA	M		;LOGICALLY OR THEM
	MOV	M,A		;AND MAKE IT NEW ERROR BYTE
	MOV	A,C		;GET ERROR NUMBER
	JMP	OPRER1		;EXIT WITH AN ERROR
GETSM6	MVI	A,6
	CALL	ADAHL		;GET TO SYMBOL'S VALUE
	MOV	A,M		;GET THE VALUE INTO H/L
	INX	H
	MOV	H,M
	MOV	L,A
	SHLD	TERM		;SAVE RESULT
	LHLD	LBLTP2
	SHLD	LBLTMP		;RESTORE LABEL ADDRESS
	LDA	ERRTMP
	STA	ERR4		;RESTORE ERROR BYTE
	JMP	FINEVL		;FINISH EVALUATIO

* GET A NUMBER FROM SOURCE
*    PARSES THE SOURCE LINE POINTED TO BY THE H/L
*    REGISTER TO DETERMINE A 16 BIT BINARY VALUE
*    FROM THE HEX, DECIMAL, OCTAL OR BINARY NUMBER
*    GIVEN.  ALLOWS PREFIXES OR POSTFIXES FOR BASE
*    SPECIFICATION.  LEAVES THE H/L POINTING AFTER
*    THE NUMBER

GETNO	CALL	CLASS		;CLASSIFY THE CHARACTER
	JZ	GETNO1		;SKIP IF A DIGIT
	MOV	A,M
	INX	H
	CPI	'$'		;HEX PREFIX ?
	JZ	HEX		;GO TO HEX ROUTINE
	CPI	'&'		;OCTAL PREFIX ?
	JZ	OCTAL		;GO TO OCTAL ROUTINE
	CPI	'%'		;BINARY PREFIX ?
	JZ	BIN		;GO TO BINARY ROUTINE
	JMP	CNSERR		;ERROR IF NONE
GETNO1	MOV	D,H		;SAVE POINTER IN D/E
	MOV	E,L
GETNO2	INX	H
	MOV	A,M		;GET NEXT CHARACTER
	CALL	ISITS		;IS IT A SEPARATOR ?
	JZ	GETNO2		;LOOP IF NOT
	DCX	H		;CHECK LAST CHARACTER
	CALL	CLASS		;CLASSIFY IT
	XCHG			;RESTORE POINTER
	JZ	DECML		;DECIMAL IF A DIGIT
	LDAX	D		;GET LAST CHARACTER
	ANI	5FH		;FORCE UPPER CASE
	CPI	'H'		;HEX POSTFIX ?
	JZ	HEX		;GO TO HEX ROUTINE
	CPI	'Q'		;OCTAL POSTFIX ?
	JZ	OCTAL		;GO TO OCTAL ROUTINE
	CPI	'O'		;OCTAL POSTFIX ?
	JZ	OCTAL		;GO TO OCTAL ROUTINE
	CPI	'B'		;BINARY POSTFIX ?
	JZ	BIN		;GO TO BINARY ROUTINE
	CPI	'D'		;DECIMAL POSTFIX ?
	JZ	DECML		;GO TO DECIMAL ROUTINE
	JMP	CNSERR		;ERROR IF NONE

* DECIMAL CONVERSION ROUTINE

DECML	MVI	B,'D'		;SAVE POSTFIX
	XCHG
DECML1	LXI	H,0000
DECML2	LDAX	D		;GET FIRST CHAR
	SUI	'0'		;REMOVE ASCII BIAS
	JC	DECML3
	CPI	9+1		;A DECIMAL DIGIT ?
	JNC	DECML3		;FINISH UP IF NOT
	PUSH	D
	DAD	H		;NUMBER*2
	MOV	D,H		;SAVE (NBR * 2)
	MOV	E,L
	DAD	H		;NUMBER * 4
	DAD	H		;NUMBER * 8
	DAD	D		;NUMBER * 10
	POP	D
	CALL	ADAHL		;ADD IN DIGIT'S VALUE
	INX	D		;POINT TO NEXT CHARACTER
	JMP	DECML2		;LOOP BACK
DECML3	MVI	A,'D'
	CMP	B		;ENTERED EXTERNALLY ?
	JZ	POST		;JUMP IF NOT
	RET

* OCTAL CONVERSION ROUTINE

OCTAL	MVI	B,'Q'		;SAVE POSTFIX
	XCHG
	LXI	H,0000
OCTAL2	LDAX	D		;GET A CHARACTER
	SUI	'0'		;REMOVE ASCII BIAS
	JC	POST
	CPI	7+1		;IS IT AN OCTAL DIGIT ?
	JNC	POST		;FINISH UP IF NOT
	DAD	H		;NUMBER * 2
	DAD	H		;NUMBER * 4
	DAD	H		;NUMBER * 8
	ADD	L		;ADD IN DIGIT'S VALUE
	MOV	L,A
	INX	D		;POINT TO NEXT CHARACTER
	JMP	OCTAL2		;LOOP BACK

* HEXADECIMAL CONVERSION ROUTINE

HEX	MVI	B,'H'		;SAVE POSTFIX
	XCHG
	LXI	H,0000
HEX2	LDAX	D		;GET A CHARACTER
	CALL	MAKHEX		;CONVERT TO HEX
	JNC	POST		;FINISH UP IF NON-HEX
	DAD	H		;TAKE NUMBER * 16
	DAD	H
	DAD	H
	DAD	H
	ADD	L		;ADD IN DIGIT
	MOV	L,A
	INX	D		;POINT TO NEXT CHARACTER
	JMP	HEX2		;LOOP BACK

* BINARY CONVERSION ROUTINE

BIN	MVI	B,'B'		;SAVE POSTFIX
	XCHG
	LXI	H,0000
BIN2	LDAX	D		;GET A CHARACTER
	SUI	'0'		;REMOVE ASCII BIAS
	JC	POST
	CPI	1+1		;A BINARY DIGIT ?
	JNC	POST		;FINISH UP IF NON-BINARY
	DAD	H		;NUMBER * 2
	ADD	L		;ADD IN BINARY DIGIT
	MOV	L,A
	INX	D		;POINT TO NEXT CHARACTER
	JMP	BIN2		;LOOP BACK

* CHECK FOR POSTFIX ON NUMBER
*    CHECKS THE CHARACTER WHICH KICKED US OUT OF
*    THE CONVERSION ROUTINE.  IF IT IS A POSTFIX,
*    IT MUST BE THE PROPER ONE OR THERE IS AN
*    ERROR.  OTHERWISE IT MUST BE A SEPARATOR.
*    THE B REGISTER IS ASSUMED TO HOLD THE PROPER
*    POSTFIX ON ENTRY.

POST	SHLD	TERM		;SAVE NUMBER
	XCHG
	MOV	A,M		;GET THE TERMINATOR
	ANI	5FH		;FORCE UPPER CASE
	INX	H
	CMP	B		;IS IT THE PROPER POSTFIX ?
	JZ	POST1		;FINISH UP IF SO
	PUSH	PSW		;SAVE CHARACTER
	MOV	A,B		;GET POSTFIX CHAR
	CPI	'Q'		;OCTAL NUMBER
	JNZ	POST0		;SKIP IF NOT
	MVI	B,'O'		;ELSE SET NEW POSTFIX (O)
POST0	POP	PSW		;RESTORE CHARACTER
	CMP	B		;COMPARE NEW POSTFIX
	JZ	POST1		;FINISH UP IF A MATCH
	DCX	H
	MOV	A,M		;GET THE CHARACTER
	CALL	ISITS		;IS IT A SEPARATOR ?
	JZ	CNSERR		;ERROR IF NOT
POST1	SHLD	LINPTR
	JMP	FINEVL		;FINISH EVALUATIO
CNSERR	MVI	A,8		;SET CONSTANT ERROR
	JMP	OPRER1		;EXIT EVAL ROUTINE

* SUBTRACT ROUTINE
*    SUBTRACTS THE VALUE IN THE H/L REGISTER
*    FROM RESULT.

SUBB	CALL	NEGRP		;NEGATE CONTENTS OF H/L

* ADD ROUTINE
*    ADDS THE CONTENTS OF THE H/L REGISTER TO
*    RESULT.

ADDD	XCHG
	LHLD	RESULT		;GET RESULT
	DAD	D		;ADD TO IT
	JMP	FINEV2		;FINISH UP

* MULTIPLY ROUTINE
*    MULTIPLIES THE CONTENTS OF THE H/L REG
*    TIMES RESULT.  THIS IS AN UNSIGNED
*    MULTIPLY AND ONLY THE LEAST SIGNIFICANT
*    16 BITS ARE RETURNED IN THE H/L REG.

MUL	LXI	D,0000
	MVI	B,16		;SET COUNT
MUL1	XCHG
	DAD	H		;SHIFT ANSWER LEFT 1
	XCHG
	DAD	H		;SHIFT H-L LEFT ONE
	JNC	MUL2		;SKIP IF NO CARRY
	PUSH	H
	LHLD	RESULT		;ADD IN CONTENTS OF RESULT
	DAD	D
	XCHG			;PUT BACK IN D-E
	POP	H
MUL2	DCR	B
	JNZ	MUL1		;LOOP TILL DONE
	XCHG			;ANSWER INTO H-L
	JMP	FINEV2

* DIVIDE ROUTINE
*    DIVIDES RESULT BY THE VALUE IN TERM.  THIS IS
*    AN UNSIGNED DIVIDE WITH NO REMAINDER RETURNED.
*    THE QUOTIENT IS RETURNED IN THE H/L REGISTER.

DIV	LHLD	RESULT
	LXI	D,0000
	MVI	B,17		;SET COUNT
DIV1	PUSH	H
	LHLD	TERM
	CALL	NEGRP		;SUBTRACT OFF DIVISOR
	DAD	D
	XCHG
	JC	DIV2		;SKIP IF A CARRY OUT
	LHLD	TERM
	DAD	D		;ELSE, ADD BACK IN
	XCHG
	XRA	A		;AND CLEAR CARRY BIT
DIV2	POP	H
	MOV	A,L
	RAL			;ROTATE THE QUOTIENT TO
	MOV	L,A		;THE LEFT ONE PLACE
	MOV	A,H
	RAL
	MOV	H,A
	MOV	A,E
	RAL
	MOV	E,A
	MOV	A,D
	RAL
	MOV	D,A
	DCR	B
	JNZ	DIV1		;LOOP TILL DONE
	JMP	FINEV2

* FINISH EVALUATION
*    THIS COMPLETES THE EXPRESSION EVALUATION BY
*    LOOKING FOR AN OPERATOR OR DELIMITER AND
*    TAKING THE PROPER ACTION.

FINEVL	LHLD	TERM		;GET TERM
	LDA	NEGFLG
	ORA	A		;SHOULD IT BE NEGATED ?
	JZ	FINEV1
	CALL	NEGRP		;IF SO, DO IT
FINEV1	LDA	OPRATR		;GET PREVIOUS OPERATOR
	ORA	A
	JZ	FINEV2		;SKIP IF NONE
	CPI	'+'
	JZ	ADDD		;DO ADD IF +
	CPI	'-'
	JZ	SUBB		;DO SUBTRACT IF -
	CPI	'*'
	JZ	MUL		;DO MULTIPLY IF *
	CPI	'/'
	JZ	DIV		;DO DIVIDE IF /
	JMP	OPRERR		;ELSE, IT'S AN ERROR
FINEV2	XRA	A
	STA	OPRATR		;CLEAR OPERATOR
	SHLD	RESULT		;SAVE RESULT
	LHLD	LINPTR
	MOV	A,M		;GET NEXT CHAR FROM SOURCE
	CPI	','		;A COMMA ?
	JZ	CMMERR		;IF SO, A "COMMA ERROR"
	CALL	ISITD		;A DELIMITER ?
	JNZ	FINEV3		;SKIP IF SO
	CALL	ISITS		;A SEPARATOR ?
	JZ	OPRERR		;ERROR IF NOT
	STA	OPRATR		;SAVE IT AS OPERATOR
	INX	H
	SHLD	LINPTR		;SAVE LINE POINTER
	JMP	EVAL0		;GET NEXT TERM
FINEV3	SHLD	LINPTR
	LHLD	RESULT		;LOAD RESULT INTO H/L
	XRA	A		;SET GOOD OPERAND FLAG
	RET

* DB STRING ERROR

DBSERR	XRA	A
	STA	DBSIP		;TURN OFF IN PROGRESS FLAG

* OPERAND ERROR
*    SETS OPERAND ERROR, CLEARS RESULT AND
*    RETURNS WITH ZERO FLAG CLEARED.

OPRERR	MVI	A,5
OPRER1	CALL	ERROR		;SET IN ERROR
	LXI	H,0000
	SHLD	RESULT		;CLEARS RESULT
	MVI	A,1
	ORA	A		;SET BAD OPERAND FLAG
	RET

* COMMA ERROR
*    IF THE OPERAND PARSED GOOD AND A VALUE WAS
*    OBTAINED, BUT IT WAS ENDED WITH A COMMA AS
*    A DELIMITER, WE HAVE A COMMA ERROR.  THIS
*    LEAVES THE COMPUTED VALUE IN RESULT, CLEARS
*    THE ZERO FLAG, AND SETS THE CARRY.  ANYTHING
*    BUT A DB OR DW WILL ALSO RECEIVE AN OPERAND
*    ERROR SET.

CMMERR	LDA	DBDWF
	ORA	A		;A DB OR DW INSTRUCTION ?
	JNZ	CMERR1		;SKIP IF SO
	MVI	A,5		;ELSE, SET OPERAND ERROR
	CALL	ERROR
CMERR1	LHLD	RESULT		;GET RESULT
	MVI	A,1
	ORA	A		;SET BAD OPERAND FLAG
	STC			;SET COMMA ERROR FLAG
	RET

* SYMBOL TABLE SORT ROUTINE
*    SORTS THE SYMBOL TABLE INTO ASCENDING ASCII
*    ORDER.  BEFORE SORTING, THE SYMBOL TABLE IS
*    COMPRESSED.  THE SORT METHOD USED IS THE QUICKSORT.

SORT	CALL	PACK		;COMPRESS THE TABLE
	LXI	H,BUFFER
	SHLD	SRSP		;SET S.R. STACK POINTER
	XCHG
	CALL	HLSUB8		;GET UPPER LABEL POINTER
	XCHG
	LHLD	SYMBEG		;GET FIRST LABEL POINTER
	CALL	PPUSH		;PUSH THEM ON S.R. STACK
SORT2	LHLD	SRSP		;PULL A SORT REQUEST
	DCX	H
	MOV	E,M		;GET RIGHT ADDRESS
	DCX	H
	MOV	D,M
	XCHG
	SHLD	RIGHT		;SAVE IT
	XCHG
	DCX	H
	MOV	E,M		;GET LEFT ADDRESS
	DCX	H
	MOV	D,M
	SHLD	SRSP		;SAVE NEW S.R. SP
	XCHG
	SHLD	LEFT
SORT3	LHLD	LEFT		;GET LEFT ADDRESS
	SHLD	I		;SET I=LEFT
	XCHG
	LHLD	RIGHT		;GET RIGHT ADDRESS
	SHLD	J		;SET J=RIGHT
	CALL	CMPDH		;COMPARE THEM
	JZ	SORT12		;FINISHED PARTITION IF
	JC	SORT12		;I .GE. J
SORT4	CALL	CMPLBL		;COMPARE J TO I
	JC	SORT6		;SKIP IF I .LT. J
	CALL	XCHNGE		;SWAP LABELS
SORT5	CALL	DEADD8		;INCREMENT I
	CALL	CMPDH		;FINISHED PARTITION ?
	JZ	SORT7		;SKIP IF SO
	CALL	CMPLBL		;COMPARE I TO J
	JC	SORT5		;JUMP IF I .LT. J
	CALL	XCHNGE		;SWAP LABELS
SORT6	CALL	HLSUB8		;DECREMENT J
	CALL	CMPDH		;FINISHED PARTITION ?
	JNZ	SORT4		;JUMP IF NOT
SORT7	CALL	DEADD8		;INCREMENT I
	CALL	HLSUB8		;DECREMENT J
	SHLD	J		;SAVE THEM
	XCHG
	SHLD	I
	LHLD	LEFT		;COMPUTE (J-LEFT)
	CALL	NEGRP
	DAD	D
	PUSH	H		;SAVE IT
	LHLD	RIGHT		;COMPUTE (RIGHT-I)
	XCHG
	LHLD	I
	CALL	NEGRP
	DAD	D
	XCHG			;(RIGHT-I) INTO D/E
	POP	H		;(J-LEFT) INTO H/L
	CALL	CMPDH		;COMPARE THEM
	JC	SORT10		;SKIP IF (RIGHT-I) IS .GT.
	LHLD	J
	XCHG
	LHLD	LEFT
	CALL	CMPDH		;COMPARE J TO LEFT
	CC	PPUSH		;PUSH SORT REQUEST IF .GT.
	LHLD	I
	SHLD	LEFT		;SET NEW LEFT (=I)
	JMP	SORT11		;JUMP AHEAD
SORT10	LHLD	RIGHT
	XCHG
	LHLD	I
	CALL	CMPDH		;COMPARE RIGHT TO I
	CC	PPUSH		;PUSH SORT REQUEST IF .GT.
	LHLD	J
	SHLD	RIGHT		;SET NEW RIGHT (=J)
SORT11	LHLD	RIGHT
	XCHG
	LHLD	LEFT
	CALL	CMPDH		;IS PARTITION SORTED ?
	JC	SORT3		;JUMP BACK IF NOT
SORT12	LXI	D,BUFFER
	LHLD	SRSP
	CALL	CMPDH		;SORT REQUEST STACK EMPTY ?
	JNZ	SORT2		;LOOP BACK IF NOT
	RET

* EXCHANGE LABELS
*    THE TWO LABELS AND ASSOCIATED VALUES WHICH 
*    ARE POINTED TO BY THE DE AND HL REGISTERS ARE
*    CAUSED TO CHANGE POSITIONS.
*  USES A,B,C

XCHNGE	PUSH	H
	PUSH	D
	MVI	C,8		;SET COUNT
XCHNG1	MOV	B,M		;GET CHAR FROM HL
	LDAX	D		;GET CHAR FROM DE
	MOV	M,A		;STORE ONE
	MOV	A,B
	STAX	D		;STORE THE OTHER
	INX	D		;POINT TO NEXT
	INX	H
	DCR	C		;DONE YET ?
	JNZ	XCHNG1		;LOOP IF NOT
	POP	D
	POP	H
	RET

* DECREMENT HL REGISTER PAIR BY 8
*  USES H,L

HLSUB8	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	RET

* INCREMENT DE REGISTER PAIR BY 8
*  USES D,E

DEADD8	INX	D
	INX	D
	INX	D
	INX	D
	INX	D
	INX	D
	INX	D
	INX	D
	RET

* PUSH SORT REQUEST ONTO STACK
*    PUSHES A SORT REQUEST ONTO THE "SORT REQUEST
*    STACK" IN THE FORM OF A LEFT ADDRESS FROM HL AND
*    A RIGHT ADDRESS FROM DE.
*  USES B,C,H,L

PPUSH	MOV	B,H		;PUT LEFT REQUEST INTO BC
	MOV	C,L
	LHLD	SRSP		;GET S.R. STACK POINTER
	MOV	M,B		;PUSH LEFT REQUEST
	INX	H
	MOV	M,C
	INX	H
	MOV	M,D		;PUSH RIGHT REQUEST
	INX	H
	MOV	M,E
	INX	H
	SHLD	SRSP		;SAVE NEW STACK POINTER
	RET

* COMPARE TWO LABELS
*    COMPARES THE TWO LABELS POINTED TO BY THE DE
*    AND HL REGISTERS.  SETS ALL THE FLAGS A NORMAL
*    MACHINE COMPARE WOULD SET.
*  USES A

CMPLBL	PUSH	D		;SAVE REGISTERS
	PUSH	H
	CALL	CMPLB1		;PERFORM COMPARE
	POP	H		;RESTORE REGISTERS
	POP	D
	RET
CMPLB1	PUSH	H		;MAKE USE OF CHKLBL
	LDAX	D
	JMP	CHKLB1

* COMPRESS THE SYMBOL TABLE FOR SORT
*    COMPRESSES THE SYMBOL TABLE BY REMOVING
*    ALL EMPTY ENTRIES AND PLACING THEM AT THE
*    TOP WHILE MOVING OTHERS DOWN.  ALSO
*    STRIPS THE PARITY BIT OFF THE FIRST
*    CHARACTER OF ALL LABELS.  ON RETURN, THE
*    FIRST EMPTY SPOT IN THE TABLE IS POINTED
*    TO BY THE CONTENTS OF D/E.
*  USES ALL

PACK	LHLD	SYMBEG		;GET TABLE START
	XCHG
	LHLD	SYMEND		;AND TABLE END
	INX	H
PACK0	CALL	HLSUB8
PACK1	LDAX	D		;CHECK FOR EMPTY ENTRY
	ORA	A
	JZ	PACK2		;SKIP IF SO
	ANI	7FH		;ELSE STRIP PARITY
	STAX	D
	CALL	DEADD8		;POINT TO NEXT ENTRY
	CALL	CMPDH		;FINISHED ?
	JNZ	PACK1		;LOOP IF NOT
	MOV	A,M		;WAS TABLE FULL ?
	ORA	A
	RZ			;RETURN IF NOT
	JMP	DEADD8		;ELSE, POINT TO NEXT
PACK2	MOV	A,M		;CHECK UPPER END FOR EMPTY
	ORA	A
	JNZ	PACK3		;SKIP IF NOT
	CALL	CMPDH		;FINISHED ?
	RZ			;RETURN IF SO
	CALL	HLSUB8		;BACK UP ONE ENTRY
	JMP	PACK2		;GO TRY THIS ONE
PACK3	ANI	7FH		;STRIP PARITY
	MOV	M,A
	MVI	B,8		;SET EXCHANGE COUNT
PACK4	MOV	A,M		;GET UPPER LABEL CHAR
	STAX	D		;STORE IN LOWER LABEL
	MVI	M,0		;CLEAR UPPER LABEL
	INX	H
	INX	D
	DCR	B
	JNZ	PACK4		;LOOP TILL DONE
	JMP	PACK0		;GO LOOK FOR MORE EMPTIES

* PUNCH ASSEMBLED CODE
*    PRODUCES AN INTEL FORMAT TAPE BY STORING
*    EACH INSTRUCTION'S DATA IN 'BUFFER' UNTIL
*    FULL.  AT THAT POINT, THE BUFFER IS OUTPUT
*    TO THE TAPE AND REFILLED AS NECESSARY.

PUNCH	LDA	OBJYET		;ANY CODE YET ?
	ORA	A
	JNZ	PUNCH1		;SKIP IF SO
	CMA
	STA	OBJYET		;SET FLAG
PUNCH1	LHLD	LC		;GET PRESENT ADDRESS
	XCHG
	LHLD	OBJADR		;CALCULATE TAPE ADDRESS
	LDA	BUFCNT
	CALL	ADAHL
	CALL	CMPDH		;ARE THEY SAME ?
	JZ	PUNCH2		;SKIP IF SO
	CALL	RECORD		;FLUSH BUFFER
	LHLD	LC
	SHLD	OBJADR		;SET NEW TAPE ADDRESS
PUNCH2	LDA	OPTYPE
	CPI	6		;A DS PSEUDO-OP ?
	RZ			;RETURN IF SO
	LDA	BYTES		;GET NBR OF BYTES
	ORA	A
	RZ			;EXIT IF NONE
	MOV	B,A
	LXI	H,BUFFER	;POSITION BUFFER POINTER
	LDA	BUFCNT
	CALL	ADAHL
	LDA	BUFCNT
	ADD	B		;FIND NEW BUFFER POINTER
	MOV	B,A
	STA	BUFCNT		;SAVE IT
	LXI	D,OPCODE		;POINT TO CODE
	MVI	C,3
PUNCH3	LDAX	D		;GET A BYTE
	MOV	M,A		;PUT INTO BUFFER
	INX	D		;INCREMENT POINTERS
	INX	H
	DCR	C		;3 BYTES MOVED YET ?
	JNZ	PUNCH3		;LOOP IF NOT
	MOV	A,B		;GET BUFFER COUNT
	CPI	RCSZ		;COMPARE TO RECORD SIZE
	RC			;EXIT IF LESS
	CALL	RECORD		;ELSE, PUNCH A RECORD
	LHLD	BUFFER+RCSZ
	SHLD	BUFFER		;MOVE LEFT-OVERS DOWN
	MOV	A,B		;GET COUNT
	SUI	RCSZ		;HOW MANY LEFT-OVERS ?
	STA	BUFCNT		;MAKE IT NEW COUNT
	LHLD	OBJADR
	MVI	A,RCSZ
	CALL	ADAHL		;GET NEW TAPE ADDRESS
	SHLD	OBJADR
	RET

* PUNCH REMAINDER OF CODE AND TURN OFF TAPE
*    FLUSHES THE REMAINING DATA IN THE OBJECT
*    CODE BUFFER AND TURNS OFF THE TAPE
*    DEVICE AFTER DELAYING.

ENDPUN	CALL	RECORD		;FLUSH OBJECT CODE BUFFER
	MVI	A,':'		;PRINT END RECORD
	CALL	TOUCH
	XRA	A		;ZERO BYTE COUNT
	CALL	PUNBYT
	MVI	A,0DH
	CALL	TOUCH		;OUTPUT A RETURN
	MVI	A,0AH
	CALL	TOUCH		;OUTPUT A LINE FEED
	RET

* PUNCH ONE RECORD ON TAPE
*    OUTPUTS THE CONTENTS OF THE OBJECT CODE
*    BUFFER TO TAPE IN ONE INTEL FORMAT RECORD.

RECORD	LDA	BUFCNT		;ANYTHING IN BUFFER ?
	ORA	A
	RZ			;EXIT IF NOT
	CPI	RCSZ		;IS BUFFER OVERFLOWED ?
	JC	RECD1		;SKIP IF NOT
	MVI	A,RCSZ		;LIMIT RECORD SIZE
RECD1	MOV	D,A		;RECORD LENGTH IN D
	MVI	E,0		;ZERO THE CHECKSUM IN E
	MVI	A,':'		;PRINT RECORD START MARKER
	CALL	TOUCH
	MOV	A,D		;PRINT RECORD LENGTH
	CALL	PUNBYT
	LHLD	OBJADR
	MOV	A,H		;PRINT M.S. HALF OF ADDRESS
	CALL	PUNBYT
	MOV	A,L		;PRINT L.S. HALF OF ADDRESS
	CALL	PUNBYT
	XRA	A		;PRINT RECORD TYPE
	CALL	PUNBYT
	LXI	H,BUFFER	;POINT TO CODE BUFFER
RECD2	MOV	A,M		;GET A BYTE
	CALL	PUNBYT		;PUNCH IT
	INX	H
	DCR	D
	JNZ	RECD2		;LOOP TILL DONE
	XRA	A
	STA	BUFCNT		;RESET BUFFER COUNT
	SUB	E		;CALCULATE CHECKSUM
	CALL	PUNBYT		;AND PRINT IT
	MVI	A,0DH
	CALL	TOUCH		;OUTPUT A RETURN
	MVI	A,0AH
	CALL	TOUCH		;OUTPUT A LINE FEED
	RET

* PUNCH ONE BYTE

PUNBYT	MOV	C,A		;SAVE CHARACTER IN C
	ADD	E		;UPDATE CHECKSUM
	MOV	E,A
	MOV	A,C
	CALL	HEXL		;PRINT M.S. HALF
	CALL	TOUCH
	MOV	A,C
	CALL	HEXR		;PRINT L.S. HALF
	JMP	TOUCH

* PUT BINARY OBJECT CODE
*    PUTS ASSEMBLED DATA INTO A TEMPORARY RECORD
*    BUFFER CALLED BINBUF.  WHEN THE BUFFER IS FULL,
*    THIS ROUTINE CALLS BINREC TO WRITE THE RECORD
*    OUT TO THE DISK.  EACH RECORD HAS AN 02 HEX
*    BYTE AS A START MARKER, A ONE BYTE RECORD
*    LENGTH, THE RECORD'S LOAD ADDRESS (M.S. HALF
*    FIRST) AND THE ACTUAL DATA.

PUTBIN	LHLD	BINBUF
	LDA	BBYTCT
	CALL	ADAHL		;FIND ABSOLUTE ADDRESS
	XCHG
	LHLD	LC		;GET PRESENT ADDRESS
	CALL	CMPDH		;ARE THEY SAME ?
	CNZ	BINREC		;DUMP BUFFER IF NOT
	LDA	BYTES
	ORA	A		;ANY DATA ?
	RZ			;RETURN IF NOT
	LDA	OPTYPE
	CPI	6		;A DS PSEUDO-OP ?
	RZ			;EXIT IF SO
	LXI	H,BBYTCT+1
	LDA	BBYTCT		;GET ADDRESS OF DATA IN
	CALL	ADAHL		;THE BINARY BUFFER
	LXI	D,OPCODE		;POINT TO CODE
	MVI	C,3		;SET UP TO MOVE 3
PUTBN1	LDAX	D		;MOVE THE CODE
	MOV	M,A
	INX	H
	INX	D
	DCR	C
	JNZ	PUTBN1		;LOOP TILL DONE
	LDA	BYTES
	LXI	H,BBYTCT
	ADD	M		;GET NEW RECORD COUNT
	MOV	M,A		;SAVE IT
	CPI	253		;TIME TO DUMP BUFFER ?
	CNC	BINREC		;IF SO, DUMP IT
	RET

* ROUTINE TO WRITE A RECORD OF BINARY ONTO DISK

BINREC	LDA	BBYTCT
	ORA	A		;ANYTHING TO DUMP ?
	JZ	BINRC3		;SKIP IF NOT
	MOV	C,A
	MVI	A,02
	CALL	TOUCH		;WRITE RECORD START MARKER
	MOV	A,C
	CALL	TOUCH		;WRITE RECORD LENGTH
	LDA	BINBUF+1
	CALL	TOUCH		;M.S. ADDRESS BYTE
	LDA	BINBUF
	CALL	TOUCH		;L.S. ADDRESS BYTE
	LXI	H,BBYTCT+1	;POINT TO DATA
BINRC2	MOV	A,M
	INX	H
	CALL	TOUCH		;WRITE A BYTE OF DATA
	DCR	C		;BUFFER EMPTIED ?
	JNZ	BINRC2		;LOOP IF NOT
BINRC3	XRA	A
	STA	BBYTCT		;CLEAR RECORD LENGTH
	LHLD	LC
	SHLD	BINBUF		;SET RECORD ADDRESS
	RET

* ENDUP BINARY OUTPUT
*    FLUSHES REMAINDER OF BUFFER AND IF A TRANSFER
*    ADDRESS WAS SPECIFIED ON THE END STATEMENT, IT
*    IS PLACED ON THE DISK AS A RECORD WITH A 16 HEX
*    START MARKER FOLLOWED BY THE ADDRESS (M.S. HALF
*    FIRST).

ENDBIN	CALL	BINREC		;DUMP BUFFER
	LDA	XFRFLG
	ORA	A		;A TRANSFER ADDRESS ?
	RZ			;EXIT IF NOT
	MVI	A,16H		;XFR ADDRESS RECORD MARKER
	CALL	TOUCH		;WRITE IT
	LDA	XFRADR+1
	CALL	TOUCH		;WRITE M.S. ADDRESS BYTE
	LDA	XFRADR
	CALL	TOUCH		;WRITE L.S. ADDRESS BYTE
	RET


***************************************************

* AUXILIARY OPTION LIST

AUXOPT	DB	0,0,0,0,0,0,0,0,0
OPTPRN	DB	0
OPTECH	DB	0
OPTDEL	DB	0
OPTOUT	DB	0
OPTBIN	DB	0


***************************************************
* ASSEMBLER PARAMETERS WHICH MUST BE SET
*
SRCBEG	DS	2	;ADDRESS OF FIRST SOURCE CHAR
SRCEND	DS	2	;ADDRESS OF LAST SOURCE CHAR
SYMBEG	DS	2	;START OF SYMBOL TABLE
SYMEND	DS	2	;END OF SYMBOL TABLE
JNKCNT	DS	1	;JUNK BYTES BEFORE EACH LINE
MEMORY	DS	2	;ADDRESS OF MEMORY CODE STORE
***************************************************


* PARAMETERS WHICH MAY BE SET

LINES	DB	59	;NBR OF LINES BEFORE EJECT
LBLINE	DB	05	;LABELS PER LINE IN S.T.
TDELAY	DB	05	;TAPE DELAY AMOUNT
LOPAGE	DW	0000	;LOWER PAGE LIMIT
HIPAGE	DW	0FFFFH	;UPPER PAGE LIMIT


* END FLAG

ENDFLG	DS	1	;END INSTRUCTION HIT


* TEMPORARY STORAGE AREA

LINPTR	DS	2	;SOURCE LINE POINTER
LINBEG	DS	2	;START OF ACTUAL SOURCE LINE
XFRADR	DS	2	;TRANSFER ADDRESS
OPRPRT	DS	2	;OPERAND POINTER
LABEL	DS	6	;LABEL STORAGE AREA
LBLTMP	DS	2	;ADDRESS OF LABEL IN S.T.
LBLTP2	DS	2	;TEMPORARY LABEL ADDRESS
VLDLBL	DS	1	;VALID LABEL FLAG
RESULT	DS	2	;RESULT OF OPERAND EVALUATE
TERM	DS	2	;TERM OF OPERAND
OPRATR	DS	1	;OPERATOR
NEGFLG	DS	1	;UNARY NEGATE FLAG
DATA	DS	1	;MORE DB OR DW DATA FLAG
DBSIP	DS	1	;DB STRING IN PROGRESS FLAG
DELIM	DS	1	;DB STRING DELIMITER
OBJYET	DS	1	;OBJECT CODE PUNCHED FLAG
BUFCNT	DS	1	;OBJECT CODE BUFFER COUNT
OBJADR	DS	2	;OBJECT CODE ADDRESS
XFRFLG	DS	1	;TRANSFER ADDRESS FLAG
SEED	DS	3	;RANDOM NUMBER ROUTINE SEED
SYMTBK	DS	1	;K LIMIT OF SYMBOL TABLE
ERRTMP	DS	1	;TEMPORARY ERROR FLAG
ERRORS	DS	2	;ERROR COUNT
SPCCNT	DS	1	;SPACE COUNT
PAGENO	DS	2	;CURRENT PAGE NUMBER
LINCNT	DS	1	;CURRENT LINE COUNT
LINENO	DS	2	;INPUT SOURCE LINE COUNT
OUTFLG	DS	1	;OUTPUT FLAG
LEFT	DS	2	;LEFT END OF PARTITION
RIGHT	DS	2	;RIGHT END OF PARTITION
I	DS	2	;PARTITION POINTER
J	DS	2	;PARTITION POINTER
SRSP	DS	2	;SORT REQUEST STACK POINTER
BUFFER	DS	44	;BUFFER FOR TAPE AND SORT
TITLL	DS	33	;TITLE

ERR0	DS	1	;SYMBOL TABLE FULL ERROR
ERR1	DS	1	;UNDEFINED SYMBOL ERROR
ERR2	DS	1	;MULTIPLY DEFINED ERROR
ERR3	DS	1	;ILLEGAL MNEMONIC ERROR
ERR4	DS	1	;ILLEGAL SYMBOL ERROR
ERR5	DS	1	;ILLEGAL OPERAND ERROR
ERR6	DS	1	;SYNTAX ERROR
ERR7	DS	1	;ILLEGAL REGISTER ERROR
ERR8	DS	1	;ILLEGAL CONSTANT ERROR
ERR9	DS	1	;ILLEGAL OPTION ERROR

OPTSYM	DS	1	;SYMBOL TABLE OPTION
OPTGEN	DS	1	;GENERATE OPTION
OPTLST	DS	1	;LIST OPTION
OPTPAG	DS	1	;PAGING OPTION
OPTMEM	DS	1	;MEMORY OPTION
OPTTAP	DS	1	;TAPE OPTION
OPTHEX	DS	1	;HEX/OCT OPTION
OPTEXP	DS	1	;AUTO-FIELDING OPTION
OPTNUM	DS	1	;LINE NUMBER OPTION

LC	DS	2	;LOCATION (PROGRAM) COUNTER
PASS	DS	1	;PASS DESIGNATOR
P3FLG	DS	1	;PASS 3 FLAG
BYTES	DS	2	;NBR OF BYTES IN INSTRUCTION
DBDWF	DS	1	;DB OR DW INSTRUCTION FLAG
OPTYPE	DS	1	;PSEUDO-OP TYPE
OPCODE	DS	1	;ASSEMBLED OPCODE
BYTE2	DS	1	;ASSEMBLED BYTE NBR 2
BYTE3	DS	1	;ASSEMBLED BYTE NBR 3
BINBUF	DS	2	;BINARY CODE ADDRESS
BBYTCT	DS	1	;BINARY CODE LENGTH
	DS	255	;BINARY CODE BUFFER


* TEMPORARY DISK STORAGE

SRCFCB	DS	34
HEXFCB	DS	34
PRNFCB	DS	34
SRCBUF	DS	129
HEXBUF	DS	129
PRNBUF	DS	129

FCBADR	DS	2
BUFEND	DS	2
OLDSP	DS	2
LOGDR	DS	1
STSIZE	DS	1
ALLIN	DS	1
PRN	DS	1

* PROGRAM STACK

	DS	59
STACK	DS	1


* SOURCE FILE BEGINS HERE

RAMBEG	EQU	$



	END
