/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log$
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2/pmap_inline.c
 *	Author: David E. Bohman II (CMU macmach)
 */

#ifndef	_MACHINE_PMAP_INLINE_C_
#define	_MACHINE_PMAP_INLINE_C_

/*
 * Address Translation tree walking
 * primatives (inline expansions).
 *
 * NB: these primatives DO NOT check
 * for zero pointers or invalid ptp's or pp's.
 */

/*
 * Given a ptr to a page-table-pointer table and
 * an offset, return a ptr to the corresponding
 * page-table-pointer.
 */
static inline
ptp_t	*
ptptbl_to_ptp(p, v)
ptp_t			p[];
vm_offset_fields_t	v;
{
    return (&p[v.ptptbl_index]);
}

/*
 * Given a ptr to a page-table-pointer, return
 * a ptr to the corresponding page-pointer table.
 */
static inline
pp_t	*
ptp_to_pptbl(p)
ptp_t			*p;
{
    vm_offset_fields_t t;

    t.full_offset = 0;
    t.pg_index = p->pfn;

    return ((pp_t *)t.full_offset);
}

/*
 * Given a ptr to a page-pointer table and
 * an offset, return a ptr to the corresponding
 * page-pointer.
 */
static inline
pp_t	*
pptbl_to_pp(p, v)
pp_t			p[];
vm_offset_fields_t	v;
{
    return (&p[v.pptbl_index]);
}

/*
 * Given a ptr to a page-table-pointer and
 * an offset, return a ptr to the corresponding
 * page-pointer.
 */
static inline
pp_t *
ptp_to_pp(p, v)
ptp_t			*p;
vm_offset_fields_t	v;
{
    return (pptbl_to_pp(ptp_to_pptbl(p), v));
}

/*
 * Given a ptr to a ptp, return the corresponding
 * virtual offset.
 */
static inline
vm_offset_t
ptp_to_va(p)
ptp_t			*p;
{
    union {
	vm_offset_t	full_offset;
	struct {
	    vm_offset_t	     :22,
			index:8,
			     :2;
	} t;
    } t;
    vm_offset_fields_t	v;

    t.full_offset = (vm_offset_t)p;

    v.full_offset = 0;
    v.ptptbl_index = t.t.index;

    return (v.full_offset);
}

#endif	_MACHINE_PMAP_INLINE_C_
