/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/macmemory.h
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

/*
 * Macintosh memory
 * defines
 */

/*
 * Addresses/Sizes
 * of objects that
 * must be mapped
 * into the address
 * space.
 */
/*
 * 32 bit addressing mode
 */
#define ROM_32B_ADDR 0x40000000
#define ROM_HIGH_32B_ADDR 0x40800000
#define ROM_32B_SIZE (512*1024)

#define EMUL_32B_ADDR 0x40880000
#define EMUL_32B_SIZE (512*1024)

#define SND_32B_ADDR 0x50f14000
#define SND_32B_SIZE (8*1024)

#define IWM_32B_ADDR 0x50f16000
#define IWM_32B_SIZE (8*1024)

#define SCC_32B_ADDR 0x50f04000
#define SCC_32B_SIZE (8*1024)

#define SCSI1_32B_ADDR 0x50f10000
#define SCSI1_32B_SIZE (16*1024)

#define SCSI2_32B_ADDR 0x50f06000
#define SCSI2_32B_SIZE (8*1024)

#define SLOT_32B_ADDR(slot)	slot_to_ptr(slot)
#define SLOT_32B_SIZE (16*1024*1024)

/*
 * 24 bit addressing mode
 */
#define ROM_24B_ADDR 0x00800000
#define ROM_24B_SIZE (512*1024)

#define EMUL_24B_ADDR 0x00880000
#define EMUL_24B_SIZE (512*1024)

#define SND_24B_ADDR 0x00f14000
#define SND_24B_SIZE (8*1024)

#define IWM_24B_ADDR 0x00f16000
#define IWM_24B_SIZE (8*1024)

#define SCC_24B_ADDR 0x00f04000
#define SCC_24B_SIZE (8*1024)

#define SCSI1_24B_ADDR 0x00f10000
#define SCSI1_24B_SIZE (16*1024)

#define SCSI2_24B_ADDR 0x00f06000
#define SCSI2_24B_SIZE (8*1024)

#define SLOT_24B_ADDR(slot)	((slot) << 20)
#define SLOT_24B_SIZE (1024*1024)

struct mac_object_mapping {
  vm_offset_t	m_task_address;
  vm_size_t	m_task_size;
  vm_prot_t	m_task_prot;
  dev_t         m_object_dev;
  int           (*m_object_mapfun)();
  vm_offset_t	m_object_offset;
};

#define ADDRESS_24BIT_MASK (0xffffff)
