/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/macdevice.c
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

/*
 * Device emulation
 * routines
 */

#include <sys/types.h>

#include <vm/vm_map.h>

#include <mac2/pcb.h>

#include <mac2emul/macdefs.h>
#include <mac2emul/macdevice.h>
#include <mac2emul/macmemory.h>

int (*device_emul_switch[])() = {
    device_via1,
    device_via2,
    device_scc,
    device_scsi_h,
    device_none,
    device_none,
    device_none,
    device_none,
    device_scsi,
    device_scsi_d,
    device_sound,
    device_iwm,
    device_none,
    device_none,
    device_none,
    device_none
    };

valid_device(addr, data, size, rw)
register unsigned long addr;
register unsigned long *data;
register size, rw;
{
    register struct mac_internal *mac = current_thread_pcb()->pcb_emul;
    
    if ((mac->flags&MAC_F_24BIT) == 0) {
	if ((addr&DEV_VALID_MASK) == DEV_VALID_ADDR_1 ||
	    (addr&DEV_VALID_MASK) == DEV_VALID_ADDR_2) {
	    /* FALL THROUGH */
	}
	else
	    return (0);
    }
    else {
	addr &= ADDRESS_24BIT_MASK;
	if ((addr&DEV_VALID_MASK) != DEV_VALID_ADDR_3)
	    return (0);
    }
    return ((*device_emul_switch[(addr&DEV_TYPE_MASK)>>DEV_TYPE_SHIFT])
	    (addr&DEV_OFFSET_MASK, data, size, rw));
}

device_none()
{
    return (0);
}

device_null()
{
    return (1);
}
