/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log$
 */

#include <sys/types.h>

#include <mac2dev/scc.h>

#include <mac2/autoconf.h>

scc_reg_t sccaddr;

/*
 * Dummy SCC serial driver
 * resets chip on every interrupt. (for now)
 */
sccinit(dp)
register struct devconf *dp;
{
    register scc_reg_t sc;

    sccaddr = (scc_reg_t)dp->dc_csr;

    sc = sccaddr;
    sc->csra = 0x9;	/* register 9 */
    sc->csra = W9NV|W9ARESET;

    sc->csrb = 0x9;	/* register 9 */
    sc->csrb = W9NV|W9BRESET;
    return (1);
}

sccintr()
{
    register scc_reg_t sc;

    sc = sccaddr;
    sc->csra = 0x9;	/* register 9 */
    sc->csra = W9NV|W9ARESET;

    sc->csrb = 0x9;	/* register 9 */
    sc->csrb = W9NV|W9BRESET;
}
