/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log$
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2/frame.h
 *	Author: David E. Bohman II (CMU macmach)
 */

#ifndef _MAC2_FRAME_H_
#define _MAC2_FRAME_H_

/*
 * MC68020/68030 exception frame
 * definitions
 */

struct normal_exception_frame {
    unsigned short f_sr;
    unsigned long f_pc;
    unsigned short f_fmt:4,
		f_vector:12;
};
#define STKFMT_NORMAL 0x0

struct special_exception_frame {
    unsigned short f_sr;
    unsigned long f_pc;
    unsigned short f_fmt:4,
		f_vector:12;
    unsigned long f_instpc;
};
#define STKFMT_SPECIAL 0x2

struct coproc_exception_frame {
    unsigned short f_sr;
    unsigned long f_pc;
    unsigned short f_fmt:4,
		f_vector:12;
    unsigned long f_instpc;
    unsigned long f_internal;
    unsigned long f_eea;
};
#define STKFMT_COPROC 0x9

#define BUSERR_READ  1
#define BUSERR_WRITE 0

#define BUSERR_SIZE_LONG 0
#define BUSERR_SIZE_BYTE 1
#define BUSERR_SIZE_WORD 2

struct short_buserr_exception_frame {
    unsigned short f_sr;
    unsigned long f_pc;
    unsigned short f_fmt:4,
		f_vector:12;
    unsigned short f_internal;
    struct {
	unsigned short ssw_faultc:1,
		       ssw_faultb:1,
		       ssw_rerunc:1,
		       ssw_rerunb:1,
				 :3,
		       ssw_dfault:1,
			  ssw_rmw:1,
			   ssw_rw:1,
			 ssw_size:2,
				 :1,
			ssw_fcode:3;
    } f_ssw;
#define f_faultc f_ssw.ssw_faultc
#define f_faultb f_ssw.ssw_faultb
#define f_rerunc f_ssw.ssw_rerunc
#define f_rerunb f_ssw.ssw_rerunb
#define f_dfault f_ssw.ssw_dfault
#define f_rmw    f_ssw.ssw_rmw
#define f_rw     f_ssw.ssw_rw
#define f_size   f_ssw.ssw_size
#define f_fcode  f_ssw.ssw_fcode
    unsigned short f_ipsc;
    unsigned short f_ipsb;
    unsigned long f_fault;
    unsigned long f_internal2;
    unsigned long f_dob;
    unsigned long f_internal3;
};
#define STKFMT_SHORT_BUSERR 0xA

struct long_buserr_exception_frame {
    unsigned short f_sr;
    unsigned long f_pc;
    unsigned short f_fmt:4,
		f_vector:12;
    unsigned short f_internal;
    struct {
	unsigned short ssw_faultc:1,
		       ssw_faultb:1,
		       ssw_rerunc:1,
		       ssw_rerunb:1,
				 :3,
		       ssw_dfault:1,
			  ssw_rmw:1,
			   ssw_rw:1,
			 ssw_size:2,
				 :1,
			ssw_fcode:3;
    } f_ssw;
    unsigned short f_ipsc;
    unsigned short f_ipsb;
    unsigned long f_fault;
    unsigned long f_internal2;
    unsigned long f_dob;
    unsigned long f_internal3;
    unsigned long f_internal4;
    unsigned long f_stageb;
    unsigned long f_internal5;
    unsigned long f_dib;
    unsigned long f_internal6[11];
};
#define STKFMT_LONG_BUSERR 0xB

#endif	_MAC2_FRAME_H_
