/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	unpcb.h,v $
 * Revision 2.5  89/04/22  15:32:42  gm0w
 * 	Removed MACH_VFS changes.
 * 	[89/04/14            gm0w]
 * 
 * Revision 2.4  89/03/09  22:09:51  rpd
 * 	More cleanup.
 * 
 * Revision 2.3  89/02/25  17:58:00  gm0w
 * 	Made dependencies on MACH_VFS only be used inside
 * 	KERNEL. Outside of kernel old names must be used.
 * 	[89/02/14            mrt]
 * 
 * Revision 2.2  89/01/18  01:20:24  jsb
 * 	Vnode support: change inodes to vnodes.
 * 	[89/01/13            jsb]
 * 
 */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)unpcb.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Protocol control block for an active
 * instance of a UNIX internal protocol.
 *
 * A socket may be associated with an inode in the
 * file system.  If so, the unp_inode pointer holds
 * a reference count to this inode, which should be irele'd
 * when the socket goes away.
 *
 * A socket may be connected to another socket, in which
 * case the control block of the socket to which it is connected
 * is given by unp_conn.
 *
 * A socket may be referenced by a number of sockets (e.g. several
 * sockets may be connected to a datagram socket.)  These sockets
 * are in a linked list starting with unp_refs, linked through
 * unp_nextref and null-terminated.  Note that a socket may be referenced
 * by a number of other sockets and may also reference a socket (not
 * necessarily one which is referencing it).  This generates
 * the need for unp_refs and unp_nextref to be separate fields.
 *
 * Stream sockets keep copies of receive sockbuf sb_cc and sb_mbcnt
 * so that changes in the sockbuf may be computed to modify
 * back pressure on the sender accordingly.
 */

#ifndef	_SYS_UNPCB_H_
#define _SYS_UNPCB_H_

#include <sys/types.h>

struct	unpcb {
	struct	socket *unp_socket;	/* pointer back to socket */
	struct	inode *unp_inode;	/* if associated with file */
	ino_t	unp_ino;		/* fake inode number */
	struct	unpcb *unp_conn;	/* control block of connected socket */
	struct	unpcb *unp_refs;	/* referencing socket linked list */
	struct 	unpcb *unp_nextref;	/* link in unp_refs list */
	struct	mbuf *unp_addr;		/* bound address of socket */
	int	unp_cc;			/* copy of rcv.sb_cc */
	int	unp_mbcnt;		/* copy of rcv.sb_mbcnt */
};

#define sotounpcb(so)	((struct unpcb *)((so)->so_pcb))

#endif	_SYS_UNPCB_H_
