#! /bin/sh
#HISTORY
# 11-Jun-88  Michael Young (mwyoung) at Carnegie-Mellon University
#	Take source directory name as a fourth argument.
#
# 23-Jun-87  William Bolosky (bolosky) at Carnegie-Mellon University
#	Changed completion message.
#
# 27-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
#	Removed useless acis "cross-compile" code, and also now look
#	at the contents of "romp_rdb.h" to decide if we really need
#	to do a debugger merge.
#
# 11-Nov-86  Robert Baron (rvb) at Carnegie-Mellon University
#	set kernel back to segment e
#
#set -x$-
#$Header: make.ws,v 2.2 88/06/11 18:14:13 mwyoung Exp $
#$Source: /afs/cs.cmu.edu/bsd4.3/source/rcs/kernel/conf/make.ws,v $
#
# shell script to generate a workstation binary with the debugger and
# symbol table merged in.
#
#
# this version deals with only the native compile case.
#
PATH=/xri/bin:/usr/ibmtools:/usr/public:/usr/local:/bin:/usr/bin:/ucb
export PATH
input=${1-vmunix}
output=${3-$input.ws}
source=${4-..}

rm -f $output

case `cat romp_rdb.h` in
*0*)
		# no debugger merge needed
	ln $input $output
	echo "Debugger not configured, so not merged."
	exec true
	;;
*)		# native compile
	VMRDB=${2-../standca/rdb.out}
	nm -n $input > $input.nm || exit 1
	;;

esac

	echo "symbol table produced in $input.nm"

	rm -f $input.out
	cp $input $input.out
OMERGE=omerge
#
# get the offsets and positions of the debugger 
#
eval `awk ' $1 == "#define" { print $2 "=" substr($3,3) } ' $source/machine/rdb.h `
# make a vmunix.out that is -N format (vax compatible)
	${OMERGE} -p2048 -o0x${RDB_RELOC?} -e0x${RDB_END?} ${VMRDB} $input.out || exit 1
# convert NCS symbols if necessary
$source/conf/fixsyms $input.nm $input.snm
# following sed makes the 'int' routines visable and also changes the
# virtual kernel addresses back into real addresses
	( sed -e 's;^e;0;' -e 's; int; _int;' $input.snm ) |
		makesym -h > $input.sym
	${OMERGE} -p2048 -o0x${RDB_SYMTAB?} -l0x${RDB_SYMLEN?} $input.sym $input.out || exit 1
	echo "debugger (from ${VMRDB}) merged into $input.out"

	ln $input.out $output

	echo "Mach kernel with debugger now in $output"

