/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afsvlint.cs.c,v $
 * Revision 2.3  89/06/03  15:34:42  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:10:54  jsb]
 * 
 * Revision 2.2  89/04/22  15:18:40  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/* Machine generated file -- Do NOT edit */

#include <afsint/afsvlint.h>

#define	VLF_RWEXISTS	    0x1000  /* flags for whole vldb entry */
#define	VLF_ROEXISTS	    0x2000
#define	VLF_BACKEXISTS	    0x4000
#define	VLSF_NEWREPSITE	    0x01    /* flags for indiv. server entry */
#define	VLSF_ROVOL	    0x02
#define	VLSF_RWVOL	    0x04
#define	VLSF_BACKVOL	    0x08
int VL_GetEntryByID(z_conn, Volid, voltype, entry)
	register struct rx_connection *z_conn;
	long Volid, voltype;
	vldbentry * entry;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 503;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_long(&z_xdrs, &Volid))
	     || (!xdr_long(&z_xdrs, &voltype))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_vldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int VL_GetEntryByName(z_conn, volumename, entry)
	register struct rx_connection *z_conn;
	char * volumename;
	vldbentry * entry;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 504;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, &volumename, MAXNAMELEN))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_vldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

