/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	Kvice.cs.c,v $
 * Revision 2.3  89/06/03  15:33:37  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:09:45  jsb]
 * 
 * Revision 2.2  89/04/22  15:18:04  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/* Machine generated file -- Do NOT edit */

#include <afsint/afsint.h>

#define VICECONNBAD	1234
#define VICETOKENDEAD	1235
#define AFS_LOCKWAIT	(5*60)
#define CALLBACK_VERSION	1
#define Invalid 0
#define File 1 
#define Directory 2 
#define SymbolicLink 3 
#define	AFS_SETMODTIME	1
#define	AFS_SETOWNER	2
#define	AFS_SETGROUP		4
#define	AFS_SETMODE		8
#define	AFS_SETSEGSIZE	16
#define ReadOnly 0
#define ReadWrite 1
#define LockRead		0
#define LockWrite		1
#define LockExtend	2
#define LockRelease	3
#define NoSalvage 0
#define Salvage 1
int StartRXAFS_FetchData(z_call, Fid, Pos, Length)
	register struct rx_call *z_call;
	AFSFid * Fid;
	long Pos, Length;
{
	static int z_op = 130;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_long(&z_xdrs, &Pos))
	     || (!xdr_long(&z_xdrs, &Length))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_FetchData(z_call, OutStatus, CallBack, Sync)
	register struct rx_call *z_call;
	AFSFetchStatus * OutStatus;
	AFSCallBack * CallBack;
	AFSVolSync * Sync;
{
	int z_result;
	XDR z_xdrs;

	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int RXAFS_FetchACL(z_conn, Fid, AccessList, OutStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * Fid;
	AFSOpaque * AccessList;
	AFSFetchStatus * OutStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 131;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSOpaque(&z_xdrs, AccessList))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_FetchStatus(z_conn, Fid, OutStatus, CallBack, Sync)
	register struct rx_connection *z_conn;
	AFSFid * Fid;
	AFSFetchStatus * OutStatus;
	AFSCallBack * CallBack;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 132;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int StartRXAFS_StoreData(z_call, Fid, InStatus, Pos, Length, FileLength)
	register struct rx_call *z_call;
	AFSFid * Fid;
	AFSStoreStatus * InStatus;
	long Pos, Length, FileLength;
{
	static int z_op = 133;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))
	     || (!xdr_long(&z_xdrs, &Pos))
	     || (!xdr_long(&z_xdrs, &Length))
	     || (!xdr_long(&z_xdrs, &FileLength))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_StoreData(z_call, OutStatus, Sync)
	register struct rx_call *z_call;
	AFSFetchStatus * OutStatus;
	AFSVolSync * Sync;
{
	int z_result;
	XDR z_xdrs;

	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int RXAFS_StoreACL(z_conn, Fid, AccessList, OutStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * Fid;
	AFSOpaque * AccessList;
	AFSFetchStatus * OutStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 134;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSOpaque(&z_xdrs, AccessList))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_StoreStatus(z_conn, Fid, InStatus, OutStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * Fid;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 135;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_RemoveFile(z_conn, DirFid, Name, OutStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * DirFid;
	char * Name;
	AFSFetchStatus * OutStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 136;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, &Name, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_CreateFile(z_conn, DirFid, Name, InStatus, OutFid, OutFidStatus, OutDirStatus, CallBack, Sync)
	register struct rx_connection *z_conn;
	AFSFid * DirFid, *OutFid;
	char * Name;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
	AFSCallBack * CallBack;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 137;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, &Name, AFSNAMEMAX))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_Rename(z_conn, OldDirFid, OldName, NewDirFid, NewName, OutOldDirStatus, OutNewDirStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * OldDirFid, *NewDirFid;
	char * OldName, *NewName;
	AFSFetchStatus * OutOldDirStatus, *OutNewDirStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 138;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, OldDirFid))
	     || (!xdr_string(&z_xdrs, &OldName, AFSNAMEMAX))
	     || (!xdr_AFSFid(&z_xdrs, NewDirFid))
	     || (!xdr_string(&z_xdrs, &NewName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutOldDirStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutNewDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_Symlink(z_conn, DirFid, Name, LinkContents, InStatus, OutFid, OutFidStatus, OutDirStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * DirFid, *OutFid;
	char * Name, *LinkContents;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 139;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, &Name, AFSNAMEMAX))
	     || (!xdr_string(&z_xdrs, &LinkContents, AFSPATHMAX))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_Link(z_conn, DirFid, Name, ExistingFid, OutFidStatus, OutDirStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * DirFid, *ExistingFid;
	char * Name;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 140;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, &Name, AFSNAMEMAX))
	     || (!xdr_AFSFid(&z_xdrs, ExistingFid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_MakeDir(z_conn, DirFid, Name, InStatus, OutFid, OutFidStatus, OutDirStatus, CallBack, Sync)
	register struct rx_connection *z_conn;
	AFSFid * DirFid, *OutFid;
	char * Name;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
	AFSCallBack * CallBack;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 141;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, &Name, AFSNAMEMAX))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_RemoveDir(z_conn, DirFid, Name, OutDirStatus, Sync)
	register struct rx_connection *z_conn;
	AFSFid * DirFid;
	char * Name;
	AFSFetchStatus * OutDirStatus;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 142;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, &Name, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_SetLock(z_conn, Fid, Type, Sync)
	register struct rx_connection *z_conn;
	AFSFid * Fid;
	ViceLockType Type;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 143;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_ViceLockType(&z_xdrs, &Type))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_ExtendLock(z_conn, Fid, Sync)
	register struct rx_connection *z_conn;
	AFSFid * Fid;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 144;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_ReleaseLock(z_conn, Fid, Sync)
	register struct rx_connection *z_conn;
	AFSFid * Fid;
	AFSVolSync * Sync;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 145;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_GetStatistics(z_conn, Statistics)
	register struct rx_connection *z_conn;
	ViceStatistics * Statistics;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 146;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_ViceStatistics(&z_xdrs, Statistics))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_GiveUpCallBacks(z_conn, Fids_Array, CallBacks_Array)
	register struct rx_connection *z_conn;
	AFSCBFids * Fids_Array;
	AFSCBs * CallBacks_Array;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 147;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSCBFids(&z_xdrs, Fids_Array))
	     || (!xdr_AFSCBs(&z_xdrs, CallBacks_Array))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_GetVolumeInfo(z_conn, VolumeName, Volumeinfo)
	register struct rx_connection *z_conn;
	char * VolumeName;
	VolumeInfo * Volumeinfo;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 148;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, &VolumeName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_VolumeInfo(&z_xdrs, Volumeinfo))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_GetVolumeStatus(z_conn, Volumeid, Volumestatus, Name, OfflineMsg, Motd)
	register struct rx_connection *z_conn;
	long Volumeid;
	AFSFetchVolumeStatus * Volumestatus;
	char * *Name, **OfflineMsg, **Motd;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 149;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_long(&z_xdrs, &Volumeid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchVolumeStatus(&z_xdrs, Volumestatus))
	     || (!xdr_string(&z_xdrs, Name, AFSNAMEMAX))
	     || (!xdr_string(&z_xdrs, OfflineMsg, AFSOPAQUEMAX))
	     || (!xdr_string(&z_xdrs, Motd, AFSOPAQUEMAX))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_SetVolumeStatus(z_conn, Volumeid, Volumestatus, Name, OfflineMsg, Motd)
	register struct rx_connection *z_conn;
	long Volumeid;
	AFSStoreVolumeStatus * Volumestatus;
	char * Name, *OfflineMsg, *Motd;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 150;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_long(&z_xdrs, &Volumeid))
	     || (!xdr_AFSStoreVolumeStatus(&z_xdrs, Volumestatus))
	     || (!xdr_string(&z_xdrs, &Name, AFSNAMEMAX))
	     || (!xdr_string(&z_xdrs, &OfflineMsg, AFSOPAQUEMAX))
	     || (!xdr_string(&z_xdrs, &Motd, AFSOPAQUEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_GetRootVolume(z_conn, VolumeName)
	register struct rx_connection *z_conn;
	char * *VolumeName;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 151;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_string(&z_xdrs, VolumeName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_CheckToken(z_conn, ViceId, token)
	register struct rx_connection *z_conn;
	long ViceId;
	AFSOpaque * token;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 152;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_long(&z_xdrs, &ViceId))
	     || (!xdr_AFSOpaque(&z_xdrs, token))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_GetTime(z_conn, Seconds, USeconds)
	register struct rx_connection *z_conn;
	u_long * Seconds, *USeconds;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 153;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_u_long(&z_xdrs, Seconds))
	     || (!xdr_u_long(&z_xdrs, USeconds))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

int RXAFS_NGetVolumeInfo(z_conn, VolumeName, stuff)
	register struct rx_connection *z_conn;
	char * VolumeName;
	AFSVolumeInfo * stuff;
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 154;
	int z_result;
	XDR z_xdrs;

	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, &VolumeName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSVolumeInfo(&z_xdrs, stuff))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return rx_EndCall(z_call, z_result);
}

