/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	rxkad_common.c,v $
 * Revision 2.4  89/08/02  08:02:37  jsb
 * 	Use osi_Zalloc instead of osi_Alloc.
 * 	[89/07/31  18:04:41  jsb]
 * 
 * Revision 2.3  89/06/03  15:32:30  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  19:08:56  jsb]
 * 
 * Revision 2.2  89/04/22  15:17:30  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */

/*
 * COPYRIGHT (C) IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#ifndef lint
#endif

/* $ Log:	rxkad_common.c,v $
 * Revision 1.11  89/02/14  09:11:36  kazar
 * more athena fixes for ticket expiratoin
 * and a better make clean to take into acct
 * compile_et junk
 * 
 * Revision 1.10  88/12/20  21:03:41  vasilis
 * *** empty log message ***
 * 
 * Revision 1.9  88/12/16  18:45:42  kazar
 * fixup kernel stuff in rxkad agin
 * 
 * Revision 1.8  88/12/15  16:21:15  ota
 * Added RCS header, source and log fields.
 *  */

#ifdef KERNEL
#include <afs/param.h>
#ifdef	AFS_AIX_ENV
#include <sys/systm.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <rx/rx.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include "rxkad.h"

#else KERNEL
#include <afs/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <rx/rx.h>
#include <rx/xdr.h>
#include "rxkad.h"

#endif KERNEL

#ifndef max
#define	max(a,b)    ((a) < (b)? (b) : (a))
#endif max

/* called by rx with the security class object as a parameter when a security
   object is to be discarded */

rxkad_Close (aobj)
  struct rx_securityClass *aobj;
{   struct rxkad_cprivate *tcp;		/* both structures start w/ type field */

    tcp = (struct rxkad_cprivate *)aobj->privateData;
    osi_Zfree(rx_securityClass_zone, aobj);
    if (tcp->type == rxkad_client) {
	osi_Zfree(rxkad_cprivate_zone, tcp);
    }
    else if (tcp->type == rxkad_server) {
	panic("rxkad_Close.rxkad_server");
    }
    else { return RXKADINCONSISTENCY; }	/* unknown type */
    return 0;
}

/* either: called to (re)create a new connection. */

rxkad_NewConnection (aobj, aconn)
  struct rx_securityClass *aobj;
  struct rx_connection	  *aconn;
{   int size;
    struct rxkad_cprivate *tcp;

    if (aconn->securityData) return RXKADINCONSISTENCY;	/* already allocated??? */

    if (rx_IsServerConn(aconn)) {
	size = sizeof(struct rxkad_sconn);
	aconn->securityData = (char *) osi_Zalloc(rxkad_sconn_zone);
	bzero(aconn->securityData, size);	/* initialize it conveniently */
    }
    else { /* client */
	/* no per connection data */
	tcp = (struct rxkad_cprivate *) aobj->privateData;
	rxkad_SetLevel(aconn, tcp->level); /* set header and trailer sizes */
    }

    aobj->refCount++;			/* attached connection */
    return 0;
}

/* either: called to destroy a connection. */

rxkad_DestroyConnection (aobj, aconn)
  struct rx_securityClass *aobj;
  struct rx_connection	  *aconn;
{   struct rxkad_sconn *sconn;
    struct rxkad_cconn *cconn;
    struct rxkad_serverinfo *rock;

    if (rx_IsServerConn(aconn)) {
	sconn = (struct rxkad_sconn *)aconn->securityData;
	if (sconn) {
	    rock = sconn->rock;
	    if (rock) osi_Free (rock, sizeof(struct rxkad_serverinfo));
	    osi_Free (sconn, sizeof(struct rxkad_sconn));
	}
    }
    else {				/* client */
	/* there shouldn't be any */
	cconn = (struct rxkad_cconn *)aconn->securityData;
	if (cconn) {
	    osi_Free (cconn, sizeof(struct rxkad_cconn));
	}
    }
    aobj->refCount--;			/* decrement connection counter */
    if ((aobj->refCount <= 0) &&
	rx_IsClientConn (aconn)) {	/* server's never free security classes */
	osi_Free (aobj, sizeof (struct rx_securityClass));
    }
    return 0;
}

/* either: decode packet */

rxkad_CheckPacket (aobj, acall, apacket)
  struct rx_securityClass *aobj;
  struct rx_call	  *acall;
  struct rx_packet	  *apacket;
{   struct rx_connection  *tconn;
    struct rxkad_sconn	  *sconn;
    struct rxkad_cprivate *tcp;
    rxkad_level	           level;
    fc_KeySchedule *schedule;
    fc_InitializationVector *ivec;
    int len;
    int nlen;
    int word;
    
    tconn = rx_ConnectionOf(acall);
    if (rx_IsServerConn(tconn)) {
	sconn = (struct rxkad_sconn *) tconn->securityData;
#ifdef KERNEL
	if (sconn && sconn->authenticated && (osi_Time() < sconn->expirationTime)) {
#else KERNEL
	if (sconn && sconn->authenticated && (time(0) < sconn->expirationTime)) {
#endif KERNEL
	    level = sconn->level;
	    if (level == rxkad_clear) return 0;
	    schedule = (fc_KeySchedule *)sconn->keysched;
	    ivec = (fc_InitializationVector *)sconn->ivec;
	}
	else return RXKADEXPIRED;
    }
    else {				/* client connection */
	tcp = (struct rxkad_cprivate *) aobj->privateData;
	level = tcp->level;
	if (level == rxkad_clear) return 0;
	schedule = (fc_KeySchedule *)tcp->keysched;
	ivec = (fc_InitializationVector *)tcp->ivec;
    }
    len = rx_GetDataSize (apacket);
    switch (level) {
      case rxkad_clear: return 0;	/* shouldn't happen */
      case rxkad_auth:
	fc_ecb_encrypt (apacket->wire.data, apacket->wire.data, schedule, DECRYPT);
	break;
      case rxkad_crypt:
	fc_cbc_encrypt (apacket->wire.data, apacket->wire.data, len, schedule, ivec, DECRYPT);
	if (ntohl(apacket->wire.data[1]) != 0 /* cksum */) return RXKADSEALEDINCON;
	break;
    }
    word = ntohl(apacket->wire.data[0]); /* get first sealed word */
    if ((word >> 16) !=
	((apacket->header.seq ^ apacket->header.callNumber) & 0xffff))
	return RXKADSEALEDINCON;
    nlen = word & 0xffff;		/* get real user data length */
    if (nlen > rx_MaxUserDataSize(tconn)) return RXKADDATALEN;
    rx_SetDataSize (apacket, nlen);
    return 0;
}

/* either: encode packet */

rxkad_PreparePacket (aobj, acall, apacket)
  struct rx_securityClass *aobj;
  struct rx_call *acall;
  struct rx_packet *apacket;
{
    struct rx_connection *tconn;
    struct rxkad_sconn *sconn;
    struct rxkad_cprivate *tcp;
    rxkad_level	        level;
    fc_KeySchedule *schedule;
    fc_InitializationVector *ivec;
    int len;
    int nlen;
    int word;
    
    tconn = rx_ConnectionOf(acall);
    if (rx_IsServerConn(tconn)) {
	sconn = (struct rxkad_sconn *) tconn->securityData;
#ifdef KERNEL
	if (sconn && sconn->authenticated && (osi_Time() < sconn->expirationTime)) {
#else KERNEL
	if (sconn && sconn->authenticated && (time(0) < sconn->expirationTime)) {
#endif KERNEL
	    level = sconn->level;
	    if (level == rxkad_clear) return 0;
	    schedule = (fc_KeySchedule *)sconn->keysched;
	    ivec = (fc_InitializationVector *)sconn->ivec;
	}
	else return RXKADEXPIRED;
    }
    else {				/* client connection */
	tcp = (struct rxkad_cprivate *) aobj->privateData;
	level = tcp->level;
	if (level == rxkad_clear) return 0;
	schedule = (fc_KeySchedule *)tcp->keysched;
	ivec = (fc_InitializationVector *)tcp->ivec;
    }

    len = rx_GetDataSize (apacket);
    word = (((apacket->header.seq ^ apacket->header.callNumber)
	     & 0xffff) << 16) | (len & 0xffff);
    apacket->wire.data[0] = htonl(word);

    switch (level) {
      case rxkad_clear: return 0;	/* shouldn't happen */
      case rxkad_auth:
	nlen = max (ENCRYPTIONBLOCKSIZE, len + rx_GetSecurityHeaderSize(tconn));
#if 0
	len_ptr = (char *)apacket->wire.data + (nlen-sizeof(short));
	short_len = htons (len);
	bcopy (&short_len, len_ptr, sizeof(short_len));
#endif
	fc_ecb_encrypt (apacket->wire.data, apacket->wire.data, schedule, ENCRYPT);
	break;
      case rxkad_crypt:
	apacket->wire.data[1] = htonl(0 /* cksum */);
	nlen = round_up_to_ebs(len + rx_GetSecurityHeaderSize(tconn));
	fc_cbc_encrypt (apacket->wire.data, apacket->wire.data, nlen, schedule, ivec, ENCRYPT);
	break;
    }
    rx_SetDataSize (apacket, nlen);
    return 0;
}

int rxkad_SetLevel(conn, level)
  struct rx_connection *conn;
  rxkad_level	        level;
{
    if (level == rxkad_auth) {
	rx_SetSecurityHeaderSize (conn, 4);
	rx_SetSecurityMaxTrailerSize (conn, 4);
    }
    else if (level == rxkad_crypt) {
	rx_SetSecurityHeaderSize (conn, 8);
	rx_SetSecurityMaxTrailerSize (conn, 7);
    }
}

#ifdef	MACH
zone_t rxkad_cprivate_zone;
zone_t rxkad_sconn_zone;

rxkad_zone_init()
{
    rxkad_cprivate_zone		= zinit(sizeof(struct rxkad_cprivate),
					1024*1024, 0, FALSE,
					"rxkad cprivate");

    rxkad_sconn_zone		= zinit(sizeof(struct rxkad_sconn),
					1024*1024, 0, FALSE,
					"rxkad sconn");
}
#endif
