/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	rxkad_client.c,v $
 * Revision 2.4  89/08/02  08:02:19  jsb
 * 	Use osi_Zalloc instead of osi_Alloc.
 * 	[89/07/31  18:06:00  jsb]
 * 
 * Revision 2.3  89/06/03  15:32:19  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  19:08:45  jsb]
 * 
 * Revision 2.2  89/04/22  15:17:25  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */

/*
 * COPYRIGHT (C) IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#ifdef KERNEL

#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <rx/rx.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include "rxkad.h"

#else KERNEL

#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <rx/rx.h>
#include <rx/xdr.h>
#include "rxkad.h"

#endif KERNEL

#ifndef max
#define	max(a,b)    ((a) < (b)? (b) : (a))
#endif max

/* The rxkad security object.  Authentication using a DES-encrypted Kerberos-style ticket. */

extern int
    rxkad_Close(),
    rxkad_NewConnection(),
    rxkad_CheckAuthentication(),
    rxkad_CreateChallenge(),
    rxkad_GetChallenge(),
    rxkad_GetResponse(),
    rxkad_CheckPacket(),
    rxkad_PreparePacket(),
    rxkad_CheckResponse(),
    rxkad_DestroyConnection();

static struct rx_securityOps rxkad_client_ops = {
    rxkad_Close,
    rxkad_NewConnection,		/* every new connection */
    rxkad_PreparePacket,		/* once per packet creation */
    0,					/* send packet (once per packet retransmission) */
    0,
    0,
    0,
    rxkad_GetResponse,			/* respond to challenge packet */
    0,
    rxkad_CheckPacket,			/* check data packet after duplicate elimination */
    rxkad_DestroyConnection,
};

/* Allocate a new client security object.  Called with the exryption level, the
   session key and the ticket for the other side obtained from the AuthServer. */

struct rx_securityClass *rxkad_NewClientSecurityObject(level, sessionkey, kvno, ticketLen, ticket)
  rxkad_level      level;
  struct ktc_encryptionKey *sessionkey;
  long		   kvno;
  int		   ticketLen;
  char		  *ticket;
{   struct rx_securityClass *tsc;
    struct rxkad_cprivate   *tcp;
    int			     code;

    tsc = (struct rx_securityClass *) osi_Zalloc(rx_securityClass_zone);
    tsc->refCount = 0;
    tsc->ops = &rxkad_client_ops;

    tcp = (struct rxkad_cprivate *) osi_Zalloc(rxkad_cprivate_zone);
    tsc->privateData = (char *) tcp;
    tcp->type = rxkad_client;
    tcp->level = level;
    code = fc_keysched (sessionkey, tcp->keysched);
    if (code) return 0;			/* bad key */
    bcopy (sessionkey, tcp->ivec, sizeof(tcp->ivec));
    tcp->kvno = kvno;			/* key version number */
    tcp->ticketLen = ticketLen;		/* length of ticket */
    bcopy(ticket, tcp->ticket, ticketLen);

    return tsc;
}

/* client: respond to a challenge packet */

rxkad_GetResponse (aobj, aconn, apacket)
  struct rx_securityClass *aobj;
  struct rx_packet *apacket;
  struct rx_connection *aconn;
{   struct rxkad_cprivate *tcp;
    char		  *tp;
    int			   size;
    long		   a[2];
    long		   kvno;
    long		   tlen;
    rxkad_level		   level;

    tcp = (struct rxkad_cprivate *) aobj->privateData;

    if (rx_GetDataSize(apacket) != rxkad_challengeSize) return RXKADPACKETSHORT;
    bcopy (apacket->wire.data, a, sizeof(a));
    level = ntohl(a[1]);		/* gets server's minimum level */
    if (level > tcp->level) return RXKADLEVELFAIL;
    a[0] = htonl(ntohl(a[0])+1);	/* perform challenge computation */
    a[1] = htonl(tcp->level);		/* return level to use */

    fc_ecb_encrypt (a, a, tcp->keysched, ENCRYPT); /* encrypt it with session key */

    tp = (char *) apacket->wire.data;
    size = rx_MaxUserDataSize (aconn);	/* max size for returned data */
    if (size < rxkad_responseSize + tcp->ticketLen)
	return RXKADPACKETSHORT;	/* not enough space */
    bcopy(a, tp, sizeof(a));		/* encrypted challenge function */
    tp += sizeof(a);
    kvno = htonl(tcp->kvno);		/* key version of ticket */
    bcopy (&kvno, tp, sizeof(long));
    tp += sizeof(long);
    tlen = htonl(tcp->ticketLen);	/* length of ticket */
    bcopy (&tlen, tp, sizeof(long));
    tp += sizeof(long);
    bcopy (tcp->ticket, tp, tcp->ticketLen); /* ticket */
    tp += tcp->ticketLen;

    rx_SetDataSize (apacket, rxkad_responseSize + tcp->ticketLen);
    return 0;
}

