/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afs_osinet.c,v $
 * Revision 2.8  89/08/02  07:59:36  jsb
 * 	Use osi_Zalloc instead of osi_Alloc for afs packets.
 * 	[89/07/31  17:59:40  jsb]
 * 
 * Revision 2.7  89/06/03  15:28:35  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  19:06:49  jsb]
 * 
 * Revision 2.6  89/04/22  15:14:35  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987, 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#include <afs/param.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef	AFS_AUX_ENV
#ifdef	PAGING
#include <sys/mmu.h>
#include <sys/seg.h>
#include <sys/page.h>
#include <sys/region.h>
#endif
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#endif
#include <sys/systm.h>
#if	!defined(AFS_IBM_ENV) || !defined(sys_rt_r3)
#include <sys/time.h>
#endif	AFS_IBM_ENV
#ifndef	AFS_AIX_ENV
#include <sys/kernel.h>
#endif
#ifdef	notdef
#include <sys/cmap.h>	/* Hope to get rid of this */
#endif
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/protosw.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/uio.h>
#include <sys/buf.h>
#ifdef	AFS_GFS_ENV
#include <afs/gfs_vfs.h>
#include <afs/gfs_vnode.h>
#else
#ifdef	AFS_MACH_ENV
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#include <sys/inode.h>
#else	AFS_MACH_ENV
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#endif	AFS_MACH_ENV
#endif	AFS_GFS_ENV
#include <netinet/in.h>
#include <sys/mbuf.h>
#include <sys/proc.h>
#include <sys/file.h>
#include <rpc/types.h>
#include <afs/osi.h>
#include <afs/lock.h>
#include <afs/volerrors.h>
#include <afs/voldefs.h>
#include <afsint/afsint.h>
#include <afs/afs.h>

extern int selwait;
extern long afs_debug;

long osi_PacketsAlloced = 0;
long osi_allocs = 0;
static struct osi_packet {
    struct osi_packet *next;
} *freePacketList = 0;

/* free space allocated by AllocSendSpace.  Also called by mclput when freeing a packet
    allocated by osi_NetReceive.
*/
osi_FreeSendSpace(adata)
    register struct osi_packet *adata; {
    osi_PacketsAlloced--;
#ifdef	AFS_MACH_ENV
    osi_Zfree(afs_packet_zone, adata);
#else
    adata->next = freePacketList;
    freePacketList = adata;
#endif
    return 0;
}

/* allocate space for sender */
char *osi_AllocSendSpace() {
    register struct osi_packet *tp;
    osi_PacketsAlloced++;
#ifdef	AFS_MACH_ENV
    return (char *)osi_Zalloc(afs_packet_zone);
#else
    if (!freePacketList) return osi_Alloc(osi_PACKETSIZE);
    tp = freePacketList;
    freePacketList = tp->next;
    return (char *) tp;
#endif
}

/* Since AIX doesn't accept socket file descriptors we have to pay some attention here; to be done soon... */
#ifndef	AFS_AIX_ENV
/* turn a socket into a greedy socket */
int osi_xgreedy() {
    register struct a {
	int fdes;
    } *uap = (struct a *)u.u_ap;
    register struct file *tf;
    register struct socket *ts;

    tf = getf(uap->fdes);
    if (!tf) {
	u.u_error = EBADF;
	return;
    }
    if (tf->f_type != DTYPE_SOCKET) {
	u.u_error = ENOTSOCK;
	return;
    }
    ts = (struct socket *) tf->f_data;
    u.u_error = soreserve(ts, 32766, 32766);
}
#endif

/* allocate a new socket at specified address */
struct osi_socket *osi_NewSocket(aport)
    short aport; {		/* network byte order */
    register long code;
    struct socket *newSocket;
    register struct mbuf *nam;
    struct sockaddr_in myaddr;

    code = socreate(AF_INET, &newSocket, SOCK_DGRAM, 0);
    if (code) return (struct osi_socket *) 0;
    code = soreserve(newSocket, 50000, 50000);
    if (code) {
	code = soreserve(newSocket, 32766, 32766);
	if (code) panic("osi_NewSocket: last attempt to reserve 32K failed!\n");
    }
    myaddr.sin_family = AF_INET;
    myaddr.sin_port = aport;
    myaddr.sin_addr.s_addr = 0;
    nam = m_get(M_WAIT, MT_SONAME);
    nam->m_len = sizeof(myaddr);
    bcopy(&myaddr, mtod(nam, caddr_t), sizeof(myaddr));
    code = sobind(newSocket, nam);
    if (code) {
	soclose(newSocket);
	m_freem(nam);
	return (struct osi_socket *) 0;
    }
    return (struct osi_socket *) newSocket;
}

/* free socket allocated by osi_NetSocket */
int osi_FreeSocket(asocket)
    register struct socket *asocket; {
    soclose(asocket);
    return 0;
}

#ifdef AFS_ACTULTRIX
/* set lock on sockbuf sb; can't call sblock since we're at interrupt level sometimes */
static trysblock(sb)    
register struct sockbuf *sb; {
    if (sb->sb_flags & SB_LOCK)	return -1;  /* can't lock socket */
    sb->sb_flags |= SB_LOCK;
    return 0;
}
#endif AFS_ACTULTRIX

/* send asize bytes at adata from asocket to host at addr.
 *
 * Now, why do we allocate a new buffer when we could theoretically use the one pointed to by adata?
 * Because PRU_SEND returns after queueing the message, not after sending it.  If the sender changes
 * the data after queueing it, we'd see the already-queued data change.  One attempt to fix this
 * without adding a copy would be to have this function wait until the datagram is sent; however this
 * doesn't work well.  In particular, if a host is down, and an ARP fails to that host, this packet
 * will be queued until the ARP request comes back, which could be hours later.  We can't block
 * in this routine that long, since it prevents RPC timeouts from happening.
 */
int osi_NetSend(asocket, addr, adata, asize)
    register struct socket *asocket;
    char *adata;
    register long asize;
    struct sockaddr_in *addr; {
    register struct mbuf *tm, *um;
    register long code;
    int s;
    struct mbuf *top = 0;
    register struct mbuf *m, **mp;
    int len;

/* Actually, the Ultrix way is as good as any for us, so we don't bother with
    special mbufs any more.  Used to think we could get away with
    not copying the data to the interface, but there's no way to tell the
    caller not to reuse the buffers after sending, so we lost out on
    that trick anyway */
#ifdef	AFS_ACTULTRIX
    if (trysblock(&asocket->so_snd)) return 2;	/* can't lock socket, give up */
#endif	AFS_ACTULTRIX
    s = splnet();
    mp = &top;
    while (1) {
	MGET(m, M_WAIT, MT_DATA);
	if (asize >= NBPG) {	/* try to get cluster mbuf */
	    register struct mbuf *p;

	    /* different algorithms for getting cluster mbuf */
#ifdef AFS_ACTULTRIX
	    MCLGET(m, p);
	    if (p == 0)
		goto nopages;
#else  AFS_ACTULTRIX
#ifdef	MCLGET
#ifdef	AFS_VFS40
/* Although sun 4.0 defines MCLGET (to make it very close to 4.3's mbuf.h), it's wrong (mclrefcnt is externally defined) and they never call it from the kernel; they use mclget instead. */
	    mclget(m);
#else
	    MCLGET(m);
#endif
#else	MCLGET
	    mclget(m);
#endif	MCLGET
	    if (m->m_len == MLEN)
		goto nopages;
#endif AFS_ACTULTRIX

	    /* now compute usable size */
#ifdef	AFS_ACTULTRIX
	    len	= MIN(CLBYTES, asize);	/* ultrix doesn't set m_len! */
#else	AFS_ACTULTIX
	    len = MIN(m->m_len, asize);
#endif	AFS_ACTULTRIX
	} else {
nopages:
            len = MIN(MLEN, asize);

	}
	bcopy(adata, mtod(m, caddr_t), len);
	asize -= len;
	adata += len;
	m->m_len = len;
	*mp = m;
	mp = &m->m_next;
	if (asize <= 0)
	    break;
    }
    tm = top;

#ifdef AFS_ACTFLAG
    tm->m_act = (struct mbuf *) 1;
#else	AFS_ACTFLAG
    tm->m_act = (struct mbuf *) 0;
#endif

    /* setup mbuf corresponding to destination address */
#ifdef MM_BUGFIX
    um = m_get(M_DONTWAIT, MT_SONAME);
#else
    um = m_get(M_WAIT, MT_SONAME);
#endif
    if (!um) {
#ifdef	AFS_VFS40
	sbunlock(asocket, &asocket->so_snd);
#else
	sbunlock(&asocket->so_snd);
#endif
	splx(s);
	return 1;
    }
    bcopy(addr, mtod(um, caddr_t), sizeof(*addr));
    um->m_len = sizeof(*addr);
    /* note that udp_usrreq frees funny mbuf.  We hold onto data, but mbuf around
	it is gone.  we free address ourselves.   */
    if (afs_debug & AFSDEB_NETWORK)
	afs_dp("sendto: %x.%x\n", mtod(um, struct sockaddr_in *)->sin_addr.s_addr,
	       mtod(um, struct sockaddr_in *)->sin_port);
    code = (*asocket->so_proto->pr_usrreq)(asocket, PRU_SEND, tm, um, 0);
    splx(s);
    m_free(um);
#ifdef	AFS_ACTULTRIX
    sbunlock(&asocket->so_snd);
#endif
    if (code) { 
	if (afs_debug &	AFSDEB_NETWORK)	afs_dp("PRU_SEND code %d\n", code); 
    }
    return code;
}

osi_InitWaitHandle (achandle)
    register struct osi_WaitHandle *achandle; {
    achandle->proc = (caddr_t) 0;
}

static char waitV;

static WaitHack () {
    wakeup(&waitV);
}

/* cancel osi_Wait */
osi_CancelWait(achandle)
    struct osi_WaitHandle *achandle; {
    caddr_t proc;

    proc = achandle->proc;
    if (proc == 0) return;
    achandle->proc = (caddr_t) 0;   /* so dude can figure out he was signalled */
    wakeup(&waitV);
}

/* wait for data on asocket, or ams ms later.  asocket may be null.  Returns
    0 if timeout and 2 if signalled */
int osi_Wait(ams, ahandle)
    register struct osi_WaitHandle *ahandle;
    long ams; {
    register int code;
    long endTime;

    endTime = osi_Time() + (ams/1000);
    if (ahandle)
	ahandle->proc = (caddr_t) u.u_procp;
    code = 0;
    do {
	osi_CallProc(WaitHack, (char *) u.u_procp, ams);
	sleep(&waitV, PZERO-3);
	osi_CancelProc(WaitHack,  (char *) u.u_procp);
	if (ahandle && (ahandle->proc == (caddr_t) 0)) {
	    code = 2;	/* we've been signalled */
	    break;
	}
    } while (osi_Time() < endTime);
    return code;
}

shutdown_osinet()
{   
    /* this code didn't work, and anyway, there's no real need to put back
	this memory; new AFS instance will use it again */
    return 0;
}
