/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afs_osi.c,v $
 * Revision 2.6  89/06/03  15:27:59  jsb
 * 	Merged with newer ITC sources.
 * 	[89/06/02  01:18:22  jsb]
 * 
 * Revision 2.5  89/04/22  15:14:21  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */

/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987, 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#include <afs/param.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef	AFS_AUX_ENV
#ifdef	PAGING
#include <sys/mmu.h>
#include <sys/seg.h>
#include <sys/page.h>
#include <sys/region.h>
#endif
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#include <sys/var.h>
#endif
#include <sys/systm.h>
#if	!defined(AFS_IBM_ENV) || !defined(sys_rt_r3)
#include <sys/time.h>
#endif	AFS_IBM_ENV
#ifndef	AFS_AIX_ENV
#include <sys/kernel.h>
#endif
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/protosw.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/uio.h>
#include <sys/buf.h>
#ifdef	AFS_GFS_ENV
#include <afs/gfs_vfs.h>
#include <afs/gfs_vnode.h>
#include <machine/psl.h>
#else
#ifdef	AFS_MACH_ENV
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#include <sys/inode.h>
#else	AFS_MACH_ENV
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#endif	AFS_MACH_ENV
#endif	AFS_GFS_ENV
#include <netinet/in.h>
#include <sys/mbuf.h>
#include <sys/proc.h>
#if	!defined(AFS_VFS40) && !defined(AFS_MACH_ENV)
#include <sys/text.h>
#endif	!defined(AFS_VFS40) && !defined(AFS_MACH_ENV)
#include <rpc/types.h>
#include <afs/osi.h>
#include <afs/lock.h>
#include <afs/volerrors.h>
#include <afsint/afsint.h>
#include <afs/afs.h>

long osi_memUsage = 0;

static int dumping = 0;
#ifdef AFSDEBMEM
static struct osimem *memlist;
#endif

struct osimem {
    struct osimem *next;
#ifdef AFSDEBMEM
    long size;
    long addr;
#endif AFSDEBMEM
};

#if	(defined(AFS_SUN_ENV) && !defined(AFS_VFS40))
/* On Suns we have a race condition where in xuntext they unlock the text object before some critical work is completed (i.e. vsxfree(), VN_RELE(), etc) which results to major problems; to keep the binaary-only distribution promise we recode xuntext below. */
afs_sun_xuntext(xp)
	register struct text *xp;
{
	register struct vnode *vp;

	xlock(xp);
	if (xp->x_count) {
		xunlock(xp);
		return;
	}
	vp = xp->x_vptr;
/*	xp->x_flag &= ~XLOCK;	THE CULPRIT! */
	xp->x_vptr = NULL;
	vsxfree(xp, (long)xp->x_size);
	vp->v_flag &= ~(VTEXT|VTEXTMOD);
	VN_RELE(vp);
	xunlock(xp);	/* This was done much earlier in the code */
}
#endif	/*(defined(AFS_SUN_ENV) && !defined(AFS_VFS40))*/

osi_Active(avc)
register struct vcache *avc; {
#if ((defined(AFS_SUN_ENV) && defined(AFS_VFS40)) || defined(AFS_AIX_ENV))
    if (avc->opens > 0)	return 1;   /* XXX: Warning, verify this XXX */
#else
#ifdef	AFS_MACH_ENV
    if (avc->opens > 0 || ((avc->v.v_flag & VTEXT) && !inode_uncache_try(avc))) return 1;
#else	AFS_MACH_ENV
    if (avc->opens > 0 || (avc->v.v_flag & VTEXT)) return 1;
#endif	AFS_MACH_ENV
#endif
    return 0;
}

static int afs_purges = 0;
static long afs_ftf=0;	/* flush text lock */
/* flush text cache */
osi_FlushText(vp)
    register struct vcache *vp; {
    register long fdv;	/* version before which we'll flush */
    register struct text *xp;
    

    /* see if we've already flushed this data version */
    if (vp->m.DataVersion <= vp->flushDV) return;

    ObtainWriteLock(((struct afs_lock *)&afs_ftf));
    fdv = vp->m.DataVersion;
#if	(!defined(AFS_AIX_ENV) && !defined(AFS_AUX_ENV) && !defined(AFS_VFS40) && !defined(AFS_MACH_ENV)) 
    /* why this disgusting code below?  xuntext, called by xrele, doesn't notice
	when it is called with a freed text object.  Sun continually calls xrele
	or xuntext without any locking, as long as VTEXT is set on the corresponding
	vnode.  But, if the text object is locked when you check the VTEXT flag,
	several processes can wait in xuntext, waiting for the text lock; when
	the second one finally enters xuntext's critical region, the text object
	is already free, but the check was already done by xuntext's caller.
	
	Even worse, it turns out that xalloc locks the text object before reading
	or stating a file via the vnode layer.  Thus, we could end up in getdcache,
	being asked to bring in a new version of a file, but the corresponding text
	object could be locked.  We can't flush the text object without causing
	deadlock, so now we just don't try to lock the text object unless it is
	guaranteed to work.  And we try to flush the text when we need to
	a bit more often at the vnode layer.
	
	Sun really blew the vm-cache flushing interface.
    */

    if (vp->v.v_flag & VTEXT) {
#ifdef AFS_SUN_ENV
	register struct text *txp;
#endif AFS_SUN_ENV

	xp = (struct text *) 0;
#ifdef	AFS_GFS_ENV
	if (((struct gnode *)vp)->g_textp)
	    xp = (struct text *) ((struct gnode *)vp)->g_textp;
#else
#ifdef	AFS_SUN_ENV
	/* Sun's vnode doesn't support the v_text field!
	 * We'll do it the long way (looking in the text table), since it's
	 * the only way...
	 */
	for (txp = text; txp < textNTEXT; txp++)
	    if (vp == (struct vcache *) txp->x_vptr) {
		xp = txp;
		break;
	    }
#else
	if (vp->v.v_text) xp = vp->v.v_text;
#endif	AFS_SUN_ENV
#endif	AFS_GFS_ENV

	/* now, if text object is locked, give up */
	if (xp && (xp->x_flag &	XLOCK))	{
	    ReleaseWriteLock(((struct afs_lock *)&afs_ftf));
	    return;
	}
	if (vp->v.v_flag & VTEXT)	/* still has a text object? */
#ifdef	AFS_SUN_ENV
	    /* Note that we don't need to call xrele(vp) since it's expensive on suns (finds xp --which we got-- by following the whole text table) PLUS of course because of sun's xuntext() race condition we need to replace it by the following */
	    afs_sun_xuntext(xp);
#else
	    xrele(vp);  /* try now, brown cow */
#endif
    }

    /* next do the stuff that need not check for deadlock problems */
    afs_purges++;
#ifdef	AFS_GFS_ENV
    afs_mpurge((struct gnode *)vp);
    binval(NODEV, (struct gnode *)vp);
#else
    mpurge(vp);
#endif
#else	/* (!defined(AFS_AIX_ENV) && !defined(AFS_AUX_ENV) && !defined(AFS_VFS40))  && !defined(AFS_MACH_ENV) */
#ifdef	AFS_VFS40
    /* For now we simply toss out (invalidate) all the pages belonging to the vnode, vp. The vnode vp should be locked by the fs so that more pages can't be added when sleeping on this routine. */
    pvn_vptrunc((struct vnode *)vp, 0, 0);
#else
#ifdef	AFS_MACH_ENV
    if (vp->v.v_flag & VTEXT) inode_uncache(vp);
#endif
#endif

#endif	/* (!defined(AFS_AIX_ENV) && !defined(AFS_AUX_ENV) && !defined(AFS_VFS40))  && !defined(AFS_MACH_ENV) */
    /* finally, record that we've done it */
    vp->flushDV = fdv;

    ReleaseWriteLock(((struct afs_lock *)&afs_ftf));
}

/* procedure for making our processes as invisible as we can */
osi_Invisible() {
    /* called once per "kernel" lwp to make it invisible */
    u.u_procp->p_flag |= SSYS;
}

/* call procedure aproc with arock as an argument, in ams milliseconds */
int osi_CallProc(aproc, arock, ams)
    register int (*aproc);
    register char *arock;
    long ams; {
    /* hz is in cycles/second, and timeout's 3rd parm is in cycles(barf!) */
    return timeout(aproc, arock, (ams * afs_hz)/1000 + 1);
}

/* cancel a timeout, whether or not it has already occurred */
int osi_CancelProc(aproc, arock)
    register int (*aproc);
    register char *arock; {
    return untimeout(aproc, arock);
}

/* get the time in seconds */
long osi_Time() {
    struct timeval tv;
    osi_GetTime(&tv);
    return tv.tv_sec;
}

/* set the real time */
osi_SetTime(atv)
    register struct timeval *atv; {
    register int s;

#ifdef	AFS_AIX_ENV
    logtchg(atv->tv_sec);
    clkset(atv->tv_sec);
#else
    /* stolen from kern_time.c */
#ifndef	AFS_AUX_ENV
    boottime.tv_sec += atv->tv_sec - time.tv_sec;
#endif
    s = splclock(); time = *atv; (void) splx(s);
    resettodr();
#ifdef	AFS_AUX_ENV
    logtchg(atv->tv_sec);
#endif
#endif	AFS_AIX_ENV
    return 0;
}

char *osi_Alloc(x)
    long x; {
    register struct osimem *tm;
#ifdef	AFS_IBM_ENV
    x += 4;	/* rt strlen overruns end of string */
#endif	AFS_IBM_ENV
    osi_memUsage += x;
#ifdef AFSDEBMEM
    tm = (struct osimem *) AFS_KALLOC(x+12);
#else
    tm = (struct osimem *) AFS_KALLOC(x);
#endif AFSDEBMEM
#ifdef AFSDEBMEM
    tm->next = memlist;
    memlist = tm;
    tm->size = x;
    tm->addr = *((long *)((char	*)&x - 4));	/* try to find return address */
    return (char *) ((long)tm + 12);
#else
    return (char *) tm;
#endif AFSDEBMEM
}

osi_Free(x,asize)
    register char *x;
    register long asize; {
    register struct osimem *tm, **lm, *um;

#ifdef	AFS_IBM_ENV
    asize += 4;	    /* rt strlen overruns end of strings */
#endif	AFS_IBM_ENV
    osi_memUsage -= asize;
#ifdef AFSDEBMEM
    while(dumping) osi_Sleep(&dumping);	    /* not bulletproof, but good enough */
    tm = (struct osimem *) ((long)x - 12);
    lm = &memlist;
    for(um=memlist; um; lm = &um->next, um = *lm) {
	if (um == tm) break;
    }
    if (um) *lm = tm->next;
    AFS_KFREE(tm,asize+12);
#else
    AFS_KFREE((struct osimem *)x, asize);
#endif
}

osi_Dump(){
    register struct osimem *tm;
    register long *val;
    dumping = 1;
#ifdef AFSDEBMEM
    for(tm=memlist; tm; tm=tm->next) {
	val = (long *) ((long)tm + 12);
	printf("block at %x size %d addr %x: ",
	       tm, tm->size, tm->addr);
	if (tm->size >= 4) printf("%x ", val[0]);
	if (tm->size >= 8) printf("%x ", val[1]);
	if (tm->size >= 12) printf("%x ", val[2]);
	if (tm->size >= 16) printf("%x ", val[3]);
	if (tm->size >= 20) printf("%x ", val[4]);
	printf("\n");
    }
#endif AFSDEBMEM
    dumping = 0;
    osi_Wakeup(&dumping);
}

shutdown_osi()
{
    osi_memUsage = 0;
    dumping = 0;
    afs_purges = 0;
#ifdef	AFSDEBMEM
    memlist = 0;
#endif
}
