/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afs_callback.c,v $
 * Revision 2.5  89/06/03  15:26:53  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  19:05:50  jsb]
 * 
 * Revision 2.4  89/04/22  15:13:21  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987, 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#include <afs/param.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef	AFS_AUX_ENV
#include <sys/mmu.h>
#include <sys/seg.h>
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#endif
#if	!defined(AFS_IBM_ENV) || !defined(sys_rt_r3)
#include <sys/time.h>
#endif	AFS_IBM_ENV
#ifndef	AFS_AIX_ENV
#include <sys/kernel.h>
#endif
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/protosw.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/file.h>
#include <sys/uio.h>
#ifdef	AFS_GFS_ENV
#include <afs/gfs_vfs.h>
#include <afs/gfs_vnode.h>
#else
#ifdef	AFS_MACH_ENV
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#include <sys/inode.h>
#else	AFS_MACH_ENV
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#endif	AFS_MACH_ENV
#endif	AFS_GFS_ENV
#include <netinet/in.h>
#include <sys/mbuf.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include <afs/osi.h>
#include <rx/rx.h>

#include <afs/lock.h>
#include <afs/volerrors.h>
#include <afsint/afsint.h>
#include <afs/afs.h>
#include <afs/prs_fs.h>
#include <afs/dir.h>

extern struct vcache *afs_FindVCache();
extern struct server *afs_FindServer();
long afs_oddCBs	= 0;	    /* break callbacks on dirs */
long afs_evenCBs = 0;	    /* break callbacks received on files */
long afs_oddZaps = 0;	    /* dir cache entries deleted */
long afs_evenZaps = 0;	    /* file cache entries deleted */
long afs_connectBacks = 0;
extern struct rx_service *afs_server;

static ClearCallBack(aconn, afid)
    register struct rx_connection *aconn;
    register struct ViceFid *afid; {
    register struct vcache *tvc;
    register int i;
    register long otherHost;
    register struct server *tserve;
    struct VenusFid localFid;

    otherHost = rx_HostOf(rx_PeerOf(aconn));		/* hosts are always in network order */
    tserve = afs_FindServer(otherHost);	/* cell is don't care value */
    /* normally cell field is valid, but this could be call from previous boot */
    localFid.Cell = ((tserve && tserve->cell)? tserve->cell->cell : 0);
    localFid.Fid.Volume = afid->Volume;
    localFid.Fid.Vnode = afid->Vnode;
    localFid.Fid.Unique = afid->Unique;
    if (afid->Vnode & 1) afs_oddCBs++;	/* could do this on volume basis, too */
    else afs_evenCBs++;
    if (afid->Volume == 0) {
	/* noop */
    }
    else if (afid->Vnode == 0) {
        /* Clear callback for the whole volume. */
        for (i=0;i<VCSIZE;i++)
            for (tvc = afs_vhashTable[i]; tvc; tvc = tvc->hnext) {
                if (tvc->fid.Fid.Volume == afid->Volume
		    && (!localFid.Cell || tvc->fid.Cell == localFid.Cell))
		    tvc->callback = 0;
	    }
    }
    else {
	/* a particular fid was specified */
	i = VCHash(&localFid);
	for(tvc = afs_vhashTable[i]; tvc; tvc = tvc->hnext) {
	    if (tvc->fid.Fid.Vnode == afid->Vnode && tvc->fid.Fid.Volume == afid->Volume
		&& tvc->fid.Fid.Unique == afid->Unique
		&& (!localFid.Cell || tvc->fid.Cell == localFid.Cell)) {
		    tvc->callback = 0;
		}
	}
    }
}

RXAFSCB_CallBack(acall, afids, acallbacks)
struct rx_call *acall;
register struct AFSCBFids *afids;
struct AFSCBs *acallbacks; {
    register int i;
    struct AFSFid *tfid;
    register struct rx_connection *tconn;

    tconn = rx_ConnectionOf(acall);
    tfid = afids->AFSCBFids_val;
    /* for now, we ignore callbacks, since we only *break* callbacks at present */
    for(i=0;i<afids->AFSCBFids_len;i++) ClearCallBack(tconn, &tfid[i]);
    return 0;    
}

RXAFSCB_Probe(acall)
struct rx_call *acall; {
    return 0;
}

/* clear all callbacks from this host */
RXAFSCB_InitCallBackState(acall)
struct rx_call *acall; {
    register int i;
    long otherHost;
    register struct vcache *tvc;
    register struct rx_connection *tconn;

    /* find the address of the host making this call */
    tconn = rx_ConnectionOf(acall);
    otherHost = rx_HostOf(rx_PeerOf(tconn));
    afs_oddCBs++;    /* including any missed via create race */
    afs_evenCBs++;    /* including any missed via create race */
    for (i=0;i<VCSIZE;i++)
	for (tvc = afs_vhashTable[i]; tvc; tvc = tvc->hnext) {
	    if (tvc->callback == otherHost) tvc->callback = 0;
	}
    return 0;
}

afs_RXCallBackServer() {
    while (1) {
	if (afs_server) break;
	osi_Sleep(&afs_server);
    }
    rx_ServerProc();	    /* donate this process to rx */
}

shutdown_CB() {}
