/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log$
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2/reg.h
 *	Author: David E. Bohman II (CMU macmach)
 */

#ifndef _MAC2_REG_H_
#define _MAC2_REG_H_

/*
 * Location of the users' stored
 * registers relative to R0.
 * Usage is u.u_ar0[XX].
 */
#define	R0	(0)
#define	R1	(1)
#define	R2	(2)
#define	R3	(3)
#define	R4	(4)
#define	R5	(5)
#define	R6	(6)
#define	R7	(7)
#define	AR0	(8)
#define	AR1	(9)
#define	AR2	(10)
#define	AR3	(11)
#define	AR4	(12)
#define	AR5	(13)
#define	AR6	(14)
#define	AR7	(15)
#define	SP	(15)

/*
 * Format of 68020/30 processor registers
 * saved after a trap.
 * 1.  user registers from user traps are
 *     saved in the PCB.
 * 2.  kernel registers from kernel traps are
 *     saved on the kernel stack.
 *
 * The program counter and status register are always
 * left in the stack frame on the kernel stack.
 */
#ifndef ASSEMBLER
struct regs {
    int	r_dreg[8];		/* data registers */
#define r_r0 r_dreg[0]
#define r_r1 r_dreg[1]
    int	r_areg[8];		/* address registers */
#define r_sp	r_areg[7]
};

/*
 * 68881/2 FPU.
 */
/*
 * Definition of 96 bit floating
 * point register.
 */
typedef	struct {
    unsigned long	fp[3];
} fp_reg_t;

/*
 * Register state for the FPU.
 */
typedef struct {
    fp_reg_t		fps_regs[8];		/* floating point regs */
    unsigned long	fps_control;		/* control reg */
    unsigned long	fps_status;		/* status reg */
    unsigned long	fps_iaddr;		/* instr address reg */
} fp_state_t;

/*
 * Internal state for the FPU.
 */
#define FPF_NULL_SIZE	0
#define FPF_IDLE_SIZE	0x18
#define FPF_BUSY_SIZE	0xb4

typedef union {
    unsigned long	fpf_format;		/* format word */
    struct {
	unsigned char	fpff_version;		/* version number */
	unsigned char	fpff_size;		/* size of frame */
	unsigned short	fpff_mbz;
	union {
	    struct {
		unsigned short	fpffi_ccr;	/* command/cond register */
		unsigned short	fpffi_mbo;
		unsigned char	fpffi_opnd[12];	/* exceptional operand */
		unsigned long	fpffi_opnd_reg;	/* operand register */
		unsigned long	fpffi_biu_flgs;	/* biu flags */
	    } fpffs_idle_data;
	    unsigned char	fpffs_busy_data[FPF_BUSY_SIZE];
	} fpff_extra;
    } fpf_frame;
} fp_frame_t;
#define fpf_version	fpf_frame.fpff_version
#define fpf_size	fpf_frame.fpff_size
#define fpf_data	fpf_frame.fpff_extra

#endif

#endif _MAC2_REG_H_
