/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log$
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2/phys.s
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * This file contains routines used to
 * copy, zero physical pages.
 */

#include <mac2/asm.h>
#include <mac2/vm_param.h>

/*
 * phys_zero(phys, size)
 *
 * zeros the specified amount of PHYSICAL
 * memory.  Assumes that the address and size
 * describe an integral number of machine-dependent
 * pages.
 */
ENTRY(phys_zero)
    movl    sp@(4),a0
    movl    sp@(8),d1
    movl    #MAC2_PGBYTES-1,d0
    addl    d0,d1
    notl    d0
    andl    d0,d1
    beq	    0f
    jmp	    _zero_mem
0:  rts

/*
 * pmap_zero_page(phys)
 *
 * zeros a machine-independent page of PHYSICAL
 * memory.
 */
ENTRY(pmap_zero_page)
    movl    sp@(4),a0
    movl    _page_size,d1
    jmp	    _zero_mem

/*
 * pmap_copy_page(src, dst)
 *
 * copy one machine independent page of physical
 * memory to another.
 */
ENTRY(pmap_copy_page)
    movl    sp@(4),a0
    movl    sp@(8),a1
    movl    _page_size,d1
    jmp	    _copy_mem

/*
 * copy_to_phys(virt_from, phys_to, size)
 *
 * copies kernel virtual memory to physical memory
 */
ENTRY(copy_to_phys)
    movl    sp@(4),a0
    movl    sp@(8),a1
    movl    sp@(12),d1
    jmp	    _copy_mem

/*
 * copy_from_phys(phys_from, virt_to, size)
 *
 * copies physical memory to kernel virtual memory
 */
ENTRY(copy_from_phys)
    movl    sp@(4),a0
    movl    sp@(8),a1
    movl    sp@(12),d1
    jmp	    _copy_mem

/*
 * getmemc(phys)
 *
 * returns the byte located at the given
 * physical address
 */
ENTRY(getmemc)
    movl    sp@(4),a0
    moveq   #0,d0
    movb    a0@,d0
    rts

/*
 * putmemc(phys, byte)
 *
 * stores the byte at the given
 * physical address
 */
ENTRY(putmemc)
    movl    sp@(4),a0
    movl    sp@(8),d0
    movb    d0,a0@
    rts
