/* Module random */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msg_request_port	msg_local_port
#define msg_reply_port		msg_remote_port
#include <mach/std_types.h>
#include "random_types.h"

/* Procedure init_seed */
mig_internal novalue _Xinit_seed
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
		msg_type_t seedType;
		dbl seed;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern void init_seed
#if	(defined(__STDC__) || defined(c_plusplus))
		(port_t server_port, dbl seed);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_t seedCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		2,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 36) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->seedType != * (int *) &seedCheck)
#else	UseStaticMsgType
	if ((In0P->seedType.msg_type_inline != TRUE) ||
	    (In0P->seedType.msg_type_longform != FALSE) ||
	    (In0P->seedType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (In0P->seedType.msg_type_number != 2) ||
	    (In0P->seedType.msg_type_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; goto punt0; }
#endif	TypeCheck

	init_seed(In0P->Head.msg_request_port, In0P->seed);
	OutP->RetCode = KERN_SUCCESS;
punt0:
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 32;

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = msg_size;
}

/* Function get_randomf */
mig_internal novalue _Xget_randomf
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t get_randomfType;
		int get_randomf;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern int get_randomf
#if	(defined(__STDC__) || defined(c_plusplus))
		(port_t server_port);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_t get_randomfType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->get_randomf = get_randomf(In0P->Head.msg_request_port);
	OutP->RetCode = KERN_SUCCESS;
punt0:
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 40;

#if	UseStaticMsgType
	OutP->get_randomfType = get_randomfType;
#else	UseStaticMsgType
	OutP->get_randomfType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->get_randomfType.msg_type_size = 32;
	OutP->get_randomfType.msg_type_number = 1;
	OutP->get_randomfType.msg_type_inline = TRUE;
	OutP->get_randomfType.msg_type_longform = FALSE;
	OutP->get_randomfType.msg_type_deallocate = FALSE;
	OutP->get_randomfType.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = msg_size;
}

/* Routine get_random */
mig_internal novalue _Xget_random
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t numType;
		int num;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t get_random
#if	(defined(__STDC__) || defined(c_plusplus))
		(port_t server_port, int *num);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_t numType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = get_random(In0P->Head.msg_request_port, &OutP->num);
punt0:
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 40;

#if	UseStaticMsgType
	OutP->numType = numType;
#else	UseStaticMsgType
	OutP->numType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->numType.msg_type_size = 32;
	OutP->numType.msg_type_number = 1;
	OutP->numType.msg_type_inline = TRUE;
	OutP->numType.msg_type_longform = FALSE;
	OutP->numType.msg_type_deallocate = FALSE;
	OutP->numType.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = msg_size;
}

/* Routine get_secret */
mig_internal novalue _Xget_secret
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[3];
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[3];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t get_secret
#if	(defined(__STDC__) || defined(c_plusplus))
		(port_t server_port, string25 password);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_t passwordCheck = {
		/* msg_type_name = */		MSG_TYPE_STRING,
		/* msg_type_size = */		200,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t passwordType = {
		/* msg_type_name = */		MSG_TYPE_STRING,
		/* msg_type_size = */		200,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 56) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->passwordType != * (int *) &passwordCheck)
#else	UseStaticMsgType
	if ((In0P->passwordType.msg_type_inline != TRUE) ||
	    (In0P->passwordType.msg_type_longform != FALSE) ||
	    (In0P->passwordType.msg_type_name != MSG_TYPE_STRING) ||
	    (In0P->passwordType.msg_type_number != 1) ||
	    (In0P->passwordType.msg_type_size != 200))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; goto punt0; }
#endif	TypeCheck

	OutP->RetCode = get_secret(In0P->Head.msg_request_port, In0P->password);
punt0:
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 64;

#if	UseStaticMsgType
	OutP->passwordType = passwordType;
#else	UseStaticMsgType
	OutP->passwordType.msg_type_name = MSG_TYPE_STRING;
	OutP->passwordType.msg_type_size = 200;
	OutP->passwordType.msg_type_number = 1;
	OutP->passwordType.msg_type_inline = TRUE;
	OutP->passwordType.msg_type_longform = FALSE;
	OutP->passwordType.msg_type_deallocate = FALSE;
	OutP->passwordType.msg_type_unused = 0;
#endif	UseStaticMsgType

	(void) mig_strncpy(/* 0 */ OutP->password, In0P->password, 25);
	/* 0 */ OutP->password[24] = '\0';

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = msg_size;
}

/* Routine get_confidential */
mig_internal novalue _Xget_confidential
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_long_t dataType;
		page_ptr data;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t get_confidential
#if	(defined(__STDC__) || defined(c_plusplus))
		(port_t server_port, page_ptr *data);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_long_t dataType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	TRUE,
		/* msg_type_unused = */	0,
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	4096,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = get_confidential(In0P->Head.msg_request_port, &OutP->data);
punt0:
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msg_size = 48;

#if	UseStaticMsgType
	OutP->dataType = dataType;
#else	UseStaticMsgType
	OutP->dataType.msg_type_long_name = MSG_TYPE_INTEGER_32;
	OutP->dataType.msg_type_long_size = 32;
	OutP->dataType.msg_type_long_number = 4096;
	OutP->dataType.msg_type_header.msg_type_inline = FALSE;
	OutP->dataType.msg_type_header.msg_type_longform = TRUE;
	OutP->dataType.msg_type_header.msg_type_deallocate = TRUE;
	OutP->dataType.msg_type_header.msg_type_unused = 0;
#endif	UseStaticMsgType

	OutP->Head.msg_simple = FALSE;
	OutP->Head.msg_size = msg_size;
}

/* SimpleRoutine use_random */
mig_internal novalue _Xuse_random
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
		msg_type_t info_seedType;
		string80 info_seed;
		msg_type_t infoType;
		comp_arr info;
		msg_type_long_t info_1Type;
		words info_1;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t use_random
#if	(defined(__STDC__) || defined(c_plusplus))
		(port_t server_port, string80 info_seed, comp_arr info, words info_1, unsigned int info_1Cnt);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	UseStaticMsgType
	static msg_type_t info_seedCheck = {
		/* msg_type_name = */		MSG_TYPE_CHAR,
		/* msg_type_size = */		8,
		/* msg_type_number = */		80,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t infoCheck = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		2560,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 10368) || (msg_simple != FALSE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->info_seedType != * (int *) &info_seedCheck)
#else	UseStaticMsgType
	if ((In0P->info_seedType.msg_type_inline != TRUE) ||
	    (In0P->info_seedType.msg_type_longform != FALSE) ||
	    (In0P->info_seedType.msg_type_name != MSG_TYPE_CHAR) ||
	    (In0P->info_seedType.msg_type_number != 80) ||
	    (In0P->info_seedType.msg_type_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; goto punt0; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->infoType != * (int *) &infoCheck)
#else	UseStaticMsgType
	if ((In0P->infoType.msg_type_inline != TRUE) ||
	    (In0P->infoType.msg_type_longform != FALSE) ||
	    (In0P->infoType.msg_type_name != MSG_TYPE_INTEGER_32) ||
	    (In0P->infoType.msg_type_number != 2560) ||
	    (In0P->infoType.msg_type_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; goto punt0; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->info_1Type.msg_type_header.msg_type_inline != FALSE) ||
	    (In0P->info_1Type.msg_type_header.msg_type_longform != TRUE) ||
	    (In0P->info_1Type.msg_type_long_name != MSG_TYPE_INTEGER_32) ||
	    (In0P->info_1Type.msg_type_long_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; goto punt0; }
#endif	TypeCheck

	(void) use_random(In0P->Head.msg_request_port, In0P->info_seed, In0P->info, In0P->info_1, In0P->info_1Type.msg_type_long_number);
	OutP->RetCode = MIG_NO_REPLY;
punt0:
	;
}

/* SimpleProcedure exit */
mig_internal novalue _Xexit
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern void exit
#if	(defined(__STDC__) || defined(c_plusplus))
		(port_t server_port);
#else
		();
#endif

#if	TypeCheck
	boolean_t msg_simple;
#endif	TypeCheck

	unsigned int msg_size;

#if	TypeCheck
	msg_size = In0P->Head.msg_size;
	msg_simple = In0P->Head.msg_simple;
	if ((msg_size != 24) || (msg_simple != TRUE))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	exit(In0P->Head.msg_request_port);
	OutP->RetCode = MIG_NO_REPLY;
punt0:
	;
}

boolean_t random_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(msg_header_t *InHeadP, msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register msg_header_t *InP =  InHeadP;
	register death_pill_t *OutP = (death_pill_t *) OutHeadP;

#if	UseStaticMsgType
	static msg_type_t RetCodeType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
		/* msg_type_unused = */	0,
	};
#endif	UseStaticMsgType

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = sizeof *OutP;
	OutP->Head.msg_type = InP->msg_type;
	OutP->Head.msg_local_port = PORT_NULL;
	OutP->Head.msg_remote_port = InP->msg_reply_port;
	OutP->Head.msg_id = InP->msg_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msg_type_size = 32;
	OutP->RetCodeType.msg_type_number = 1;
	OutP->RetCodeType.msg_type_inline = TRUE;
	OutP->RetCodeType.msg_type_longform = FALSE;
	OutP->RetCodeType.msg_type_deallocate = FALSE;
	OutP->RetCodeType.msg_type_unused = 0;
#endif	UseStaticMsgType
	OutP->RetCode = MIG_BAD_ID;

	if ((InP->msg_id > 506) || (InP->msg_id < 500))
		return FALSE;
	else {
		typedef novalue (*SERVER_STUB_PROC)
#if	(defined(__STDC__) || defined(c_plusplus))
			(msg_header_t *, msg_header_t *);
#else
			();
#endif
		static SERVER_STUB_PROC routines[] = {
			_Xinit_seed,
			_Xget_randomf,
			_Xget_random,
			_Xget_secret,
			_Xget_confidential,
			_Xuse_random,
			_Xexit,
		};

		if (routines[InP->msg_id - 500])
			(routines[InP->msg_id - 500]) (InP, &OutP->Head);
		 else
			return FALSE;
	}
	return TRUE;
}
