#ifndef	_random
#define	_random

/* Module random */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#ifndef	mig_external
#define mig_external extern
#endif

mig_external void init_random
#if	(defined(__STDC__) || defined(c_plusplus))
    (port_t rep_port);
#else
    ();
#endif
#include <mach/std_types.h>
#include "random_types.h"

/* Procedure init_seed */
mig_external void init_seed
#if	defined(LINTLIBRARY)
    (server_port, seed)
	port_t server_port;
	dbl seed;
{ init_seed(server_port, seed); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	dbl seed
);
#else
    ();
#endif
#endif

/* Function get_randomf */
mig_external int get_randomf
#if	defined(LINTLIBRARY)
    (server_port)
	port_t server_port;
{ return get_randomf(server_port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port
);
#else
    ();
#endif
#endif

/* Routine get_random */
mig_external kern_return_t get_random
#if	defined(LINTLIBRARY)
    (server_port, num)
	port_t server_port;
	int *num;
{ return get_random(server_port, num); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	int *num
);
#else
    ();
#endif
#endif

/* Routine get_secret */
mig_external kern_return_t get_secret
#if	defined(LINTLIBRARY)
    (server_port, password)
	port_t server_port;
	string25 password;
{ return get_secret(server_port, password); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	string25 password
);
#else
    ();
#endif
#endif

/* Routine get_confidential */
mig_external kern_return_t get_confidential
#if	defined(LINTLIBRARY)
    (server_port, wait, mtype | MSG_TYPE_RPC, data)
	port_t server_port;
	int wait;
	int mtype | MSG_TYPE_RPC;
	page_ptr *data;
{ return get_confidential(server_port, wait, mtype | MSG_TYPE_RPC, data); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	int wait,
	int mtype | MSG_TYPE_RPC,
	page_ptr *data
);
#else
    ();
#endif
#endif

/* SimpleRoutine use_random */
mig_external kern_return_t use_random
#if	defined(LINTLIBRARY)
    (server_port, info_seed, info, info_1, info_1Cnt)
	port_t server_port;
	string80 info_seed;
	comp_arr info;
	words info_1;
	unsigned int info_1Cnt;
{ return use_random(server_port, info_seed, info, info_1, info_1Cnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port,
	string80 info_seed,
	comp_arr info,
	words info_1,
	unsigned int info_1Cnt
);
#else
    ();
#endif
#endif

/* SimpleProcedure exit */
mig_external void exit
#if	defined(LINTLIBRARY)
    (server_port)
	port_t server_port;
{ exit(server_port); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	port_t server_port
);
#else
    ();
#endif
#endif

#endif	_random
