#! /bin/sh

# /etc/newsys for MacMach BSD 4.3

# BUG: should extract gateway address from $DISK/.hostname

# these are the possible installation sources, only one will be non-null
# with a value that is the system type for that source
# future possibilities are  NFS, TAPE, TAR, CPIO, ???
AFS=""
AFS_VALUE="An AFS system type is the name of an installation script."
DISK=""
DISK_VALUE="A DISK system type is the source directory."
FTP=""
FTP_VALUE="An FTP system type is the address of the ftp server."

# FTP installation constants, override with environment variables
[ "$FTP_USER" ] || FTP_USER="guest"
[ "$FTP_PASSWD" ] || FTP_PASSWD="guest"
[ "$FTP_SCRIPT" ] || FTP_SCRIPT="macmach.install"
LOCAL_FTP_SCRIPT="/$FTP_SCRIPT"

# parse command line arguments
if [ "$#" != 5 -a "$#" != 0 ]; then
  echo "usage: newsys [ <SOURCE> <TYPE> <ADDR> <SCSIID> <ROOT> ]"
  echo "Note: ADDR and/or SCSIID may be \"*\" to indicate automatic selection."
  exit 1
fi
SOURCE="$1"
TYPE="$2"
ADDR="$3"
SCSIID="$4"
ROOT="$5"

# gather important parameters
ASKED=""
echo ""
echo "MacMach System Installer"
while [ ! "$SOURCE" ]; do
  echo "The supported system sources are: AFS DISK FTP"
  echo -n "Enter the installation source: "
  read SOURCE
  case $SOURCE in
    afs|AFS) break ;;
    disk|DISK) break ;;
    ftp|FTP) break ;;
    *) SOURCE="" ;;
  esac
  ASKED="YES"
done
while [ ! "$TYPE" ]; do
  case $SOURCE in
    afs|AFS) echo "$AFS_PROMPT"; break ;;
    disk|DISK) echo "$DISK_PROMPT"; break ;;
    ftp|FTP) echo "$FTP_PROMPT"
      echo "Other FTP environment variables are:
      echo "  FTP_USER=$FTP_USER"
      echo "  FTP_PASSWD=$FTP_PASSWD"
      echo "  FTP_SUBDIR=$FTP_SUBDIR"
      echo "  FTP_SCRIPT=-$FTP_SCRIPT"
      break ;;
  esac
  echo -n "Enter the system type: "
  read TYPE
  ASKED="YES"
done
if [ ! "$ADDR" ]; then
  echo "The network address for the target system will be used by the"
  echo "installing system if the network is not already enabled."
  echo "If the installing system is not registered with a local bootp"
  echo "server, the actual address must be specified.  The /etc/hosts and"
  echo "/.hostname files on the target machine may have to be manually"
  echo "updated if the address is not already in the host table."
  echo -n "Enter the network address of this system (* for bootp) [*]: "
  read ADDR
  [ "$ADDR" ] || ADDR="*"
  ASKED="YES"
fi
if [ ! "$SCSIID" ]; then
  echo "The target disk must have an Apple partition of one of these types:"
  echo "  Apple_Free"
  echo "  Mach_UNIX_BSD4.3"
  echo "An old Apple partition of type "MACH" is also accepted."
  echo "The installation software can search all disks for usable partitions."
  echo -n "Enter the SCSI ID # of the target disk drive (* for search) [*]: "
  read SCSIID
  [ "$SCSIID" ] || SCSIID="*"
  ASKED="YES"
fi
if [ ! "$ROOT" ]; then
  echo "The target disk will be mounted as a local directory during the"
  echo "installation process."
  echo -n "Enter the root of the new file system [/mnt]: "
  read ROOT
  [ "$ROOT" ] || ROOT="/mnt"
  ASKED="YES"
fi
case $SOURCE in
  afs|AFS) AFS="$TYPE"; break ;;
  disk|DISK) DISK="$TYPE"; break ;;
  ftp|FTP) FTP="$TYPE"; break ;;
  *) echo "ERROR: invalid installation source \"$SOURCE\""
    echo "Valid sources are: AFS or DISK"
    exit 1
    ;;
esac
while true; do
  echo ""
  echo "Installation source:   $SOURCE"
  echo "System type:           $TYPE"
  echo "Network address:       $ADDR"
  echo "SCSI Disk address:     $SCSIID"
  echo "File system root:      $ROOT"
  [ "$ASKED" ] || break
  echo -n "Ok to proceed? "
  read YES
  case $YES in
    Y|y|YES|yes) break
      ;;
    N|n|NO|no) exit 0
      ;;
    *) echo "Please enter YES or NO."
      ;;
  esac
done
echo ""

# Turn automatic selection flags into null strings.
[ "$SCSIID" = "*" ] && SCSIID=""
[ "$ADDR" = "*" ] && ADDR=""

# AFS and FTP installation uses network
if [ "$AFS" -o "$FTP" -o ! "$ADDR" ]; then
  # if network not up, bring up using specified address
  expr "`ifconfig en0`" : ".*UP" >/dev/null 2>&1 || {
    echo ""
    [ "$ADDR" ] || {
      echo "Using BOOTP to determine network address."
      ifconfig en0 0.0.0.0 netmask 0x0 broadcast 128.2.0.0 || {
        echo "ERROR: ifconfig failed before bootp"
	echo "This should not have happened!"
        exit 1
      }
      ADDR=`bootp` || {
        echo "ERROR: bootp failed"
        echo "Your ethernet address is probably not in the bootp database yet."
        ifconfig en0 down
        exit 1
      }
      ifconfig en0 down
    }
    echo "Starting network access for $ADDR."
    ifconfig en0 $ADDR up arp -trailers || {
      echo "ERROR: ifconfig failed for address \"$ADDR\""
      echo "This should not have happened!"
      exit 1
    }
  }
  [ "$ADDR" ] || {
    echo "ERROR: No network address."
    echo "Do not use \"*\" when the network is already started."
    echo "Use "ifconfig en0 down" to turn off the network."
    exit 1
  }
fi

if [ "$FTP" ]; then
  echo ""
  echo "Loading installation script from ftp server."
  (
    echo "user $FTP_USER $FTP_PASSWD"
    echo "cd $FTP_SUBDIR"
    echo "get $FTP_SCRIPT $LOCAL_FTP_SCRIPT"
    echo "bye"
  ) | ftp -n -i $FTP
  [ -f $LOCAL_FTP_SCRIPT ] || {
    echo "Can not get ftp installation script from \"$FTP\"."
  }
fi

echo ""
SCSIID="`mac2part $SCSIID`"
[ "$SCSIID" ] || {
  echo "ERROR: mac2part failed"
  echo "Can not determine SCSI disk ID."
  exit 1
}

echo ""
echo "No further user interaction will be required for this installation."

# make sure that the disk is not already mounted somehow...
umount /dev/sd$SCSIID"g" >/dev/null 2>&1
umount /dev/sd$SCSIID"a" >/dev/null 2>&1

echo ""
echo "Making root file system on disk $SCSIID."
newfs /dev/rsd$SCSIID"a"

echo ""
echo "Making usr file system on disk $SCSIID."
newfs /dev/rsd$SCSIID"g"

echo ""
echo "Mounting new file system, creating lost+found directories."
mount /dev/sd$SCSIID"a" $ROOT
cd $ROOT
mklost+found
mkdir $ROOT/usr
mount /dev/sd$SCSIID"g" $ROOT/usr
cd $ROOT/usr
mklost+found

# Note that /tmp and /usr on a ramdisk will be
# symbolic links to $ROOT/tmp and $ROOT/usr
mkdir $ROOT/tmp
chmod 777 $ROOT/tmp
mkdir $ROOT/usr/tmp
chmod 777 $ROOT/usr/tmp

# DISK installation, copy files disk to disk
if [ "$DISK" ]; then
  ROOTSTUFF=".README .cshrc .login .profile bin dev etc lib vmunix"
  USRSTUFF="adm bin dict etc games guest include lib man old preserve spool ucb"
  [ -d $DISK ] || {
    echo "ERROR: can not access \"$DISK\"."
    echo "This should be the directory where the source disk is mounted."
    exit 1
  }
  PATH="$DISK/bin:$DISK/usr/bin:$DISK/usr/ucb:$DISK/etc"
  export PATH
  cd $DISK
  find $ROOTSTUFF -print | cpio -pduvm $ROOT
  cd $DISK/usr
  find $USRSTUFF -print | cpio -pduvm $ROOT/usr
  echo ""
  echo "Making $ROOT/etc/fstab for disk $SCSIID"
  (
    echo "/dev/sd${SCSIID}a:/:rw:0:1"
    echo "/dev/sd${SCSIID}g:/usr:rw:0:2"
  ) > $ROOT/etc/fstab
  chmod 444 $ROOT/etc/fstab
  echo ""
  echo "Making $ROOT/.hostname for address $ADDR"
  HOSTS=$DISK/etc/hosts
  HOSTNAME="`grep $ADDR $HOSTS |
  sed -e 's/^[^ 	]*[ 	]*//' -e 's/[ 	].*//' -e 'q'`"
  [ "$HOSTNAME" ] || {
    echo "WARNING: could not find $ADDR in $HOSTS"
    echo "System will not use external network."
  }
  # BUG: should extract gateway address from $DISK/.hostname
  GATEWAY="128.2.254.36"
  (
    echo "# This is the system's name."
    if [ "$HOSTNAME" ]; then
      echo "HOSTNAME=\"$HOSTNAME\""
    else
      echo "HOSTNAME=\"MacMach\""
    fi
    echo ""
    echo "# Set NETNAME to \$HOSTNAME to enable external network access."
    if [ "$HOSTNAME" ]; then
      echo "NETNAME=\"\$HOSTNAME\""
    else
      echo "#NETNAME=\"\$HOSTNAME\""
      echo "NETNAME=\"\""
    fi
    echo ""
    echo "# This is the gateway IP address."
    echo "GATEWAY=\"$GATEWAY\""
  ) >$ROOT/.hostname
  chmod 444 $ROOT/.hostname
  # flush the old message of the day
  rm -f $ROOT/etc/motd
  echo ""
  echo "Unmounting disk $SCSIID"
  sync
  mount /dev/sd$SCSIID"g"
  umount /dev/sd$SCSIID"a"
  echo ""
  echo "Installation on $ROOT (SCSIID $SCSIID) complete"
  exit 0
fi

# AFS installation uses AFS
if [ "$AFS" ]; then
  # build new vice directory, usually for ramdisk operation
  [ -d /usr/vice ] || {
    echo ""
    echo "Starting up AFS access."
    [ -d /vice.etc ] || {
      echo "ERROR: can not find files for /usr/vice/etc in /vice.etc"
      echo "These files are needed for AFS."
      exit 1
    }
    mkdir /usr/vice
    chmod 755 /usr/vice
    mkdir /usr/vice/cache
    chmod 700 /usr/vice/cache
    mkdir /usr/vice/etc
    chmod 755 /usr/vice/etc
    cp /vice.etc/* /usr/vice/etc
    /usr/vice/etc/afsd -rootvol root.afs.readonly
  }
  [ -r $AFS ] || {
    echo "ERROR: can not read \"$AFS\""
    echo "The AFS system type is the full path name of the install script."
    exit 1
  }
  echo ""
  echo "Continuing installation from $AFS"
  exec sh $AFS $ROOT $ADDR $SCSIID
fi

if [ "$FTP" ]; then
  echo ""
  echo "Continuing installation from $LOCAL_FTP_SCRIPT"
  exec sh $LOCAL_FTP_SCRIPT $ROOT $ADDR $SCSIID
fi
