#ifndef lint
static	char sccsid[] = "@(#)setup.c	1.1 (Berkeley) 2/25/86";
#endif

/*
 * adb - routines to read a.out+core at startup
 */
#include "defs.h"
#include <machine/frame.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <machine/pcb.h>

off_t	txtbas;
off_t	datbas;			/* offset of the base of the data segment */
off_t	stksiz;			/* stack size in the core image */
INT	sigcode;	/* belongs in head.h */

char	*symfil	= "a.out";
char	*corfil	= "core";

setsym()
{
	off_t loc;
	struct exec hdr;
	register struct nlist *sp;
	int ssiz;
	char *strtab, *malloc();

	fsym = getfile(symfil, 1);
	txtmap.ufd = fsym;
	if (read(fsym, (char *)&hdr, sizeof hdr) != sizeof hdr ||
	    N_BADMAG(hdr)) {
		txtmap.e1 = MAXFILE;
		return;
	}
	filhdr = hdr;
	loc = filhdr.a_text+filhdr.a_data;
	txtbas = (filhdr.a_magic == ZMAGIC) ? N_TXTADDR(filhdr) : filhdr.a_entry;
	txtmap.f1 = txtmap.f2 = N_TXTOFF(filhdr);
	txtmap.b1 = 0;
	switch (filhdr.a_magic) {

	case OMAGIC:
		txtmap.b1 = txtmap.e1 = 0;
		txtmap.b2 = datbas = txtbas;
		txtmap.e2 = loc+txtbas;
		break;

	case ZMAGIC:
	case NMAGIC:
		txtmap.b1 = txtbas;
		txtmap.e1 = filhdr.a_text+txtbas;
		txtmap.b2 = datbas = round(filhdr.a_text, SEGSIZ);
		txtmap.e2 = datbas + filhdr.a_data;
		txtmap.f2 += filhdr.a_text;
	}
	loc = N_SYMOFF(filhdr);
	symtab = (struct nlist *) malloc(filhdr.a_syms);
	esymtab = &symtab[filhdr.a_syms / sizeof (struct nlist)];
	if (symtab == NULL)
		goto nospac;
	lseek(fsym, loc, L_SET);
	if (filhdr.a_syms == 0)
		goto nosymt;
	/* SHOULD SQUISH OUT STABS HERE!!! */
	if (read(fsym, symtab, filhdr.a_syms) != filhdr.a_syms)
		goto readerr;
	if (read(fsym, &ssiz, sizeof (ssiz)) != sizeof (ssiz))
		goto oldfmt;
	strtab = malloc(ssiz);
	if (strtab == 0)
		goto nospac;
	*(int *)strtab = ssiz;
	ssiz -= sizeof (ssiz);
	if (read(fsym, strtab + sizeof (ssiz), ssiz) != ssiz)
		goto readerr;
	for (sp = symtab; sp < esymtab; sp++)
		if (sp->n_un.n_strx)
			/* SHOULD PERFORM RANGE CHECK HERE */
			sp->n_un.n_name = strtab + sp->n_un.n_strx;
nosymt:
	return;
readerr:
	printf("Error reading symbol|string table\n");
	exit(1);
nospac:
	printf("Not enough space for symbol|string table\n");
	exit(1);
oldfmt:
	printf("Old format a.out - no string table\n");
	exit(1);
}

#include <stdio.h>

setcor()
{
	fcor = datmap.ufd = getfile(corfil,2);
	if (kernel) {
		struct stat stb;

		fstat(fcor, &stb);
		datmap.b1 = 0;
		datmap.e1 = -1;
		datmap.f1 = 0;
		return;
 	}

	if (read(fcor, (char *)&u, ctob(UPAGES))!=ctob(UPAGES)) {
		datmap.e1 = MAXFILE;
		return;
	}
	signo = u.u_arg[0];
	sigcode = u.u_code;
	filhdr.a_text = ctob(u.u_tsize);
	filhdr.a_data = ctob(u.u_dsize);
	stksiz = ctob(u.u_ssize);
	switch (filhdr.a_magic) {

	case OMAGIC:
		datmap.b1 = txtbas;
		datmap.e1 = datmap.b1 + filhdr.a_text+filhdr.a_data;
		datmap.f2 = ctob(UPAGES) + filhdr.a_text+filhdr.a_data;
		break;

	case NMAGIC:
	case ZMAGIC:
		datmap.b1 = round(filhdr.a_text, SEGSIZ);
		datmap.e1 = datmap.b1 + filhdr.a_data;
		datmap.f2 = ctob(UPAGES) + filhdr.a_data;
		break;
	}
	datmap.f1 = ctob(UPAGES);
	datmap.b2 = MAXSTOR - stksiz;
	datmap.e2 = MAXSTOR;

#ifdef mac2
	getpcb();
#endif mac2
}

getpcb()
{
    struct pcb *pcb;
    int frame;

    pcb = (struct pcb *)&udot.UU[NBPG];
    frame = ((int)pcb->pcb_frame & (NBPG-1)) + NBPG;
    bcopy(&pcb->pcb_user, adbinfo.userregs, sizeof pcb->pcb_user);
    bcopy(&pcb->pcb_fp_state, adbinfo.fpregs, sizeof adbinfo.fpregs);
    adbinfo.userregs[PS] = *((u_short *)&udot.UU[frame]);
    adbinfo.userregs[PC] = *((int *)&udot.UU[frame+2]);
}

create(f)
	char *f;
{
	register int fd;

	fd = creat(f, 0644);
	if (fd < 0)
		return (-1);
	close(fd);
	return (open(f, wtflag));
}

getfile(filnam, cnt)
	char *filnam;
{
	register int fsym;

	if (eqstr(filnam, "-"))
		return (-1);
	fsym = open(filnam, wtflag);
	if (fsym < 0 && xargc > cnt) {
		if (wtflag)
			fsym = create(filnam);
		if (fsym < 0)
			printf("cannot open `%s'\n", filnam);
	}
	return (fsym);
}

setvar()
{

	var[varchk('b')] = datbas;
	var[varchk('d')] = filhdr.a_data;
	var[varchk('e')] = filhdr.a_entry;
	var[varchk('m')] = filhdr.a_magic;
	var[varchk('s')] = stksiz;
	var[varchk('t')] = filhdr.a_text;
}
