/* $XConsortium: maskbits.c,v 1.6 89/11/13 09:37:34 rws Exp $ */
/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

	All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
#include "maskbits.h"
#include "servermd.h"

/*
these tables are used by several macros in the mfb code.

   the vax numbers everything left to right, so bit indices on the
screen match bit indices in longwords.  the pc-rt and Sun number
bits on the screen the way they would be written on paper,
(i.e. msb to the left), and so a bit index n on the screen is
bit index 32-n in a longword

   see also maskbits.h
*/

#if (BITMAP_BIT_ORDER == MSBFirst)
/* NOTE:
the first element in starttab could be 0xffffffff.  making it 0
lets us deal with a full first word in the middle loop, rather
than having to do the multiple reads and masks that we'd
have to do if we thought it was partial.
*/
int starttab[32] =
    {
	LONG2CHARS( 0x00000000 ),
	LONG2CHARS( 0x7FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000001 )
    };

int endtab[32] =
    {
	LONG2CHARS( 0x00000000 ),
	LONG2CHARS( 0x80000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFFE )
    };

#if NEED_OLD_MFB_MASKS
/* a hack, for now, since the entries for 0 need to be all
   1 bits, not all zeros.
   this means the code DOES NOT WORK for segments of length
   0 (which is only a problem in the horizontal line code.)
*/
int startpartial[32] =
    {
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0x7FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000001 )
    };

int endpartial[32] =
    {
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0x80000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFFE )
    };
#endif

unsigned int partmasks[32][32] = {
     {LONG2CHARS( 0xFFFFFFFF ), LONG2CHARS( 0x80000000 ), LONG2CHARS( 0xC0000000 ), LONG2CHARS( 0xE0000000 ),
      LONG2CHARS( 0xF0000000 ), LONG2CHARS( 0xF8000000 ), LONG2CHARS( 0xFC000000 ), LONG2CHARS( 0xFE000000 ),
      LONG2CHARS( 0xFF000000 ), LONG2CHARS( 0xFF800000 ), LONG2CHARS( 0xFFC00000 ), LONG2CHARS( 0xFFE00000 ),
      LONG2CHARS( 0xFFF00000 ), LONG2CHARS( 0xFFF80000 ), LONG2CHARS( 0xFFFC0000 ), LONG2CHARS( 0xFFFE0000 ),
      LONG2CHARS( 0xFFFF0000 ), LONG2CHARS( 0xFFFF8000 ), LONG2CHARS( 0xFFFFC000 ), LONG2CHARS( 0xFFFFE000 ),
      LONG2CHARS( 0xFFFFF000 ), LONG2CHARS( 0xFFFFF800 ), LONG2CHARS( 0xFFFFFC00 ), LONG2CHARS( 0xFFFFFE00 ),
      LONG2CHARS( 0xFFFFFF00 ), LONG2CHARS( 0xFFFFFF80 ), LONG2CHARS( 0xFFFFFFC0 ), LONG2CHARS( 0xFFFFFFE0 ),
      LONG2CHARS( 0xFFFFFFF0 ), LONG2CHARS( 0xFFFFFFF8 ), LONG2CHARS( 0xFFFFFFFC ), LONG2CHARS( 0xFFFFFFFE )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x40000000 ), LONG2CHARS( 0x60000000 ), LONG2CHARS( 0x70000000 ),
      LONG2CHARS( 0x78000000 ), LONG2CHARS( 0x7C000000 ), LONG2CHARS( 0x7E000000 ), LONG2CHARS( 0x7F000000 ),
      LONG2CHARS( 0x7F800000 ), LONG2CHARS( 0x7FC00000 ), LONG2CHARS( 0x7FE00000 ), LONG2CHARS( 0x7FF00000 ),
      LONG2CHARS( 0x7FF80000 ), LONG2CHARS( 0x7FFC0000 ), LONG2CHARS( 0x7FFE0000 ), LONG2CHARS( 0x7FFF0000 ),
      LONG2CHARS( 0x7FFF8000 ), LONG2CHARS( 0x7FFFC000 ), LONG2CHARS( 0x7FFFE000 ), LONG2CHARS( 0x7FFFF000 ),
      LONG2CHARS( 0x7FFFF800 ), LONG2CHARS( 0x7FFFFC00 ), LONG2CHARS( 0x7FFFFE00 ), LONG2CHARS( 0x7FFFFF00 ),
      LONG2CHARS( 0x7FFFFF80 ), LONG2CHARS( 0x7FFFFFC0 ), LONG2CHARS( 0x7FFFFFE0 ), LONG2CHARS( 0x7FFFFFF0 ),
      LONG2CHARS( 0x7FFFFFF8 ), LONG2CHARS( 0x7FFFFFFC ), LONG2CHARS( 0x7FFFFFFE ), LONG2CHARS( 0x7FFFFFFF )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x20000000 ), LONG2CHARS( 0x30000000 ), LONG2CHARS( 0x38000000 ),
      LONG2CHARS( 0x3C000000 ), LONG2CHARS( 0x3E000000 ), LONG2CHARS( 0x3F000000 ), LONG2CHARS( 0x3F800000 ),
      LONG2CHARS( 0x3FC00000 ), LONG2CHARS( 0x3FE00000 ), LONG2CHARS( 0x3FF00000 ), LONG2CHARS( 0x3FF80000 ),
      LONG2CHARS( 0x3FFC0000 ), LONG2CHARS( 0x3FFE0000 ), LONG2CHARS( 0x3FFF0000 ), LONG2CHARS( 0x3FFF8000 ),
      LONG2CHARS( 0x3FFFC000 ), LONG2CHARS( 0x3FFFE000 ), LONG2CHARS( 0x3FFFF000 ), LONG2CHARS( 0x3FFFF800 ),
      LONG2CHARS( 0x3FFFFC00 ), LONG2CHARS( 0x3FFFFE00 ), LONG2CHARS( 0x3FFFFF00 ), LONG2CHARS( 0x3FFFFF80 ),
      LONG2CHARS( 0x3FFFFFC0 ), LONG2CHARS( 0x3FFFFFE0 ), LONG2CHARS( 0x3FFFFFF0 ), LONG2CHARS( 0x3FFFFFF8 ),
      LONG2CHARS( 0x3FFFFFFC ), LONG2CHARS( 0x3FFFFFFE ), LONG2CHARS( 0x3FFFFFFF ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x10000000 ), LONG2CHARS( 0x18000000 ), LONG2CHARS( 0x1C000000 ),
      LONG2CHARS( 0x1E000000 ), LONG2CHARS( 0x1F000000 ), LONG2CHARS( 0x1F800000 ), LONG2CHARS( 0x1FC00000 ),
      LONG2CHARS( 0x1FE00000 ), LONG2CHARS( 0x1FF00000 ), LONG2CHARS( 0x1FF80000 ), LONG2CHARS( 0x1FFC0000 ),
      LONG2CHARS( 0x1FFE0000 ), LONG2CHARS( 0x1FFF0000 ), LONG2CHARS( 0x1FFF8000 ), LONG2CHARS( 0x1FFFC000 ),
      LONG2CHARS( 0x1FFFE000 ), LONG2CHARS( 0x1FFFF000 ), LONG2CHARS( 0x1FFFF800 ), LONG2CHARS( 0x1FFFFC00 ),
      LONG2CHARS( 0x1FFFFE00 ), LONG2CHARS( 0x1FFFFF00 ), LONG2CHARS( 0x1FFFFF80 ), LONG2CHARS( 0x1FFFFFC0 ),
      LONG2CHARS( 0x1FFFFFE0 ), LONG2CHARS( 0x1FFFFFF0 ), LONG2CHARS( 0x1FFFFFF8 ), LONG2CHARS( 0x1FFFFFFC ),
      LONG2CHARS( 0x1FFFFFFE ), LONG2CHARS( 0x1FFFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x08000000 ), LONG2CHARS( 0x0C000000 ), LONG2CHARS( 0x0E000000 ),
      LONG2CHARS( 0x0F000000 ), LONG2CHARS( 0x0F800000 ), LONG2CHARS( 0x0FC00000 ), LONG2CHARS( 0x0FE00000 ),
      LONG2CHARS( 0x0FF00000 ), LONG2CHARS( 0x0FF80000 ), LONG2CHARS( 0x0FFC0000 ), LONG2CHARS( 0x0FFE0000 ),
      LONG2CHARS( 0x0FFF0000 ), LONG2CHARS( 0x0FFF8000 ), LONG2CHARS( 0x0FFFC000 ), LONG2CHARS( 0x0FFFE000 ),
      LONG2CHARS( 0x0FFFF000 ), LONG2CHARS( 0x0FFFF800 ), LONG2CHARS( 0x0FFFFC00 ), LONG2CHARS( 0x0FFFFE00 ),
      LONG2CHARS( 0x0FFFFF00 ), LONG2CHARS( 0x0FFFFF80 ), LONG2CHARS( 0x0FFFFFC0 ), LONG2CHARS( 0x0FFFFFE0 ),
      LONG2CHARS( 0x0FFFFFF0 ), LONG2CHARS( 0x0FFFFFF8 ), LONG2CHARS( 0x0FFFFFFC ), LONG2CHARS( 0x0FFFFFFE ),
      LONG2CHARS( 0x0FFFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x04000000 ), LONG2CHARS( 0x06000000 ), LONG2CHARS( 0x07000000 ),
      LONG2CHARS( 0x07800000 ), LONG2CHARS( 0x07C00000 ), LONG2CHARS( 0x07E00000 ), LONG2CHARS( 0x07F00000 ),
      LONG2CHARS( 0x07F80000 ), LONG2CHARS( 0x07FC0000 ), LONG2CHARS( 0x07FE0000 ), LONG2CHARS( 0x07FF0000 ),
      LONG2CHARS( 0x07FF8000 ), LONG2CHARS( 0x07FFC000 ), LONG2CHARS( 0x07FFE000 ), LONG2CHARS( 0x07FFF000 ),
      LONG2CHARS( 0x07FFF800 ), LONG2CHARS( 0x07FFFC00 ), LONG2CHARS( 0x07FFFE00 ), LONG2CHARS( 0x07FFFF00 ),
      LONG2CHARS( 0x07FFFF80 ), LONG2CHARS( 0x07FFFFC0 ), LONG2CHARS( 0x07FFFFE0 ), LONG2CHARS( 0x07FFFFF0 ),
      LONG2CHARS( 0x07FFFFF8 ), LONG2CHARS( 0x07FFFFFC ), LONG2CHARS( 0x07FFFFFE ), LONG2CHARS( 0x07FFFFFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x02000000 ), LONG2CHARS( 0x03000000 ), LONG2CHARS( 0x03800000 ),
      LONG2CHARS( 0x03C00000 ), LONG2CHARS( 0x03E00000 ), LONG2CHARS( 0x03F00000 ), LONG2CHARS( 0x03F80000 ),
      LONG2CHARS( 0x03FC0000 ), LONG2CHARS( 0x03FE0000 ), LONG2CHARS( 0x03FF0000 ), LONG2CHARS( 0x03FF8000 ),
      LONG2CHARS( 0x03FFC000 ), LONG2CHARS( 0x03FFE000 ), LONG2CHARS( 0x03FFF000 ), LONG2CHARS( 0x03FFF800 ),
      LONG2CHARS( 0x03FFFC00 ), LONG2CHARS( 0x03FFFE00 ), LONG2CHARS( 0x03FFFF00 ), LONG2CHARS( 0x03FFFF80 ),
      LONG2CHARS( 0x03FFFFC0 ), LONG2CHARS( 0x03FFFFE0 ), LONG2CHARS( 0x03FFFFF0 ), LONG2CHARS( 0x03FFFFF8 ),
      LONG2CHARS( 0x03FFFFFC ), LONG2CHARS( 0x03FFFFFE ), LONG2CHARS( 0x03FFFFFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x01000000 ), LONG2CHARS( 0x01800000 ), LONG2CHARS( 0x01C00000 ),
      LONG2CHARS( 0x01E00000 ), LONG2CHARS( 0x01F00000 ), LONG2CHARS( 0x01F80000 ), LONG2CHARS( 0x01FC0000 ),
      LONG2CHARS( 0x01FE0000 ), LONG2CHARS( 0x01FF0000 ), LONG2CHARS( 0x01FF8000 ), LONG2CHARS( 0x01FFC000 ),
      LONG2CHARS( 0x01FFE000 ), LONG2CHARS( 0x01FFF000 ), LONG2CHARS( 0x01FFF800 ), LONG2CHARS( 0x01FFFC00 ),
      LONG2CHARS( 0x01FFFE00 ), LONG2CHARS( 0x01FFFF00 ), LONG2CHARS( 0x01FFFF80 ), LONG2CHARS( 0x01FFFFC0 ),
      LONG2CHARS( 0x01FFFFE0 ), LONG2CHARS( 0x01FFFFF0 ), LONG2CHARS( 0x01FFFFF8 ), LONG2CHARS( 0x01FFFFFC ),
      LONG2CHARS( 0x01FFFFFE ), LONG2CHARS( 0x01FFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00800000 ), LONG2CHARS( 0x00C00000 ), LONG2CHARS( 0x00E00000 ),
      LONG2CHARS( 0x00F00000 ), LONG2CHARS( 0x00F80000 ), LONG2CHARS( 0x00FC0000 ), LONG2CHARS( 0x00FE0000 ),
      LONG2CHARS( 0x00FF0000 ), LONG2CHARS( 0x00FF8000 ), LONG2CHARS( 0x00FFC000 ), LONG2CHARS( 0x00FFE000 ),
      LONG2CHARS( 0x00FFF000 ), LONG2CHARS( 0x00FFF800 ), LONG2CHARS( 0x00FFFC00 ), LONG2CHARS( 0x00FFFE00 ),
      LONG2CHARS( 0x00FFFF00 ), LONG2CHARS( 0x00FFFF80 ), LONG2CHARS( 0x00FFFFC0 ), LONG2CHARS( 0x00FFFFE0 ),
      LONG2CHARS( 0x00FFFFF0 ), LONG2CHARS( 0x00FFFFF8 ), LONG2CHARS( 0x00FFFFFC ), LONG2CHARS( 0x00FFFFFE ),
      LONG2CHARS( 0x00FFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00400000 ), LONG2CHARS( 0x00600000 ), LONG2CHARS( 0x00700000 ),
      LONG2CHARS( 0x00780000 ), LONG2CHARS( 0x007C0000 ), LONG2CHARS( 0x007E0000 ), LONG2CHARS( 0x007F0000 ),
      LONG2CHARS( 0x007F8000 ), LONG2CHARS( 0x007FC000 ), LONG2CHARS( 0x007FE000 ), LONG2CHARS( 0x007FF000 ),
      LONG2CHARS( 0x007FF800 ), LONG2CHARS( 0x007FFC00 ), LONG2CHARS( 0x007FFE00 ), LONG2CHARS( 0x007FFF00 ),
      LONG2CHARS( 0x007FFF80 ), LONG2CHARS( 0x007FFFC0 ), LONG2CHARS( 0x007FFFE0 ), LONG2CHARS( 0x007FFFF0 ),
      LONG2CHARS( 0x007FFFF8 ), LONG2CHARS( 0x007FFFFC ), LONG2CHARS( 0x007FFFFE ), LONG2CHARS( 0x007FFFFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00200000 ), LONG2CHARS( 0x00300000 ), LONG2CHARS( 0x00380000 ),
      LONG2CHARS( 0x003C0000 ), LONG2CHARS( 0x003E0000 ), LONG2CHARS( 0x003F0000 ), LONG2CHARS( 0x003F8000 ),
      LONG2CHARS( 0x003FC000 ), LONG2CHARS( 0x003FE000 ), LONG2CHARS( 0x003FF000 ), LONG2CHARS( 0x003FF800 ),
      LONG2CHARS( 0x003FFC00 ), LONG2CHARS( 0x003FFE00 ), LONG2CHARS( 0x003FFF00 ), LONG2CHARS( 0x003FFF80 ),
      LONG2CHARS( 0x003FFFC0 ), LONG2CHARS( 0x003FFFE0 ), LONG2CHARS( 0x003FFFF0 ), LONG2CHARS( 0x003FFFF8 ),
      LONG2CHARS( 0x003FFFFC ), LONG2CHARS( 0x003FFFFE ), LONG2CHARS( 0x003FFFFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00100000 ), LONG2CHARS( 0x00180000 ), LONG2CHARS( 0x001C0000 ),
      LONG2CHARS( 0x001E0000 ), LONG2CHARS( 0x001F0000 ), LONG2CHARS( 0x001F8000 ), LONG2CHARS( 0x001FC000 ),
      LONG2CHARS( 0x001FE000 ), LONG2CHARS( 0x001FF000 ), LONG2CHARS( 0x001FF800 ), LONG2CHARS( 0x001FFC00 ),
      LONG2CHARS( 0x001FFE00 ), LONG2CHARS( 0x001FFF00 ), LONG2CHARS( 0x001FFF80 ), LONG2CHARS( 0x001FFFC0 ),
      LONG2CHARS( 0x001FFFE0 ), LONG2CHARS( 0x001FFFF0 ), LONG2CHARS( 0x001FFFF8 ), LONG2CHARS( 0x001FFFFC ),
      LONG2CHARS( 0x001FFFFE ), LONG2CHARS( 0x001FFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00080000 ), LONG2CHARS( 0x000C0000 ), LONG2CHARS( 0x000E0000 ),
      LONG2CHARS( 0x000F0000 ), LONG2CHARS( 0x000F8000 ), LONG2CHARS( 0x000FC000 ), LONG2CHARS( 0x000FE000 ),
      LONG2CHARS( 0x000FF000 ), LONG2CHARS( 0x000FF800 ), LONG2CHARS( 0x000FFC00 ), LONG2CHARS( 0x000FFE00 ),
      LONG2CHARS( 0x000FFF00 ), LONG2CHARS( 0x000FFF80 ), LONG2CHARS( 0x000FFFC0 ), LONG2CHARS( 0x000FFFE0 ),
      LONG2CHARS( 0x000FFFF0 ), LONG2CHARS( 0x000FFFF8 ), LONG2CHARS( 0x000FFFFC ), LONG2CHARS( 0x000FFFFE ),
      LONG2CHARS( 0x000FFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00040000 ), LONG2CHARS( 0x00060000 ), LONG2CHARS( 0x00070000 ),
      LONG2CHARS( 0x00078000 ), LONG2CHARS( 0x0007C000 ), LONG2CHARS( 0x0007E000 ), LONG2CHARS( 0x0007F000 ),
      LONG2CHARS( 0x0007F800 ), LONG2CHARS( 0x0007FC00 ), LONG2CHARS( 0x0007FE00 ), LONG2CHARS( 0x0007FF00 ),
      LONG2CHARS( 0x0007FF80 ), LONG2CHARS( 0x0007FFC0 ), LONG2CHARS( 0x0007FFE0 ), LONG2CHARS( 0x0007FFF0 ),
      LONG2CHARS( 0x0007FFF8 ), LONG2CHARS( 0x0007FFFC ), LONG2CHARS( 0x0007FFFE ), LONG2CHARS( 0x0007FFFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00020000 ), LONG2CHARS( 0x00030000 ), LONG2CHARS( 0x00038000 ),
      LONG2CHARS( 0x0003C000 ), LONG2CHARS( 0x0003E000 ), LONG2CHARS( 0x0003F000 ), LONG2CHARS( 0x0003F800 ),
      LONG2CHARS( 0x0003FC00 ), LONG2CHARS( 0x0003FE00 ), LONG2CHARS( 0x0003FF00 ), LONG2CHARS( 0x0003FF80 ),
      LONG2CHARS( 0x0003FFC0 ), LONG2CHARS( 0x0003FFE0 ), LONG2CHARS( 0x0003FFF0 ), LONG2CHARS( 0x0003FFF8 ),
      LONG2CHARS( 0x0003FFFC ), LONG2CHARS( 0x0003FFFE ), LONG2CHARS( 0x0003FFFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00010000 ), LONG2CHARS( 0x00018000 ), LONG2CHARS( 0x0001C000 ),
      LONG2CHARS( 0x0001E000 ), LONG2CHARS( 0x0001F000 ), LONG2CHARS( 0x0001F800 ), LONG2CHARS( 0x0001FC00 ),
      LONG2CHARS( 0x0001FE00 ), LONG2CHARS( 0x0001FF00 ), LONG2CHARS( 0x0001FF80 ), LONG2CHARS( 0x0001FFC0 ),
      LONG2CHARS( 0x0001FFE0 ), LONG2CHARS( 0x0001FFF0 ), LONG2CHARS( 0x0001FFF8 ), LONG2CHARS( 0x0001FFFC ),
      LONG2CHARS( 0x0001FFFE ), LONG2CHARS( 0x0001FFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00008000 ), LONG2CHARS( 0x0000C000 ), LONG2CHARS( 0x0000E000 ),
      LONG2CHARS( 0x0000F000 ), LONG2CHARS( 0x0000F800 ), LONG2CHARS( 0x0000FC00 ), LONG2CHARS( 0x0000FE00 ),
      LONG2CHARS( 0x0000FF00 ), LONG2CHARS( 0x0000FF80 ), LONG2CHARS( 0x0000FFC0 ), LONG2CHARS( 0x0000FFE0 ),
      LONG2CHARS( 0x0000FFF0 ), LONG2CHARS( 0x0000FFF8 ), LONG2CHARS( 0x0000FFFC ), LONG2CHARS( 0x0000FFFE ),
      LONG2CHARS( 0x0000FFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00004000 ), LONG2CHARS( 0x00006000 ), LONG2CHARS( 0x00007000 ),
      LONG2CHARS( 0x00007800 ), LONG2CHARS( 0x00007C00 ), LONG2CHARS( 0x00007E00 ), LONG2CHARS( 0x00007F00 ),
      LONG2CHARS( 0x00007F80 ), LONG2CHARS( 0x00007FC0 ), LONG2CHARS( 0x00007FE0 ), LONG2CHARS( 0x00007FF0 ),
      LONG2CHARS( 0x00007FF8 ), LONG2CHARS( 0x00007FFC ), LONG2CHARS( 0x00007FFE ), LONG2CHARS( 0x00007FFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00002000 ), LONG2CHARS( 0x00003000 ), LONG2CHARS( 0x00003800 ),
      LONG2CHARS( 0x00003C00 ), LONG2CHARS( 0x00003E00 ), LONG2CHARS( 0x00003F00 ), LONG2CHARS( 0x00003F80 ),
      LONG2CHARS( 0x00003FC0 ), LONG2CHARS( 0x00003FE0 ), LONG2CHARS( 0x00003FF0 ), LONG2CHARS( 0x00003FF8 ),
      LONG2CHARS( 0x00003FFC ), LONG2CHARS( 0x00003FFE ), LONG2CHARS( 0x00003FFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00001000 ), LONG2CHARS( 0x00001800 ), LONG2CHARS( 0x00001C00 ),
      LONG2CHARS( 0x00001E00 ), LONG2CHARS( 0x00001F00 ), LONG2CHARS( 0x00001F80 ), LONG2CHARS( 0x00001FC0 ),
      LONG2CHARS( 0x00001FE0 ), LONG2CHARS( 0x00001FF0 ), LONG2CHARS( 0x00001FF8 ), LONG2CHARS( 0x00001FFC ),
      LONG2CHARS( 0x00001FFE ), LONG2CHARS( 0x00001FFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000800 ), LONG2CHARS( 0x00000C00 ), LONG2CHARS( 0x00000E00 ),
      LONG2CHARS( 0x00000F00 ), LONG2CHARS( 0x00000F80 ), LONG2CHARS( 0x00000FC0 ), LONG2CHARS( 0x00000FE0 ),
      LONG2CHARS( 0x00000FF0 ), LONG2CHARS( 0x00000FF8 ), LONG2CHARS( 0x00000FFC ), LONG2CHARS( 0x00000FFE ),
      LONG2CHARS( 0x00000FFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000400 ), LONG2CHARS( 0x00000600 ), LONG2CHARS( 0x00000700 ),
      LONG2CHARS( 0x00000780 ), LONG2CHARS( 0x000007C0 ), LONG2CHARS( 0x000007E0 ), LONG2CHARS( 0x000007F0 ),
      LONG2CHARS( 0x000007F8 ), LONG2CHARS( 0x000007FC ), LONG2CHARS( 0x000007FE ), LONG2CHARS( 0x000007FF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000200 ), LONG2CHARS( 0x00000300 ), LONG2CHARS( 0x00000380 ),
      LONG2CHARS( 0x000003C0 ), LONG2CHARS( 0x000003E0 ), LONG2CHARS( 0x000003F0 ), LONG2CHARS( 0x000003F8 ),
      LONG2CHARS( 0x000003FC ), LONG2CHARS( 0x000003FE ), LONG2CHARS( 0x000003FF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000100 ), LONG2CHARS( 0x00000180 ), LONG2CHARS( 0x000001C0 ),
      LONG2CHARS( 0x000001E0 ), LONG2CHARS( 0x000001F0 ), LONG2CHARS( 0x000001F8 ), LONG2CHARS( 0x000001FC ),
      LONG2CHARS( 0x000001FE ), LONG2CHARS( 0x000001FF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000080 ), LONG2CHARS( 0x000000C0 ), LONG2CHARS( 0x000000E0 ),
      LONG2CHARS( 0x000000F0 ), LONG2CHARS( 0x000000F8 ), LONG2CHARS( 0x000000FC ), LONG2CHARS( 0x000000FE ),
      LONG2CHARS( 0x000000FF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000040 ), LONG2CHARS( 0x00000060 ), LONG2CHARS( 0x00000070 ),
      LONG2CHARS( 0x00000078 ), LONG2CHARS( 0x0000007C ), LONG2CHARS( 0x0000007E ), LONG2CHARS( 0x0000007F ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000020 ), LONG2CHARS( 0x00000030 ), LONG2CHARS( 0x00000038 ),
      LONG2CHARS( 0x0000003C ), LONG2CHARS( 0x0000003E ), LONG2CHARS( 0x0000003F ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000010 ), LONG2CHARS( 0x00000018 ), LONG2CHARS( 0x0000001C ),
      LONG2CHARS( 0x0000001E ), LONG2CHARS( 0x0000001F ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000008 ), LONG2CHARS( 0x0000000C ), LONG2CHARS( 0x0000000E ),
      LONG2CHARS( 0x0000000F ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000004 ), LONG2CHARS( 0x00000006 ), LONG2CHARS( 0x00000007 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000002 ), LONG2CHARS( 0x00000003 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000001 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
};

#else		/* LSBFirst */
/* NOTE:
the first element in starttab could be LONG2CHARS( 0xffffffff.  making it 0
lets us deal with a full first word in the middle loop ), rather
than having to do the multiple reads and masks that we'd
have to do if we thought it was partial.
*/
int starttab[32] = 
	{
	LONG2CHARS( 0x00000000 ),
	LONG2CHARS( 0xFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0x80000000 )
	};

int endtab[32] = 
	{
	LONG2CHARS( 0x00000000 ),
	LONG2CHARS( 0x00000001 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x7FFFFFFF )
	};

#ifdef NEED_OLD_MFB_MASKS
/* a hack ), for now, since the entries for 0 need to be all
   1 bits ), not all zeros.
   this means the code DOES NOT WORK for segments of length
   0 (which is only a problem in the horizontal line code.)
*/
int startpartial[32] = 
	{
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0xFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0x80000000 )
	};

int endpartial[32] = 
	{
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0x00000001 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x7FFFFFFF )
	};
#endif

unsigned int partmasks[32][32] = {
     {LONG2CHARS( 0xFFFFFFFF ), LONG2CHARS( 0x00000001 ), LONG2CHARS( 0x00000003 ), LONG2CHARS( 0x00000007 ),
      LONG2CHARS( 0x0000000F ), LONG2CHARS( 0x0000001F ), LONG2CHARS( 0x0000003F ), LONG2CHARS( 0x0000007F ),
      LONG2CHARS( 0x000000FF ), LONG2CHARS( 0x000001FF ), LONG2CHARS( 0x000003FF ), LONG2CHARS( 0x000007FF ),
      LONG2CHARS( 0x00000FFF ), LONG2CHARS( 0x00001FFF ), LONG2CHARS( 0x00003FFF ), LONG2CHARS( 0x00007FFF ),
      LONG2CHARS( 0x0000FFFF ), LONG2CHARS( 0x0001FFFF ), LONG2CHARS( 0x0003FFFF ), LONG2CHARS( 0x0007FFFF ),
      LONG2CHARS( 0x000FFFFF ), LONG2CHARS( 0x001FFFFF ), LONG2CHARS( 0x003FFFFF ), LONG2CHARS( 0x007FFFFF ),
      LONG2CHARS( 0x00FFFFFF ), LONG2CHARS( 0x01FFFFFF ), LONG2CHARS( 0x03FFFFFF ), LONG2CHARS( 0x07FFFFFF ),
      LONG2CHARS( 0x0FFFFFFF ), LONG2CHARS( 0x1FFFFFFF ), LONG2CHARS( 0x3FFFFFFF ), LONG2CHARS( 0x7FFFFFFF )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000002 ), LONG2CHARS( 0x00000006 ), LONG2CHARS( 0x0000000E ),
      LONG2CHARS( 0x0000001E ), LONG2CHARS( 0x0000003E ), LONG2CHARS( 0x0000007E ), LONG2CHARS( 0x000000FE ),
      LONG2CHARS( 0x000001FE ), LONG2CHARS( 0x000003FE ), LONG2CHARS( 0x000007FE ), LONG2CHARS( 0x00000FFE ),
      LONG2CHARS( 0x00001FFE ), LONG2CHARS( 0x00003FFE ), LONG2CHARS( 0x00007FFE ), LONG2CHARS( 0x0000FFFE ),
      LONG2CHARS( 0x0001FFFE ), LONG2CHARS( 0x0003FFFE ), LONG2CHARS( 0x0007FFFE ), LONG2CHARS( 0x000FFFFE ),
      LONG2CHARS( 0x001FFFFE ), LONG2CHARS( 0x003FFFFE ), LONG2CHARS( 0x007FFFFE ), LONG2CHARS( 0x00FFFFFE ),
      LONG2CHARS( 0x01FFFFFE ), LONG2CHARS( 0x03FFFFFE ), LONG2CHARS( 0x07FFFFFE ), LONG2CHARS( 0x0FFFFFFE ),
      LONG2CHARS( 0x1FFFFFFE ), LONG2CHARS( 0x3FFFFFFE ), LONG2CHARS( 0x7FFFFFFE ), LONG2CHARS( 0xFFFFFFFE )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000004 ), LONG2CHARS( 0x0000000C ), LONG2CHARS( 0x0000001C ),
      LONG2CHARS( 0x0000003C ), LONG2CHARS( 0x0000007C ), LONG2CHARS( 0x000000FC ), LONG2CHARS( 0x000001FC ),
      LONG2CHARS( 0x000003FC ), LONG2CHARS( 0x000007FC ), LONG2CHARS( 0x00000FFC ), LONG2CHARS( 0x00001FFC ),
      LONG2CHARS( 0x00003FFC ), LONG2CHARS( 0x00007FFC ), LONG2CHARS( 0x0000FFFC ), LONG2CHARS( 0x0001FFFC ),
      LONG2CHARS( 0x0003FFFC ), LONG2CHARS( 0x0007FFFC ), LONG2CHARS( 0x000FFFFC ), LONG2CHARS( 0x001FFFFC ),
      LONG2CHARS( 0x003FFFFC ), LONG2CHARS( 0x007FFFFC ), LONG2CHARS( 0x00FFFFFC ), LONG2CHARS( 0x01FFFFFC ),
      LONG2CHARS( 0x03FFFFFC ), LONG2CHARS( 0x07FFFFFC ), LONG2CHARS( 0x0FFFFFFC ), LONG2CHARS( 0x1FFFFFFC ),
      LONG2CHARS( 0x3FFFFFFC ), LONG2CHARS( 0x7FFFFFFC ), LONG2CHARS( 0xFFFFFFFC ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000008 ), LONG2CHARS( 0x00000018 ), LONG2CHARS( 0x00000038 ),
      LONG2CHARS( 0x00000078 ), LONG2CHARS( 0x000000F8 ), LONG2CHARS( 0x000001F8 ), LONG2CHARS( 0x000003F8 ),
      LONG2CHARS( 0x000007F8 ), LONG2CHARS( 0x00000FF8 ), LONG2CHARS( 0x00001FF8 ), LONG2CHARS( 0x00003FF8 ),
      LONG2CHARS( 0X00007FF8 ), LONG2CHARS( 0x0000FFF8 ), LONG2CHARS( 0x0001FFF8 ), LONG2CHARS( 0x0003FFF8 ),
      LONG2CHARS( 0X0007FFF8 ), LONG2CHARS( 0x000FFFF8 ), LONG2CHARS( 0x001FFFF8 ), LONG2CHARS( 0x003FFFF8 ),
      LONG2CHARS( 0X007FFFF8 ), LONG2CHARS( 0x00FFFFF8 ), LONG2CHARS( 0x01FFFFF8 ), LONG2CHARS( 0x03FFFFF8 ),
      LONG2CHARS( 0X07FFFFF8 ), LONG2CHARS( 0x0FFFFFF8 ), LONG2CHARS( 0x1FFFFFF8 ), LONG2CHARS( 0x3FFFFFF8 ),
      LONG2CHARS( 0X7FFFFFF8 ), LONG2CHARS( 0xFFFFFFF8 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000010 ), LONG2CHARS( 0x00000030 ), LONG2CHARS( 0x00000070 ),
      LONG2CHARS( 0X000000F0 ), LONG2CHARS( 0x000001F0 ), LONG2CHARS( 0x000003F0 ), LONG2CHARS( 0x000007F0 ),
      LONG2CHARS( 0X00000FF0 ), LONG2CHARS( 0x00001FF0 ), LONG2CHARS( 0x00003FF0 ), LONG2CHARS( 0x00007FF0 ),
      LONG2CHARS( 0X0000FFF0 ), LONG2CHARS( 0x0001FFF0 ), LONG2CHARS( 0x0003FFF0 ), LONG2CHARS( 0x0007FFF0 ),
      LONG2CHARS( 0X000FFFF0 ), LONG2CHARS( 0x001FFFF0 ), LONG2CHARS( 0x003FFFF0 ), LONG2CHARS( 0x007FFFF0 ),
      LONG2CHARS( 0X00FFFFF0 ), LONG2CHARS( 0x01FFFFF0 ), LONG2CHARS( 0x03FFFFF0 ), LONG2CHARS( 0x07FFFFF0 ),
      LONG2CHARS( 0X0FFFFFF0 ), LONG2CHARS( 0x1FFFFFF0 ), LONG2CHARS( 0x3FFFFFF0 ), LONG2CHARS( 0x7FFFFFF0 ),
      LONG2CHARS( 0XFFFFFFF0 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000020 ), LONG2CHARS( 0x00000060 ), LONG2CHARS( 0x000000E0 ),
      LONG2CHARS( 0X000001E0 ), LONG2CHARS( 0x000003E0 ), LONG2CHARS( 0x000007E0 ), LONG2CHARS( 0x00000FE0 ),
      LONG2CHARS( 0X00001FE0 ), LONG2CHARS( 0x00003FE0 ), LONG2CHARS( 0x00007FE0 ), LONG2CHARS( 0x0000FFE0 ),
      LONG2CHARS( 0X0001FFE0 ), LONG2CHARS( 0x0003FFE0 ), LONG2CHARS( 0x0007FFE0 ), LONG2CHARS( 0x000FFFE0 ),
      LONG2CHARS( 0X001FFFE0 ), LONG2CHARS( 0x003FFFE0 ), LONG2CHARS( 0x007FFFE0 ), LONG2CHARS( 0x00FFFFE0 ),
      LONG2CHARS( 0X01FFFFE0 ), LONG2CHARS( 0x03FFFFE0 ), LONG2CHARS( 0x07FFFFE0 ), LONG2CHARS( 0x0FFFFFE0 ),
      LONG2CHARS( 0X1FFFFFE0 ), LONG2CHARS( 0x3FFFFFE0 ), LONG2CHARS( 0x7FFFFFE0 ), LONG2CHARS( 0xFFFFFFE0 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000040 ), LONG2CHARS( 0x000000C0 ), LONG2CHARS( 0x000001C0 ),
      LONG2CHARS( 0X000003C0 ), LONG2CHARS( 0x000007C0 ), LONG2CHARS( 0x00000FC0 ), LONG2CHARS( 0x00001FC0 ),
      LONG2CHARS( 0X00003FC0 ), LONG2CHARS( 0x00007FC0 ), LONG2CHARS( 0x0000FFC0 ), LONG2CHARS( 0x0001FFC0 ),
      LONG2CHARS( 0X0003FFC0 ), LONG2CHARS( 0x0007FFC0 ), LONG2CHARS( 0x000FFFC0 ), LONG2CHARS( 0x001FFFC0 ),
      LONG2CHARS( 0X003FFFC0 ), LONG2CHARS( 0x007FFFC0 ), LONG2CHARS( 0x00FFFFC0 ), LONG2CHARS( 0x01FFFFC0 ),
      LONG2CHARS( 0X03FFFFC0 ), LONG2CHARS( 0x07FFFFC0 ), LONG2CHARS( 0x0FFFFFC0 ), LONG2CHARS( 0x1FFFFFC0 ),
      LONG2CHARS( 0X3FFFFFC0 ), LONG2CHARS( 0x7FFFFFC0 ), LONG2CHARS( 0xFFFFFFC0 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000080 ), LONG2CHARS( 0x00000180 ), LONG2CHARS( 0x00000380 ),
      LONG2CHARS( 0X00000780 ), LONG2CHARS( 0x00000F80 ), LONG2CHARS( 0x00001F80 ), LONG2CHARS( 0x00003F80 ),
      LONG2CHARS( 0X00007F80 ), LONG2CHARS( 0x0000FF80 ), LONG2CHARS( 0x0001FF80 ), LONG2CHARS( 0x0003FF80 ),
      LONG2CHARS( 0X0007FF80 ), LONG2CHARS( 0x000FFF80 ), LONG2CHARS( 0x001FFF80 ), LONG2CHARS( 0x003FFF80 ),
      LONG2CHARS( 0X007FFF80 ), LONG2CHARS( 0x00FFFF80 ), LONG2CHARS( 0x01FFFF80 ), LONG2CHARS( 0x03FFFF80 ),
      LONG2CHARS( 0X07FFFF80 ), LONG2CHARS( 0x0FFFFF80 ), LONG2CHARS( 0x1FFFFF80 ), LONG2CHARS( 0x3FFFFF80 ),
      LONG2CHARS( 0X7FFFFF80 ), LONG2CHARS( 0xFFFFFF80 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000100 ), LONG2CHARS( 0x00000300 ), LONG2CHARS( 0x00000700 ),
      LONG2CHARS( 0X00000F00 ), LONG2CHARS( 0x00001F00 ), LONG2CHARS( 0x00003F00 ), LONG2CHARS( 0x00007F00 ),
      LONG2CHARS( 0X0000FF00 ), LONG2CHARS( 0x0001FF00 ), LONG2CHARS( 0x0003FF00 ), LONG2CHARS( 0x0007FF00 ),
      LONG2CHARS( 0X000FFF00 ), LONG2CHARS( 0x001FFF00 ), LONG2CHARS( 0x003FFF00 ), LONG2CHARS( 0x007FFF00 ),
      LONG2CHARS( 0X00FFFF00 ), LONG2CHARS( 0x01FFFF00 ), LONG2CHARS( 0x03FFFF00 ), LONG2CHARS( 0x07FFFF00 ),
      LONG2CHARS( 0X0FFFFF00 ), LONG2CHARS( 0x1FFFFF00 ), LONG2CHARS( 0x3FFFFF00 ), LONG2CHARS( 0x7FFFFF00 ),
      LONG2CHARS( 0XFFFFFF00 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000200 ), LONG2CHARS( 0x00000600 ), LONG2CHARS( 0x00000E00 ),
      LONG2CHARS( 0X00001E00 ), LONG2CHARS( 0x00003E00 ), LONG2CHARS( 0x00007E00 ), LONG2CHARS( 0x0000FE00 ),
      LONG2CHARS( 0X0001FE00 ), LONG2CHARS( 0x0003FE00 ), LONG2CHARS( 0x0007FE00 ), LONG2CHARS( 0x000FFE00 ),
      LONG2CHARS( 0X001FFE00 ), LONG2CHARS( 0x003FFE00 ), LONG2CHARS( 0x007FFE00 ), LONG2CHARS( 0x00FFFE00 ),
      LONG2CHARS( 0X01FFFE00 ), LONG2CHARS( 0x03FFFE00 ), LONG2CHARS( 0x07FFFE00 ), LONG2CHARS( 0x0FFFFE00 ),
      LONG2CHARS( 0X1FFFFE00 ), LONG2CHARS( 0x3FFFFE00 ), LONG2CHARS( 0x7FFFFE00 ), LONG2CHARS( 0xFFFFFE00 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000400 ), LONG2CHARS( 0x00000C00 ), LONG2CHARS( 0x00001C00 ),
      LONG2CHARS( 0X00003C00 ), LONG2CHARS( 0x00007C00 ), LONG2CHARS( 0x0000FC00 ), LONG2CHARS( 0x0001FC00 ),
      LONG2CHARS( 0X0003FC00 ), LONG2CHARS( 0x0007FC00 ), LONG2CHARS( 0x000FFC00 ), LONG2CHARS( 0x001FFC00 ),
      LONG2CHARS( 0X003FFC00 ), LONG2CHARS( 0x007FFC00 ), LONG2CHARS( 0x00FFFC00 ), LONG2CHARS( 0x01FFFC00 ),
      LONG2CHARS( 0X03FFFC00 ), LONG2CHARS( 0x07FFFC00 ), LONG2CHARS( 0x0FFFFC00 ), LONG2CHARS( 0x1FFFFC00 ),
      LONG2CHARS( 0X3FFFFC00 ), LONG2CHARS( 0x7FFFFC00 ), LONG2CHARS( 0xFFFFFC00 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000800 ), LONG2CHARS( 0x00001800 ), LONG2CHARS( 0x00003800 ),
      LONG2CHARS( 0X00007800 ), LONG2CHARS( 0x0000F800 ), LONG2CHARS( 0x0001F800 ), LONG2CHARS( 0x0003F800 ),
      LONG2CHARS( 0X0007F800 ), LONG2CHARS( 0x000FF800 ), LONG2CHARS( 0x001FF800 ), LONG2CHARS( 0x003FF800 ),
      LONG2CHARS( 0X007FF800 ), LONG2CHARS( 0x00FFF800 ), LONG2CHARS( 0x01FFF800 ), LONG2CHARS( 0x03FFF800 ),
      LONG2CHARS( 0X07FFF800 ), LONG2CHARS( 0x0FFFF800 ), LONG2CHARS( 0x1FFFF800 ), LONG2CHARS( 0x3FFFF800 ),
      LONG2CHARS( 0X7FFFF800 ), LONG2CHARS( 0xFFFFF800 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00001000 ), LONG2CHARS( 0x00003000 ), LONG2CHARS( 0x00007000 ),
      LONG2CHARS( 0X0000F000 ), LONG2CHARS( 0x0001F000 ), LONG2CHARS( 0x0003F000 ), LONG2CHARS( 0x0007F000 ),
      LONG2CHARS( 0X000FF000 ), LONG2CHARS( 0x001FF000 ), LONG2CHARS( 0x003FF000 ), LONG2CHARS( 0x007FF000 ),
      LONG2CHARS( 0X00FFF000 ), LONG2CHARS( 0x01FFF000 ), LONG2CHARS( 0x03FFF000 ), LONG2CHARS( 0x07FFF000 ),
      LONG2CHARS( 0X0FFFF000 ), LONG2CHARS( 0x1FFFF000 ), LONG2CHARS( 0x3FFFF000 ), LONG2CHARS( 0x7FFFF000 ),
      LONG2CHARS( 0XFFFFF000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00002000 ), LONG2CHARS( 0x00006000 ), LONG2CHARS( 0x0000E000 ),
      LONG2CHARS( 0X0001E000 ), LONG2CHARS( 0x0003E000 ), LONG2CHARS( 0x0007E000 ), LONG2CHARS( 0x000FE000 ),
      LONG2CHARS( 0X001FE000 ), LONG2CHARS( 0x003FE000 ), LONG2CHARS( 0x007FE000 ), LONG2CHARS( 0x00FFE000 ),
      LONG2CHARS( 0X01FFE000 ), LONG2CHARS( 0x03FFE000 ), LONG2CHARS( 0x07FFE000 ), LONG2CHARS( 0x0FFFE000 ),
      LONG2CHARS( 0X1FFFE000 ), LONG2CHARS( 0x3FFFE000 ), LONG2CHARS( 0x7FFFE000 ), LONG2CHARS( 0xFFFFE000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00004000 ), LONG2CHARS( 0x0000C000 ), LONG2CHARS( 0x0001C000 ),
      LONG2CHARS( 0X0003C000 ), LONG2CHARS( 0x0007C000 ), LONG2CHARS( 0x000FC000 ), LONG2CHARS( 0x001FC000 ),
      LONG2CHARS( 0X003FC000 ), LONG2CHARS( 0x007FC000 ), LONG2CHARS( 0x00FFC000 ), LONG2CHARS( 0x01FFC000 ),
      LONG2CHARS( 0X03FFC000 ), LONG2CHARS( 0x07FFC000 ), LONG2CHARS( 0x0FFFC000 ), LONG2CHARS( 0x1FFFC000 ),
      LONG2CHARS( 0X3FFFC000 ), LONG2CHARS( 0x7FFFC000 ), LONG2CHARS( 0xFFFFC000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00008000 ), LONG2CHARS( 0x00018000 ), LONG2CHARS( 0x00038000 ),
      LONG2CHARS( 0X00078000 ), LONG2CHARS( 0x000F8000 ), LONG2CHARS( 0x001F8000 ), LONG2CHARS( 0x003F8000 ),
      LONG2CHARS( 0X007F8000 ), LONG2CHARS( 0x00FF8000 ), LONG2CHARS( 0x01FF8000 ), LONG2CHARS( 0x03FF8000 ),
      LONG2CHARS( 0X07FF8000 ), LONG2CHARS( 0x0FFF8000 ), LONG2CHARS( 0x1FFF8000 ), LONG2CHARS( 0x3FFF8000 ),
      LONG2CHARS( 0X7FFF8000 ), LONG2CHARS( 0xFFFF8000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00010000 ), LONG2CHARS( 0x00030000 ), LONG2CHARS( 0x00070000 ),
      LONG2CHARS( 0X000F0000 ), LONG2CHARS( 0x001F0000 ), LONG2CHARS( 0x003F0000 ), LONG2CHARS( 0x007F0000 ),
      LONG2CHARS( 0X00FF0000 ), LONG2CHARS( 0x01FF0000 ), LONG2CHARS( 0x03FF0000 ), LONG2CHARS( 0x07FF0000 ),
      LONG2CHARS( 0X0FFF0000 ), LONG2CHARS( 0x1FFF0000 ), LONG2CHARS( 0x3FFF0000 ), LONG2CHARS( 0x7FFF0000 ),
      LONG2CHARS( 0XFFFF0000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00020000 ), LONG2CHARS( 0x00060000 ), LONG2CHARS( 0x000E0000 ),
      LONG2CHARS( 0X001E0000 ), LONG2CHARS( 0x003E0000 ), LONG2CHARS( 0x007E0000 ), LONG2CHARS( 0x00FE0000 ),
      LONG2CHARS( 0X01FE0000 ), LONG2CHARS( 0x03FE0000 ), LONG2CHARS( 0x07FE0000 ), LONG2CHARS( 0x0FFE0000 ),
      LONG2CHARS( 0X1FFE0000 ), LONG2CHARS( 0x3FFE0000 ), LONG2CHARS( 0x7FFE0000 ), LONG2CHARS( 0xFFFE0000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00040000 ), LONG2CHARS( 0x000C0000 ), LONG2CHARS( 0x001C0000 ),
      LONG2CHARS( 0X003C0000 ), LONG2CHARS( 0x007C0000 ), LONG2CHARS( 0x00FC0000 ), LONG2CHARS( 0x01FC0000 ),
      LONG2CHARS( 0X03FC0000 ), LONG2CHARS( 0x07FC0000 ), LONG2CHARS( 0x0FFC0000 ), LONG2CHARS( 0x1FFC0000 ),
      LONG2CHARS( 0X3FFC0000 ), LONG2CHARS( 0x7FFC0000 ), LONG2CHARS( 0xFFFC0000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00080000 ), LONG2CHARS( 0x00180000 ), LONG2CHARS( 0x00380000 ),
      LONG2CHARS( 0X00780000 ), LONG2CHARS( 0x00F80000 ), LONG2CHARS( 0x01F80000 ), LONG2CHARS( 0x03F80000 ),
      LONG2CHARS( 0X07F80000 ), LONG2CHARS( 0x0FF80000 ), LONG2CHARS( 0x1FF80000 ), LONG2CHARS( 0x3FF80000 ),
      LONG2CHARS( 0X7FF80000 ), LONG2CHARS( 0xFFF80000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00100000 ), LONG2CHARS( 0x00300000 ), LONG2CHARS( 0x00700000 ),
      LONG2CHARS( 0X00F00000 ), LONG2CHARS( 0x01F00000 ), LONG2CHARS( 0x03F00000 ), LONG2CHARS( 0x07F00000 ),
      LONG2CHARS( 0X0FF00000 ), LONG2CHARS( 0x1FF00000 ), LONG2CHARS( 0x3FF00000 ), LONG2CHARS( 0x7FF00000 ),
      LONG2CHARS( 0XFFF00000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00200000 ), LONG2CHARS( 0x00600000 ), LONG2CHARS( 0x00E00000 ),
      LONG2CHARS( 0X01E00000 ), LONG2CHARS( 0x03E00000 ), LONG2CHARS( 0x07E00000 ), LONG2CHARS( 0x0FE00000 ),
      LONG2CHARS( 0X1FE00000 ), LONG2CHARS( 0x3FE00000 ), LONG2CHARS( 0x7FE00000 ), LONG2CHARS( 0xFFE00000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00400000 ), LONG2CHARS( 0x00C00000 ), LONG2CHARS( 0x01C00000 ),
      LONG2CHARS( 0X03C00000 ), LONG2CHARS( 0x07C00000 ), LONG2CHARS( 0x0FC00000 ), LONG2CHARS( 0x1FC00000 ),
      LONG2CHARS( 0X3FC00000 ), LONG2CHARS( 0x7FC00000 ), LONG2CHARS( 0xFFC00000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00800000 ), LONG2CHARS( 0x01800000 ), LONG2CHARS( 0x03800000 ),
      LONG2CHARS( 0X07800000 ), LONG2CHARS( 0x0F800000 ), LONG2CHARS( 0x1F800000 ), LONG2CHARS( 0x3F800000 ),
      LONG2CHARS( 0X7F800000 ), LONG2CHARS( 0xFF800000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x01000000 ), LONG2CHARS( 0x03000000 ), LONG2CHARS( 0x07000000 ),
      LONG2CHARS( 0X0F000000 ), LONG2CHARS( 0x1F000000 ), LONG2CHARS( 0x3F000000 ), LONG2CHARS( 0x7F000000 ),
      LONG2CHARS( 0XFF000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x02000000 ), LONG2CHARS( 0x06000000 ), LONG2CHARS( 0x0E000000 ),
      LONG2CHARS( 0X1E000000 ), LONG2CHARS( 0x3E000000 ), LONG2CHARS( 0x7E000000 ), LONG2CHARS( 0xFE000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x04000000 ), LONG2CHARS( 0x0C000000 ), LONG2CHARS( 0x1C000000 ),
      LONG2CHARS( 0X3C000000 ), LONG2CHARS( 0x7C000000 ), LONG2CHARS( 0xFC000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x08000000 ), LONG2CHARS( 0x18000000 ), LONG2CHARS( 0x38000000 ),
      LONG2CHARS( 0X78000000 ), LONG2CHARS( 0xF8000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x10000000 ), LONG2CHARS( 0x30000000 ), LONG2CHARS( 0x70000000 ),
      LONG2CHARS( 0XF0000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x20000000 ), LONG2CHARS( 0x60000000 ), LONG2CHARS( 0xE0000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x40000000 ), LONG2CHARS( 0xC0000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x80000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
};
#endif


/* used for masking bits in bresenham lines
   mask[n] is used to mask out all but bit n in a longword (n is a
screen position).
   rmask[n] is used to mask out the single bit at position n (n
is a screen posiotion.)
*/

#if (BITMAP_BIT_ORDER == MSBFirst)
int mask[] =
    {
    LONG2CHARS( 1<<31 ), LONG2CHARS( 1<<30 ), LONG2CHARS( 1<<29 ), 
    LONG2CHARS( 1<<28 ), LONG2CHARS( 1<<27 ), LONG2CHARS( 1<<26 ), 
    LONG2CHARS( 1<<25 ), LONG2CHARS( 1<<24 ), LONG2CHARS( 1<<23 ), 
    LONG2CHARS( 1<<22 ), LONG2CHARS( 1<<21 ), LONG2CHARS( 1<<20 ), 
    LONG2CHARS( 1<<19 ), LONG2CHARS( 1<<18 ), LONG2CHARS( 1<<17 ), 
    LONG2CHARS( 1<<16 ), LONG2CHARS( 1<<15 ), LONG2CHARS( 1<<14 ), 
    LONG2CHARS( 1<<13 ), LONG2CHARS( 1<<12 ), LONG2CHARS( 1<<11 ), 
    LONG2CHARS( 1<<10 ), LONG2CHARS( 1<<9 ), LONG2CHARS( 1<<8 ),
    LONG2CHARS( 1<<7 ), LONG2CHARS( 1<<6 ), LONG2CHARS( 1<<5 ), 
    LONG2CHARS( 1<<4 ), LONG2CHARS( 1<<3 ), LONG2CHARS( 1<<2 ), 
    LONG2CHARS( 1<<1 ), LONG2CHARS( 1<<0 )
    }; 
int rmask[] = 
    {
    0xffffffff ^ LONG2CHARS( 1<<31 ), 0xffffffff ^ LONG2CHARS( 1<<30 ), 
    0xffffffff ^ LONG2CHARS( 1<<29 ), 0xffffffff ^ LONG2CHARS( 1<<28), 
    0xffffffff ^ LONG2CHARS( 1<<27 ), 0xffffffff ^ LONG2CHARS( 1<<26),
    0xffffffff ^ LONG2CHARS( 1<<25 ), 0xffffffff ^ LONG2CHARS( 1<<24 ), 
    0xffffffff ^ LONG2CHARS( 1<<23 ), 0xffffffff ^ LONG2CHARS( 1<<22), 
    0xffffffff ^ LONG2CHARS( 1<<21 ), 0xffffffff ^ LONG2CHARS( 1<<20),
    0xffffffff ^ LONG2CHARS( 1<<19 ), 0xffffffff ^ LONG2CHARS( 1<<18 ), 
    0xffffffff ^ LONG2CHARS( 1<<17 ), 0xffffffff ^ LONG2CHARS( 1<<16),
    0xffffffff ^ LONG2CHARS( 1<<15 ), 0xffffffff ^ LONG2CHARS( 1<<14),
    0xffffffff ^ LONG2CHARS( 1<<13 ), 0xffffffff ^ LONG2CHARS( 1<<12 ),
    0xffffffff ^ LONG2CHARS( 1<<11 ), 0xffffffff ^ LONG2CHARS( 1<<10), 
    0xffffffff ^ LONG2CHARS( 1<<9 ),  0xffffffff ^ LONG2CHARS( 1<<8),
    0xffffffff ^ LONG2CHARS( 1<<7 ),  0xffffffff ^ LONG2CHARS( 1<<6),  
    0xffffffff ^ LONG2CHARS( 1<<5 ),  0xffffffff ^ LONG2CHARS( 1<<4),  
    0xffffffff ^ LONG2CHARS( 1<<3 ),  0xffffffff ^ LONG2CHARS( 1<<2),
    0xffffffff ^ LONG2CHARS( 1<<1 ),  0xffffffff ^ LONG2CHARS( 1<<0)
    };
#else	/* LSBFirst */
int mask[] =
    {
    LONG2CHARS( 1<<0 ), LONG2CHARS( 1<<1 ), LONG2CHARS( 1<<2), 
    LONG2CHARS( 1<<3 ), LONG2CHARS( 1<<4 ), LONG2CHARS( 1<<5), 
    LONG2CHARS( 1<<6 ), LONG2CHARS( 1<<7 ), LONG2CHARS( 1<<8), 
    LONG2CHARS( 1<<9 ), LONG2CHARS( 1<<10 ), LONG2CHARS( 1<<11), 
    LONG2CHARS( 1<<12 ), LONG2CHARS( 1<<13 ), LONG2CHARS( 1<<14), 
    LONG2CHARS( 1<<15 ), LONG2CHARS( 1<<16 ), LONG2CHARS( 1<<17), 
    LONG2CHARS( 1<<18 ), LONG2CHARS( 1<<19 ), LONG2CHARS( 1<<20), 
    LONG2CHARS( 1<<21 ), LONG2CHARS( 1<<22 ), LONG2CHARS( 1<<23),
    LONG2CHARS( 1<<24 ), LONG2CHARS( 1<<25 ), LONG2CHARS( 1<<26), 
    LONG2CHARS( 1<<27 ), LONG2CHARS( 1<<28 ), LONG2CHARS( 1<<29), 
    LONG2CHARS( 1<<30 ), LONG2CHARS( 1<<31 )
    }; 
int rmask[] = 
    {
    0xffffffff ^ LONG2CHARS( 1<<0), 0xffffffff ^ LONG2CHARS( 1<<1), 
    0xffffffff ^ LONG2CHARS( 1<<2), 0xffffffff ^ LONG2CHARS( 1<<3), 
    0xffffffff ^ LONG2CHARS( 1<<4), 0xffffffff ^ LONG2CHARS( 1<<5),
    0xffffffff ^ LONG2CHARS( 1<<6), 0xffffffff ^ LONG2CHARS( 1<<7), 
    0xffffffff ^ LONG2CHARS( 1<<8), 0xffffffff ^ LONG2CHARS( 1<<9), 
    0xffffffff ^ LONG2CHARS( 1<<10), 0xffffffff ^ LONG2CHARS( 1<<11),
    0xffffffff ^ LONG2CHARS( 1<<12), 0xffffffff ^ LONG2CHARS( 1<<13), 
    0xffffffff ^ LONG2CHARS( 1<<14), 0xffffffff ^ LONG2CHARS( 1<<15), 
    0xffffffff ^ LONG2CHARS( 1<<16), 0xffffffff ^ LONG2CHARS( 1<<17),
    0xffffffff ^ LONG2CHARS( 1<<18), 0xffffffff ^ LONG2CHARS( 1<<19), 
    0xffffffff ^ LONG2CHARS( 1<<20), 0xffffffff ^ LONG2CHARS( 1<<21), 
    0xffffffff ^ LONG2CHARS( 1<<22), 0xffffffff ^ LONG2CHARS( 1<<23),
    0xffffffff ^ LONG2CHARS( 1<<24), 0xffffffff ^ LONG2CHARS( 1<<25), 
    0xffffffff ^ LONG2CHARS( 1<<26), 0xffffffff ^ LONG2CHARS( 1<<27), 
    0xffffffff ^ LONG2CHARS( 1<<28), 0xffffffff ^ LONG2CHARS( 1<<29),
    0xffffffff ^ LONG2CHARS( 1<<30), 0xffffffff ^ LONG2CHARS( 1<<31)
    };
#endif
