# Stand-alone I/O support via prom-resident debugger calls


	set	cr%,0x0d		# carriage return
	set	lf%,0x0a		# line feed

	set	CONOUT%, 0x400
	set	CONIN%, 0x406
	set	DEVREQ%, 0x40c
	set	SENDICB%, 0x412
	set	CHGINT%,  0x418
	set	PUTCHAR%, 0x424
	set	GETCHAR%, 0x41e
	set	USRABORT%, 0x42a

	set	CONOUT1%, 0x440400
	set	CONIN1%, 0x440406
	set	DEVREQ1%, 0x44040c
	set	SENDICB1%, 0x440412
	set	CHGINT1%,  0x440418
	set	PUTCHAR1%, 0x440424
	set	GETCHAR1%, 0x44041e
	set	USRABORT1%, 0x44042a

	global  _start
	global  init
	global  bfile
	global	putchar
	global  pgchar
	global  conin
	global  conout
	global  chgint
	global	devreq
	global  sendicb
	global  usrabort
	global	aputch
	global  argsav%
	global  spsave%
	global  promret
	global	twenty_fiveM
	

# -----------------------------------------
# all standalone program return to here
# _________________________________________
btret%:
#	mov.l	&end+0x1800,%sp	# boot stack
	jmp	bfile

_start:
	mov.l	%sp,argsav%
	movm.l	&0xffff,-(%sp)
	mov.l	%sp,spsave%
	jsr	init

promret:
	mov.l	spsave%,%sp
	movm.l	(%sp)+,&0xffff
	rts

putchar:
	tst.b	twenty_fiveM
	bne.b	putchar1
	jmp	PUTCHAR%
putchar1:
	jmp	PUTCHAR1%
pgchar:
	tst.b	twenty_fiveM
	bne.b	pgchar1
	jmp	GETCHAR%
pgchar1:
	jmp	GETCHAR1%
conin:
	tst.b	twenty_fiveM
	bne.b	conin1
	jmp	CONIN%
conin1:
	jmp	CONIN1%
chgint:
	tst.b	twenty_fiveM
	bne.b	chgint1
	jmp	CHGINT%
chgint1:
	jmp	CHGINT1%
devreq:
	tst.b	twenty_fiveM
	bne.b	devreq1
	jmp	DEVREQ%
devreq1:
	jmp	DEVREQ1%
aputch:
	tst.b	twenty_fiveM
	bne.b	aput1
	jmp	CONOUT%
aput1:
	jmp	CONOUT1%
sendicb:
	tst.b	twenty_fiveM
	bne.b	sendicb1
	jmp	SENDICB%
sendicb1:
	jmp	SENDICB1%
usrabort:
	tst.b	twenty_fiveM
	bne.b	usrabort1
	jmp	USRABORT%
usrabort1:
	jmp	USRABORT1%
conout:
	tst.b	twenty_fiveM
	bne.b	conout1
	jmp	CONOUT%
conout1:
	jmp	CONOUT1%


	data
argsav%:
	space	4
spsave%:
	space 	4
